// components/remote_cocoa/common/font.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/font.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/font.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/font.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "components/remote_cocoa/common/font_mojom_traits.h"
#include "ui/gfx/font.h"
#include "ui/gfx/platform_font_mac.h"




namespace remote_cocoa::mojom {






class  FontName {
 public:
  using DataView = FontNameDataView;
  using Data_ = internal::FontName_Data;
  using Tag = Data_::FontName_Tag;

  template <typename... Args>
  static FontNamePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |system_font|.
  static FontNamePtr NewSystemFont(
      gfx::PlatformFontMac::SystemFontType value);
  // Construct an instance holding |regular_font|.
  static FontNamePtr NewRegularFont(
      const std::string& value);

  template <typename U>
  static FontNamePtr From(const U& u) {
    return mojo::TypeConverter<FontNamePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FontName>::Convert(*this);
  }
  ~FontName();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FontName(const FontName& other) = delete;
  FontName& operator=(const FontName& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FontNamePtr>
  FontNamePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FontName>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FontName>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_system_font() const { return tag_ == Tag::kSystemFont; }
  gfx::PlatformFontMac::SystemFontType get_system_font() const {
    CHECK(tag_ == Tag::kSystemFont);
    return data_.system_font;
  }
  void set_system_font(gfx::PlatformFontMac::SystemFontType system_font);

  bool is_regular_font() const { return tag_ == Tag::kRegularFont; }
  const std::string& get_regular_font() const {
    CHECK(tag_ == Tag::kRegularFont);
    return data_.regular_font;
  }
  std::string& get_regular_font() {
    CHECK(tag_ == Tag::kRegularFont);
    return data_.regular_font;
  }
  void set_regular_font(const std::string& regular_font);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FontName::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FontName::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSystemFont)>,
        gfx::PlatformFontMac::SystemFontType value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegularFont)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    gfx::PlatformFontMac::SystemFontType system_font;
    std::string regular_font;
  };

  FontName(
      std::in_place_index_t<static_cast<size_t>(Tag::kSystemFont)>,
      gfx::PlatformFontMac::SystemFontType value);
  FontName(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegularFont)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  Font {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Font, T>::value>;
  using DataView = FontDataView;
  using Data_ = internal::Font_Data;

  template <typename... Args>
  static FontPtr New(Args&&... args) {
    return FontPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FontPtr From(const U& u) {
    return mojo::TypeConverter<FontPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Font>::Convert(*this);
  }


  Font();

  Font(
      FontNamePtr name,
      uint32_t size,
      uint32_t style,
      gfx::Font::Weight weight);

Font(const Font&) = delete;
Font& operator=(const Font&) = delete;

  ~Font();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FontPtr>
  FontPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Font::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Font::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Font::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Font::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Font::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Font::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Font_UnserializedMessageContext<
            UserType, Font::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Font::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Font::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Font_UnserializedMessageContext<
            UserType, Font::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Font::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FontNamePtr name;
  
  uint32_t size;
  
  uint32_t style;
  
  gfx::Font::Weight weight;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Font::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Font::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Font::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Font::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FontNamePtr FontName::Clone() const {
  switch (tag_) {
    case Tag::kSystemFont:
      return NewSystemFont(
          mojo::Clone(data_.system_font));
    case Tag::kRegularFont:
      return NewRegularFont(
          mojo::Clone(data_.regular_font));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FontName>::value>::type*>
bool FontName::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSystemFont:
      return mojo::Equals(data_.system_font, other.data_.system_font);
    case Tag::kRegularFont:
      return mojo::Equals(data_.regular_font, other.data_.regular_font);
  }

  return false;
}
template <typename StructPtrType>
FontPtr Font::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(size),
      mojo::Clone(style),
      mojo::Clone(weight)
  );
}

template <typename T, Font::EnableIfSame<T>*>
bool Font::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->style, other_struct.style))
    return false;
  if (!mojo::Equals(this->weight, other_struct.weight))
    return false;
  return true;
}

template <typename T, Font::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.style < rhs.style)
    return true;
  if (rhs.style < lhs.style)
    return false;
  if (lhs.weight < rhs.weight)
    return true;
  if (rhs.weight < lhs.weight)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::Font::DataView,
                                         ::remote_cocoa::mojom::FontPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::FontPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::FontPtr* output) { output->reset(); }

  static const decltype(::remote_cocoa::mojom::Font::name)& name(
      const ::remote_cocoa::mojom::FontPtr& input) {
    return input->name;
  }

  static decltype(::remote_cocoa::mojom::Font::size) size(
      const ::remote_cocoa::mojom::FontPtr& input) {
    return input->size;
  }

  static decltype(::remote_cocoa::mojom::Font::style) style(
      const ::remote_cocoa::mojom::FontPtr& input) {
    return input->style;
  }

  static decltype(::remote_cocoa::mojom::Font::weight) weight(
      const ::remote_cocoa::mojom::FontPtr& input) {
    return input->weight;
  }

  static bool Read(::remote_cocoa::mojom::Font::DataView input, ::remote_cocoa::mojom::FontPtr* output);
};


template <>
struct  UnionTraits<::remote_cocoa::mojom::FontName::DataView,
                                        ::remote_cocoa::mojom::FontNamePtr> {
  static bool IsNull(const ::remote_cocoa::mojom::FontNamePtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::FontNamePtr* output) { output->reset(); }

  static ::remote_cocoa::mojom::FontName::Tag GetTag(const ::remote_cocoa::mojom::FontNamePtr& input) {
    return input->which();
  }

  static  gfx::PlatformFontMac::SystemFontType system_font(const ::remote_cocoa::mojom::FontNamePtr& input) {
    return input->get_system_font();
  }

  static const std::string& regular_font(const ::remote_cocoa::mojom::FontNamePtr& input) {
    return input->get_regular_font();
  }

  static bool Read(::remote_cocoa::mojom::FontName::DataView input, ::remote_cocoa::mojom::FontNamePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_H_