// components/remote_cocoa/common/alert.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_ALERT_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_ALERT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/alert.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/alert.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/alert.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class AlertBridgeProxy;

template <typename ImplRefTraits>
class AlertBridgeStub;

class AlertBridgeRequestValidator;
class AlertBridgeResponseValidator;


class AlertBridge
    : public AlertBridgeInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.AlertBridge";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AlertBridgeInterfaceBase;
  using Proxy_ = AlertBridgeProxy;

  template <typename ImplRefTraits>
  using Stub_ = AlertBridgeStub<ImplRefTraits>;

  using RequestValidator_ = AlertBridgeRequestValidator;
  using ResponseValidator_ = AlertBridgeResponseValidator;
  enum MethodMinVersions : uint32_t {
    kShowMinVersion = 0,
    kDismissMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Show_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Dismiss_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AlertBridge() = default;

  using ShowCallback = base::OnceCallback<void(AlertDisposition, const ::std::u16string&, bool)>;
  using ShowMojoCallback = base::OnceCallback<void(AlertDisposition, const ::std::u16string&, bool)>;

  virtual void Show(AlertBridgeInitParamsPtr params, ShowCallback callback) = 0;

  virtual void Dismiss() = 0;
};



class  AlertBridgeProxy
    : public AlertBridge {
 public:
  using InterfaceType = AlertBridge;

  explicit AlertBridgeProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Show(AlertBridgeInitParamsPtr params, ShowCallback callback) final;
  
  void Dismiss() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AlertBridgeStubDispatch {
 public:
  static bool Accept(AlertBridge* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AlertBridge* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AlertBridge>>
class AlertBridgeStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AlertBridgeStub() = default;
  ~AlertBridgeStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AlertBridgeStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AlertBridgeStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AlertBridgeRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AlertBridgeResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  AlertBridgeInitParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AlertBridgeInitParams, T>::value>;
  using DataView = AlertBridgeInitParamsDataView;
  using Data_ = internal::AlertBridgeInitParams_Data;

  template <typename... Args>
  static AlertBridgeInitParamsPtr New(Args&&... args) {
    return AlertBridgeInitParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AlertBridgeInitParamsPtr From(const U& u) {
    return mojo::TypeConverter<AlertBridgeInitParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AlertBridgeInitParams>::Convert(*this);
  }


  AlertBridgeInitParams();

  AlertBridgeInitParams(
      const ::std::u16string& title,
      const ::std::u16string& message_text,
      const ::std::u16string& primary_button_text,
      const std::optional<::std::u16string>& secondary_button_text,
      const std::optional<::std::u16string>& text_field_text,
      const std::optional<::std::u16string>& check_box_text);


  ~AlertBridgeInitParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AlertBridgeInitParamsPtr>
  AlertBridgeInitParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AlertBridgeInitParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AlertBridgeInitParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AlertBridgeInitParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AlertBridgeInitParams_UnserializedMessageContext<
            UserType, AlertBridgeInitParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AlertBridgeInitParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AlertBridgeInitParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AlertBridgeInitParams_UnserializedMessageContext<
            UserType, AlertBridgeInitParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AlertBridgeInitParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  ::std::u16string message_text;
  
  ::std::u16string primary_button_text;
  
  std::optional<::std::u16string> secondary_button_text;
  
  std::optional<::std::u16string> text_field_text;
  
  std::optional<::std::u16string> check_box_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AlertBridgeInitParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AlertBridgeInitParamsPtr AlertBridgeInitParams::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(message_text),
      mojo::Clone(primary_button_text),
      mojo::Clone(secondary_button_text),
      mojo::Clone(text_field_text),
      mojo::Clone(check_box_text)
  );
}

template <typename T, AlertBridgeInitParams::EnableIfSame<T>*>
bool AlertBridgeInitParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->message_text, other_struct.message_text))
    return false;
  if (!mojo::Equals(this->primary_button_text, other_struct.primary_button_text))
    return false;
  if (!mojo::Equals(this->secondary_button_text, other_struct.secondary_button_text))
    return false;
  if (!mojo::Equals(this->text_field_text, other_struct.text_field_text))
    return false;
  if (!mojo::Equals(this->check_box_text, other_struct.check_box_text))
    return false;
  return true;
}

template <typename T, AlertBridgeInitParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.message_text < rhs.message_text)
    return true;
  if (rhs.message_text < lhs.message_text)
    return false;
  if (lhs.primary_button_text < rhs.primary_button_text)
    return true;
  if (rhs.primary_button_text < lhs.primary_button_text)
    return false;
  if (lhs.secondary_button_text < rhs.secondary_button_text)
    return true;
  if (rhs.secondary_button_text < lhs.secondary_button_text)
    return false;
  if (lhs.text_field_text < rhs.text_field_text)
    return true;
  if (rhs.text_field_text < lhs.text_field_text)
    return false;
  if (lhs.check_box_text < rhs.check_box_text)
    return true;
  if (rhs.check_box_text < lhs.check_box_text)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::AlertBridgeInitParams::DataView,
                                         ::remote_cocoa::mojom::AlertBridgeInitParamsPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::AlertBridgeInitParamsPtr* output) { output->reset(); }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::title)& title(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->title;
  }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::message_text)& message_text(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->message_text;
  }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::primary_button_text)& primary_button_text(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->primary_button_text;
  }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::secondary_button_text)& secondary_button_text(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->secondary_button_text;
  }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::text_field_text)& text_field_text(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->text_field_text;
  }

  static const decltype(::remote_cocoa::mojom::AlertBridgeInitParams::check_box_text)& check_box_text(
      const ::remote_cocoa::mojom::AlertBridgeInitParamsPtr& input) {
    return input->check_box_text;
  }

  static bool Read(::remote_cocoa::mojom::AlertBridgeInitParams::DataView input, ::remote_cocoa::mojom::AlertBridgeInitParamsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_ALERT_MOJOM_H_