// components/remote_cocoa/common/alert.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/alert.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/alert.mojom-params-data.h"
#include "components/remote_cocoa/common/alert.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/alert.mojom-import-headers.h"
#include "components/remote_cocoa/common/alert.mojom-test-utils.h"


namespace remote_cocoa::mojom {
AlertBridgeInitParams::AlertBridgeInitParams()
    : title(),
      message_text(),
      primary_button_text(),
      secondary_button_text(),
      text_field_text(),
      check_box_text() {}

AlertBridgeInitParams::AlertBridgeInitParams(
    const ::std::u16string& title_in,
    const ::std::u16string& message_text_in,
    const ::std::u16string& primary_button_text_in,
    const std::optional<::std::u16string>& secondary_button_text_in,
    const std::optional<::std::u16string>& text_field_text_in,
    const std::optional<::std::u16string>& check_box_text_in)
    : title(std::move(title_in)),
      message_text(std::move(message_text_in)),
      primary_button_text(std::move(primary_button_text_in)),
      secondary_button_text(std::move(secondary_button_text_in)),
      text_field_text(std::move(text_field_text_in)),
      check_box_text(std::move(check_box_text_in)) {}

AlertBridgeInitParams::~AlertBridgeInitParams() = default;

void AlertBridgeInitParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message_text"), this->message_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_button_text"), this->primary_button_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secondary_button_text"), this->secondary_button_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_field_text"), this->text_field_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "check_box_text"), this->check_box_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AlertBridgeInitParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AlertBridge::IPCStableHashFunction AlertBridge::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AlertBridge>(message.name())) {
    case messages::AlertBridge::kShow: {
      return &AlertBridge::Show_Sym::IPCStableHash;
    }
    case messages::AlertBridge::kDismiss: {
      return &AlertBridge::Dismiss_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AlertBridge::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AlertBridge>(message.name())) {
      case messages::AlertBridge::kShow:
            return "Receive remote_cocoa::mojom::AlertBridge::Show";
      case messages::AlertBridge::kDismiss:
            return "Receive remote_cocoa::mojom::AlertBridge::Dismiss";
    }
  } else {
    switch (static_cast<messages::AlertBridge>(message.name())) {
      case messages::AlertBridge::kShow:
            return "Receive reply remote_cocoa::mojom::AlertBridge::Show";
      case messages::AlertBridge::kDismiss:
            return "Receive reply remote_cocoa::mojom::AlertBridge::Dismiss";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AlertBridge::Show_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4dfd0c80;  // IPCStableHash for remote_cocoa::mojom::AlertBridge::Show
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AlertBridge::Dismiss_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d36f617;  // IPCStableHash for remote_cocoa::mojom::AlertBridge::Dismiss
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AlertBridge_Show_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AlertBridge_Show_ForwardToCallback(
      AlertBridge::ShowCallback callback
      ) : callback_(std::move(callback)) {
  }

  AlertBridge_Show_ForwardToCallback(const AlertBridge_Show_ForwardToCallback&) = delete;
  AlertBridge_Show_ForwardToCallback& operator=(const AlertBridge_Show_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AlertBridge::ShowCallback callback_;
};

AlertBridgeProxy::AlertBridgeProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AlertBridgeProxy::Show(
    AlertBridgeInitParamsPtr in_params, ShowCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::AlertBridge::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type AlertBridgeInitParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AlertBridge::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::AlertBridge_Show_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::remote_cocoa::mojom::AlertBridgeInitParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AlertBridge.Show request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AlertBridge::Name_);
  message.set_method_name("Show");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AlertBridge_Show_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AlertBridgeProxy::Dismiss(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::AlertBridge::Dismiss");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AlertBridge::kDismiss), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::AlertBridge_Dismiss_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AlertBridge::Name_);
  message.set_method_name("Dismiss");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AlertBridge_Show_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AlertBridge::ShowCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AlertBridge_Show_ProxyToResponder> proxy(
        new AlertBridge_Show_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AlertBridge_Show_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AlertBridge_Show_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AlertBridge_Show_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AlertBridge::ShowCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AlertDisposition in_disposition, const ::std::u16string& in_text_field_value, bool in_check_box_value);
};

bool AlertBridge_Show_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AlertBridge_Show_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AlertBridge_Show_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AlertBridge.0
  bool success = true;
  AlertDisposition p_disposition{};
  ::std::u16string p_text_field_value{};
  bool p_check_box_value{};
  AlertBridge_Show_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDisposition(&p_disposition))
    success = false;
  if (success && !input_data_view.ReadTextFieldValue(&p_text_field_value))
    success = false;
  if (success)
    p_check_box_value = input_data_view.check_box_value();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AlertBridge::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_disposition), 
std::move(p_text_field_value), 
std::move(p_check_box_value));
  }
  return true;
}

void AlertBridge_Show_ProxyToResponder::Run(
    AlertDisposition in_disposition, const ::std::u16string& in_text_field_value, bool in_check_box_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply remote_cocoa::mojom::AlertBridge::Show", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type AlertDisposition>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_field_value"), in_text_field_value,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("check_box_value"), in_check_box_value,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AlertBridge::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::AlertBridge_Show_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::AlertDisposition>(
    in_disposition,
    &params->disposition);
  mojo::internal::MessageFragment<
      typename decltype(params->text_field_value)::BaseType> text_field_value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text_field_value,
    text_field_value_fragment);

  params->text_field_value.Set(
      text_field_value_fragment.is_null() ? nullptr : text_field_value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text_field_value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text_field_value in ");

  params->check_box_value = in_check_box_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AlertBridge::Name_);
  message.set_method_name("Show");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AlertBridgeStubDispatch::Accept(
    AlertBridge* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AlertBridge>(message->header()->name)) {
    case messages::AlertBridge::kShow: {
      break;
    }
    case messages::AlertBridge::kDismiss: {
      DCHECK(message->is_serialized());
      internal::AlertBridge_Dismiss_Params_Data* params =
          reinterpret_cast<internal::AlertBridge_Dismiss_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AlertBridge.1
      bool success = true;
      AlertBridge_Dismiss_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AlertBridge::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dismiss(        );
      return true;
    }
  }
  return false;
}

// static
bool AlertBridgeStubDispatch::AcceptWithResponder(
    AlertBridge* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AlertBridge>(message->header()->name)) {
    case messages::AlertBridge::kShow: {
      internal::AlertBridge_Show_Params_Data* params =
          reinterpret_cast<
              internal::AlertBridge_Show_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AlertBridge.0
      bool success = true;
      AlertBridgeInitParamsPtr p_params{};
      AlertBridge_Show_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AlertBridge::Name_, 0, false);
        return false;
      }
      auto callback =
          AlertBridge_Show_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::AlertBridge::kDismiss: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAlertBridgeValidationInfo[] = {
    { &internal::AlertBridge_Show_Params_Data::Validate,
     &internal::AlertBridge_Show_ResponseParams_Data::Validate},
    { &internal::AlertBridge_Dismiss_Params_Data::Validate,
     nullptr /* no response */},
};

bool AlertBridgeRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::AlertBridge::Name_,
    kAlertBridgeValidationInfo);
}

bool AlertBridgeResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::remote_cocoa::mojom::AlertBridge::Name_,
    kAlertBridgeValidationInfo);
}


}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::AlertBridgeInitParams::DataView, ::remote_cocoa::mojom::AlertBridgeInitParamsPtr>::Read(
    ::remote_cocoa::mojom::AlertBridgeInitParams::DataView input,
    ::remote_cocoa::mojom::AlertBridgeInitParamsPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::AlertBridgeInitParamsPtr result(::remote_cocoa::mojom::AlertBridgeInitParams::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadMessageText(&result->message_text))
        success = false;
      if (success && !input.ReadPrimaryButtonText(&result->primary_button_text))
        success = false;
      if (success && !input.ReadSecondaryButtonText(&result->secondary_button_text))
        success = false;
      if (success && !input.ReadTextFieldText(&result->text_field_text))
        success = false;
      if (success && !input.ReadCheckBoxText(&result->check_box_text))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void AlertBridgeInterceptorForTesting::Show(AlertBridgeInitParamsPtr params, ShowCallback callback) {
  GetForwardingInterface()->Show(
    std::move(params)
    , std::move(callback));
}
void AlertBridgeInterceptorForTesting::Dismiss() {
  GetForwardingInterface()->Dismiss();
}
AlertBridgeAsyncWaiter::AlertBridgeAsyncWaiter(
    AlertBridge* proxy) : proxy_(proxy) {}

AlertBridgeAsyncWaiter::~AlertBridgeAsyncWaiter() = default;


void AlertBridgeAsyncWaiter::Show(
    AlertBridgeInitParamsPtr params, AlertDisposition* out_disposition, ::std::u16string* out_text_field_value, bool* out_check_box_value) {
  base::RunLoop loop;
  proxy_->Show(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             AlertDisposition* out_disposition
,
             ::std::u16string* out_text_field_value
,
             bool* out_check_box_value
,
             AlertDisposition disposition,
             const ::std::u16string& text_field_value,
             bool check_box_value) {*out_disposition = std::move(disposition);*out_text_field_value = std::move(text_field_value);*out_check_box_value = std::move(check_box_value);
            loop->Quit();
          },
          &loop,
          out_disposition,
          out_text_field_value,
          out_check_box_value));
  loop.Run();
}








}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif