// components/remote_cocoa/common/alert.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/alert.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/alert.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* AlertDispositionToStringHelper(AlertDisposition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AlertDisposition::PRIMARY_BUTTON:
      return "PRIMARY_BUTTON";
    case AlertDisposition::SECONDARY_BUTTON:
      return "SECONDARY_BUTTON";
    case AlertDisposition::CLOSE:
      return "CLOSE";
    default:
      return nullptr;
  }
}

std::string AlertDispositionToString(AlertDisposition value) {
  const char *str = AlertDispositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AlertDisposition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AlertDisposition value) {
  return os << AlertDispositionToString(value);
}

namespace internal {


// static
bool AlertBridgeInitParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AlertBridgeInitParams_Data* object =
      static_cast<const AlertBridgeInitParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message_text, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_button_text, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary_button_text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->secondary_button_text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->text_field_text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->check_box_text, validation_context))
    return false;

  return true;
}

AlertBridgeInitParams_Data::AlertBridgeInitParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AlertBridge_Show_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AlertBridge_Show_Params_Data* object =
      static_cast<const AlertBridge_Show_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

AlertBridge_Show_Params_Data::AlertBridge_Show_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AlertBridge_Show_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AlertBridge_Show_ResponseParams_Data* object =
      static_cast<const AlertBridge_Show_ResponseParams_Data*>(data);


  if (!::remote_cocoa::mojom::internal::AlertDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_field_value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_field_value, validation_context))
    return false;

  return true;
}

AlertBridge_Show_ResponseParams_Data::AlertBridge_Show_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AlertBridge_Dismiss_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AlertBridge_Dismiss_Params_Data* object =
      static_cast<const AlertBridge_Dismiss_Params_Data*>(data);

  return true;
}

AlertBridge_Dismiss_Params_Data::AlertBridge_Dismiss_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::AlertDisposition>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::AlertDisposition value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::AlertDispositionToString(value));
}

} // namespace perfetto