// components/persistent_cache/mojom/persistent_cache.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/persistent_cache/mojom/persistent_cache.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-params-data.h"
#include "components/persistent_cache/mojom/persistent_cache.mojom-shared-message-ids.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-import-headers.h"
#include "components/persistent_cache/mojom/persistent_cache.mojom-test-utils.h"


namespace persistent_cache::mojom {
ReadWriteBackendParams::ReadWriteBackendParams()
    : db_file(),
      journal_file(),
      shared_lock() {}

ReadWriteBackendParams::ReadWriteBackendParams(
    ::base::File db_file_in,
    ::base::File journal_file_in,
    ::base::UnsafeSharedMemoryRegion shared_lock_in)
    : db_file(std::move(db_file_in)),
      journal_file(std::move(journal_file_in)),
      shared_lock(std::move(shared_lock_in)) {}

ReadWriteBackendParams::~ReadWriteBackendParams() = default;

void ReadWriteBackendParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "db_file"), this->db_file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "journal_file"), this->journal_file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_lock"), this->shared_lock,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::UnsafeSharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadWriteBackendParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // persistent_cache::mojom


namespace mojo {


// static
bool StructTraits<::persistent_cache::mojom::ReadWriteBackendParams::DataView, ::persistent_cache::mojom::ReadWriteBackendParamsPtr>::Read(
    ::persistent_cache::mojom::ReadWriteBackendParams::DataView input,
    ::persistent_cache::mojom::ReadWriteBackendParamsPtr* output) {
  bool success = true;
  ::persistent_cache::mojom::ReadWriteBackendParamsPtr result(::persistent_cache::mojom::ReadWriteBackendParams::New());
  
      if (success && !input.ReadDbFile(&result->db_file))
        success = false;
      if (success && !input.ReadJournalFile(&result->journal_file))
        success = false;
      if (success && !input.ReadSharedLock(&result->shared_lock))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace persistent_cache::mojom {




}  // persistent_cache::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif