// components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_SHARED_H_
#define COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-data-view.h"




namespace std {

template <>
struct hash<::password_manager::mojom::CSVPassword_Status>
    : public mojo::internal::EnumHashImpl<::password_manager::mojom::CSVPassword_Status> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::password_manager::mojom::CSVPassword_Status, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::password_manager::mojom::CSVPassword_Status, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::password_manager::mojom::CSVPassword_Status>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::password_manager::mojom::CSVPasswordSequenceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::CSVPasswordSequenceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::CSVPasswordSequence_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::csv_passwords(input)) in_csv_passwords = Traits::csv_passwords(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->csv_passwords)::BaseType>
        csv_passwords_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& csv_passwords_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::password_manager::mojom::CSVPasswordDataView>>(
      in_csv_passwords,
      csv_passwords_fragment,
      &csv_passwords_validate_params);

    fragment->csv_passwords.Set(
        csv_passwords_fragment.is_null() ? nullptr : csv_passwords_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->csv_passwords.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null csv_passwords in CSVPasswordSequence struct");
  }

  static bool Deserialize(::password_manager::mojom::internal::CSVPasswordSequence_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::password_manager::mojom::CSVPasswordSequenceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::password_manager::mojom::CSVPasswordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::CSVPasswordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::CSVPassword_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::password_manager::mojom::CSVPassword_Status>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType> username_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_username,
      username_fragment);

    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username in CSVPassword struct");

    decltype(Traits::password(input)) in_password = Traits::password(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password)::BaseType> password_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_password,
      password_fragment);

    fragment->password.Set(
        password_fragment.is_null() ? nullptr : password_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->password.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password in CSVPassword struct");

    decltype(Traits::note(input)) in_note = Traits::note(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->note)::BaseType> note_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_note,
      note_fragment);

    fragment->note.Set(
        note_fragment.is_null() ? nullptr : note_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->note.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null note in CSVPassword struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CSVPassword struct");

    decltype(Traits::invalid_url(input)) in_invalid_url = Traits::invalid_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->invalid_url)::BaseType> invalid_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_invalid_url,
      invalid_url_fragment);

    fragment->invalid_url.Set(
        invalid_url_fragment.is_null() ? nullptr : invalid_url_fragment.data());
  }

  static bool Deserialize(::password_manager::mojom::internal::CSVPassword_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::password_manager::mojom::CSVPasswordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace password_manager::mojom {

inline void CSVPasswordSequenceDataView::GetCsvPasswordsDataView(
    mojo::ArrayDataView<CSVPasswordDataView>* output) {
  auto pointer = data_->csv_passwords.Get();
  *output = mojo::ArrayDataView<CSVPasswordDataView>(pointer, message_);
}


inline void CSVPasswordDataView::GetUsernameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->username.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSVPasswordDataView::GetPasswordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->password.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSVPasswordDataView::GetNoteDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->note.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSVPasswordDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CSVPasswordDataView::GetInvalidUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->invalid_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // password_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::password_manager::mojom::CSVPassword_Status> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::password_manager::mojom::CSVPassword_Status value);
};

} // namespace perfetto

#endif  // COMPONENTS_PASSWORD_MANAGER_SERVICES_CSV_PASSWORD_PUBLIC_MOJOM_CSV_PASSWORD_PARSER_MOJOM_SHARED_H_