// components/page_load_metrics/common/page_load_metrics.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/page_load_metrics/common/page_load_metrics.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/page_load_metrics/common/page_load_metrics.mojom-params-data.h"
namespace page_load_metrics {
namespace mojom {

NOINLINE static const char* CacheTypeToStringHelper(CacheType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CacheType::kNotCached:
      return "kNotCached";
    case CacheType::kHttp:
      return "kHttp";
    case CacheType::kMemory:
      return "kMemory";
    default:
      return nullptr;
  }
}

std::string CacheTypeToString(CacheType value) {
  const char *str = CacheTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CacheType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CacheType value) {
  return os << CacheTypeToString(value);
}

namespace internal {


// static
bool DocumentTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentTiming_Data* object =
      static_cast<const DocumentTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->dom_content_loaded_event_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->load_event_start, validation_context))
    return false;

  return true;
}

DocumentTiming_Data::DocumentTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LcpResourceLoadTimings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LcpResourceLoadTimings_Data* object =
      static_cast<const LcpResourceLoadTimings_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->discovery_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->load_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->load_end, validation_context))
    return false;

  return true;
}

LcpResourceLoadTimings_Data::LcpResourceLoadTimings_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LargestContentfulPaintTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LargestContentfulPaintTiming_Data* object =
      static_cast<const LargestContentfulPaintTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->largest_image_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->largest_text_paint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_load_timings, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource_load_timings, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->image_request_priority_value, validation_context))
    return false;

  return true;
}

LargestContentfulPaintTiming_Data::LargestContentfulPaintTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintTiming_Data* object =
      static_cast<const PaintTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->first_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_image_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_contentful_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_meaningful_paint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->largest_contentful_paint, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->largest_contentful_paint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->experimental_largest_contentful_paint, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->experimental_largest_contentful_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_eligible_to_paint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_input_or_scroll_notified_timestamp, validation_context))
    return false;

  return true;
}

PaintTiming_Data::PaintTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParseTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ParseTiming_Data* object =
      static_cast<const ParseTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->parse_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parse_stop, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parse_blocked_on_script_load_duration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parse_blocked_on_script_load_from_document_write_duration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parse_blocked_on_script_execution_duration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parse_blocked_on_script_execution_from_document_write_duration, validation_context))
    return false;

  return true;
}

ParseTiming_Data::ParseTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InteractiveTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InteractiveTiming_Data* object =
      static_cast<const InteractiveTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->first_input_delay, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_input_timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_scroll_delay, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_scroll_timestamp, validation_context))
    return false;

  return true;
}

InteractiveTiming_Data::InteractiveTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomUserTimingMark_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomUserTimingMark_Data* object =
      static_cast<const CustomUserTimingMark_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mark_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mark_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mark_name, validation_context,
                                         &mark_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  return true;
}

CustomUserTimingMark_Data::CustomUserTimingMark_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DomainLookupTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DomainLookupTiming_Data* object =
      static_cast<const DomainLookupTiming_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->domain_lookup_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->domain_lookup_end, validation_context))
    return false;

  return true;
}

DomainLookupTiming_Data::DomainLookupTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageLoadTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageLoadTiming_Data* object =
      static_cast<const PageLoadTiming_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->connect_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->connect_end, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_timing, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interactive_timing, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interactive_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->paint_timing, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->paint_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parse_timing, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parse_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain_lookup_timing, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->domain_lookup_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->back_forward_cache_timings, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& back_forward_cache_timings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->back_forward_cache_timings, validation_context,
                                         &back_forward_cache_timings_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->activation_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->input_to_navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->user_timing_mark_fully_loaded, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->user_timing_mark_fully_visible, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->user_timing_mark_interactive, validation_context))
    return false;

  return true;
}

PageLoadTiming_Data::PageLoadTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameMetadata_Data* object =
      static_cast<const FrameMetadata_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->main_frame_intersection_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->main_frame_viewport_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_ad_rects, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& main_frame_ad_rects_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->main_frame_ad_rects, validation_context,
                                         &main_frame_ad_rects_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->framework_detection_result, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->framework_detection_result, validation_context))
    return false;

  return true;
}

FrameMetadata_Data::FrameMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SubresourceLoadMetrics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SubresourceLoadMetrics_Data* object =
      static_cast<const SubresourceLoadMetrics_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->service_worker_subresource_load_metrics, validation_context))
    return false;

  return true;
}

SubresourceLoadMetrics_Data::SubresourceLoadMetrics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerSubresourceLoadMetrics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerSubresourceLoadMetrics_Data* object =
      static_cast<const ServiceWorkerSubresourceLoadMetrics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_router_evaluation_time_for_subresources, 36, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_router_evaluation_time_for_subresources, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_cache_lookup_time_for_subresources, 37, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_cache_lookup_time_for_subresources, validation_context))
    return false;

  return true;
}

ServiceWorkerSubresourceLoadMetrics_Data::ServiceWorkerSubresourceLoadMetrics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceDataUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResourceDataUpdate_Data* object =
      static_cast<const ResourceDataUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delta_bytes, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->delta_bytes, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->received_data_length, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->received_data_length, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoded_body_length, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->encoded_body_length, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decoded_body_length, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decoded_body_length, validation_context))
    return false;


  if (!::page_load_metrics::mojom::internal::CacheType_Data
        ::Validate(object->cache_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

ResourceDataUpdate_Data::ResourceDataUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayoutShift_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayoutShift_Data* object =
      static_cast<const LayoutShift_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layout_shift_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->layout_shift_time, validation_context))
    return false;

  return true;
}

LayoutShift_Data::LayoutShift_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameRenderDataUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameRenderDataUpdate_Data* object =
      static_cast<const FrameRenderDataUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_layout_shifts, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_layout_shifts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_layout_shifts, validation_context,
                                         &new_layout_shifts_validate_params)) {
    return false;
  }

  return true;
}

FrameRenderDataUpdate_Data::FrameRenderDataUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CpuTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CpuTiming_Data* object =
      static_cast<const CpuTiming_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->task_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->task_time, validation_context))
    return false;

  return true;
}

CpuTiming_Data::CpuTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InputTiming_Data* object =
      static_cast<const InputTiming_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_interaction_latencies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_interaction_latencies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_interaction_latencies, validation_context,
                                         &user_interaction_latencies_validate_params)) {
    return false;
  }

  return true;
}

InputTiming_Data::InputTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserInteractionLatency_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserInteractionLatency_Data* object =
      static_cast<const UserInteractionLatency_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interaction_latency, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interaction_latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interaction_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interaction_time, validation_context))
    return false;

  return true;
}

UserInteractionLatency_Data::UserInteractionLatency_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackForwardCacheTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackForwardCacheTiming_Data* object =
      static_cast<const BackForwardCacheTiming_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->first_paint_after_back_forward_cache_restore, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->first_paint_after_back_forward_cache_restore, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_animation_frames_after_back_forward_cache_restore, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& request_animation_frames_after_back_forward_cache_restore_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->request_animation_frames_after_back_forward_cache_restore, validation_context,
                                         &request_animation_frames_after_back_forward_cache_restore_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->first_input_delay_after_back_forward_cache_restore, validation_context))
    return false;

  return true;
}

BackForwardCacheTiming_Data::BackForwardCacheTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SoftNavigationMetrics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SoftNavigationMetrics_Data* object =
      static_cast<const SoftNavigationMetrics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->largest_contentful_paint, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->largest_contentful_paint, validation_context))
    return false;

  return true;
}

SoftNavigationMetrics_Data::SoftNavigationMetrics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageLoadMetrics_UpdateTiming_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageLoadMetrics_UpdateTiming_Params_Data* object =
      static_cast<const PageLoadMetrics_UpdateTiming_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_load_timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_load_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_features, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_features, validation_context,
                                         &new_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resources, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resources, validation_context,
                                         &resources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_data, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->render_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cpu_load_timing, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cpu_load_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_timing_delta, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_timing_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->subresource_load_metrics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->soft_navigation_metrics, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->soft_navigation_metrics, validation_context))
    return false;

  return true;
}

PageLoadMetrics_UpdateTiming_Params_Data::PageLoadMetrics_UpdateTiming_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data* object =
      static_cast<const PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dropped_frames_memory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dropped_frames_memory, validation_context))
    return false;

  return true;
}

PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data::PageLoadMetrics_SetUpSharedMemoryForDroppedFrames_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageLoadMetrics_AddCustomUserTiming_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageLoadMetrics_AddCustomUserTiming_Params_Data* object =
      static_cast<const PageLoadMetrics_AddCustomUserTiming_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->custom_user_timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->custom_user_timing, validation_context))
    return false;

  return true;
}

PageLoadMetrics_AddCustomUserTiming_Params_Data::PageLoadMetrics_AddCustomUserTiming_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace page_load_metrics

namespace perfetto {

// static
void TraceFormatTraits<::page_load_metrics::mojom::CacheType>::WriteIntoTrace(
   perfetto::TracedValue context, ::page_load_metrics::mojom::CacheType value) {
  return std::move(context).WriteString(::page_load_metrics::mojom::CacheTypeToString(value));
}

} // namespace perfetto