// components/page_image_service/mojom/page_image_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_H_
#define COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/page_image_service/mojom/page_image_service.mojom-features.h"  // IWYU pragma: export
#include "components/page_image_service/mojom/page_image_service.mojom-shared.h"  // IWYU pragma: export
#include "components/page_image_service/mojom/page_image_service.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace page_image_service::mojom {

class PageImageServiceHandlerProxy;

template <typename ImplRefTraits>
class PageImageServiceHandlerStub;

class PageImageServiceHandlerRequestValidator;
class PageImageServiceHandlerResponseValidator;


class PageImageServiceHandler
    : public PageImageServiceHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "page_image_service.mojom.PageImageServiceHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageImageServiceHandlerInterfaceBase;
  using Proxy_ = PageImageServiceHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageImageServiceHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageImageServiceHandlerRequestValidator;
  using ResponseValidator_ = PageImageServiceHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPageImageUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPageImageUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageImageServiceHandler() = default;

  using GetPageImageUrlCallback = base::OnceCallback<void(ImageResultPtr)>;
  using GetPageImageUrlMojoCallback = base::OnceCallback<void(ImageResultPtr)>;

  virtual void GetPageImageUrl(ClientId client_id, const ::GURL& page_url, OptionsPtr options, GetPageImageUrlCallback callback) = 0;
};



class  PageImageServiceHandlerProxy
    : public PageImageServiceHandler {
 public:
  using InterfaceType = PageImageServiceHandler;

  explicit PageImageServiceHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPageImageUrl(ClientId client_id, const ::GURL& page_url, OptionsPtr options, GetPageImageUrlCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageImageServiceHandlerStubDispatch {
 public:
  static bool Accept(PageImageServiceHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageImageServiceHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageImageServiceHandler>>
class PageImageServiceHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageImageServiceHandlerStub() = default;
  ~PageImageServiceHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageImageServiceHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageImageServiceHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageImageServiceHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageImageServiceHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Options {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Options, T>::value>;
  using DataView = OptionsDataView;
  using Data_ = internal::Options_Data;

  template <typename... Args>
  static OptionsPtr New(Args&&... args) {
    return OptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OptionsPtr From(const U& u) {
    return mojo::TypeConverter<OptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Options>::Convert(*this);
  }


  Options();

  Options(
      bool suggest_images,
      bool optimization_guide_images);


  ~Options();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OptionsPtr>
  OptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Options::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Options::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Options::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Options::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Options::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Options::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Options_UnserializedMessageContext<
            UserType, Options::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Options::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Options::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Options_UnserializedMessageContext<
            UserType, Options::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Options::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool suggest_images;
  
  bool optimization_guide_images;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Options::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Options::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Options::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Options::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  ImageResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageResult, T>::value>;
  using DataView = ImageResultDataView;
  using Data_ = internal::ImageResult_Data;

  template <typename... Args>
  static ImageResultPtr New(Args&&... args) {
    return ImageResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageResultPtr From(const U& u) {
    return mojo::TypeConverter<ImageResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageResult>::Convert(*this);
  }


  ImageResult();

  explicit ImageResult(
      const ::GURL& image_url);


  ~ImageResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageResultPtr>
  ImageResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageResult_UnserializedMessageContext<
            UserType, ImageResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageResult_UnserializedMessageContext<
            UserType, ImageResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL image_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OptionsPtr Options::Clone() const {
  return New(
      mojo::Clone(suggest_images),
      mojo::Clone(optimization_guide_images)
  );
}

template <typename T, Options::EnableIfSame<T>*>
bool Options::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->suggest_images, other_struct.suggest_images))
    return false;
  if (!mojo::Equals(this->optimization_guide_images, other_struct.optimization_guide_images))
    return false;
  return true;
}

template <typename T, Options::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.suggest_images < rhs.suggest_images)
    return true;
  if (rhs.suggest_images < lhs.suggest_images)
    return false;
  if (lhs.optimization_guide_images < rhs.optimization_guide_images)
    return true;
  if (rhs.optimization_guide_images < lhs.optimization_guide_images)
    return false;
  return false;
}
template <typename StructPtrType>
ImageResultPtr ImageResult::Clone() const {
  return New(
      mojo::Clone(image_url)
  );
}

template <typename T, ImageResult::EnableIfSame<T>*>
bool ImageResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  return true;
}

template <typename T, ImageResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  return false;
}


}  // page_image_service::mojom

namespace mojo {


template <>
struct  StructTraits<::page_image_service::mojom::Options::DataView,
                                         ::page_image_service::mojom::OptionsPtr> {
  static bool IsNull(const ::page_image_service::mojom::OptionsPtr& input) { return !input; }
  static void SetToNull(::page_image_service::mojom::OptionsPtr* output) { output->reset(); }

  static decltype(::page_image_service::mojom::Options::suggest_images) suggest_images(
      const ::page_image_service::mojom::OptionsPtr& input) {
    return input->suggest_images;
  }

  static decltype(::page_image_service::mojom::Options::optimization_guide_images) optimization_guide_images(
      const ::page_image_service::mojom::OptionsPtr& input) {
    return input->optimization_guide_images;
  }

  static bool Read(::page_image_service::mojom::Options::DataView input, ::page_image_service::mojom::OptionsPtr* output);
};


template <>
struct  StructTraits<::page_image_service::mojom::ImageResult::DataView,
                                         ::page_image_service::mojom::ImageResultPtr> {
  static bool IsNull(const ::page_image_service::mojom::ImageResultPtr& input) { return !input; }
  static void SetToNull(::page_image_service::mojom::ImageResultPtr* output) { output->reset(); }

  static const decltype(::page_image_service::mojom::ImageResult::image_url)& image_url(
      const ::page_image_service::mojom::ImageResultPtr& input) {
    return input->image_url;
  }

  static bool Read(::page_image_service::mojom::ImageResult::DataView input, ::page_image_service::mojom::ImageResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PAGE_IMAGE_SERVICE_MOJOM_PAGE_IMAGE_SERVICE_MOJOM_H_