// components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/optimization_guide/optimization_guide_internals/webui/optimization_guide_internals.mojom-shared-internal.h"
#include "components/optimization_guide/core/optimization_guide_common.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace optimization_guide_internals::mojom {
class DownloadedModelInfoDataView;

class LoggedClientIdsDataView;

class MqlsLogDataView;



}  // optimization_guide_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::optimization_guide_internals::mojom::DownloadedModelInfoDataView> {
  using Data = ::optimization_guide_internals::mojom::internal::DownloadedModelInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::optimization_guide_internals::mojom::LoggedClientIdsDataView> {
  using Data = ::optimization_guide_internals::mojom::internal::LoggedClientIds_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::optimization_guide_internals::mojom::MqlsLogDataView> {
  using Data = ::optimization_guide_internals::mojom::internal::MqlsLog_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace optimization_guide_internals::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class DownloadedModelInfoDataView {
 public:
  DownloadedModelInfoDataView() = default;

  DownloadedModelInfoDataView(
      internal::DownloadedModelInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptimizationTargetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptimizationTarget(UserType* output) {
    
    auto* pointer = data_->optimization_target.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t version() const {
    return data_->version;
  }
  inline void GetFilePathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DownloadedModelInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoggedClientIdsDataView {
 public:
  LoggedClientIdsDataView() = default;

  LoggedClientIdsDataView(
      internal::LoggedClientIds_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t client_id() const {
    return data_->client_id;
  }
 private:
  internal::LoggedClientIds_Data* data_ = nullptr;
};


class MqlsLogDataView {
 public:
  MqlsLogDataView() = default;

  MqlsLogDataView(
      internal::MqlsLog_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeatureDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeature(UserType* output) {
    
    auto* pointer = data_->feature.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetProtoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProto(UserType* output) {
    
    auto* pointer = data_->proto.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MqlsLog_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // optimization_guide_internals::mojom

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_INTERNALS_WEBUI_OPTIMIZATION_GUIDE_INTERNALS_MOJOM_DATA_VIEW_H_