// components/omnibox/browser/searchbox.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_TEST_UTILS_H_
#define COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_TEST_UTILS_H_

#include "components/omnibox/browser/searchbox.mojom.h"


namespace searchbox::mojom {


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void SetPage(::mojo::PendingRemote<Page> page) override;
  void OnFocusChanged(bool focused) override;
  void QueryAutocomplete(const ::std::u16string& input, bool prevent_inline_autocomplete) override;
  void StopAutocomplete(bool clear_result) override;
  void OpenAutocompleteMatch(uint8_t line, const ::GURL& url, bool are_matches_showing, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) override;
  void OnNavigationLikely(uint8_t line, const ::GURL& url, ::omnibox::mojom::NavigationPredictor navigation_predictor) override;
  void DeleteAutocompleteMatch(uint8_t line, const ::GURL& url) override;
  void ActivateKeyword(uint8_t line, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, bool is_mouse_event) override;
  void ExecuteAction(uint8_t line, uint8_t action_index, const ::GURL& url, ::base::TimeTicks match_selection_timestamp, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) override;
  void OnThumbnailRemoved() override;
  void GetPlaceholderConfig(GetPlaceholderConfigCallback callback) override;
  void GetRecentTabs(GetRecentTabsCallback callback) override;
  void GetTabPreview(int32_t tab_id, GetTabPreviewCallback callback) override;
  void NotifySessionStarted() override;
  void NotifySessionAbandoned() override;
  void AddFileContext(SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, AddFileContextCallback callback) override;
  void AddTabContext(int32_t tab_id, AddTabContextCallback callback) override;
  void DeleteContext(const ::base::UnguessableToken& token) override;
  void ClearFiles() override;
  void SubmitQuery(const std::string& query_text, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetPlaceholderConfig(
      PlaceholderConfigPtr* out_config);
  PlaceholderConfigPtr GetPlaceholderConfig();
  void GetRecentTabs(
      std::vector<TabInfoPtr>* out_tabs);
  std::vector<TabInfoPtr> GetRecentTabs();
  void GetTabPreview(
      int32_t tab_id, std::optional<std::string>* out_preview_data_url);
  std::optional<std::string> GetTabPreview(int32_t tab_id);
  void AddFileContext(
      SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes, ::base::UnguessableToken* out_token);
  ::base::UnguessableToken AddFileContext(SelectedFileInfoPtr file_info, ::mojo_base::BigBuffer file_bytes);
  void AddTabContext(
      int32_t tab_id, std::optional<::base::UnguessableToken>* out_token);
  std::optional<::base::UnguessableToken> AddTabContext(int32_t tab_id);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void AutocompleteResultChanged(AutocompleteResultPtr result) override;
  void UpdateSelection(OmniboxPopupSelectionPtr old_selection, OmniboxPopupSelectionPtr selection) override;
  void SetInputText(const std::string& input) override;
  void SetThumbnail(const std::string& thumbnail_url, bool is_deletable) override;
  void OnContextualInputStatusChanged(const ::base::UnguessableToken& token, ::composebox_query::mojom::FileUploadStatus status, std::optional<::composebox_query::mojom::FileUploadErrorType> error_type) override;
  void OnTabStripChanged() override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // searchbox::mojom

#endif  // COMPONENTS_OMNIBOX_BROWSER_SEARCHBOX_MOJOM_TEST_UTILS_H_