// components/omnibox/browser/searchbox.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/omnibox/browser/searchbox.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/omnibox/browser/searchbox.mojom-params-data.h"
namespace searchbox {
namespace mojom {

NOINLINE static const char* SideTypeToStringHelper(SideType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SideType::kDefaultPrimary:
      return "kDefaultPrimary";
    case SideType::kSecondary:
      return "kSecondary";
    default:
      return nullptr;
  }
}

std::string SideTypeToString(SideType value) {
  const char *str = SideTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SideType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SideType value) {
  return os << SideTypeToString(value);
}

NOINLINE static const char* RenderTypeToStringHelper(RenderType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RenderType::kDefaultVertical:
      return "kDefaultVertical";
    case RenderType::kHorizontal:
      return "kHorizontal";
    case RenderType::kGrid:
      return "kGrid";
    default:
      return nullptr;
  }
}

std::string RenderTypeToString(RenderType value) {
  const char *str = RenderTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RenderType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RenderType value) {
  return os << RenderTypeToString(value);
}

NOINLINE static const char* SelectionLineStateToStringHelper(SelectionLineState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectionLineState::kNormal:
      return "kNormal";
    case SelectionLineState::kKeywordMode:
      return "kKeywordMode";
    case SelectionLineState::kFocusedButtonAction:
      return "kFocusedButtonAction";
    case SelectionLineState::kFocusedButtonRemoveSuggestion:
      return "kFocusedButtonRemoveSuggestion";
    default:
      return nullptr;
  }
}

std::string SelectionLineStateToString(SelectionLineState value) {
  const char *str = SelectionLineStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectionLineState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectionLineState value) {
  return os << SelectionLineStateToString(value);
}

namespace internal {


// static
bool ACMatchClassification_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ACMatchClassification_Data* object =
      static_cast<const ACMatchClassification_Data*>(data);

  return true;
}

ACMatchClassification_Data::ACMatchClassification_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Action_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Action_Data* object =
      static_cast<const Action_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hint, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hint, validation_context,
                                         &hint_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestion_contents, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestion_contents_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestion_contents, validation_context,
                                         &suggestion_contents_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_path, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icon_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_path, validation_context,
                                         &icon_path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->a11y_label, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& a11y_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->a11y_label, validation_context,
                                         &a11y_label_validate_params)) {
    return false;
  }

  return true;
}

Action_Data::Action_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SuggestionAnswer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SuggestionAnswer_Data* object =
      static_cast<const SuggestionAnswer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->first_line, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->first_line, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->second_line, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->second_line, validation_context))
    return false;

  return true;
}

SuggestionAnswer_Data::SuggestionAnswer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteMatch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 168, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteMatch_Data* object =
      static_cast<const AutocompleteMatch_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->a11y_label, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->a11y_label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actions, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actions, validation_context,
                                         &actions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->answer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->contents, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents_class, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& contents_class_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->contents_class, validation_context,
                                         &contents_class_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_class, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_class_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_class, validation_context,
                                         &description_class_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inline_autocompletion, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->inline_autocompletion, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fill_into_edit, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fill_into_edit, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_path, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icon_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_path, validation_context,
                                         &icon_path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_dominant_color, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_dominant_color_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_dominant_color, validation_context,
                                         &image_dominant_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_url, validation_context,
                                         &image_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 22, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remove_button_a11y_label, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remove_button_a11y_label, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tail_suggest_common_prefix, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword_chip_hint, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keyword_chip_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyword_chip_hint, validation_context,
                                         &keyword_chip_hint_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyword_chip_a11y, 30, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keyword_chip_a11y_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyword_chip_a11y, validation_context,
                                         &keyword_chip_a11y_validate_params)) {
    return false;
  }

  return true;
}

AutocompleteMatch_Data::AutocompleteMatch_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabInfo_Data* object =
      static_cast<const TabInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_active, validation_context))
    return false;

  return true;
}

TabInfo_Data::TabInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectedFileInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectedFileInfo_Data* object =
      static_cast<const SelectedFileInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_name, validation_context,
                                         &file_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection_time, validation_context))
    return false;

  return true;
}

SelectedFileInfo_Data::SelectedFileInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SuggestionGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SuggestionGroup_Data* object =
      static_cast<const SuggestionGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->header, validation_context))
    return false;


  if (!::searchbox::mojom::internal::RenderType_Data
        ::Validate(object->render_type, validation_context))
    return false;


  if (!::searchbox::mojom::internal::SideType_Data
        ::Validate(object->side_type, validation_context))
    return false;

  return true;
}

SuggestionGroup_Data::SuggestionGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteResult_Data* object =
      static_cast<const AutocompleteResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestion_groups_map, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestion_groups_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->suggestion_groups_map, validation_context,
                                         &suggestion_groups_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matches, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->matches, validation_context,
                                         &matches_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->smart_compose_inline_hint, validation_context))
    return false;

  return true;
}

AutocompleteResult_Data::AutocompleteResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OmniboxPopupSelection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OmniboxPopupSelection_Data* object =
      static_cast<const OmniboxPopupSelection_Data*>(data);


  if (!::searchbox::mojom::internal::SelectionLineState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

OmniboxPopupSelection_Data::OmniboxPopupSelection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlaceholderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlaceholderConfig_Data* object =
      static_cast<const PlaceholderConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->texts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& texts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->texts, validation_context,
                                         &texts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->change_text_animation_interval, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->change_text_animation_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fade_text_animation_duration, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fade_text_animation_duration, validation_context))
    return false;

  return true;
}

PlaceholderConfig_Data::PlaceholderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPage_Params_Data* object =
      static_cast<const PageHandler_SetPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_SetPage_Params_Data::PageHandler_SetPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnFocusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnFocusChanged_Params_Data* object =
      static_cast<const PageHandler_OnFocusChanged_Params_Data*>(data);

  return true;
}

PageHandler_OnFocusChanged_Params_Data::PageHandler_OnFocusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_QueryAutocomplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_QueryAutocomplete_Params_Data* object =
      static_cast<const PageHandler_QueryAutocomplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  return true;
}

PageHandler_QueryAutocomplete_Params_Data::PageHandler_QueryAutocomplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StopAutocomplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StopAutocomplete_Params_Data* object =
      static_cast<const PageHandler_StopAutocomplete_Params_Data*>(data);

  return true;
}

PageHandler_StopAutocomplete_Params_Data::PageHandler_StopAutocomplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenAutocompleteMatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenAutocompleteMatch_Params_Data* object =
      static_cast<const PageHandler_OpenAutocompleteMatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_OpenAutocompleteMatch_Params_Data::PageHandler_OpenAutocompleteMatch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnNavigationLikely_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnNavigationLikely_Params_Data* object =
      static_cast<const PageHandler_OnNavigationLikely_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::omnibox::mojom::internal::NavigationPredictor_Data
        ::Validate(object->navigation_predictor, validation_context))
    return false;

  return true;
}

PageHandler_OnNavigationLikely_Params_Data::PageHandler_OnNavigationLikely_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteAutocompleteMatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteAutocompleteMatch_Params_Data* object =
      static_cast<const PageHandler_DeleteAutocompleteMatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_DeleteAutocompleteMatch_Params_Data::PageHandler_DeleteAutocompleteMatch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ActivateKeyword_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ActivateKeyword_Params_Data* object =
      static_cast<const PageHandler_ActivateKeyword_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match_selection_timestamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->match_selection_timestamp, validation_context))
    return false;

  return true;
}

PageHandler_ActivateKeyword_Params_Data::PageHandler_ActivateKeyword_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ExecuteAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ExecuteAction_Params_Data* object =
      static_cast<const PageHandler_ExecuteAction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match_selection_timestamp, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->match_selection_timestamp, validation_context))
    return false;

  return true;
}

PageHandler_ExecuteAction_Params_Data::PageHandler_ExecuteAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnThumbnailRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnThumbnailRemoved_Params_Data* object =
      static_cast<const PageHandler_OnThumbnailRemoved_Params_Data*>(data);

  return true;
}

PageHandler_OnThumbnailRemoved_Params_Data::PageHandler_OnThumbnailRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetPlaceholderConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetPlaceholderConfig_Params_Data* object =
      static_cast<const PageHandler_GetPlaceholderConfig_Params_Data*>(data);

  return true;
}

PageHandler_GetPlaceholderConfig_Params_Data::PageHandler_GetPlaceholderConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetPlaceholderConfig_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetPlaceholderConfig_ResponseParams_Data* object =
      static_cast<const PageHandler_GetPlaceholderConfig_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

PageHandler_GetPlaceholderConfig_ResponseParams_Data::PageHandler_GetPlaceholderConfig_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetRecentTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetRecentTabs_Params_Data* object =
      static_cast<const PageHandler_GetRecentTabs_Params_Data*>(data);

  return true;
}

PageHandler_GetRecentTabs_Params_Data::PageHandler_GetRecentTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetRecentTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetRecentTabs_ResponseParams_Data* object =
      static_cast<const PageHandler_GetRecentTabs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tabs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tabs, validation_context,
                                         &tabs_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetRecentTabs_ResponseParams_Data::PageHandler_GetRecentTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabPreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabPreview_Params_Data* object =
      static_cast<const PageHandler_GetTabPreview_Params_Data*>(data);

  return true;
}

PageHandler_GetTabPreview_Params_Data::PageHandler_GetTabPreview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabPreview_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabPreview_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabPreview_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& preview_data_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->preview_data_url, validation_context,
                                         &preview_data_url_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetTabPreview_ResponseParams_Data::PageHandler_GetTabPreview_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_NotifySessionStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_NotifySessionStarted_Params_Data* object =
      static_cast<const PageHandler_NotifySessionStarted_Params_Data*>(data);

  return true;
}

PageHandler_NotifySessionStarted_Params_Data::PageHandler_NotifySessionStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_NotifySessionAbandoned_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_NotifySessionAbandoned_Params_Data* object =
      static_cast<const PageHandler_NotifySessionAbandoned_Params_Data*>(data);

  return true;
}

PageHandler_NotifySessionAbandoned_Params_Data::PageHandler_NotifySessionAbandoned_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddFileContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddFileContext_Params_Data* object =
      static_cast<const PageHandler_AddFileContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->file_bytes, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->file_bytes, validation_context))
    return false;

  return true;
}

PageHandler_AddFileContext_Params_Data::PageHandler_AddFileContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddFileContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddFileContext_ResponseParams_Data* object =
      static_cast<const PageHandler_AddFileContext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

PageHandler_AddFileContext_ResponseParams_Data::PageHandler_AddFileContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddTabContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddTabContext_Params_Data* object =
      static_cast<const PageHandler_AddTabContext_Params_Data*>(data);

  return true;
}

PageHandler_AddTabContext_Params_Data::PageHandler_AddTabContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AddTabContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AddTabContext_ResponseParams_Data* object =
      static_cast<const PageHandler_AddTabContext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

PageHandler_AddTabContext_ResponseParams_Data::PageHandler_AddTabContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteContext_Params_Data* object =
      static_cast<const PageHandler_DeleteContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

PageHandler_DeleteContext_Params_Data::PageHandler_DeleteContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClearFiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClearFiles_Params_Data* object =
      static_cast<const PageHandler_ClearFiles_Params_Data*>(data);

  return true;
}

PageHandler_ClearFiles_Params_Data::PageHandler_ClearFiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SubmitQuery_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SubmitQuery_Params_Data* object =
      static_cast<const PageHandler_SubmitQuery_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query_text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query_text, validation_context,
                                         &query_text_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SubmitQuery_Params_Data::PageHandler_SubmitQuery_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_AutocompleteResultChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_AutocompleteResultChanged_Params_Data* object =
      static_cast<const Page_AutocompleteResultChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Page_AutocompleteResultChanged_Params_Data::Page_AutocompleteResultChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_UpdateSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_UpdateSelection_Params_Data* object =
      static_cast<const Page_UpdateSelection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->old_selection, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->old_selection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection, validation_context))
    return false;

  return true;
}

Page_UpdateSelection_Params_Data::Page_UpdateSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetInputText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetInputText_Params_Data* object =
      static_cast<const Page_SetInputText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  return true;
}

Page_SetInputText_Params_Data::Page_SetInputText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetThumbnail_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetThumbnail_Params_Data* object =
      static_cast<const Page_SetThumbnail_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumbnail_url, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& thumbnail_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->thumbnail_url, validation_context,
                                         &thumbnail_url_validate_params)) {
    return false;
  }

  return true;
}

Page_SetThumbnail_Params_Data::Page_SetThumbnail_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnContextualInputStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnContextualInputStatusChanged_Params_Data* object =
      static_cast<const Page_OnContextualInputStatusChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;


  if (!::composebox_query::mojom::internal::FileUploadStatus_Data
        ::Validate(object->status, validation_context))
    return false;


  if (!::composebox_query::mojom::internal::FileUploadErrorType_Data
        ::Validate(object->error_type_$value, validation_context))
    return false;

  return true;
}

Page_OnContextualInputStatusChanged_Params_Data::Page_OnContextualInputStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnTabStripChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnTabStripChanged_Params_Data* object =
      static_cast<const Page_OnTabStripChanged_Params_Data*>(data);

  return true;
}

Page_OnTabStripChanged_Params_Data::Page_OnTabStripChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace searchbox

namespace perfetto {

// static
void TraceFormatTraits<::searchbox::mojom::SideType>::WriteIntoTrace(
   perfetto::TracedValue context, ::searchbox::mojom::SideType value) {
  return std::move(context).WriteString(::searchbox::mojom::SideTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::searchbox::mojom::RenderType>::WriteIntoTrace(
   perfetto::TracedValue context, ::searchbox::mojom::RenderType value) {
  return std::move(context).WriteString(::searchbox::mojom::RenderTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::searchbox::mojom::SelectionLineState>::WriteIntoTrace(
   perfetto::TracedValue context, ::searchbox::mojom::SelectionLineState value) {
  return std::move(context).WriteString(::searchbox::mojom::SelectionLineStateToString(value));
}

} // namespace perfetto