// components/mirroring/mojom/session_parameters.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/mirroring/mojom/session_parameters.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/session_parameters.mojom-params-data.h"
#include "components/mirroring/mojom/session_parameters.mojom-shared-message-ids.h"

#include "components/mirroring/mojom/session_parameters.mojom-import-headers.h"
#include "components/mirroring/mojom/session_parameters.mojom-test-utils.h"


namespace mirroring::mojom {
SessionParameters::SessionParameters()
    : type(),
      receiver_address(),
      receiver_friendly_name(),
      source_id(),
      destination_id(),
      target_playout_delay(),
      is_remote_playback(),
      force_letterboxing(),
      enable_rtcp_reporting() {}

SessionParameters::SessionParameters(
    SessionType type_in,
    const ::net::IPAddress& receiver_address_in,
    const std::string& receiver_friendly_name_in,
    const std::string& source_id_in,
    const std::string& destination_id_in,
    std::optional<::base::TimeDelta> target_playout_delay_in,
    bool is_remote_playback_in,
    bool force_letterboxing_in,
    bool enable_rtcp_reporting_in)
    : type(std::move(type_in)),
      receiver_address(std::move(receiver_address_in)),
      receiver_friendly_name(std::move(receiver_friendly_name_in)),
      source_id(std::move(source_id_in)),
      destination_id(std::move(destination_id_in)),
      target_playout_delay(std::move(target_playout_delay_in)),
      is_remote_playback(std::move(is_remote_playback_in)),
      force_letterboxing(std::move(force_letterboxing_in)),
      enable_rtcp_reporting(std::move(enable_rtcp_reporting_in)) {}

SessionParameters::~SessionParameters() = default;

void SessionParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SessionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver_address"), this->receiver_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPAddress&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver_friendly_name"), this->receiver_friendly_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination_id"), this->destination_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_playout_delay"), this->target_playout_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_remote_playback"), this->is_remote_playback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_letterboxing"), this->force_letterboxing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_rtcp_reporting"), this->enable_rtcp_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SessionParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // mirroring::mojom


namespace mojo {


// static
bool StructTraits<::mirroring::mojom::SessionParameters::DataView, ::mirroring::mojom::SessionParametersPtr>::Read(
    ::mirroring::mojom::SessionParameters::DataView input,
    ::mirroring::mojom::SessionParametersPtr* output) {
  bool success = true;
  ::mirroring::mojom::SessionParametersPtr result(::mirroring::mojom::SessionParameters::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadReceiverAddress(&result->receiver_address))
        success = false;
      if (success && !input.ReadReceiverFriendlyName(&result->receiver_friendly_name))
        success = false;
      if (success && !input.ReadSourceId(&result->source_id))
        success = false;
      if (success && !input.ReadDestinationId(&result->destination_id))
        success = false;
      if (success && !input.ReadTargetPlayoutDelay(&result->target_playout_delay))
        success = false;
      if (success)
        result->is_remote_playback = input.is_remote_playback();
      if (success)
        result->force_letterboxing = input.force_letterboxing();
      if (success)
        result->enable_rtcp_reporting = input.enable_rtcp_reporting();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mirroring::mojom {




}  // mirroring::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif