// components/mirroring/mojom/session_parameters.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/mirroring/mojom/session_parameters.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/mirroring/mojom/session_parameters.mojom-params-data.h"
namespace mirroring {
namespace mojom {

NOINLINE static const char* SessionTypeToStringHelper(SessionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SessionType::AUDIO_ONLY:
      return "AUDIO_ONLY";
    case SessionType::VIDEO_ONLY:
      return "VIDEO_ONLY";
    case SessionType::AUDIO_AND_VIDEO:
      return "AUDIO_AND_VIDEO";
    default:
      return nullptr;
  }
}

std::string SessionTypeToString(SessionType value) {
  const char *str = SessionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SessionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SessionType value) {
  return os << SessionTypeToString(value);
}

namespace internal {


// static
bool SessionParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionParameters_Data* object =
      static_cast<const SessionParameters_Data*>(data);


  if (!::mirroring::mojom::internal::SessionType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->receiver_address, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->receiver_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->receiver_friendly_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& receiver_friendly_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->receiver_friendly_name, validation_context,
                                         &receiver_friendly_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_id, validation_context,
                                         &source_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& destination_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->destination_id, validation_context,
                                         &destination_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->target_playout_delay, validation_context))
    return false;

  return true;
}

SessionParameters_Data::SessionParameters_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mirroring

namespace perfetto {

// static
void TraceFormatTraits<::mirroring::mojom::SessionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::mirroring::mojom::SessionType value) {
  return std::move(context).WriteString(::mirroring::mojom::SessionTypeToString(value));
}

} // namespace perfetto