// components/mirroring/mojom/mirroring_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MIRRORING_MOJOM_MIRRORING_SERVICE_MOJOM_H_
#define COMPONENTS_MIRRORING_MOJOM_MIRRORING_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/mirroring/mojom/mirroring_service.mojom-features.h"  // IWYU pragma: export
#include "components/mirroring/mojom/mirroring_service.mojom-shared.h"  // IWYU pragma: export
#include "components/mirroring/mojom/mirroring_service.mojom-forward.h"  // IWYU pragma: export
#include "components/mirroring/mojom/cast_message_channel.mojom-forward.h"
#include "components/mirroring/mojom/resource_provider.mojom-forward.h"
#include "components/mirroring/mojom/session_observer.mojom-forward.h"
#include "components/mirroring/mojom/session_parameters.mojom-forward.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kMirroringSandbox = ::sandbox::mojom::Sandbox::kMirroring;


namespace mirroring::mojom {

class MirroringServiceProxy;

template <typename ImplRefTraits>
class MirroringServiceStub;

class MirroringServiceRequestValidator;
class MirroringServiceResponseValidator;


class MirroringService
    : public MirroringServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mirroring.mojom.MirroringService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kMirroring;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MirroringServiceInterfaceBase;
  using Proxy_ = MirroringServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MirroringServiceStub<ImplRefTraits>;

  using RequestValidator_ = MirroringServiceRequestValidator;
  using ResponseValidator_ = MirroringServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kSwitchMirroringSourceTabMinVersion = 0,
    kGetMirroringStatsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwitchMirroringSourceTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMirroringStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MirroringService() = default;

  virtual void Start(::mirroring::mojom::SessionParametersPtr params, const ::gfx::Size& max_resolution, ::mojo::PendingRemote<::mirroring::mojom::SessionObserver> observer, ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider> resource_provider, ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel> outbound_channel, ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel> inbound_channel) = 0;

  virtual void SwitchMirroringSourceTab() = 0;

  using GetMirroringStatsCallback = base::OnceCallback<void(::base::Value)>;
  using GetMirroringStatsMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void GetMirroringStats(GetMirroringStatsCallback callback) = 0;
};



class  MirroringServiceProxy
    : public MirroringService {
 public:
  using InterfaceType = MirroringService;

  explicit MirroringServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(::mirroring::mojom::SessionParametersPtr params, const ::gfx::Size& max_resolution, ::mojo::PendingRemote<::mirroring::mojom::SessionObserver> observer, ::mojo::PendingRemote<::mirroring::mojom::ResourceProvider> resource_provider, ::mojo::PendingRemote<::mirroring::mojom::CastMessageChannel> outbound_channel, ::mojo::PendingReceiver<::mirroring::mojom::CastMessageChannel> inbound_channel) final;
  
  void SwitchMirroringSourceTab() final;
  
  void GetMirroringStats(GetMirroringStatsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MirroringServiceStubDispatch {
 public:
  static bool Accept(MirroringService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MirroringService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MirroringService>>
class MirroringServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MirroringServiceStub() = default;
  ~MirroringServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MirroringServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MirroringServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MirroringServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MirroringServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // mirroring::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MIRRORING_MOJOM_MIRRORING_SERVICE_MOJOM_H_