// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";export function umaLogTypeToString(type){if(!type){return"Unknown"}return type}export function timestampToString(timestampSeconds){if(!timestampSeconds.length){return"N/A"}const timestampInt=parseInt(timestampSeconds);assert(!isNaN(timestampInt));return new Date(timestampInt*1e3).toLocaleString()}export function sizeToString(size){if(size<0){return"N/A"}return`${(size/1024).toFixed(2)} KiB`}export function logEventToString(event){let result=`[${new Date(event.timestampMs).toISOString()}] ${event.event}`;if(event.message){result+=` (${event.message})`}return result}export function getEventsPeekString(events){if(!events.length){return"N/A"}const lastEvent=events[events.length-1];assert(lastEvent);return logEventToString(lastEvent)}