// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{getTrustedHTML}from"chrome://resources/js/static_types.js";import{MetricsInternalsBrowserProxyImpl}from"./browser_proxy.js";import{getTemplate}from"./field_trials.html.js";class NameUnhasher{hashNames=new Map(JSON.parse(localStorage.getItem("names")||"[]"));maxStoredNames=500;add(names){let changed=false;for(const[hash,name]of Object.entries(names)){if(name&&!this.hashNames.has(hash)){changed=true;this.hashNames.set(hash,name)}}if(changed){localStorage.setItem("names",JSON.stringify(Array.from(this.hashNames.entries()).slice(-this.maxStoredNames)))}return changed}displayName(named){const name=named.name||this.hashNames.get(named.hash);return name?`${name} (#${named.hash})`:`#${named.hash}`}}class SearchFilter{unhasher;searchText;searchParts=[];constructor(unhasher,searchText){this.unhasher=unhasher;this.searchText=searchText;this.searchText=searchText.toLowerCase();for(const separator of"/.:-"){const parts=this.searchText.split(separator);if(parts.length===2){this.searchParts.push(parts)}}}match(named,checkParts){if(this.searchText===""){return MatchResult.NONE}let match=this.matchNameOrHash(this.searchText,named);if(!match&&checkParts){for(const parts of this.searchParts){match=this.matchNameOrHash(parts["groups"in named?0:1],named);if(match){break}}}return match?MatchResult.MATCH:MatchResult.MISMATCH}matchNameOrHash(search,subject){return this.unhasher.displayName(subject).toLowerCase().includes(search)}}var MatchResult;(function(MatchResult){MatchResult["NONE"]="";MatchResult["MATCH"]="match";MatchResult["MISMATCH"]="no-match"})(MatchResult||(MatchResult={}));export class TrialRow{app;trial;root;overridden=false;experimentRows=[];constructor(app,trial){this.app=app;this.trial=trial;this.root=document.createElement("div");this.root.classList.add("trial-row");this.root.innerHTML=getTrustedHTML`
      <div class="trial-header">
        <button class="expand-button"></button>
        <span class="trial-name"></span>
      </div>
      <div class="trial-groups"></div>`;for(const group of trial.groups){this.overridden=this.overridden||group.forceEnabled;const experimentRow=new ExperimentRow(this.app,trial,group);this.experimentRows.push(experimentRow)}this.root.querySelector(".trial-groups").replaceChildren(...this.experimentRows.map((r=>r.root)));this.root.querySelector(".expand-button").addEventListener("click",(()=>{const dataset=this.root.dataset;dataset["expanded"]=String(dataset["expanded"]!=="true")}))}update(){this.root.querySelector(".trial-name").replaceChildren(this.app.unhasher.displayName(this.trial));for(const row of this.experimentRows){row.update()}}findExperimentRow(groupHash){return this.experimentRows.find((row=>row.group.hash===groupHash))}setMatchResult(result){this.root.dataset["searchResult"]=result}filter(searchFilter){let matches=0;let trialResult=searchFilter.match(this.trial,true);for(const row of this.experimentRows){const result=searchFilter.match(row.group,trialResult===MatchResult.MATCH);row.setMatchResult(result);if(result===MatchResult.MATCH){trialResult=MatchResult.MATCH;matches++}}this.root.dataset["searchResult"]=trialResult;return[trialResult===MatchResult.MATCH,matches]}displayName(){return this.app.unhasher.displayName(this.trial)}sortKey(){const name=this.displayName();return`${Number(!this.overridden)}${Number(name.startsWith("#"))}${name}`}}class ExperimentRow{app;trial;group;root;constructor(app,trial,group){this.app=app;this.trial=trial;this.group=group;this.root=document.createElement("div");this.root.classList.add("experiment-row");this.root.innerHTML=getTrustedHTML`
      <div class="experiment-name"></div>
      <div class="override">
        <label for="override">
          Override <input type="checkbox" name="override">
        </label>
      </div>`;if(group.enabled){this.root.dataset["enrolled"]="1"}if(group.forceEnabled){this.setForceEnabled(true)}this.update();this.root.querySelector("input").addEventListener("click",(()=>this.app.toggleForceEnable(trial,group)))}update(){this.root.querySelector(".experiment-name").replaceChildren(this.app.unhasher.displayName(this.group))}setForceEnabled(forceEnabled){this.group.forceEnabled=forceEnabled;const checkbox=this.root.querySelector("input");checkbox.checked=forceEnabled;if(forceEnabled){checkbox.dataset["overridden"]="1"}else{delete checkbox.dataset["overridden"]}}setMatchResult(result){this.root.dataset["searchResult"]=result}}export class FieldTrialsAppElement extends CustomElement{static get is(){return"field-trials-app"}static get template(){return getTemplate()}proxy_=MetricsInternalsBrowserProxyImpl.getInstance();dirty=true;trials=[];unhasher=new NameUnhasher;onUpdateForTesting=()=>{};el(id){const result=this.shadowRoot.getElementById(id);assert(result);return result}constructor(){super();new Promise((resolve=>{const observer=new IntersectionObserver((entries=>{if(entries.filter((entry=>entry.intersectionRatio>0)).length>0){resolve()}}));observer.observe(this)})).then((()=>{this.init_()}))}init_(){this.proxy_.fetchTrialState().then((state=>this.populateState_(state)));this.getRequiredElement("form").addEventListener("submit",(e=>e.preventDefault()));this.filterInputElement.value=localStorage.getItem("filter")||"";this.filterInputElement.addEventListener("input",(()=>this.filterUpdated_()));this.el("restart-button").addEventListener("click",(()=>this.proxy_.restart()));this.filterUpdated_()}forceUpdateForTesting(){this.update_()}setRestartRequired_(){this.dataset["needsRestart"]="true"}filterUpdated_(){this.el("filter-status").replaceChildren();localStorage.setItem("filter",this.filterInputElement.value);this.proxy_.lookupTrialOrGroupName(this.filterInputElement.value).then((names=>{if(this.unhasher.add(names)){this.setDirty_()}}));this.setDirty_()}setDirty_(){if(this.dirty){return}this.dirty=true;window.setTimeout((()=>this.update_()),500)}update_(){if(!this.dirty){return}this.dirty=false;for(const trial of this.trials){trial.update()}this.filterToInput_();this.onUpdateForTesting()}get filterInputElement(){return this.el("filter")}findTrialRow(trial){for(const t of this.trials){if(t.trial.hash===trial.hash){return t}}return undefined}toggleForceEnable(trial,group){group.forceEnabled=!group.forceEnabled;const trialRow=this.findTrialRow(trial);if(trialRow){for(const row of trialRow.experimentRows){row.setForceEnabled(group.forceEnabled&&row.group.hash===group.hash)}}this.proxy_.setTrialEnrollState(trial.hash,group.hash,group.forceEnabled);this.setRestartRequired_()}populateState_(state){const trialListDiv=this.el("field-trial-list");this.trials=state.trials.map((t=>new TrialRow(this,t)));this.trials.sort(((a,b)=>a.sortKey().localeCompare(b.sortKey())));trialListDiv.replaceChildren(...this.trials.map((t=>t.root)));this.dirty=true;if(state.restartRequired){this.setRestartRequired_()}this.update_()}filterToInput_(){this.filter_(this.filterInputElement.value)}filter_(searchText){const searchFilter=new SearchFilter(this.unhasher,searchText);let matchGroupCount=0;let matchTrialCount=0;let totalExperimentCount=0;for(const trial of this.trials){const[matched,matchedGroups]=trial.filter(searchFilter);if(matched){++matchTrialCount}matchGroupCount+=matchedGroups;totalExperimentCount+=trial.experimentRows.length}this.el("field-trial-list").dataset["expandAll"]=String(matchGroupCount>0&&matchGroupCount<totalExperimentCount/2);this.el("filter-status").replaceChildren(` (matched ${matchTrialCount} trials, ${matchGroupCount} groups)`)}}customElements.define(FieldTrialsAppElement.is,FieldTrialsAppElement);