// components/media_router/common/mojom/media_router.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/media_router.mojom-features.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/media_router.mojom-shared.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/media_router.mojom-forward.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/logger.mojom-forward.h"
#include "components/media_router/common/mojom/debugger.mojom-forward.h"
#include "components/media_router/common/mojom/media_controller.mojom-forward.h"
#include "components/media_router/common/mojom/media_route_provider_id.mojom-forward.h"
#include "components/media_router/common/mojom/media_status.mojom-forward.h"
#include "components/media_router/common/mojom/route_request_result_code.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/media_router/common/mojom/media_router_mojom_traits.h"




namespace media_router::mojom {

class MediaRouteProviderProxy;

template <typename ImplRefTraits>
class MediaRouteProviderStub;

class MediaRouteProviderRequestValidator;
class MediaRouteProviderResponseValidator;


class MediaRouteProvider
    : public MediaRouteProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_router.mojom.MediaRouteProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaRouteProviderInterfaceBase;
  using Proxy_ = MediaRouteProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaRouteProviderStub<ImplRefTraits>;

  using RequestValidator_ = MediaRouteProviderRequestValidator;
  using ResponseValidator_ = MediaRouteProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateRouteMinVersion = 0,
    kJoinRouteMinVersion = 0,
    kTerminateRouteMinVersion = 0,
    kSendRouteMessageMinVersion = 0,
    kSendRouteBinaryMessageMinVersion = 0,
    kStartObservingMediaSinksMinVersion = 0,
    kStopObservingMediaSinksMinVersion = 0,
    kStartObservingMediaRoutesMinVersion = 0,
    kDetachRouteMinVersion = 0,
    kDiscoverSinksNowMinVersion = 0,
    kBindMediaControllerMinVersion = 0,
    kGetStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateRoute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JoinRoute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TerminateRoute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendRouteMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendRouteBinaryMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartObservingMediaSinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopObservingMediaSinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartObservingMediaRoutes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetachRoute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DiscoverSinksNow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindMediaController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaRouteProvider() = default;

  using CreateRouteCallback = base::OnceCallback<void(const std::optional<::media_router::MediaRoute>&, RoutePresentationConnectionPtr, const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;
  using CreateRouteMojoCallback = base::OnceCallback<void(const std::optional<::media_router::MediaRoute>&, RoutePresentationConnectionPtr, const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;

  virtual void CreateRoute(const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, CreateRouteCallback callback) = 0;

  using JoinRouteCallback = base::OnceCallback<void(const std::optional<::media_router::MediaRoute>&, RoutePresentationConnectionPtr, const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;
  using JoinRouteMojoCallback = base::OnceCallback<void(const std::optional<::media_router::MediaRoute>&, RoutePresentationConnectionPtr, const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;

  virtual void JoinRoute(const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, JoinRouteCallback callback) = 0;

  using TerminateRouteCallback = base::OnceCallback<void(const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;
  using TerminateRouteMojoCallback = base::OnceCallback<void(const std::optional<std::string>&, ::media_router::mojom::RouteRequestResultCode)>;

  virtual void TerminateRoute(const std::string& route_id, TerminateRouteCallback callback) = 0;

  virtual void SendRouteMessage(const std::string& media_route_id, const std::string& message) = 0;

  virtual void SendRouteBinaryMessage(const std::string& media_route_id, const std::vector<uint8_t>& data) = 0;

  virtual void StartObservingMediaSinks(const std::string& media_source) = 0;

  virtual void StopObservingMediaSinks(const std::string& media_source) = 0;

  virtual void StartObservingMediaRoutes() = 0;

  virtual void DetachRoute(const std::string& route_id) = 0;

  virtual void DiscoverSinksNow() = 0;

  using BindMediaControllerCallback = base::OnceCallback<void(bool)>;
  using BindMediaControllerMojoCallback = base::OnceCallback<void(bool)>;

  virtual void BindMediaController(const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, BindMediaControllerCallback callback) = 0;

  using GetStateCallback = base::OnceCallback<void(ProviderStatePtr)>;
  using GetStateMojoCallback = base::OnceCallback<void(ProviderStatePtr)>;

  virtual void GetState(GetStateCallback callback) = 0;
};

class MediaRouterProxy;

template <typename ImplRefTraits>
class MediaRouterStub;

class MediaRouterRequestValidator;
class MediaRouterResponseValidator;


class MediaRouter
    : public MediaRouterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_router.mojom.MediaRouter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaRouterInterfaceBase;
  using Proxy_ = MediaRouterProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaRouterStub<ImplRefTraits>;

  using RequestValidator_ = MediaRouterRequestValidator;
  using ResponseValidator_ = MediaRouterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterMediaRouteProviderMinVersion = 0,
    kOnSinksReceivedMinVersion = 0,
    kOnIssueMinVersion = 0,
    kClearTopIssueForSinkMinVersion = 0,
    kOnRoutesUpdatedMinVersion = 0,
    kOnPresentationConnectionStateChangedMinVersion = 0,
    kOnPresentationConnectionClosedMinVersion = 0,
    kOnRouteMessagesReceivedMinVersion = 0,
    kGetMediaSinkServiceStatusMinVersion = 0,
    kGetLoggerMinVersion = 0,
    kGetDebuggerMinVersion = 0,
    kGetLogsAsStringMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterMediaRouteProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSinksReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnIssue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTopIssueForSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRoutesUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPresentationConnectionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPresentationConnectionClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRouteMessagesReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMediaSinkServiceStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLogger_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDebugger_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLogsAsString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaRouter() = default;

  virtual void RegisterMediaRouteProvider(::media_router::mojom::MediaRouteProviderId provider_id, ::mojo::PendingRemote<MediaRouteProvider> media_router_provider) = 0;

  virtual void OnSinksReceived(::media_router::mojom::MediaRouteProviderId provider_id, const std::string& media_source, const std::vector<::media_router::MediaSinkInternal>& sinks, const std::vector<::url::Origin>& origins) = 0;

  virtual void OnIssue(const ::media_router::IssueInfo& issue) = 0;

  virtual void ClearTopIssueForSink(const std::string& sink_id) = 0;

  virtual void OnRoutesUpdated(::media_router::mojom::MediaRouteProviderId provider_id, const std::vector<::media_router::MediaRoute>& routes) = 0;

  virtual void OnPresentationConnectionStateChanged(const std::string& route_id, ::blink::mojom::PresentationConnectionState state) = 0;

  virtual void OnPresentationConnectionClosed(const std::string& route_id, ::blink::mojom::PresentationConnectionCloseReason reason, const std::string& message) = 0;

  virtual void OnRouteMessagesReceived(const std::string& route_id, std::vector<RouteMessagePtr> messages) = 0;

  using GetMediaSinkServiceStatusCallback = base::OnceCallback<void(const std::string&)>;
  using GetMediaSinkServiceStatusMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetMediaSinkServiceStatus(GetMediaSinkServiceStatusCallback callback) = 0;

  virtual void GetLogger(::mojo::PendingReceiver<::media_router::mojom::Logger> receiver) = 0;

  virtual void GetDebugger(::mojo::PendingReceiver<::media_router::mojom::Debugger> receiver) = 0;

  using GetLogsAsStringCallback = base::OnceCallback<void(const std::string&)>;
  using GetLogsAsStringMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetLogsAsString(GetLogsAsStringCallback callback) = 0;
};



class  MediaRouteProviderProxy
    : public MediaRouteProvider {
 public:
  using InterfaceType = MediaRouteProvider;

  explicit MediaRouteProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateRoute(const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, CreateRouteCallback callback) final;
  
  void JoinRoute(const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, JoinRouteCallback callback) final;
  
  void TerminateRoute(const std::string& route_id, TerminateRouteCallback callback) final;
  
  void SendRouteMessage(const std::string& media_route_id, const std::string& message) final;
  
  void SendRouteBinaryMessage(const std::string& media_route_id, const std::vector<uint8_t>& data) final;
  
  void StartObservingMediaSinks(const std::string& media_source) final;
  
  void StopObservingMediaSinks(const std::string& media_source) final;
  
  void StartObservingMediaRoutes() final;
  
  void DetachRoute(const std::string& route_id) final;
  
  void DiscoverSinksNow() final;
  
  void BindMediaController(const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, BindMediaControllerCallback callback) final;
  
  void GetState(GetStateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaRouterProxy
    : public MediaRouter {
 public:
  using InterfaceType = MediaRouter;

  explicit MediaRouterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterMediaRouteProvider(::media_router::mojom::MediaRouteProviderId provider_id, ::mojo::PendingRemote<MediaRouteProvider> media_router_provider) final;
  
  void OnSinksReceived(::media_router::mojom::MediaRouteProviderId provider_id, const std::string& media_source, const std::vector<::media_router::MediaSinkInternal>& sinks, const std::vector<::url::Origin>& origins) final;
  
  void OnIssue(const ::media_router::IssueInfo& issue) final;
  
  void ClearTopIssueForSink(const std::string& sink_id) final;
  
  void OnRoutesUpdated(::media_router::mojom::MediaRouteProviderId provider_id, const std::vector<::media_router::MediaRoute>& routes) final;
  
  void OnPresentationConnectionStateChanged(const std::string& route_id, ::blink::mojom::PresentationConnectionState state) final;
  
  void OnPresentationConnectionClosed(const std::string& route_id, ::blink::mojom::PresentationConnectionCloseReason reason, const std::string& message) final;
  
  void OnRouteMessagesReceived(const std::string& route_id, std::vector<RouteMessagePtr> messages) final;
  
  void GetMediaSinkServiceStatus(GetMediaSinkServiceStatusCallback callback) final;
  
  void GetLogger(::mojo::PendingReceiver<::media_router::mojom::Logger> receiver) final;
  
  void GetDebugger(::mojo::PendingReceiver<::media_router::mojom::Debugger> receiver) final;
  
  void GetLogsAsString(GetLogsAsStringCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaRouteProviderStubDispatch {
 public:
  static bool Accept(MediaRouteProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaRouteProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaRouteProvider>>
class MediaRouteProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaRouteProviderStub() = default;
  ~MediaRouteProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaRouteProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaRouteProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaRouterStubDispatch {
 public:
  static bool Accept(MediaRouter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaRouter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaRouter>>
class MediaRouterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaRouterStub() = default;
  ~MediaRouterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaRouterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaRouterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaRouteProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaRouterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaRouteProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaRouterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class  CastSessionState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CastSessionState, T>::value>;
  using DataView = CastSessionStateDataView;
  using Data_ = internal::CastSessionState_Data;

  template <typename... Args>
  static CastSessionStatePtr New(Args&&... args) {
    return CastSessionStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CastSessionStatePtr From(const U& u) {
    return mojo::TypeConverter<CastSessionStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CastSessionState>::Convert(*this);
  }


  CastSessionState();

  CastSessionState(
      const std::string& sink_id,
      const std::string& app_id,
      const std::string& session_id,
      const std::string& route_description);


  ~CastSessionState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CastSessionStatePtr>
  CastSessionStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastSessionState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastSessionState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CastSessionState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CastSessionState_UnserializedMessageContext<
            UserType, CastSessionState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CastSessionState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CastSessionState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CastSessionState_UnserializedMessageContext<
            UserType, CastSessionState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CastSessionState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string sink_id;
  
  std::string app_id;
  
  std::string session_id;
  
  std::string route_description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CastSessionState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  MediaSinkExtraData {
 public:
  using DataView = MediaSinkExtraDataDataView;
  using Data_ = internal::MediaSinkExtraData_Data;
  using Tag = Data_::MediaSinkExtraData_Tag;

  template <typename... Args>
  static MediaSinkExtraDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |dial_media_sink|.
  static MediaSinkExtraDataPtr NewDialMediaSink(
      DialMediaSinkPtr value);
  // Construct an instance holding |cast_media_sink|.
  static MediaSinkExtraDataPtr NewCastMediaSink(
      CastMediaSinkPtr value);

  template <typename U>
  static MediaSinkExtraDataPtr From(const U& u) {
    return mojo::TypeConverter<MediaSinkExtraDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSinkExtraData>::Convert(*this);
  }
  ~MediaSinkExtraData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MediaSinkExtraData(const MediaSinkExtraData& other) = delete;
  MediaSinkExtraData& operator=(const MediaSinkExtraData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MediaSinkExtraDataPtr>
  MediaSinkExtraDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MediaSinkExtraData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MediaSinkExtraData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_dial_media_sink() const { return tag_ == Tag::kDialMediaSink; }
  const DialMediaSinkPtr& get_dial_media_sink() const {
    CHECK(tag_ == Tag::kDialMediaSink);
    return data_.dial_media_sink;
  }
  DialMediaSinkPtr& get_dial_media_sink() {
    CHECK(tag_ == Tag::kDialMediaSink);
    return data_.dial_media_sink;
  }
  void set_dial_media_sink(DialMediaSinkPtr dial_media_sink);

  bool is_cast_media_sink() const { return tag_ == Tag::kCastMediaSink; }
  const CastMediaSinkPtr& get_cast_media_sink() const {
    CHECK(tag_ == Tag::kCastMediaSink);
    return data_.cast_media_sink;
  }
  CastMediaSinkPtr& get_cast_media_sink() {
    CHECK(tag_ == Tag::kCastMediaSink);
    return data_.cast_media_sink;
  }
  void set_cast_media_sink(CastMediaSinkPtr cast_media_sink);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSinkExtraData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MediaSinkExtraData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDialMediaSink)>,
        DialMediaSinkPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCastMediaSink)>,
        CastMediaSinkPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    DialMediaSinkPtr dial_media_sink;
    CastMediaSinkPtr cast_media_sink;
  };

  MediaSinkExtraData(
      std::in_place_index_t<static_cast<size_t>(Tag::kDialMediaSink)>,
      DialMediaSinkPtr value);
  MediaSinkExtraData(
      std::in_place_index_t<static_cast<size_t>(Tag::kCastMediaSink)>,
      CastMediaSinkPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ProviderState {
 public:
  using DataView = ProviderStateDataView;
  using Data_ = internal::ProviderState_Data;
  using Tag = Data_::ProviderState_Tag;

  template <typename... Args>
  static ProviderStatePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |cast_provider_state|.
  static ProviderStatePtr NewCastProviderState(
      CastProviderStatePtr value);

  template <typename U>
  static ProviderStatePtr From(const U& u) {
    return mojo::TypeConverter<ProviderStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProviderState>::Convert(*this);
  }
  ~ProviderState();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ProviderState(const ProviderState& other) = delete;
  ProviderState& operator=(const ProviderState& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ProviderStatePtr>
  ProviderStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ProviderState>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ProviderState>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_cast_provider_state() const { return tag_ == Tag::kCastProviderState; }
  const CastProviderStatePtr& get_cast_provider_state() const {
    CHECK(tag_ == Tag::kCastProviderState);
    return data_.cast_provider_state;
  }
  CastProviderStatePtr& get_cast_provider_state() {
    CHECK(tag_ == Tag::kCastProviderState);
    return data_.cast_provider_state;
  }
  void set_cast_provider_state(CastProviderStatePtr cast_provider_state);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProviderState::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ProviderState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCastProviderState)>,
        CastProviderStatePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CastProviderStatePtr cast_provider_state;
  };

  ProviderState(
      std::in_place_index_t<static_cast<size_t>(Tag::kCastProviderState)>,
      CastProviderStatePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  MediaSink {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSink, T>::value>;
  using DataView = MediaSinkDataView;
  using Data_ = internal::MediaSink_Data;

  template <typename... Args>
  static MediaSinkPtr New(Args&&... args) {
    return MediaSinkPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSinkPtr From(const U& u) {
    return mojo::TypeConverter<MediaSinkPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSink>::Convert(*this);
  }


  MediaSink();

  MediaSink(
      const std::string& sink_id,
      const std::string& name,
      SinkIconType icon_type,
      ::media_router::mojom::MediaRouteProviderId provider_id,
      MediaSinkExtraDataPtr extra_data);

MediaSink(const MediaSink&) = delete;
MediaSink& operator=(const MediaSink&) = delete;

  ~MediaSink();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSinkPtr>
  MediaSinkPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSink::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSink::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSink::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSink_UnserializedMessageContext<
            UserType, MediaSink::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaSink::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaSink::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSink_UnserializedMessageContext<
            UserType, MediaSink::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSink::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string sink_id;
  
  std::string name;
  
  SinkIconType icon_type;
  
  ::media_router::mojom::MediaRouteProviderId provider_id;
  
  MediaSinkExtraDataPtr extra_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSink::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DialMediaSink {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DialMediaSink, T>::value>;
  using DataView = DialMediaSinkDataView;
  using Data_ = internal::DialMediaSink_Data;

  template <typename... Args>
  static DialMediaSinkPtr New(Args&&... args) {
    return DialMediaSinkPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DialMediaSinkPtr From(const U& u) {
    return mojo::TypeConverter<DialMediaSinkPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DialMediaSink>::Convert(*this);
  }


  DialMediaSink();

  DialMediaSink(
      const ::net::IPAddress& ip_address,
      const std::string& model_name,
      const ::GURL& app_url);


  ~DialMediaSink();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DialMediaSinkPtr>
  DialMediaSinkPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DialMediaSink::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DialMediaSink::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DialMediaSink::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DialMediaSink_UnserializedMessageContext<
            UserType, DialMediaSink::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DialMediaSink::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DialMediaSink::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DialMediaSink_UnserializedMessageContext<
            UserType, DialMediaSink::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DialMediaSink::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPAddress ip_address;
  
  std::string model_name;
  
  ::GURL app_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DialMediaSink::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CastMediaSink {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CastMediaSink, T>::value>;
  using DataView = CastMediaSinkDataView;
  using Data_ = internal::CastMediaSink_Data;

  template <typename... Args>
  static CastMediaSinkPtr New(Args&&... args) {
    return CastMediaSinkPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CastMediaSinkPtr From(const U& u) {
    return mojo::TypeConverter<CastMediaSinkPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CastMediaSink>::Convert(*this);
  }


  CastMediaSink();

  CastMediaSink(
      const ::net::IPEndPoint& ip_endpoint,
      const std::string& model_name,
      uint64_t capabilities,
      int32_t cast_channel_id);


  ~CastMediaSink();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CastMediaSinkPtr>
  CastMediaSinkPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastMediaSink::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastMediaSink::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CastMediaSink::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CastMediaSink_UnserializedMessageContext<
            UserType, CastMediaSink::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CastMediaSink::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CastMediaSink::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CastMediaSink_UnserializedMessageContext<
            UserType, CastMediaSink::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CastMediaSink::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPEndPoint ip_endpoint;
  
  std::string model_name;
  
  uint64_t capabilities;
  
  int32_t cast_channel_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CastMediaSink::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaRoute {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaRoute, T>::value>;
  using DataView = MediaRouteDataView;
  using Data_ = internal::MediaRoute_Data;

  template <typename... Args>
  static MediaRoutePtr New(Args&&... args) {
    return MediaRoutePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaRoutePtr From(const U& u) {
    return mojo::TypeConverter<MediaRoutePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaRoute>::Convert(*this);
  }


  MediaRoute();

  MediaRoute(
      const std::string& media_route_id,
      const std::string& presentation_id,
      const std::optional<std::string>& media_source,
      const std::string& media_sink_id,
      const std::string& media_sink_name,
      const std::string& description,
      bool is_local,
      RouteControllerType controller_type,
      bool is_local_presentation,
      bool is_connecting);


  ~MediaRoute();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaRoutePtr>
  MediaRoutePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaRoute::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaRoute::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaRoute::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaRoute_UnserializedMessageContext<
            UserType, MediaRoute::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaRoute::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaRoute::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaRoute_UnserializedMessageContext<
            UserType, MediaRoute::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaRoute::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string media_route_id;
  
  std::string presentation_id;
  
  std::optional<std::string> media_source;
  
  std::string media_sink_id;
  
  std::string media_sink_name;
  
  std::string description;
  
  bool is_local;
  
  RouteControllerType controller_type;
  
  bool is_local_presentation;
  
  bool is_connecting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaRoute::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Issue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Issue, T>::value>;
  using DataView = IssueDataView;
  using Data_ = internal::Issue_Data;
  using Severity = Issue_Severity;

  template <typename... Args>
  static IssuePtr New(Args&&... args) {
    return IssuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IssuePtr From(const U& u) {
    return mojo::TypeConverter<IssuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Issue>::Convert(*this);
  }


  Issue();

  Issue(
      const std::string& route_id,
      const std::string& sink_id,
      ::media_router::IssueInfo::Severity severity,
      const std::string& title,
      const std::optional<std::string>& message);


  ~Issue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IssuePtr>
  IssuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Issue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Issue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Issue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Issue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Issue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Issue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Issue_UnserializedMessageContext<
            UserType, Issue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Issue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Issue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Issue_UnserializedMessageContext<
            UserType, Issue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Issue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string route_id;
  
  std::string sink_id;
  
  ::media_router::IssueInfo::Severity severity;
  
  std::string title;
  
  std::optional<std::string> message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Issue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Issue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Issue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Issue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RouteMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RouteMessage, T>::value>;
  using DataView = RouteMessageDataView;
  using Data_ = internal::RouteMessage_Data;
  using Type = RouteMessage_Type;

  template <typename... Args>
  static RouteMessagePtr New(Args&&... args) {
    return RouteMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RouteMessagePtr From(const U& u) {
    return mojo::TypeConverter<RouteMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RouteMessage>::Convert(*this);
  }


  RouteMessage();

  RouteMessage(
      RouteMessage::Type type,
      const std::optional<std::string>& message,
      std::optional<std::vector<uint8_t>> data);


  ~RouteMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RouteMessagePtr>
  RouteMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RouteMessage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RouteMessage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RouteMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RouteMessage_UnserializedMessageContext<
            UserType, RouteMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RouteMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RouteMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RouteMessage_UnserializedMessageContext<
            UserType, RouteMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RouteMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RouteMessage::Type type;
  
  std::optional<std::string> message;
  
  std::optional<std::vector<uint8_t>> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RouteMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RoutePresentationConnection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RoutePresentationConnection, T>::value>;
  using DataView = RoutePresentationConnectionDataView;
  using Data_ = internal::RoutePresentationConnection_Data;

  template <typename... Args>
  static RoutePresentationConnectionPtr New(Args&&... args) {
    return RoutePresentationConnectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RoutePresentationConnectionPtr From(const U& u) {
    return mojo::TypeConverter<RoutePresentationConnectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RoutePresentationConnection>::Convert(*this);
  }


  RoutePresentationConnection();

  RoutePresentationConnection(
      ::mojo::PendingRemote<::blink::mojom::PresentationConnection> connection_remote,
      ::mojo::PendingReceiver<::blink::mojom::PresentationConnection> connection_receiver);

RoutePresentationConnection(const RoutePresentationConnection&) = delete;
RoutePresentationConnection& operator=(const RoutePresentationConnection&) = delete;

  ~RoutePresentationConnection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RoutePresentationConnectionPtr>
  RoutePresentationConnectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RoutePresentationConnection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RoutePresentationConnection_UnserializedMessageContext<
            UserType, RoutePresentationConnection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RoutePresentationConnection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RoutePresentationConnection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RoutePresentationConnection_UnserializedMessageContext<
            UserType, RoutePresentationConnection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RoutePresentationConnection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::PresentationConnection> connection_remote;
  
  ::mojo::PendingReceiver<::blink::mojom::PresentationConnection> connection_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RoutePresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CastProviderState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CastProviderState, T>::value>;
  using DataView = CastProviderStateDataView;
  using Data_ = internal::CastProviderState_Data;

  template <typename... Args>
  static CastProviderStatePtr New(Args&&... args) {
    return CastProviderStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CastProviderStatePtr From(const U& u) {
    return mojo::TypeConverter<CastProviderStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CastProviderState>::Convert(*this);
  }


  CastProviderState();

  explicit CastProviderState(
      std::vector<CastSessionStatePtr> session_state);

CastProviderState(const CastProviderState&) = delete;
CastProviderState& operator=(const CastProviderState&) = delete;

  ~CastProviderState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CastProviderStatePtr>
  CastProviderStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastProviderState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CastProviderState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CastProviderState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CastProviderState_UnserializedMessageContext<
            UserType, CastProviderState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CastProviderState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CastProviderState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CastProviderState_UnserializedMessageContext<
            UserType, CastProviderState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CastProviderState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<CastSessionStatePtr> session_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CastProviderState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MediaSinkExtraDataPtr MediaSinkExtraData::Clone() const {
  switch (tag_) {
    case Tag::kDialMediaSink:
      return NewDialMediaSink(
          mojo::Clone(data_.dial_media_sink));
    case Tag::kCastMediaSink:
      return NewCastMediaSink(
          mojo::Clone(data_.cast_media_sink));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MediaSinkExtraData>::value>::type*>
bool MediaSinkExtraData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDialMediaSink:
      return mojo::Equals(data_.dial_media_sink, other.data_.dial_media_sink);
    case Tag::kCastMediaSink:
      return mojo::Equals(data_.cast_media_sink, other.data_.cast_media_sink);
  }

  return false;
}
template <typename UnionPtrType>
ProviderStatePtr ProviderState::Clone() const {
  switch (tag_) {
    case Tag::kCastProviderState:
      return NewCastProviderState(
          mojo::Clone(data_.cast_provider_state));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ProviderState>::value>::type*>
bool ProviderState::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCastProviderState:
      return mojo::Equals(data_.cast_provider_state, other.data_.cast_provider_state);
  }

  return false;
}
template <typename StructPtrType>
MediaSinkPtr MediaSink::Clone() const {
  return New(
      mojo::Clone(sink_id),
      mojo::Clone(name),
      mojo::Clone(icon_type),
      mojo::Clone(provider_id),
      mojo::Clone(extra_data)
  );
}

template <typename T, MediaSink::EnableIfSame<T>*>
bool MediaSink::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon_type, other_struct.icon_type))
    return false;
  if (!mojo::Equals(this->provider_id, other_struct.provider_id))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  return true;
}

template <typename T, MediaSink::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon_type < rhs.icon_type)
    return true;
  if (rhs.icon_type < lhs.icon_type)
    return false;
  if (lhs.provider_id < rhs.provider_id)
    return true;
  if (rhs.provider_id < lhs.provider_id)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  return false;
}
template <typename StructPtrType>
DialMediaSinkPtr DialMediaSink::Clone() const {
  return New(
      mojo::Clone(ip_address),
      mojo::Clone(model_name),
      mojo::Clone(app_url)
  );
}

template <typename T, DialMediaSink::EnableIfSame<T>*>
bool DialMediaSink::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ip_address, other_struct.ip_address))
    return false;
  if (!mojo::Equals(this->model_name, other_struct.model_name))
    return false;
  if (!mojo::Equals(this->app_url, other_struct.app_url))
    return false;
  return true;
}

template <typename T, DialMediaSink::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ip_address < rhs.ip_address)
    return true;
  if (rhs.ip_address < lhs.ip_address)
    return false;
  if (lhs.model_name < rhs.model_name)
    return true;
  if (rhs.model_name < lhs.model_name)
    return false;
  if (lhs.app_url < rhs.app_url)
    return true;
  if (rhs.app_url < lhs.app_url)
    return false;
  return false;
}
template <typename StructPtrType>
CastMediaSinkPtr CastMediaSink::Clone() const {
  return New(
      mojo::Clone(ip_endpoint),
      mojo::Clone(model_name),
      mojo::Clone(capabilities),
      mojo::Clone(cast_channel_id)
  );
}

template <typename T, CastMediaSink::EnableIfSame<T>*>
bool CastMediaSink::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ip_endpoint, other_struct.ip_endpoint))
    return false;
  if (!mojo::Equals(this->model_name, other_struct.model_name))
    return false;
  if (!mojo::Equals(this->capabilities, other_struct.capabilities))
    return false;
  if (!mojo::Equals(this->cast_channel_id, other_struct.cast_channel_id))
    return false;
  return true;
}

template <typename T, CastMediaSink::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ip_endpoint < rhs.ip_endpoint)
    return true;
  if (rhs.ip_endpoint < lhs.ip_endpoint)
    return false;
  if (lhs.model_name < rhs.model_name)
    return true;
  if (rhs.model_name < lhs.model_name)
    return false;
  if (lhs.capabilities < rhs.capabilities)
    return true;
  if (rhs.capabilities < lhs.capabilities)
    return false;
  if (lhs.cast_channel_id < rhs.cast_channel_id)
    return true;
  if (rhs.cast_channel_id < lhs.cast_channel_id)
    return false;
  return false;
}
template <typename StructPtrType>
MediaRoutePtr MediaRoute::Clone() const {
  return New(
      mojo::Clone(media_route_id),
      mojo::Clone(presentation_id),
      mojo::Clone(media_source),
      mojo::Clone(media_sink_id),
      mojo::Clone(media_sink_name),
      mojo::Clone(description),
      mojo::Clone(is_local),
      mojo::Clone(controller_type),
      mojo::Clone(is_local_presentation),
      mojo::Clone(is_connecting)
  );
}

template <typename T, MediaRoute::EnableIfSame<T>*>
bool MediaRoute::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_route_id, other_struct.media_route_id))
    return false;
  if (!mojo::Equals(this->presentation_id, other_struct.presentation_id))
    return false;
  if (!mojo::Equals(this->media_source, other_struct.media_source))
    return false;
  if (!mojo::Equals(this->media_sink_id, other_struct.media_sink_id))
    return false;
  if (!mojo::Equals(this->media_sink_name, other_struct.media_sink_name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->is_local, other_struct.is_local))
    return false;
  if (!mojo::Equals(this->controller_type, other_struct.controller_type))
    return false;
  if (!mojo::Equals(this->is_local_presentation, other_struct.is_local_presentation))
    return false;
  if (!mojo::Equals(this->is_connecting, other_struct.is_connecting))
    return false;
  return true;
}

template <typename T, MediaRoute::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.media_route_id < rhs.media_route_id)
    return true;
  if (rhs.media_route_id < lhs.media_route_id)
    return false;
  if (lhs.presentation_id < rhs.presentation_id)
    return true;
  if (rhs.presentation_id < lhs.presentation_id)
    return false;
  if (lhs.media_source < rhs.media_source)
    return true;
  if (rhs.media_source < lhs.media_source)
    return false;
  if (lhs.media_sink_id < rhs.media_sink_id)
    return true;
  if (rhs.media_sink_id < lhs.media_sink_id)
    return false;
  if (lhs.media_sink_name < rhs.media_sink_name)
    return true;
  if (rhs.media_sink_name < lhs.media_sink_name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.is_local < rhs.is_local)
    return true;
  if (rhs.is_local < lhs.is_local)
    return false;
  if (lhs.controller_type < rhs.controller_type)
    return true;
  if (rhs.controller_type < lhs.controller_type)
    return false;
  if (lhs.is_local_presentation < rhs.is_local_presentation)
    return true;
  if (rhs.is_local_presentation < lhs.is_local_presentation)
    return false;
  if (lhs.is_connecting < rhs.is_connecting)
    return true;
  if (rhs.is_connecting < lhs.is_connecting)
    return false;
  return false;
}
template <typename StructPtrType>
IssuePtr Issue::Clone() const {
  return New(
      mojo::Clone(route_id),
      mojo::Clone(sink_id),
      mojo::Clone(severity),
      mojo::Clone(title),
      mojo::Clone(message)
  );
}

template <typename T, Issue::EnableIfSame<T>*>
bool Issue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->route_id, other_struct.route_id))
    return false;
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->severity, other_struct.severity))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, Issue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.route_id < rhs.route_id)
    return true;
  if (rhs.route_id < lhs.route_id)
    return false;
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.severity < rhs.severity)
    return true;
  if (rhs.severity < lhs.severity)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
RouteMessagePtr RouteMessage::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(message),
      mojo::Clone(data)
  );
}

template <typename T, RouteMessage::EnableIfSame<T>*>
bool RouteMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, RouteMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
RoutePresentationConnectionPtr RoutePresentationConnection::Clone() const {
  return New(
      mojo::Clone(connection_remote),
      mojo::Clone(connection_receiver)
  );
}

template <typename T, RoutePresentationConnection::EnableIfSame<T>*>
bool RoutePresentationConnection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->connection_remote, other_struct.connection_remote))
    return false;
  if (!mojo::Equals(this->connection_receiver, other_struct.connection_receiver))
    return false;
  return true;
}

template <typename T, RoutePresentationConnection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.connection_remote < rhs.connection_remote)
    return true;
  if (rhs.connection_remote < lhs.connection_remote)
    return false;
  if (lhs.connection_receiver < rhs.connection_receiver)
    return true;
  if (rhs.connection_receiver < lhs.connection_receiver)
    return false;
  return false;
}
template <typename StructPtrType>
CastSessionStatePtr CastSessionState::Clone() const {
  return New(
      mojo::Clone(sink_id),
      mojo::Clone(app_id),
      mojo::Clone(session_id),
      mojo::Clone(route_description)
  );
}

template <typename T, CastSessionState::EnableIfSame<T>*>
bool CastSessionState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->session_id, other_struct.session_id))
    return false;
  if (!mojo::Equals(this->route_description, other_struct.route_description))
    return false;
  return true;
}

template <typename T, CastSessionState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.session_id < rhs.session_id)
    return true;
  if (rhs.session_id < lhs.session_id)
    return false;
  if (lhs.route_description < rhs.route_description)
    return true;
  if (rhs.route_description < lhs.route_description)
    return false;
  return false;
}
template <typename StructPtrType>
CastProviderStatePtr CastProviderState::Clone() const {
  return New(
      mojo::Clone(session_state)
  );
}

template <typename T, CastProviderState::EnableIfSame<T>*>
bool CastProviderState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_state, other_struct.session_state))
    return false;
  return true;
}

template <typename T, CastProviderState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_state < rhs.session_state)
    return true;
  if (rhs.session_state < lhs.session_state)
    return false;
  return false;
}


}  // media_router::mojom

namespace mojo {


template <>
struct  StructTraits<::media_router::mojom::MediaSink::DataView,
                                         ::media_router::mojom::MediaSinkPtr> {
  static bool IsNull(const ::media_router::mojom::MediaSinkPtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::MediaSinkPtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::MediaSink::sink_id)& sink_id(
      const ::media_router::mojom::MediaSinkPtr& input) {
    return input->sink_id;
  }

  static const decltype(::media_router::mojom::MediaSink::name)& name(
      const ::media_router::mojom::MediaSinkPtr& input) {
    return input->name;
  }

  static decltype(::media_router::mojom::MediaSink::icon_type) icon_type(
      const ::media_router::mojom::MediaSinkPtr& input) {
    return input->icon_type;
  }

  static decltype(::media_router::mojom::MediaSink::provider_id) provider_id(
      const ::media_router::mojom::MediaSinkPtr& input) {
    return input->provider_id;
  }

  static const decltype(::media_router::mojom::MediaSink::extra_data)& extra_data(
      const ::media_router::mojom::MediaSinkPtr& input) {
    return input->extra_data;
  }

  static bool Read(::media_router::mojom::MediaSink::DataView input, ::media_router::mojom::MediaSinkPtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::DialMediaSink::DataView,
                                         ::media_router::mojom::DialMediaSinkPtr> {
  static bool IsNull(const ::media_router::mojom::DialMediaSinkPtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::DialMediaSinkPtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::DialMediaSink::ip_address)& ip_address(
      const ::media_router::mojom::DialMediaSinkPtr& input) {
    return input->ip_address;
  }

  static const decltype(::media_router::mojom::DialMediaSink::model_name)& model_name(
      const ::media_router::mojom::DialMediaSinkPtr& input) {
    return input->model_name;
  }

  static const decltype(::media_router::mojom::DialMediaSink::app_url)& app_url(
      const ::media_router::mojom::DialMediaSinkPtr& input) {
    return input->app_url;
  }

  static bool Read(::media_router::mojom::DialMediaSink::DataView input, ::media_router::mojom::DialMediaSinkPtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::CastMediaSink::DataView,
                                         ::media_router::mojom::CastMediaSinkPtr> {
  static bool IsNull(const ::media_router::mojom::CastMediaSinkPtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::CastMediaSinkPtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::CastMediaSink::ip_endpoint)& ip_endpoint(
      const ::media_router::mojom::CastMediaSinkPtr& input) {
    return input->ip_endpoint;
  }

  static const decltype(::media_router::mojom::CastMediaSink::model_name)& model_name(
      const ::media_router::mojom::CastMediaSinkPtr& input) {
    return input->model_name;
  }

  static decltype(::media_router::mojom::CastMediaSink::capabilities) capabilities(
      const ::media_router::mojom::CastMediaSinkPtr& input) {
    return input->capabilities;
  }

  static decltype(::media_router::mojom::CastMediaSink::cast_channel_id) cast_channel_id(
      const ::media_router::mojom::CastMediaSinkPtr& input) {
    return input->cast_channel_id;
  }

  static bool Read(::media_router::mojom::CastMediaSink::DataView input, ::media_router::mojom::CastMediaSinkPtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::MediaRoute::DataView,
                                         ::media_router::mojom::MediaRoutePtr> {
  static bool IsNull(const ::media_router::mojom::MediaRoutePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::MediaRoutePtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::MediaRoute::media_route_id)& media_route_id(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->media_route_id;
  }

  static const decltype(::media_router::mojom::MediaRoute::presentation_id)& presentation_id(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->presentation_id;
  }

  static const decltype(::media_router::mojom::MediaRoute::media_source)& media_source(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->media_source;
  }

  static const decltype(::media_router::mojom::MediaRoute::media_sink_id)& media_sink_id(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->media_sink_id;
  }

  static const decltype(::media_router::mojom::MediaRoute::media_sink_name)& media_sink_name(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->media_sink_name;
  }

  static const decltype(::media_router::mojom::MediaRoute::description)& description(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->description;
  }

  static decltype(::media_router::mojom::MediaRoute::is_local) is_local(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->is_local;
  }

  static decltype(::media_router::mojom::MediaRoute::controller_type) controller_type(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->controller_type;
  }

  static decltype(::media_router::mojom::MediaRoute::is_local_presentation) is_local_presentation(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->is_local_presentation;
  }

  static decltype(::media_router::mojom::MediaRoute::is_connecting) is_connecting(
      const ::media_router::mojom::MediaRoutePtr& input) {
    return input->is_connecting;
  }

  static bool Read(::media_router::mojom::MediaRoute::DataView input, ::media_router::mojom::MediaRoutePtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::Issue::DataView,
                                         ::media_router::mojom::IssuePtr> {
  static bool IsNull(const ::media_router::mojom::IssuePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::IssuePtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::Issue::route_id)& route_id(
      const ::media_router::mojom::IssuePtr& input) {
    return input->route_id;
  }

  static const decltype(::media_router::mojom::Issue::sink_id)& sink_id(
      const ::media_router::mojom::IssuePtr& input) {
    return input->sink_id;
  }

  static decltype(::media_router::mojom::Issue::severity) severity(
      const ::media_router::mojom::IssuePtr& input) {
    return input->severity;
  }

  static const decltype(::media_router::mojom::Issue::title)& title(
      const ::media_router::mojom::IssuePtr& input) {
    return input->title;
  }

  static const decltype(::media_router::mojom::Issue::message)& message(
      const ::media_router::mojom::IssuePtr& input) {
    return input->message;
  }

  static bool Read(::media_router::mojom::Issue::DataView input, ::media_router::mojom::IssuePtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::RouteMessage::DataView,
                                         ::media_router::mojom::RouteMessagePtr> {
  static bool IsNull(const ::media_router::mojom::RouteMessagePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::RouteMessagePtr* output) { output->reset(); }

  static decltype(::media_router::mojom::RouteMessage::type) type(
      const ::media_router::mojom::RouteMessagePtr& input) {
    return input->type;
  }

  static const decltype(::media_router::mojom::RouteMessage::message)& message(
      const ::media_router::mojom::RouteMessagePtr& input) {
    return input->message;
  }

  static const decltype(::media_router::mojom::RouteMessage::data)& data(
      const ::media_router::mojom::RouteMessagePtr& input) {
    return input->data;
  }

  static bool Read(::media_router::mojom::RouteMessage::DataView input, ::media_router::mojom::RouteMessagePtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::RoutePresentationConnection::DataView,
                                         ::media_router::mojom::RoutePresentationConnectionPtr> {
  static bool IsNull(const ::media_router::mojom::RoutePresentationConnectionPtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::RoutePresentationConnectionPtr* output) { output->reset(); }

  static  decltype(::media_router::mojom::RoutePresentationConnection::connection_remote)& connection_remote(
       ::media_router::mojom::RoutePresentationConnectionPtr& input) {
    return input->connection_remote;
  }

  static  decltype(::media_router::mojom::RoutePresentationConnection::connection_receiver)& connection_receiver(
       ::media_router::mojom::RoutePresentationConnectionPtr& input) {
    return input->connection_receiver;
  }

  static bool Read(::media_router::mojom::RoutePresentationConnection::DataView input, ::media_router::mojom::RoutePresentationConnectionPtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::CastSessionState::DataView,
                                         ::media_router::mojom::CastSessionStatePtr> {
  static bool IsNull(const ::media_router::mojom::CastSessionStatePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::CastSessionStatePtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::CastSessionState::sink_id)& sink_id(
      const ::media_router::mojom::CastSessionStatePtr& input) {
    return input->sink_id;
  }

  static const decltype(::media_router::mojom::CastSessionState::app_id)& app_id(
      const ::media_router::mojom::CastSessionStatePtr& input) {
    return input->app_id;
  }

  static const decltype(::media_router::mojom::CastSessionState::session_id)& session_id(
      const ::media_router::mojom::CastSessionStatePtr& input) {
    return input->session_id;
  }

  static const decltype(::media_router::mojom::CastSessionState::route_description)& route_description(
      const ::media_router::mojom::CastSessionStatePtr& input) {
    return input->route_description;
  }

  static bool Read(::media_router::mojom::CastSessionState::DataView input, ::media_router::mojom::CastSessionStatePtr* output);
};


template <>
struct  StructTraits<::media_router::mojom::CastProviderState::DataView,
                                         ::media_router::mojom::CastProviderStatePtr> {
  static bool IsNull(const ::media_router::mojom::CastProviderStatePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::CastProviderStatePtr* output) { output->reset(); }

  static const decltype(::media_router::mojom::CastProviderState::session_state)& session_state(
      const ::media_router::mojom::CastProviderStatePtr& input) {
    return input->session_state;
  }

  static bool Read(::media_router::mojom::CastProviderState::DataView input, ::media_router::mojom::CastProviderStatePtr* output);
};


template <>
struct  UnionTraits<::media_router::mojom::MediaSinkExtraData::DataView,
                                        ::media_router::mojom::MediaSinkExtraDataPtr> {
  static bool IsNull(const ::media_router::mojom::MediaSinkExtraDataPtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::MediaSinkExtraDataPtr* output) { output->reset(); }

  static ::media_router::mojom::MediaSinkExtraData::Tag GetTag(const ::media_router::mojom::MediaSinkExtraDataPtr& input) {
    return input->which();
  }

  static const ::media_router::mojom::DialMediaSinkPtr& dial_media_sink(const ::media_router::mojom::MediaSinkExtraDataPtr& input) {
    return input->get_dial_media_sink();
  }

  static const ::media_router::mojom::CastMediaSinkPtr& cast_media_sink(const ::media_router::mojom::MediaSinkExtraDataPtr& input) {
    return input->get_cast_media_sink();
  }

  static bool Read(::media_router::mojom::MediaSinkExtraData::DataView input, ::media_router::mojom::MediaSinkExtraDataPtr* output);
};


template <>
struct  UnionTraits<::media_router::mojom::ProviderState::DataView,
                                        ::media_router::mojom::ProviderStatePtr> {
  static bool IsNull(const ::media_router::mojom::ProviderStatePtr& input) { return !input; }
  static void SetToNull(::media_router::mojom::ProviderStatePtr* output) { output->reset(); }

  static ::media_router::mojom::ProviderState::Tag GetTag(const ::media_router::mojom::ProviderStatePtr& input) {
    return input->which();
  }

  static const ::media_router::mojom::CastProviderStatePtr& cast_provider_state(const ::media_router::mojom::ProviderStatePtr& input) {
    return input->get_cast_provider_state();
  }

  static bool Read(::media_router::mojom::ProviderState::DataView input, ::media_router::mojom::ProviderStatePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_H_