// components/media_router/common/mojom/media_router.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/media_router/common/mojom/logger.mojom-shared-internal.h"
#include "components/media_router/common/mojom/debugger.mojom-shared-internal.h"
#include "components/media_router/common/mojom/media_controller.mojom-shared-internal.h"
#include "components/media_router/common/mojom/media_route_provider_id.mojom-shared-internal.h"
#include "components/media_router/common/mojom/media_status.mojom-shared-internal.h"
#include "components/media_router/common/mojom/route_request_result_code.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media_router::mojom {
namespace internal {
class MediaSink_Data;
class DialMediaSink_Data;
class CastMediaSink_Data;
class MediaRoute_Data;
class Issue_Data;
class RouteMessage_Data;
class RoutePresentationConnection_Data;
class CastSessionState_Data;
class CastProviderState_Data;
class MediaSinkExtraData_Data;
class ProviderState_Data;

struct SinkIconType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 6:
      case 7:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RouteControllerType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Issue_Severity_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RouteMessage_Type_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  MediaSinkExtraData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  MediaSinkExtraData_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~MediaSinkExtraData_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<MediaSinkExtraData_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class MediaSinkExtraData_Tag : uint32_t {

    
    kDialMediaSink,
    
    kCastMediaSink,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::DialMediaSink_Data> f_dial_media_sink;
    mojo::internal::Pointer<internal::CastMediaSink_Data> f_cast_media_sink;
    uint64_t unknown;
  };

  uint32_t size;
  MediaSinkExtraData_Tag tag;
  Union_ data;
};
static_assert(sizeof(MediaSinkExtraData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(MediaSinkExtraData_Data)");


class  ProviderState_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  ProviderState_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~ProviderState_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<ProviderState_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class ProviderState_Tag : uint32_t {

    
    kCastProviderState,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::CastProviderState_Data> f_cast_provider_state;
    uint64_t unknown;
  };

  uint32_t size;
  ProviderState_Tag tag;
  Union_ data;
};
static_assert(sizeof(ProviderState_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(ProviderState_Data)");
class  MediaSink_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> sink_id;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  int32_t icon_type;
  int32_t provider_id;
  internal::MediaSinkExtraData_Data extra_data;

 private:
  friend class mojo::internal::MessageFragment<MediaSink_Data>;

  MediaSink_Data();
  ~MediaSink_Data() = delete;
};
static_assert(sizeof(MediaSink_Data) == 48,
              "Bad sizeof(MediaSink_Data)");
// Used by MediaSink::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MediaSink_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MediaSink_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MediaSink_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MediaSink_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MediaSink_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DialMediaSink_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data> ip_address;
  mojo::internal::Pointer<mojo::internal::String_Data> model_name;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> app_url;

 private:
  friend class mojo::internal::MessageFragment<DialMediaSink_Data>;

  DialMediaSink_Data();
  ~DialMediaSink_Data() = delete;
};
static_assert(sizeof(DialMediaSink_Data) == 32,
              "Bad sizeof(DialMediaSink_Data)");
// Used by DialMediaSink::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DialMediaSink_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DialMediaSink_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DialMediaSink_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DialMediaSink_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DialMediaSink_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CastMediaSink_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> ip_endpoint;
  mojo::internal::Pointer<mojo::internal::String_Data> model_name;
  uint64_t capabilities;
  int32_t cast_channel_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CastMediaSink_Data>;

  CastMediaSink_Data();
  ~CastMediaSink_Data() = delete;
};
static_assert(sizeof(CastMediaSink_Data) == 40,
              "Bad sizeof(CastMediaSink_Data)");
// Used by CastMediaSink::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CastMediaSink_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CastMediaSink_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CastMediaSink_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CastMediaSink_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CastMediaSink_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MediaRoute_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_route_id;
  mojo::internal::Pointer<mojo::internal::String_Data> presentation_id;
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;
  mojo::internal::Pointer<mojo::internal::String_Data> media_sink_id;
  mojo::internal::Pointer<mojo::internal::String_Data> media_sink_name;
  mojo::internal::Pointer<mojo::internal::String_Data> description;
  uint8_t is_local : 1;
  uint8_t is_local_presentation : 1;
  uint8_t is_connecting : 1;
  uint8_t pad8_[3];
  int32_t controller_type;

 private:
  friend class mojo::internal::MessageFragment<MediaRoute_Data>;

  MediaRoute_Data();
  ~MediaRoute_Data() = delete;
};
static_assert(sizeof(MediaRoute_Data) == 64,
              "Bad sizeof(MediaRoute_Data)");
// Used by MediaRoute::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MediaRoute_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MediaRoute_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MediaRoute_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MediaRoute_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MediaRoute_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Issue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;
  mojo::internal::Pointer<mojo::internal::String_Data> sink_id;
  int32_t severity;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<Issue_Data>;

  Issue_Data();
  ~Issue_Data() = delete;
};
static_assert(sizeof(Issue_Data) == 48,
              "Bad sizeof(Issue_Data)");
// Used by Issue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Issue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Issue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Issue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Issue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Issue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  RouteMessage_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<RouteMessage_Data>;

  RouteMessage_Data();
  ~RouteMessage_Data() = delete;
};
static_assert(sizeof(RouteMessage_Data) == 32,
              "Bad sizeof(RouteMessage_Data)");
// Used by RouteMessage::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RouteMessage_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RouteMessage_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RouteMessage_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RouteMessage_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RouteMessage_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  RoutePresentationConnection_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data connection_remote;
  mojo::internal::Handle_Data connection_receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RoutePresentationConnection_Data>;

  RoutePresentationConnection_Data();
  ~RoutePresentationConnection_Data() = delete;
};
static_assert(sizeof(RoutePresentationConnection_Data) == 24,
              "Bad sizeof(RoutePresentationConnection_Data)");
// Used by RoutePresentationConnection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RoutePresentationConnection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RoutePresentationConnection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RoutePresentationConnection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RoutePresentationConnection_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RoutePresentationConnection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CastSessionState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> sink_id;
  mojo::internal::Pointer<mojo::internal::String_Data> app_id;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  mojo::internal::Pointer<mojo::internal::String_Data> route_description;

 private:
  friend class mojo::internal::MessageFragment<CastSessionState_Data>;

  CastSessionState_Data();
  ~CastSessionState_Data() = delete;
};
static_assert(sizeof(CastSessionState_Data) == 40,
              "Bad sizeof(CastSessionState_Data)");
// Used by CastSessionState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CastSessionState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CastSessionState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CastSessionState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CastSessionState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CastSessionState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CastProviderState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CastSessionState_Data>>> session_state;

 private:
  friend class mojo::internal::MessageFragment<CastProviderState_Data>;

  CastProviderState_Data();
  ~CastProviderState_Data() = delete;
};
static_assert(sizeof(CastProviderState_Data) == 16,
              "Bad sizeof(CastProviderState_Data)");
// Used by CastProviderState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CastProviderState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CastProviderState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CastProviderState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CastProviderState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CastProviderState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media_router::mojom

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_INTERNAL_H_