// components/media_router/common/mojom/media_router.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SEND_VALIDATION_H_

#include "components/media_router/common/mojom/media_router.mojom-shared-internal.h"
#include "components/media_router/common/mojom/logger.mojom-shared.h"
#include "components/media_router/common/mojom/debugger.mojom-shared.h"
#include "components/media_router/common/mojom/media_controller.mojom-shared.h"
#include "components/media_router/common/mojom/media_route_provider_id.mojom-shared.h"
#include "components/media_router/common/mojom/media_status.mojom-shared.h"
#include "components/media_router/common/mojom/route_request_result_code.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/media_router/common/mojom/media_router.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_router::mojom::SinkIconType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_router::mojom::RouteControllerType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::MediaSinkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaSinkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sink_id,
        sink_id_fragment);

      fragment->sink_id.Set(
          sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sink_id in MediaSink struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in MediaSink struct");

      
      mojo::internal::Serialize<::media_router::mojom::SinkIconType>(
        Traits::icon_type(input),
        &fragment->icon_type);

      
      mojo::internal::Serialize<::media_router::mojom::MediaRouteProviderId>(
        Traits::provider_id(input),
        &fragment->provider_id);

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<decltype(fragment->extra_data)>
          extra_data_fragment(fragment.message());
      extra_data_fragment.Claim(&fragment->extra_data);
      
      mojo::internal::Serialize<::media_router::mojom::MediaSinkExtraDataDataView, send_validation>(
        in_extra_data,
        extra_data_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::DialMediaSinkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::DialMediaSinkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::DialMediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::ip_address(input)) in_ip_address = Traits::ip_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ip_address)::BaseType> ip_address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_ip_address,
        ip_address_fragment);

      fragment->ip_address.Set(
          ip_address_fragment.is_null() ? nullptr : ip_address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ip_address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ip_address in DialMediaSink struct");

      decltype(Traits::model_name(input)) in_model_name = Traits::model_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->model_name)::BaseType> model_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_model_name,
        model_name_fragment);

      fragment->model_name.Set(
          model_name_fragment.is_null() ? nullptr : model_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->model_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null model_name in DialMediaSink struct");

      decltype(Traits::app_url(input)) in_app_url = Traits::app_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->app_url)::BaseType> app_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_app_url,
        app_url_fragment);

      fragment->app_url.Set(
          app_url_fragment.is_null() ? nullptr : app_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->app_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_url in DialMediaSink struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::CastMediaSinkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastMediaSinkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastMediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::ip_endpoint(input)) in_ip_endpoint = Traits::ip_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ip_endpoint)::BaseType> ip_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPEndPointDataView, send_validation>(
        in_ip_endpoint,
        ip_endpoint_fragment);

      fragment->ip_endpoint.Set(
          ip_endpoint_fragment.is_null() ? nullptr : ip_endpoint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ip_endpoint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ip_endpoint in CastMediaSink struct");

      decltype(Traits::model_name(input)) in_model_name = Traits::model_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->model_name)::BaseType> model_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_model_name,
        model_name_fragment);

      fragment->model_name.Set(
          model_name_fragment.is_null() ? nullptr : model_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->model_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null model_name in CastMediaSink struct");

      fragment->capabilities = Traits::capabilities(input);

      fragment->cast_channel_id = Traits::cast_channel_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::MediaRouteDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaRouteDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaRoute_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::media_route_id(input)) in_media_route_id = Traits::media_route_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_route_id)::BaseType> media_route_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_route_id,
        media_route_id_fragment);

      fragment->media_route_id.Set(
          media_route_id_fragment.is_null() ? nullptr : media_route_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_route_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_route_id in MediaRoute struct");

      decltype(Traits::presentation_id(input)) in_presentation_id = Traits::presentation_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->presentation_id)::BaseType> presentation_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_presentation_id,
        presentation_id_fragment);

      fragment->presentation_id.Set(
          presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->presentation_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presentation_id in MediaRoute struct");

      decltype(Traits::media_source(input)) in_media_source = Traits::media_source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_source)::BaseType> media_source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_source,
        media_source_fragment);

      fragment->media_source.Set(
          media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

      decltype(Traits::media_sink_id(input)) in_media_sink_id = Traits::media_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_sink_id)::BaseType> media_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_sink_id,
        media_sink_id_fragment);

      fragment->media_sink_id.Set(
          media_sink_id_fragment.is_null() ? nullptr : media_sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_sink_id in MediaRoute struct");

      decltype(Traits::media_sink_name(input)) in_media_sink_name = Traits::media_sink_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->media_sink_name)::BaseType> media_sink_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_media_sink_name,
        media_sink_name_fragment);

      fragment->media_sink_name.Set(
          media_sink_name_fragment.is_null() ? nullptr : media_sink_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->media_sink_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_sink_name in MediaRoute struct");

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in MediaRoute struct");

      fragment->is_local = Traits::is_local(input);

      
      mojo::internal::Serialize<::media_router::mojom::RouteControllerType>(
        Traits::controller_type(input),
        &fragment->controller_type);

      fragment->is_local_presentation = Traits::is_local_presentation(input);

      fragment->is_connecting = Traits::is_connecting(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::IssueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::IssueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::Issue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::route_id(input)) in_route_id = Traits::route_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->route_id)::BaseType> route_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_route_id,
        route_id_fragment);

      fragment->route_id.Set(
          route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->route_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null route_id in Issue struct");

      decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sink_id,
        sink_id_fragment);

      fragment->sink_id.Set(
          sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sink_id in Issue struct");

      
      mojo::internal::Serialize<::media_router::mojom::Issue_Severity>(
        Traits::severity(input),
        &fragment->severity);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in Issue struct");

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::RouteMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::RouteMessageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::RouteMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media_router::mojom::RouteMessage_Type>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType>
          data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_data,
        data_fragment,
        &data_validate_params);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::RoutePresentationConnectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::RoutePresentationConnectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::RoutePresentationConnection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::connection_remote(input)) in_connection_remote = Traits::connection_remote(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
        in_connection_remote,
        &fragment->connection_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection_remote in RoutePresentationConnection struct");

      decltype(Traits::connection_receiver(input)) in_connection_receiver = Traits::connection_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
        in_connection_receiver,
        &fragment->connection_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection_receiver in RoutePresentationConnection struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::CastSessionStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastSessionStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastSessionState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sink_id,
        sink_id_fragment);

      fragment->sink_id.Set(
          sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sink_id in CastSessionState struct");

      decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->app_id)::BaseType> app_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_app_id,
        app_id_fragment);

      fragment->app_id.Set(
          app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->app_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_id in CastSessionState struct");

      decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_id)::BaseType> session_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_session_id,
        session_id_fragment);

      fragment->session_id.Set(
          session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_id in CastSessionState struct");

      decltype(Traits::route_description(input)) in_route_description = Traits::route_description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->route_description)::BaseType> route_description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_route_description,
        route_description_fragment);

      fragment->route_description.Set(
          route_description_fragment.is_null() ? nullptr : route_description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->route_description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null route_description in CastSessionState struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::CastProviderStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastProviderStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastProviderState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session_state(input)) in_session_state = Traits::session_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_state)::BaseType>
          session_state_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& session_state_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::CastSessionStateDataView>, send_validation>(
        in_session_state,
        session_state_fragment,
        &session_state_validate_params);

      fragment->session_state.Set(
          session_state_fragment.is_null() ? nullptr : session_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_state in CastProviderState struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::MediaSinkExtraDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media_router::mojom::MediaSinkExtraDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media_router::mojom::internal::MediaSinkExtraData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media_router::mojom::MediaSinkExtraDataDataView::Tag::kDialMediaSink: {
    decltype(Traits::dial_media_sink(input))
    in_dial_media_sink = Traits::dial_media_sink(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dial_media_sink)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::DialMediaSinkDataView, send_validation>(
  in_dial_media_sink,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dial_media_sink in MediaSinkExtraData union");
    fragment->data.f_dial_media_sink.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media_router::mojom::MediaSinkExtraDataDataView::Tag::kCastMediaSink: {
    decltype(Traits::cast_media_sink(input))
    in_cast_media_sink = Traits::cast_media_sink(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cast_media_sink)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::CastMediaSinkDataView, send_validation>(
  in_cast_media_sink,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cast_media_sink in MediaSinkExtraData union");
    fragment->data.f_cast_media_sink.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::ProviderStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media_router::mojom::ProviderStateDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media_router::mojom::internal::ProviderState_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media_router::mojom::ProviderStateDataView::Tag::kCastProviderState: {
    decltype(Traits::cast_provider_state(input))
    in_cast_provider_state = Traits::cast_provider_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cast_provider_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::CastProviderStateDataView, send_validation>(
  in_cast_provider_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cast_provider_state in ProviderState union");
    fragment->data.f_cast_provider_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SEND_VALIDATION_H_