// components/media_router/common/mojom/media_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_CONTROLLER_MOJOM_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/media_controller.mojom-features.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/media_controller.mojom-shared.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/media_controller.mojom-forward.h"  // IWYU pragma: export
#include "components/media_router/common/mojom/media_status.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media_router::mojom {

class MediaControllerProxy;

template <typename ImplRefTraits>
class MediaControllerStub;

class MediaControllerRequestValidator;


class MediaController
    : public MediaControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_router.mojom.MediaController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaControllerInterfaceBase;
  using Proxy_ = MediaControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaControllerStub<ImplRefTraits>;

  using RequestValidator_ = MediaControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPlayMinVersion = 0,
    kPauseMinVersion = 0,
    kSetMuteMinVersion = 0,
    kSetVolumeMinVersion = 0,
    kSeekMinVersion = 0,
    kNextTrackMinVersion = 0,
    kPreviousTrackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Play_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Pause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Seek_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NextTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviousTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaController() = default;

  virtual void Play() = 0;

  virtual void Pause() = 0;

  virtual void SetMute(bool mute) = 0;

  virtual void SetVolume(float volume) = 0;

  virtual void Seek(::base::TimeDelta time) = 0;

  virtual void NextTrack() = 0;

  virtual void PreviousTrack() = 0;
};



class  MediaControllerProxy
    : public MediaController {
 public:
  using InterfaceType = MediaController;

  explicit MediaControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Play() final;
  
  void Pause() final;
  
  void SetMute(bool mute) final;
  
  void SetVolume(float volume) final;
  
  void Seek(::base::TimeDelta time) final;
  
  void NextTrack() final;
  
  void PreviousTrack() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaControllerStubDispatch {
 public:
  static bool Accept(MediaController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaController>>
class MediaControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaControllerStub() = default;
  ~MediaControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media_router::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_CONTROLLER_MOJOM_H_