// components/language_detection/content/common/language_detection.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/language_detection/content/common/language_detection.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/language_detection/content/common/language_detection.mojom-params-data.h"
#include "components/language_detection/content/common/language_detection.mojom-shared-message-ids.h"

#include "components/language_detection/content/common/language_detection.mojom-blink-import-headers.h"
#include "components/language_detection/content/common/language_detection.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace language_detection::mojom::blink {
// The declaration includes the definition on other builds.

ContentLanguageDetectionDriver::IPCStableHashFunction ContentLanguageDetectionDriver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentLanguageDetectionDriver>(message.name())) {
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel: {
      return &ContentLanguageDetectionDriver::GetLanguageDetectionModel_Sym::IPCStableHash;
    }
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus: {
      return &ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentLanguageDetectionDriver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentLanguageDetectionDriver>(message.name())) {
      case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel:
            return "Receive language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModel";
      case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus:
            return "Receive language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus";
    }
  } else {
    switch (static_cast<messages::ContentLanguageDetectionDriver>(message.name())) {
      case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel:
            return "Receive reply language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModel";
      case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus:
            return "Receive reply language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentLanguageDetectionDriver::GetLanguageDetectionModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfab1692b;  // IPCStableHash for language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5ffd1b5;  // IPCStableHash for language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback(
      ContentLanguageDetectionDriver::GetLanguageDetectionModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback(const ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback&) = delete;
  ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback& operator=(const ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentLanguageDetectionDriver::GetLanguageDetectionModelCallback callback_;
};

class ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback(
      ContentLanguageDetectionDriver::GetLanguageDetectionModelStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback(const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback&) = delete;
  ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback& operator=(const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContentLanguageDetectionDriver::GetLanguageDetectionModelStatusCallback callback_;
};

ContentLanguageDetectionDriverProxy::ContentLanguageDetectionDriverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentLanguageDetectionDriverProxy::GetLanguageDetectionModel(
    GetLanguageDetectionModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::language_detection::mojom::internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentLanguageDetectionDriver::Name_);
  message.set_method_name("GetLanguageDetectionModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ContentLanguageDetectionDriverProxy::GetLanguageDetectionModelStatus(
    GetLanguageDetectionModelStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::language_detection::mojom::internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentLanguageDetectionDriver::Name_);
  message.set_method_name("GetLanguageDetectionModelStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentLanguageDetectionDriver::GetLanguageDetectionModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder> proxy(
        new ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentLanguageDetectionDriver::GetLanguageDetectionModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_model_file);
};

bool ContentLanguageDetectionDriver_GetLanguageDetectionModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentLanguageDetectionDriver.0
  bool success = true;
  ::base::File p_model_file{};
  ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModelFile(&p_model_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentLanguageDetectionDriver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_model_file));
  }
  return true;
}

void ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder::Run(
    ::base::File in_model_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_file"), in_model_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::language_detection::mojom::internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_file)::BaseType> model_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_model_file,
    model_file_fragment);

  params->model_file.Set(
      model_file_fragment.is_null() ? nullptr : model_file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentLanguageDetectionDriver::Name_);
  message.set_method_name("GetLanguageDetectionModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContentLanguageDetectionDriver::GetLanguageDetectionModelStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder> proxy(
        new ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContentLanguageDetectionDriver::GetLanguageDetectionModelStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LanguageDetectionModelStatus in_status);
};

bool ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContentLanguageDetectionDriver.1
  bool success = true;
  LanguageDetectionModelStatus p_status{};
  ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentLanguageDetectionDriver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder::Run(
    LanguageDetectionModelStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply language_detection::mojom::ContentLanguageDetectionDriver::GetLanguageDetectionModelStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type LanguageDetectionModelStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::language_detection::mojom::internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::language_detection::mojom::LanguageDetectionModelStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentLanguageDetectionDriver::Name_);
  message.set_method_name("GetLanguageDetectionModelStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContentLanguageDetectionDriverStubDispatch::Accept(
    ContentLanguageDetectionDriver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentLanguageDetectionDriver>(message->header()->name)) {
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel: {
      break;
    }
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus: {
      break;
    }
  }
  return false;
}

// static
bool ContentLanguageDetectionDriverStubDispatch::AcceptWithResponder(
    ContentLanguageDetectionDriver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentLanguageDetectionDriver>(message->header()->name)) {
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModel: {
      internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data* params =
          reinterpret_cast<
              internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentLanguageDetectionDriver.0
      bool success = true;
      ContentLanguageDetectionDriver_GetLanguageDetectionModel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentLanguageDetectionDriver::Name_, 0, false);
        return false;
      }
      auto callback =
          ContentLanguageDetectionDriver_GetLanguageDetectionModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLanguageDetectionModel(std::move(callback));
      return true;
    }
    case messages::ContentLanguageDetectionDriver::kGetLanguageDetectionModelStatus: {
      internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data* params =
          reinterpret_cast<
              internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContentLanguageDetectionDriver.1
      bool success = true;
      ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentLanguageDetectionDriver::Name_, 1, false);
        return false;
      }
      auto callback =
          ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLanguageDetectionModelStatus(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentLanguageDetectionDriverValidationInfo[] = {
    { &internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data::Validate,
     &internal::ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data::Validate},
    { &internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data::Validate,
     &internal::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data::Validate},
};

bool ContentLanguageDetectionDriverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::language_detection::mojom::blink::ContentLanguageDetectionDriver::Name_,
    kContentLanguageDetectionDriverValidationInfo);
}

bool ContentLanguageDetectionDriverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::language_detection::mojom::blink::ContentLanguageDetectionDriver::Name_,
    kContentLanguageDetectionDriverValidationInfo);
}


}  // language_detection::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace language_detection::mojom::blink {


void ContentLanguageDetectionDriverInterceptorForTesting::GetLanguageDetectionModel(GetLanguageDetectionModelCallback callback) {
  GetForwardingInterface()->GetLanguageDetectionModel(std::move(callback));
}
void ContentLanguageDetectionDriverInterceptorForTesting::GetLanguageDetectionModelStatus(GetLanguageDetectionModelStatusCallback callback) {
  GetForwardingInterface()->GetLanguageDetectionModelStatus(std::move(callback));
}
ContentLanguageDetectionDriverAsyncWaiter::ContentLanguageDetectionDriverAsyncWaiter(
    ContentLanguageDetectionDriver* proxy) : proxy_(proxy) {}

ContentLanguageDetectionDriverAsyncWaiter::~ContentLanguageDetectionDriverAsyncWaiter() = default;


void ContentLanguageDetectionDriverAsyncWaiter::GetLanguageDetectionModel(
    ::base::File* out_model_file) {
  base::RunLoop loop;
  proxy_->GetLanguageDetectionModel(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_model_file
,
             ::base::File model_file) {*out_model_file = std::move(model_file);
            loop->Quit();
          },
          &loop,
          out_model_file));
  loop.Run();
}

::base::File ContentLanguageDetectionDriverAsyncWaiter::GetLanguageDetectionModel(
    ) {
  ::base::File async_wait_result;
  GetLanguageDetectionModel(&async_wait_result);
  return async_wait_result;
}

void ContentLanguageDetectionDriverAsyncWaiter::GetLanguageDetectionModelStatus(
    LanguageDetectionModelStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetLanguageDetectionModelStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             LanguageDetectionModelStatus* out_status
,
             LanguageDetectionModelStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

LanguageDetectionModelStatus ContentLanguageDetectionDriverAsyncWaiter::GetLanguageDetectionModelStatus(
    ) {
  LanguageDetectionModelStatus async_wait_result;
  GetLanguageDetectionModelStatus(&async_wait_result);
  return async_wait_result;
}






}  // language_detection::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif