// components/ip_protection/mojom/core.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_TEST_UTILS_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_TEST_UTILS_H_

#include "components/ip_protection/mojom/core.mojom.h"


namespace ip_protection::mojom {


class  CoreControlInterceptorForTesting : public CoreControl {
  virtual CoreControl* GetForwardingInterface() = 0;
  void AuthTokensMayBeAvailable() override;
  void SetIpProtectionEnabled(bool value) override;
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::ip_protection::mojom::CoreControlTest> receiver) override;
};
class  CoreControlAsyncWaiter {
 public:
  explicit CoreControlAsyncWaiter(CoreControl* proxy);

  CoreControlAsyncWaiter(const CoreControlAsyncWaiter&) = delete;
  CoreControlAsyncWaiter& operator=(const CoreControlAsyncWaiter&) = delete;

  ~CoreControlAsyncWaiter();

 private:
  CoreControl* const proxy_;
};


class  CoreHostInterceptorForTesting : public CoreHost {
  virtual CoreHost* GetForwardingInterface() = 0;
  void TryGetAuthTokens(uint32_t batch_size, ::ip_protection::ProxyLayer proxy_layer, TryGetAuthTokensCallback callback) override;
  void GetProxyConfig(GetProxyConfigCallback callback) override;
  void TryGetProbabilisticRevealTokens(TryGetProbabilisticRevealTokensCallback callback) override;
  void RecycleTokens(::ip_protection::ProxyLayer proxy_layer, std::vector<::ip_protection::BlindSignedAuthToken> tokens) override;
};
class  CoreHostAsyncWaiter {
 public:
  explicit CoreHostAsyncWaiter(CoreHost* proxy);

  CoreHostAsyncWaiter(const CoreHostAsyncWaiter&) = delete;
  CoreHostAsyncWaiter& operator=(const CoreHostAsyncWaiter&) = delete;

  ~CoreHostAsyncWaiter();
  void TryGetAuthTokens(
      uint32_t batch_size, ::ip_protection::ProxyLayer proxy_layer, std::optional<std::vector<::ip_protection::BlindSignedAuthToken>>* out_bsa_tokens, std::optional<::base::Time>* out_try_again_after);
  
  void GetProxyConfig(
      std::optional<std::vector<::net::ProxyChain>>* out_proxy_list, std::optional<::ip_protection::GeoHint>* out_geo_hint);
  
  void TryGetProbabilisticRevealTokens(
      std::optional<::ip_protection::TryGetProbabilisticRevealTokensOutcome>* out_outcome, ::ip_protection::TryGetProbabilisticRevealTokensResult* out_result);
  

 private:
  CoreHost* const proxy_;
};




}  // ip_protection::mojom

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_TEST_UTILS_H_