// components/history_clusters/public/mojom/history_cluster_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_H_
#define COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-features.h"  // IWYU pragma: export
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared.h"  // IWYU pragma: export
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace history_clusters::mojom {





class  MatchPosition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MatchPosition, T>::value>;
  using DataView = MatchPositionDataView;
  using Data_ = internal::MatchPosition_Data;

  template <typename... Args>
  static MatchPositionPtr New(Args&&... args) {
    return MatchPositionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MatchPositionPtr From(const U& u) {
    return mojo::TypeConverter<MatchPositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MatchPosition>::Convert(*this);
  }


  MatchPosition();

  MatchPosition(
      uint32_t begin,
      uint32_t end);


  ~MatchPosition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MatchPositionPtr>
  MatchPositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MatchPosition::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MatchPosition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MatchPosition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MatchPosition_UnserializedMessageContext<
            UserType, MatchPosition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MatchPosition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MatchPosition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MatchPosition_UnserializedMessageContext<
            UserType, MatchPosition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MatchPosition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t begin;
  
  uint32_t end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MatchPosition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  SearchQuery {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchQuery, T>::value>;
  using DataView = SearchQueryDataView;
  using Data_ = internal::SearchQuery_Data;

  template <typename... Args>
  static SearchQueryPtr New(Args&&... args) {
    return SearchQueryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchQueryPtr From(const U& u) {
    return mojo::TypeConverter<SearchQueryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchQuery>::Convert(*this);
  }


  SearchQuery();

  SearchQuery(
      const std::string& query,
      const ::GURL& url);


  ~SearchQuery();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchQueryPtr>
  SearchQueryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchQuery::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchQuery::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchQuery::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchQuery_UnserializedMessageContext<
            UserType, SearchQuery::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchQuery::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchQuery::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchQuery_UnserializedMessageContext<
            UserType, SearchQuery::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchQuery::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string query;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RawVisitData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RawVisitData, T>::value>;
  using DataView = RawVisitDataDataView;
  using Data_ = internal::RawVisitData_Data;

  template <typename... Args>
  static RawVisitDataPtr New(Args&&... args) {
    return RawVisitDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RawVisitDataPtr From(const U& u) {
    return mojo::TypeConverter<RawVisitDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RawVisitData>::Convert(*this);
  }


  RawVisitData();

  RawVisitData(
      const ::GURL& url,
      ::base::Time visit_time);


  ~RawVisitData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RawVisitDataPtr>
  RawVisitDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RawVisitData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RawVisitData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RawVisitData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RawVisitData_UnserializedMessageContext<
            UserType, RawVisitData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RawVisitData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RawVisitData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RawVisitData_UnserializedMessageContext<
            UserType, RawVisitData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RawVisitData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::base::Time visit_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RawVisitData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLVisit {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLVisit, T>::value>;
  using DataView = URLVisitDataView;
  using Data_ = internal::URLVisit_Data;

  template <typename... Args>
  static URLVisitPtr New(Args&&... args) {
    return URLVisitPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLVisitPtr From(const U& u) {
    return mojo::TypeConverter<URLVisitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLVisit>::Convert(*this);
  }


  URLVisit();

  URLVisit(
      int64_t visit_id,
      const ::GURL& normalized_url,
      const std::string& url_for_display,
      const std::string& page_title,
      std::vector<MatchPositionPtr> title_match_positions,
      std::vector<MatchPositionPtr> url_for_display_match_positions,
      RawVisitDataPtr raw_visit_data,
      std::vector<RawVisitDataPtr> duplicates,
      const std::string& relative_date,
      std::vector<Annotation> annotations,
      bool is_known_to_sync,
      const base::flat_map<std::string, std::string>& debug_info,
      bool has_url_keyed_image);

URLVisit(const URLVisit&) = delete;
URLVisit& operator=(const URLVisit&) = delete;

  ~URLVisit();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLVisitPtr>
  URLVisitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLVisit::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLVisit::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLVisit::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLVisit_UnserializedMessageContext<
            UserType, URLVisit::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLVisit::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLVisit::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLVisit_UnserializedMessageContext<
            UserType, URLVisit::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLVisit::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t visit_id;
  
  ::GURL normalized_url;
  
  std::string url_for_display;
  
  std::string page_title;
  
  std::vector<MatchPositionPtr> title_match_positions;
  
  std::vector<MatchPositionPtr> url_for_display_match_positions;
  
  RawVisitDataPtr raw_visit_data;
  
  std::vector<RawVisitDataPtr> duplicates;
  
  std::string relative_date;
  
  std::vector<Annotation> annotations;
  
  bool is_known_to_sync;
  
  base::flat_map<std::string, std::string> debug_info;
  
  bool has_url_keyed_image;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLVisit::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Cluster {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Cluster, T>::value>;
  using DataView = ClusterDataView;
  using Data_ = internal::Cluster_Data;

  template <typename... Args>
  static ClusterPtr New(Args&&... args) {
    return ClusterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClusterPtr From(const U& u) {
    return mojo::TypeConverter<ClusterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Cluster>::Convert(*this);
  }


  Cluster();

  Cluster(
      int64_t id,
      std::vector<URLVisitPtr> visits,
      const std::string& label,
      const std::optional<std::string>& tab_group_name,
      std::vector<MatchPositionPtr> label_match_positions,
      std::vector<SearchQueryPtr> related_searches,
      const std::optional<::GURL>& image_url,
      bool from_persistence,
      const std::optional<std::string>& debug_info);

Cluster(const Cluster&) = delete;
Cluster& operator=(const Cluster&) = delete;

  ~Cluster();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClusterPtr>
  ClusterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Cluster::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Cluster::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Cluster::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Cluster::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Cluster::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Cluster::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Cluster_UnserializedMessageContext<
            UserType, Cluster::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Cluster::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Cluster::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Cluster_UnserializedMessageContext<
            UserType, Cluster::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Cluster::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  std::vector<URLVisitPtr> visits;
  
  std::string label;
  
  std::optional<std::string> tab_group_name;
  
  std::vector<MatchPositionPtr> label_match_positions;
  
  std::vector<SearchQueryPtr> related_searches;
  
  std::optional<::GURL> image_url;
  
  bool from_persistence;
  
  std::optional<std::string> debug_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Cluster::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Cluster::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Cluster::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Cluster::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MatchPositionPtr MatchPosition::Clone() const {
  return New(
      mojo::Clone(begin),
      mojo::Clone(end)
  );
}

template <typename T, MatchPosition::EnableIfSame<T>*>
bool MatchPosition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->begin, other_struct.begin))
    return false;
  if (!mojo::Equals(this->end, other_struct.end))
    return false;
  return true;
}

template <typename T, MatchPosition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.begin < rhs.begin)
    return true;
  if (rhs.begin < lhs.begin)
    return false;
  if (lhs.end < rhs.end)
    return true;
  if (rhs.end < lhs.end)
    return false;
  return false;
}
template <typename StructPtrType>
SearchQueryPtr SearchQuery::Clone() const {
  return New(
      mojo::Clone(query),
      mojo::Clone(url)
  );
}

template <typename T, SearchQuery::EnableIfSame<T>*>
bool SearchQuery::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, SearchQuery::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
RawVisitDataPtr RawVisitData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(visit_time)
  );
}

template <typename T, RawVisitData::EnableIfSame<T>*>
bool RawVisitData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->visit_time, other_struct.visit_time))
    return false;
  return true;
}

template <typename T, RawVisitData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.visit_time < rhs.visit_time)
    return true;
  if (rhs.visit_time < lhs.visit_time)
    return false;
  return false;
}
template <typename StructPtrType>
URLVisitPtr URLVisit::Clone() const {
  return New(
      mojo::Clone(visit_id),
      mojo::Clone(normalized_url),
      mojo::Clone(url_for_display),
      mojo::Clone(page_title),
      mojo::Clone(title_match_positions),
      mojo::Clone(url_for_display_match_positions),
      mojo::Clone(raw_visit_data),
      mojo::Clone(duplicates),
      mojo::Clone(relative_date),
      mojo::Clone(annotations),
      mojo::Clone(is_known_to_sync),
      mojo::Clone(debug_info),
      mojo::Clone(has_url_keyed_image)
  );
}

template <typename T, URLVisit::EnableIfSame<T>*>
bool URLVisit::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->visit_id, other_struct.visit_id))
    return false;
  if (!mojo::Equals(this->normalized_url, other_struct.normalized_url))
    return false;
  if (!mojo::Equals(this->url_for_display, other_struct.url_for_display))
    return false;
  if (!mojo::Equals(this->page_title, other_struct.page_title))
    return false;
  if (!mojo::Equals(this->title_match_positions, other_struct.title_match_positions))
    return false;
  if (!mojo::Equals(this->url_for_display_match_positions, other_struct.url_for_display_match_positions))
    return false;
  if (!mojo::Equals(this->raw_visit_data, other_struct.raw_visit_data))
    return false;
  if (!mojo::Equals(this->duplicates, other_struct.duplicates))
    return false;
  if (!mojo::Equals(this->relative_date, other_struct.relative_date))
    return false;
  if (!mojo::Equals(this->annotations, other_struct.annotations))
    return false;
  if (!mojo::Equals(this->is_known_to_sync, other_struct.is_known_to_sync))
    return false;
  if (!mojo::Equals(this->debug_info, other_struct.debug_info))
    return false;
  if (!mojo::Equals(this->has_url_keyed_image, other_struct.has_url_keyed_image))
    return false;
  return true;
}

template <typename T, URLVisit::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.visit_id < rhs.visit_id)
    return true;
  if (rhs.visit_id < lhs.visit_id)
    return false;
  if (lhs.normalized_url < rhs.normalized_url)
    return true;
  if (rhs.normalized_url < lhs.normalized_url)
    return false;
  if (lhs.url_for_display < rhs.url_for_display)
    return true;
  if (rhs.url_for_display < lhs.url_for_display)
    return false;
  if (lhs.page_title < rhs.page_title)
    return true;
  if (rhs.page_title < lhs.page_title)
    return false;
  if (lhs.title_match_positions < rhs.title_match_positions)
    return true;
  if (rhs.title_match_positions < lhs.title_match_positions)
    return false;
  if (lhs.url_for_display_match_positions < rhs.url_for_display_match_positions)
    return true;
  if (rhs.url_for_display_match_positions < lhs.url_for_display_match_positions)
    return false;
  if (lhs.raw_visit_data < rhs.raw_visit_data)
    return true;
  if (rhs.raw_visit_data < lhs.raw_visit_data)
    return false;
  if (lhs.duplicates < rhs.duplicates)
    return true;
  if (rhs.duplicates < lhs.duplicates)
    return false;
  if (lhs.relative_date < rhs.relative_date)
    return true;
  if (rhs.relative_date < lhs.relative_date)
    return false;
  if (lhs.annotations < rhs.annotations)
    return true;
  if (rhs.annotations < lhs.annotations)
    return false;
  if (lhs.is_known_to_sync < rhs.is_known_to_sync)
    return true;
  if (rhs.is_known_to_sync < lhs.is_known_to_sync)
    return false;
  if (lhs.debug_info < rhs.debug_info)
    return true;
  if (rhs.debug_info < lhs.debug_info)
    return false;
  if (lhs.has_url_keyed_image < rhs.has_url_keyed_image)
    return true;
  if (rhs.has_url_keyed_image < lhs.has_url_keyed_image)
    return false;
  return false;
}
template <typename StructPtrType>
ClusterPtr Cluster::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(visits),
      mojo::Clone(label),
      mojo::Clone(tab_group_name),
      mojo::Clone(label_match_positions),
      mojo::Clone(related_searches),
      mojo::Clone(image_url),
      mojo::Clone(from_persistence),
      mojo::Clone(debug_info)
  );
}

template <typename T, Cluster::EnableIfSame<T>*>
bool Cluster::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->visits, other_struct.visits))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->tab_group_name, other_struct.tab_group_name))
    return false;
  if (!mojo::Equals(this->label_match_positions, other_struct.label_match_positions))
    return false;
  if (!mojo::Equals(this->related_searches, other_struct.related_searches))
    return false;
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->from_persistence, other_struct.from_persistence))
    return false;
  if (!mojo::Equals(this->debug_info, other_struct.debug_info))
    return false;
  return true;
}

template <typename T, Cluster::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.visits < rhs.visits)
    return true;
  if (rhs.visits < lhs.visits)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.tab_group_name < rhs.tab_group_name)
    return true;
  if (rhs.tab_group_name < lhs.tab_group_name)
    return false;
  if (lhs.label_match_positions < rhs.label_match_positions)
    return true;
  if (rhs.label_match_positions < lhs.label_match_positions)
    return false;
  if (lhs.related_searches < rhs.related_searches)
    return true;
  if (rhs.related_searches < lhs.related_searches)
    return false;
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.from_persistence < rhs.from_persistence)
    return true;
  if (rhs.from_persistence < lhs.from_persistence)
    return false;
  if (lhs.debug_info < rhs.debug_info)
    return true;
  if (rhs.debug_info < lhs.debug_info)
    return false;
  return false;
}


}  // history_clusters::mojom

namespace mojo {


template <>
struct  StructTraits<::history_clusters::mojom::MatchPosition::DataView,
                                         ::history_clusters::mojom::MatchPositionPtr> {
  static bool IsNull(const ::history_clusters::mojom::MatchPositionPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::MatchPositionPtr* output) { output->reset(); }

  static decltype(::history_clusters::mojom::MatchPosition::begin) begin(
      const ::history_clusters::mojom::MatchPositionPtr& input) {
    return input->begin;
  }

  static decltype(::history_clusters::mojom::MatchPosition::end) end(
      const ::history_clusters::mojom::MatchPositionPtr& input) {
    return input->end;
  }

  static bool Read(::history_clusters::mojom::MatchPosition::DataView input, ::history_clusters::mojom::MatchPositionPtr* output);
};


template <>
struct  StructTraits<::history_clusters::mojom::SearchQuery::DataView,
                                         ::history_clusters::mojom::SearchQueryPtr> {
  static bool IsNull(const ::history_clusters::mojom::SearchQueryPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::SearchQueryPtr* output) { output->reset(); }

  static const decltype(::history_clusters::mojom::SearchQuery::query)& query(
      const ::history_clusters::mojom::SearchQueryPtr& input) {
    return input->query;
  }

  static const decltype(::history_clusters::mojom::SearchQuery::url)& url(
      const ::history_clusters::mojom::SearchQueryPtr& input) {
    return input->url;
  }

  static bool Read(::history_clusters::mojom::SearchQuery::DataView input, ::history_clusters::mojom::SearchQueryPtr* output);
};


template <>
struct  StructTraits<::history_clusters::mojom::RawVisitData::DataView,
                                         ::history_clusters::mojom::RawVisitDataPtr> {
  static bool IsNull(const ::history_clusters::mojom::RawVisitDataPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::RawVisitDataPtr* output) { output->reset(); }

  static const decltype(::history_clusters::mojom::RawVisitData::url)& url(
      const ::history_clusters::mojom::RawVisitDataPtr& input) {
    return input->url;
  }

  static const decltype(::history_clusters::mojom::RawVisitData::visit_time)& visit_time(
      const ::history_clusters::mojom::RawVisitDataPtr& input) {
    return input->visit_time;
  }

  static bool Read(::history_clusters::mojom::RawVisitData::DataView input, ::history_clusters::mojom::RawVisitDataPtr* output);
};


template <>
struct  StructTraits<::history_clusters::mojom::URLVisit::DataView,
                                         ::history_clusters::mojom::URLVisitPtr> {
  static bool IsNull(const ::history_clusters::mojom::URLVisitPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::URLVisitPtr* output) { output->reset(); }

  static decltype(::history_clusters::mojom::URLVisit::visit_id) visit_id(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->visit_id;
  }

  static const decltype(::history_clusters::mojom::URLVisit::normalized_url)& normalized_url(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->normalized_url;
  }

  static const decltype(::history_clusters::mojom::URLVisit::url_for_display)& url_for_display(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->url_for_display;
  }

  static const decltype(::history_clusters::mojom::URLVisit::page_title)& page_title(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->page_title;
  }

  static const decltype(::history_clusters::mojom::URLVisit::title_match_positions)& title_match_positions(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->title_match_positions;
  }

  static const decltype(::history_clusters::mojom::URLVisit::url_for_display_match_positions)& url_for_display_match_positions(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->url_for_display_match_positions;
  }

  static const decltype(::history_clusters::mojom::URLVisit::raw_visit_data)& raw_visit_data(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->raw_visit_data;
  }

  static const decltype(::history_clusters::mojom::URLVisit::duplicates)& duplicates(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->duplicates;
  }

  static const decltype(::history_clusters::mojom::URLVisit::relative_date)& relative_date(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->relative_date;
  }

  static const decltype(::history_clusters::mojom::URLVisit::annotations)& annotations(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->annotations;
  }

  static decltype(::history_clusters::mojom::URLVisit::is_known_to_sync) is_known_to_sync(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->is_known_to_sync;
  }

  static const decltype(::history_clusters::mojom::URLVisit::debug_info)& debug_info(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->debug_info;
  }

  static decltype(::history_clusters::mojom::URLVisit::has_url_keyed_image) has_url_keyed_image(
      const ::history_clusters::mojom::URLVisitPtr& input) {
    return input->has_url_keyed_image;
  }

  static bool Read(::history_clusters::mojom::URLVisit::DataView input, ::history_clusters::mojom::URLVisitPtr* output);
};


template <>
struct  StructTraits<::history_clusters::mojom::Cluster::DataView,
                                         ::history_clusters::mojom::ClusterPtr> {
  static bool IsNull(const ::history_clusters::mojom::ClusterPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::ClusterPtr* output) { output->reset(); }

  static decltype(::history_clusters::mojom::Cluster::id) id(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->id;
  }

  static const decltype(::history_clusters::mojom::Cluster::visits)& visits(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->visits;
  }

  static const decltype(::history_clusters::mojom::Cluster::label)& label(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->label;
  }

  static const decltype(::history_clusters::mojom::Cluster::tab_group_name)& tab_group_name(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->tab_group_name;
  }

  static const decltype(::history_clusters::mojom::Cluster::label_match_positions)& label_match_positions(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->label_match_positions;
  }

  static const decltype(::history_clusters::mojom::Cluster::related_searches)& related_searches(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->related_searches;
  }

  static const decltype(::history_clusters::mojom::Cluster::image_url)& image_url(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->image_url;
  }

  static decltype(::history_clusters::mojom::Cluster::from_persistence) from_persistence(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->from_persistence;
  }

  static const decltype(::history_clusters::mojom::Cluster::debug_info)& debug_info(
      const ::history_clusters::mojom::ClusterPtr& input) {
    return input->debug_info;
  }

  static bool Read(::history_clusters::mojom::Cluster::DataView input, ::history_clusters::mojom::ClusterPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_H_