// components/guest_contents/common/guest_contents.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_GUEST_CONTENTS_COMMON_GUEST_CONTENTS_MOJOM_H_
#define COMPONENTS_GUEST_CONTENTS_COMMON_GUEST_CONTENTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/guest_contents/common/guest_contents.mojom-features.h"  // IWYU pragma: export
#include "components/guest_contents/common/guest_contents.mojom-shared.h"  // IWYU pragma: export
#include "components/guest_contents/common/guest_contents.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace guest_contents::mojom {

class GuestContentsHostProxy;

template <typename ImplRefTraits>
class GuestContentsHostStub;

class GuestContentsHostRequestValidator;
class GuestContentsHostResponseValidator;


class GuestContentsHost
    : public GuestContentsHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "guest_contents.mojom.GuestContentsHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GuestContentsHostInterfaceBase;
  using Proxy_ = GuestContentsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = GuestContentsHostStub<ImplRefTraits>;

  using RequestValidator_ = GuestContentsHostRequestValidator;
  using ResponseValidator_ = GuestContentsHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAttachMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Attach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GuestContentsHost() = default;

  using AttachCallback = base::OnceCallback<void(bool)>;
  using AttachMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Attach(const ::blink::LocalFrameToken& frame_to_swap, int32_t guest_contents_id, AttachCallback callback) = 0;
};



class  GuestContentsHostProxy
    : public GuestContentsHost {
 public:
  using InterfaceType = GuestContentsHost;

  explicit GuestContentsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Attach(const ::blink::LocalFrameToken& frame_to_swap, int32_t guest_contents_id, AttachCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GuestContentsHostStubDispatch {
 public:
  static bool Accept(GuestContentsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GuestContentsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GuestContentsHost>>
class GuestContentsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GuestContentsHostStub() = default;
  ~GuestContentsHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestContentsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestContentsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GuestContentsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestContentsHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // guest_contents::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_GUEST_CONTENTS_COMMON_GUEST_CONTENTS_MOJOM_H_