// components/global_media_controls/public/mojom/device_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/global_media_controls/public/mojom/device_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/global_media_controls/public/mojom/device_service.mojom-params-data.h"
#include "components/global_media_controls/public/mojom/device_service.mojom-shared-message-ids.h"

#include "components/global_media_controls/public/mojom/device_service.mojom-import-headers.h"
#include "components/global_media_controls/public/mojom/device_service.mojom-test-utils.h"


namespace global_media_controls::mojom {
Device::Device()
    : id(),
      name(),
      status_text(),
      icon() {}

Device::Device(
    const std::string& id_in,
    const std::string& name_in,
    const std::string& status_text_in,
    IconType icon_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      status_text(std::move(status_text_in)),
      icon(std::move(icon_in)) {}

Device::~Device() = default;
size_t Device::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->status_text);
  seed = mojo::internal::Hash(seed, this->icon);
  return seed;
}

void Device::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_text"), this->status_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IconType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Device::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.
constexpr base::Token DeviceListHost::Uuid_;

DeviceListHost::IPCStableHashFunction DeviceListHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceListHost>(message.name())) {
    case messages::DeviceListHost::kSelectDevice: {
      return &DeviceListHost::SelectDevice_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceListHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceListHost>(message.name())) {
      case messages::DeviceListHost::kSelectDevice:
            return "Receive global_media_controls::mojom::DeviceListHost::SelectDevice";
    }
  } else {
    switch (static_cast<messages::DeviceListHost>(message.name())) {
      case messages::DeviceListHost::kSelectDevice:
            return "Receive reply global_media_controls::mojom::DeviceListHost::SelectDevice";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceListHost::SelectDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd46cffbd;  // IPCStableHash for global_media_controls::mojom::DeviceListHost::SelectDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceListHostProxy::DeviceListHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceListHostProxy::SelectDevice(
    const std::string& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DeviceListHost::SelectDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceListHost::kSelectDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceListHost_SelectDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in DeviceListHost.SelectDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceListHost::Name_);
  message.set_method_name("SelectDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceListHostStubDispatch::Accept(
    DeviceListHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceListHost>(message->header()->name)) {
    case messages::DeviceListHost::kSelectDevice: {
      DCHECK(message->is_serialized());
      internal::DeviceListHost_SelectDevice_Params_Data* params =
          reinterpret_cast<internal::DeviceListHost_SelectDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceListHost.0
      bool success = true;
      std::string p_device_id{};
      DeviceListHost_SelectDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceListHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectDevice(        
        std::move(p_device_id));
      return true;
    }
  }
  return false;
}

// static
bool DeviceListHostStubDispatch::AcceptWithResponder(
    DeviceListHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceListHost>(message->header()->name)) {
    case messages::DeviceListHost::kSelectDevice: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceListHostValidationInfo[] = {
    { &internal::DeviceListHost_SelectDevice_Params_Data::Validate,
     nullptr /* no response */},
};

bool DeviceListHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::global_media_controls::mojom::DeviceListHost::Name_,
    kDeviceListHostValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token DeviceListClient::Uuid_;

DeviceListClient::IPCStableHashFunction DeviceListClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceListClient>(message.name())) {
    case messages::DeviceListClient::kOnDevicesUpdated: {
      return &DeviceListClient::OnDevicesUpdated_Sym::IPCStableHash;
    }
    case messages::DeviceListClient::kOnPermissionRejected: {
      return &DeviceListClient::OnPermissionRejected_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceListClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceListClient>(message.name())) {
      case messages::DeviceListClient::kOnDevicesUpdated:
            return "Receive global_media_controls::mojom::DeviceListClient::OnDevicesUpdated";
      case messages::DeviceListClient::kOnPermissionRejected:
            return "Receive global_media_controls::mojom::DeviceListClient::OnPermissionRejected";
    }
  } else {
    switch (static_cast<messages::DeviceListClient>(message.name())) {
      case messages::DeviceListClient::kOnDevicesUpdated:
            return "Receive reply global_media_controls::mojom::DeviceListClient::OnDevicesUpdated";
      case messages::DeviceListClient::kOnPermissionRejected:
            return "Receive reply global_media_controls::mojom::DeviceListClient::OnPermissionRejected";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceListClient::OnDevicesUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff87aa30;  // IPCStableHash for global_media_controls::mojom::DeviceListClient::OnDevicesUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceListClient::OnPermissionRejected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88865108;  // IPCStableHash for global_media_controls::mojom::DeviceListClient::OnPermissionRejected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceListClientProxy::DeviceListClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceListClientProxy::OnDevicesUpdated(
    std::vector<DevicePtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DeviceListClient::OnDevicesUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<DevicePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceListClient::kOnDevicesUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceListClient_OnDevicesUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::global_media_controls::mojom::DeviceDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in DeviceListClient.OnDevicesUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceListClient::Name_);
  message.set_method_name("OnDevicesUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceListClientProxy::OnPermissionRejected(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DeviceListClient::OnPermissionRejected");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceListClient::kOnPermissionRejected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceListClient_OnPermissionRejected_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceListClient::Name_);
  message.set_method_name("OnPermissionRejected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceListClientStubDispatch::Accept(
    DeviceListClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceListClient>(message->header()->name)) {
    case messages::DeviceListClient::kOnDevicesUpdated: {
      DCHECK(message->is_serialized());
      internal::DeviceListClient_OnDevicesUpdated_Params_Data* params =
          reinterpret_cast<internal::DeviceListClient_OnDevicesUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceListClient.0
      bool success = true;
      std::vector<DevicePtr> p_devices{};
      DeviceListClient_OnDevicesUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDevices(&p_devices))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceListClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDevicesUpdated(        
        std::move(p_devices));
      return true;
    }
    case messages::DeviceListClient::kOnPermissionRejected: {
      DCHECK(message->is_serialized());
      internal::DeviceListClient_OnPermissionRejected_Params_Data* params =
          reinterpret_cast<internal::DeviceListClient_OnPermissionRejected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceListClient.1
      bool success = true;
      DeviceListClient_OnPermissionRejected_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceListClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPermissionRejected(        );
      return true;
    }
  }
  return false;
}

// static
bool DeviceListClientStubDispatch::AcceptWithResponder(
    DeviceListClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceListClient>(message->header()->name)) {
    case messages::DeviceListClient::kOnDevicesUpdated: {
      break;
    }
    case messages::DeviceListClient::kOnPermissionRejected: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceListClientValidationInfo[] = {
    { &internal::DeviceListClient_OnDevicesUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DeviceListClient_OnPermissionRejected_Params_Data::Validate,
     nullptr /* no response */},
};

bool DeviceListClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::global_media_controls::mojom::DeviceListClient::Name_,
    kDeviceListClientValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token DeviceService::Uuid_;

DeviceService::IPCStableHashFunction DeviceService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceService>(message.name())) {
    case messages::DeviceService::kGetDeviceListHostForSession: {
      return &DeviceService::GetDeviceListHostForSession_Sym::IPCStableHash;
    }
    case messages::DeviceService::kGetDeviceListHostForPresentation: {
      return &DeviceService::GetDeviceListHostForPresentation_Sym::IPCStableHash;
    }
    case messages::DeviceService::kSetDevicePickerProvider: {
      return &DeviceService::SetDevicePickerProvider_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceService>(message.name())) {
      case messages::DeviceService::kGetDeviceListHostForSession:
            return "Receive global_media_controls::mojom::DeviceService::GetDeviceListHostForSession";
      case messages::DeviceService::kGetDeviceListHostForPresentation:
            return "Receive global_media_controls::mojom::DeviceService::GetDeviceListHostForPresentation";
      case messages::DeviceService::kSetDevicePickerProvider:
            return "Receive global_media_controls::mojom::DeviceService::SetDevicePickerProvider";
    }
  } else {
    switch (static_cast<messages::DeviceService>(message.name())) {
      case messages::DeviceService::kGetDeviceListHostForSession:
            return "Receive reply global_media_controls::mojom::DeviceService::GetDeviceListHostForSession";
      case messages::DeviceService::kGetDeviceListHostForPresentation:
            return "Receive reply global_media_controls::mojom::DeviceService::GetDeviceListHostForPresentation";
      case messages::DeviceService::kSetDevicePickerProvider:
            return "Receive reply global_media_controls::mojom::DeviceService::SetDevicePickerProvider";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceService::GetDeviceListHostForSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7985702;  // IPCStableHash for global_media_controls::mojom::DeviceService::GetDeviceListHostForSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::GetDeviceListHostForPresentation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a7809cd;  // IPCStableHash for global_media_controls::mojom::DeviceService::GetDeviceListHostForPresentation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::SetDevicePickerProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa88f47d9;  // IPCStableHash for global_media_controls::mojom::DeviceService::SetDevicePickerProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceServiceProxy::DeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceServiceProxy::GetDeviceListHostForSession(
    const std::string& in_session_id, ::mojo::PendingReceiver<DeviceListHost> in_host_receiver, ::mojo::PendingRemote<DeviceListClient> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DeviceService::GetDeviceListHostForSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_receiver"), in_host_receiver,
                        "<value of type ::mojo::PendingReceiver<DeviceListHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote,
                        "<value of type ::mojo::PendingRemote<DeviceListClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kGetDeviceListHostForSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceService_GetDeviceListHostForSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in DeviceService.GetDeviceListHostForSession request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::global_media_controls::mojom::DeviceListHostInterfaceBase>>(
    in_host_receiver,
    &params->host_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host_receiver in DeviceService.GetDeviceListHostForSession request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::global_media_controls::mojom::DeviceListClientInterfaceBase>>(
    in_client_remote,
    &params->client_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_remote in DeviceService.GetDeviceListHostForSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("GetDeviceListHostForSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::GetDeviceListHostForPresentation(
    ::mojo::PendingReceiver<DeviceListHost> in_host_receiver, ::mojo::PendingRemote<DeviceListClient> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DeviceService::GetDeviceListHostForPresentation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_receiver"), in_host_receiver,
                        "<value of type ::mojo::PendingReceiver<DeviceListHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote,
                        "<value of type ::mojo::PendingRemote<DeviceListClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kGetDeviceListHostForPresentation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceService_GetDeviceListHostForPresentation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::global_media_controls::mojom::DeviceListHostInterfaceBase>>(
    in_host_receiver,
    &params->host_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host_receiver in DeviceService.GetDeviceListHostForPresentation request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::global_media_controls::mojom::DeviceListClientInterfaceBase>>(
    in_client_remote,
    &params->client_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_remote in DeviceService.GetDeviceListHostForPresentation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("GetDeviceListHostForPresentation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::SetDevicePickerProvider(
    ::mojo::PendingRemote<DevicePickerProvider> in_provider_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DeviceService::SetDevicePickerProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_remote"), in_provider_remote,
                        "<value of type ::mojo::PendingRemote<DevicePickerProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kSetDevicePickerProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DeviceService_SetDevicePickerProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::global_media_controls::mojom::DevicePickerProviderInterfaceBase>>(
    in_provider_remote,
    &params->provider_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->provider_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid provider_remote in DeviceService.SetDevicePickerProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("SetDevicePickerProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceServiceStubDispatch::Accept(
    DeviceService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceService>(message->header()->name)) {
    case messages::DeviceService::kGetDeviceListHostForSession: {
      DCHECK(message->is_serialized());
      internal::DeviceService_GetDeviceListHostForSession_Params_Data* params =
          reinterpret_cast<internal::DeviceService_GetDeviceListHostForSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceService.0
      bool success = true;
      std::string p_session_id{};
      ::mojo::PendingReceiver<DeviceListHost> p_host_receiver{};
      ::mojo::PendingRemote<DeviceListClient> p_client_remote{};
      DeviceService_GetDeviceListHostForSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success) {
        p_host_receiver =
            input_data_view.TakeHostReceiver<decltype(p_host_receiver)>();
      }
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceListHostForSession(        
        std::move(p_session_id), 
        std::move(p_host_receiver), 
        std::move(p_client_remote));
      return true;
    }
    case messages::DeviceService::kGetDeviceListHostForPresentation: {
      DCHECK(message->is_serialized());
      internal::DeviceService_GetDeviceListHostForPresentation_Params_Data* params =
          reinterpret_cast<internal::DeviceService_GetDeviceListHostForPresentation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceService.1
      bool success = true;
      ::mojo::PendingReceiver<DeviceListHost> p_host_receiver{};
      ::mojo::PendingRemote<DeviceListClient> p_client_remote{};
      DeviceService_GetDeviceListHostForPresentation_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host_receiver =
            input_data_view.TakeHostReceiver<decltype(p_host_receiver)>();
      }
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceListHostForPresentation(        
        std::move(p_host_receiver), 
        std::move(p_client_remote));
      return true;
    }
    case messages::DeviceService::kSetDevicePickerProvider: {
      DCHECK(message->is_serialized());
      internal::DeviceService_SetDevicePickerProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_SetDevicePickerProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceService.2
      bool success = true;
      ::mojo::PendingRemote<DevicePickerProvider> p_provider_remote{};
      DeviceService_SetDevicePickerProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_provider_remote =
            input_data_view.TakeProviderRemote<decltype(p_provider_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDevicePickerProvider(        
        std::move(p_provider_remote));
      return true;
    }
  }
  return false;
}

// static
bool DeviceServiceStubDispatch::AcceptWithResponder(
    DeviceService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceService>(message->header()->name)) {
    case messages::DeviceService::kGetDeviceListHostForSession: {
      break;
    }
    case messages::DeviceService::kGetDeviceListHostForPresentation: {
      break;
    }
    case messages::DeviceService::kSetDevicePickerProvider: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDeviceServiceValidationInfo[] = {
    { &internal::DeviceService_GetDeviceListHostForSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DeviceService_GetDeviceListHostForPresentation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DeviceService_SetDevicePickerProvider_Params_Data::Validate,
     nullptr /* no response */},
};

bool DeviceServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::global_media_controls::mojom::DeviceService::Name_,
    kDeviceServiceValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token DevicePickerProvider::Uuid_;

DevicePickerProvider::IPCStableHashFunction DevicePickerProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevicePickerProvider>(message.name())) {
    case messages::DevicePickerProvider::kCreateItem: {
      return &DevicePickerProvider::CreateItem_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kDeleteItem: {
      return &DevicePickerProvider::DeleteItem_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kShowItem: {
      return &DevicePickerProvider::ShowItem_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kHideItem: {
      return &DevicePickerProvider::HideItem_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kOnMetadataChanged: {
      return &DevicePickerProvider::OnMetadataChanged_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kOnArtworkImageChanged: {
      return &DevicePickerProvider::OnArtworkImageChanged_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kOnFaviconImageChanged: {
      return &DevicePickerProvider::OnFaviconImageChanged_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kAddObserver: {
      return &DevicePickerProvider::AddObserver_Sym::IPCStableHash;
    }
    case messages::DevicePickerProvider::kHideMediaUI: {
      return &DevicePickerProvider::HideMediaUI_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevicePickerProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevicePickerProvider>(message.name())) {
      case messages::DevicePickerProvider::kCreateItem:
            return "Receive global_media_controls::mojom::DevicePickerProvider::CreateItem";
      case messages::DevicePickerProvider::kDeleteItem:
            return "Receive global_media_controls::mojom::DevicePickerProvider::DeleteItem";
      case messages::DevicePickerProvider::kShowItem:
            return "Receive global_media_controls::mojom::DevicePickerProvider::ShowItem";
      case messages::DevicePickerProvider::kHideItem:
            return "Receive global_media_controls::mojom::DevicePickerProvider::HideItem";
      case messages::DevicePickerProvider::kOnMetadataChanged:
            return "Receive global_media_controls::mojom::DevicePickerProvider::OnMetadataChanged";
      case messages::DevicePickerProvider::kOnArtworkImageChanged:
            return "Receive global_media_controls::mojom::DevicePickerProvider::OnArtworkImageChanged";
      case messages::DevicePickerProvider::kOnFaviconImageChanged:
            return "Receive global_media_controls::mojom::DevicePickerProvider::OnFaviconImageChanged";
      case messages::DevicePickerProvider::kAddObserver:
            return "Receive global_media_controls::mojom::DevicePickerProvider::AddObserver";
      case messages::DevicePickerProvider::kHideMediaUI:
            return "Receive global_media_controls::mojom::DevicePickerProvider::HideMediaUI";
    }
  } else {
    switch (static_cast<messages::DevicePickerProvider>(message.name())) {
      case messages::DevicePickerProvider::kCreateItem:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::CreateItem";
      case messages::DevicePickerProvider::kDeleteItem:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::DeleteItem";
      case messages::DevicePickerProvider::kShowItem:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::ShowItem";
      case messages::DevicePickerProvider::kHideItem:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::HideItem";
      case messages::DevicePickerProvider::kOnMetadataChanged:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::OnMetadataChanged";
      case messages::DevicePickerProvider::kOnArtworkImageChanged:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::OnArtworkImageChanged";
      case messages::DevicePickerProvider::kOnFaviconImageChanged:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::OnFaviconImageChanged";
      case messages::DevicePickerProvider::kAddObserver:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::AddObserver";
      case messages::DevicePickerProvider::kHideMediaUI:
            return "Receive reply global_media_controls::mojom::DevicePickerProvider::HideMediaUI";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevicePickerProvider::CreateItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd04782e;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::CreateItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::DeleteItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc08f918a;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::DeleteItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::ShowItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae8965c0;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::ShowItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::HideItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa40a0ea7;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::HideItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::OnMetadataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedf86d6b;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::OnMetadataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::OnArtworkImageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc46cc9cb;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::OnArtworkImageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::OnFaviconImageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0563a08;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::OnFaviconImageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2440f51c;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerProvider::HideMediaUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x926fb67d;  // IPCStableHash for global_media_controls::mojom::DevicePickerProvider::HideMediaUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevicePickerProviderProxy::DevicePickerProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePickerProviderProxy::CreateItem(
    const ::base::UnguessableToken& in_source_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DevicePickerProvider::CreateItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kCreateItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_CreateItem_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_id in DevicePickerProvider.CreateItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("CreateItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::DeleteItem(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerProvider::DeleteItem");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kDeleteItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_DeleteItem_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("DeleteItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::ShowItem(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerProvider::ShowItem");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kShowItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_ShowItem_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("ShowItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::HideItem(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerProvider::HideItem");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kHideItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_HideItem_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("HideItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::OnMetadataChanged(
    const ::media_session::MediaMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DevicePickerProvider::OnMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::media_session::MediaMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kOnMetadataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_OnMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_session::mojom::MediaMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in DevicePickerProvider.OnMetadataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("OnMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::OnArtworkImageChanged(
    const ::gfx::ImageSkia& in_artwork_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DevicePickerProvider::OnArtworkImageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("artwork_image"), in_artwork_image,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kOnArtworkImageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_OnArtworkImageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->artwork_image)::BaseType> artwork_image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_artwork_image,
    artwork_image_fragment);

  params->artwork_image.Set(
      artwork_image_fragment.is_null() ? nullptr : artwork_image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("OnArtworkImageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::OnFaviconImageChanged(
    const ::gfx::ImageSkia& in_favicon_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DevicePickerProvider::OnFaviconImageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicon_image"), in_favicon_image,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kOnFaviconImageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_OnFaviconImageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicon_image)::BaseType> favicon_image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_favicon_image,
    favicon_image_fragment);

  params->favicon_image.Set(
      favicon_image_fragment.is_null() ? nullptr : favicon_image_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("OnFaviconImageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::AddObserver(
    ::mojo::PendingRemote<DevicePickerObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send global_media_controls::mojom::DevicePickerProvider::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<DevicePickerObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_AddObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::global_media_controls::mojom::DevicePickerObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in DevicePickerProvider.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerProviderProxy::HideMediaUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerProvider::HideMediaUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerProvider::kHideMediaUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerProvider_HideMediaUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerProvider::Name_);
  message.set_method_name("HideMediaUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevicePickerProviderStubDispatch::Accept(
    DevicePickerProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevicePickerProvider>(message->header()->name)) {
    case messages::DevicePickerProvider::kCreateItem: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_CreateItem_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_CreateItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.0
      bool success = true;
      ::base::UnguessableToken p_source_id{};
      DevicePickerProvider_CreateItem_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateItem(        
        std::move(p_source_id));
      return true;
    }
    case messages::DevicePickerProvider::kDeleteItem: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_DeleteItem_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_DeleteItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.1
      bool success = true;
      DevicePickerProvider_DeleteItem_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteItem(        );
      return true;
    }
    case messages::DevicePickerProvider::kShowItem: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_ShowItem_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_ShowItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.2
      bool success = true;
      DevicePickerProvider_ShowItem_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowItem(        );
      return true;
    }
    case messages::DevicePickerProvider::kHideItem: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_HideItem_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_HideItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.3
      bool success = true;
      DevicePickerProvider_HideItem_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideItem(        );
      return true;
    }
    case messages::DevicePickerProvider::kOnMetadataChanged: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_OnMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_OnMetadataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.4
      bool success = true;
      ::media_session::MediaMetadata p_metadata{};
      DevicePickerProvider_OnMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMetadataChanged(        
        std::move(p_metadata));
      return true;
    }
    case messages::DevicePickerProvider::kOnArtworkImageChanged: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_OnArtworkImageChanged_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_OnArtworkImageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.5
      bool success = true;
      ::gfx::ImageSkia p_artwork_image{};
      DevicePickerProvider_OnArtworkImageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArtworkImage(&p_artwork_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnArtworkImageChanged(        
        std::move(p_artwork_image));
      return true;
    }
    case messages::DevicePickerProvider::kOnFaviconImageChanged: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_OnFaviconImageChanged_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_OnFaviconImageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.6
      bool success = true;
      ::gfx::ImageSkia p_favicon_image{};
      DevicePickerProvider_OnFaviconImageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFaviconImage(&p_favicon_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFaviconImageChanged(        
        std::move(p_favicon_image));
      return true;
    }
    case messages::DevicePickerProvider::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_AddObserver_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.7
      bool success = true;
      ::mojo::PendingRemote<DevicePickerObserver> p_observer{};
      DevicePickerProvider_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::DevicePickerProvider::kHideMediaUI: {
      DCHECK(message->is_serialized());
      internal::DevicePickerProvider_HideMediaUI_Params_Data* params =
          reinterpret_cast<internal::DevicePickerProvider_HideMediaUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerProvider.8
      bool success = true;
      DevicePickerProvider_HideMediaUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerProvider::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideMediaUI(        );
      return true;
    }
  }
  return false;
}

// static
bool DevicePickerProviderStubDispatch::AcceptWithResponder(
    DevicePickerProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevicePickerProvider>(message->header()->name)) {
    case messages::DevicePickerProvider::kCreateItem: {
      break;
    }
    case messages::DevicePickerProvider::kDeleteItem: {
      break;
    }
    case messages::DevicePickerProvider::kShowItem: {
      break;
    }
    case messages::DevicePickerProvider::kHideItem: {
      break;
    }
    case messages::DevicePickerProvider::kOnMetadataChanged: {
      break;
    }
    case messages::DevicePickerProvider::kOnArtworkImageChanged: {
      break;
    }
    case messages::DevicePickerProvider::kOnFaviconImageChanged: {
      break;
    }
    case messages::DevicePickerProvider::kAddObserver: {
      break;
    }
    case messages::DevicePickerProvider::kHideMediaUI: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevicePickerProviderValidationInfo[] = {
    { &internal::DevicePickerProvider_CreateItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_DeleteItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_ShowItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_HideItem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_OnMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_OnArtworkImageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_OnFaviconImageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerProvider_HideMediaUI_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevicePickerProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::global_media_controls::mojom::DevicePickerProvider::Name_,
    kDevicePickerProviderValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token DevicePickerObserver::Uuid_;

DevicePickerObserver::IPCStableHashFunction DevicePickerObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevicePickerObserver>(message.name())) {
    case messages::DevicePickerObserver::kOnMediaUIOpened: {
      return &DevicePickerObserver::OnMediaUIOpened_Sym::IPCStableHash;
    }
    case messages::DevicePickerObserver::kOnMediaUIClosed: {
      return &DevicePickerObserver::OnMediaUIClosed_Sym::IPCStableHash;
    }
    case messages::DevicePickerObserver::kOnMediaUIUpdated: {
      return &DevicePickerObserver::OnMediaUIUpdated_Sym::IPCStableHash;
    }
    case messages::DevicePickerObserver::kOnPickerDismissed: {
      return &DevicePickerObserver::OnPickerDismissed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevicePickerObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevicePickerObserver>(message.name())) {
      case messages::DevicePickerObserver::kOnMediaUIOpened:
            return "Receive global_media_controls::mojom::DevicePickerObserver::OnMediaUIOpened";
      case messages::DevicePickerObserver::kOnMediaUIClosed:
            return "Receive global_media_controls::mojom::DevicePickerObserver::OnMediaUIClosed";
      case messages::DevicePickerObserver::kOnMediaUIUpdated:
            return "Receive global_media_controls::mojom::DevicePickerObserver::OnMediaUIUpdated";
      case messages::DevicePickerObserver::kOnPickerDismissed:
            return "Receive global_media_controls::mojom::DevicePickerObserver::OnPickerDismissed";
    }
  } else {
    switch (static_cast<messages::DevicePickerObserver>(message.name())) {
      case messages::DevicePickerObserver::kOnMediaUIOpened:
            return "Receive reply global_media_controls::mojom::DevicePickerObserver::OnMediaUIOpened";
      case messages::DevicePickerObserver::kOnMediaUIClosed:
            return "Receive reply global_media_controls::mojom::DevicePickerObserver::OnMediaUIClosed";
      case messages::DevicePickerObserver::kOnMediaUIUpdated:
            return "Receive reply global_media_controls::mojom::DevicePickerObserver::OnMediaUIUpdated";
      case messages::DevicePickerObserver::kOnPickerDismissed:
            return "Receive reply global_media_controls::mojom::DevicePickerObserver::OnPickerDismissed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevicePickerObserver::OnMediaUIOpened_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d76ae45;  // IPCStableHash for global_media_controls::mojom::DevicePickerObserver::OnMediaUIOpened
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerObserver::OnMediaUIClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5d84c04;  // IPCStableHash for global_media_controls::mojom::DevicePickerObserver::OnMediaUIClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerObserver::OnMediaUIUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb22010a;  // IPCStableHash for global_media_controls::mojom::DevicePickerObserver::OnMediaUIUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevicePickerObserver::OnPickerDismissed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb73bf5a3;  // IPCStableHash for global_media_controls::mojom::DevicePickerObserver::OnPickerDismissed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevicePickerObserverProxy::DevicePickerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevicePickerObserverProxy::OnMediaUIOpened(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerObserver::OnMediaUIOpened");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerObserver::kOnMediaUIOpened), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerObserver_OnMediaUIOpened_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerObserver::Name_);
  message.set_method_name("OnMediaUIOpened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerObserverProxy::OnMediaUIClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerObserver::OnMediaUIClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerObserver::kOnMediaUIClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerObserver_OnMediaUIClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerObserver::Name_);
  message.set_method_name("OnMediaUIClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerObserverProxy::OnMediaUIUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerObserver::OnMediaUIUpdated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerObserver::kOnMediaUIUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerObserver_OnMediaUIUpdated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerObserver::Name_);
  message.set_method_name("OnMediaUIUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevicePickerObserverProxy::OnPickerDismissed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send global_media_controls::mojom::DevicePickerObserver::OnPickerDismissed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevicePickerObserver::kOnPickerDismissed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::global_media_controls::mojom::internal::DevicePickerObserver_OnPickerDismissed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevicePickerObserver::Name_);
  message.set_method_name("OnPickerDismissed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevicePickerObserverStubDispatch::Accept(
    DevicePickerObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevicePickerObserver>(message->header()->name)) {
    case messages::DevicePickerObserver::kOnMediaUIOpened: {
      DCHECK(message->is_serialized());
      internal::DevicePickerObserver_OnMediaUIOpened_Params_Data* params =
          reinterpret_cast<internal::DevicePickerObserver_OnMediaUIOpened_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerObserver.0
      bool success = true;
      DevicePickerObserver_OnMediaUIOpened_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaUIOpened(        );
      return true;
    }
    case messages::DevicePickerObserver::kOnMediaUIClosed: {
      DCHECK(message->is_serialized());
      internal::DevicePickerObserver_OnMediaUIClosed_Params_Data* params =
          reinterpret_cast<internal::DevicePickerObserver_OnMediaUIClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerObserver.1
      bool success = true;
      DevicePickerObserver_OnMediaUIClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaUIClosed(        );
      return true;
    }
    case messages::DevicePickerObserver::kOnMediaUIUpdated: {
      DCHECK(message->is_serialized());
      internal::DevicePickerObserver_OnMediaUIUpdated_Params_Data* params =
          reinterpret_cast<internal::DevicePickerObserver_OnMediaUIUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerObserver.2
      bool success = true;
      DevicePickerObserver_OnMediaUIUpdated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaUIUpdated(        );
      return true;
    }
    case messages::DevicePickerObserver::kOnPickerDismissed: {
      DCHECK(message->is_serialized());
      internal::DevicePickerObserver_OnPickerDismissed_Params_Data* params =
          reinterpret_cast<internal::DevicePickerObserver_OnPickerDismissed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevicePickerObserver.3
      bool success = true;
      DevicePickerObserver_OnPickerDismissed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevicePickerObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPickerDismissed(        );
      return true;
    }
  }
  return false;
}

// static
bool DevicePickerObserverStubDispatch::AcceptWithResponder(
    DevicePickerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevicePickerObserver>(message->header()->name)) {
    case messages::DevicePickerObserver::kOnMediaUIOpened: {
      break;
    }
    case messages::DevicePickerObserver::kOnMediaUIClosed: {
      break;
    }
    case messages::DevicePickerObserver::kOnMediaUIUpdated: {
      break;
    }
    case messages::DevicePickerObserver::kOnPickerDismissed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevicePickerObserverValidationInfo[] = {
    { &internal::DevicePickerObserver_OnMediaUIOpened_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerObserver_OnMediaUIClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerObserver_OnMediaUIUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevicePickerObserver_OnPickerDismissed_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevicePickerObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::global_media_controls::mojom::DevicePickerObserver::Name_,
    kDevicePickerObserverValidationInfo);
}



}  // global_media_controls::mojom


namespace mojo {


// static
bool StructTraits<::global_media_controls::mojom::Device::DataView, ::global_media_controls::mojom::DevicePtr>::Read(
    ::global_media_controls::mojom::Device::DataView input,
    ::global_media_controls::mojom::DevicePtr* output) {
  bool success = true;
  ::global_media_controls::mojom::DevicePtr result(::global_media_controls::mojom::Device::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadStatusText(&result->status_text))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace global_media_controls::mojom {


void DeviceListHostInterceptorForTesting::SelectDevice(const std::string& device_id) {
  GetForwardingInterface()->SelectDevice(
    std::move(device_id)
    );
}
DeviceListHostAsyncWaiter::DeviceListHostAsyncWaiter(
    DeviceListHost* proxy) : proxy_(proxy) {}

DeviceListHostAsyncWaiter::~DeviceListHostAsyncWaiter() = default;





void DeviceListClientInterceptorForTesting::OnDevicesUpdated(std::vector<DevicePtr> devices) {
  GetForwardingInterface()->OnDevicesUpdated(
    std::move(devices)
    );
}
void DeviceListClientInterceptorForTesting::OnPermissionRejected() {
  GetForwardingInterface()->OnPermissionRejected();
}
DeviceListClientAsyncWaiter::DeviceListClientAsyncWaiter(
    DeviceListClient* proxy) : proxy_(proxy) {}

DeviceListClientAsyncWaiter::~DeviceListClientAsyncWaiter() = default;





void DeviceServiceInterceptorForTesting::GetDeviceListHostForSession(const std::string& session_id, ::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) {
  GetForwardingInterface()->GetDeviceListHostForSession(
    std::move(session_id)
    , 
    std::move(host_receiver)
    , 
    std::move(client_remote)
    );
}
void DeviceServiceInterceptorForTesting::GetDeviceListHostForPresentation(::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) {
  GetForwardingInterface()->GetDeviceListHostForPresentation(
    std::move(host_receiver)
    , 
    std::move(client_remote)
    );
}
void DeviceServiceInterceptorForTesting::SetDevicePickerProvider(::mojo::PendingRemote<DevicePickerProvider> provider_remote) {
  GetForwardingInterface()->SetDevicePickerProvider(
    std::move(provider_remote)
    );
}
DeviceServiceAsyncWaiter::DeviceServiceAsyncWaiter(
    DeviceService* proxy) : proxy_(proxy) {}

DeviceServiceAsyncWaiter::~DeviceServiceAsyncWaiter() = default;





void DevicePickerProviderInterceptorForTesting::CreateItem(const ::base::UnguessableToken& source_id) {
  GetForwardingInterface()->CreateItem(
    std::move(source_id)
    );
}
void DevicePickerProviderInterceptorForTesting::DeleteItem() {
  GetForwardingInterface()->DeleteItem();
}
void DevicePickerProviderInterceptorForTesting::ShowItem() {
  GetForwardingInterface()->ShowItem();
}
void DevicePickerProviderInterceptorForTesting::HideItem() {
  GetForwardingInterface()->HideItem();
}
void DevicePickerProviderInterceptorForTesting::OnMetadataChanged(const ::media_session::MediaMetadata& metadata) {
  GetForwardingInterface()->OnMetadataChanged(
    std::move(metadata)
    );
}
void DevicePickerProviderInterceptorForTesting::OnArtworkImageChanged(const ::gfx::ImageSkia& artwork_image) {
  GetForwardingInterface()->OnArtworkImageChanged(
    std::move(artwork_image)
    );
}
void DevicePickerProviderInterceptorForTesting::OnFaviconImageChanged(const ::gfx::ImageSkia& favicon_image) {
  GetForwardingInterface()->OnFaviconImageChanged(
    std::move(favicon_image)
    );
}
void DevicePickerProviderInterceptorForTesting::AddObserver(::mojo::PendingRemote<DevicePickerObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void DevicePickerProviderInterceptorForTesting::HideMediaUI() {
  GetForwardingInterface()->HideMediaUI();
}
DevicePickerProviderAsyncWaiter::DevicePickerProviderAsyncWaiter(
    DevicePickerProvider* proxy) : proxy_(proxy) {}

DevicePickerProviderAsyncWaiter::~DevicePickerProviderAsyncWaiter() = default;





void DevicePickerObserverInterceptorForTesting::OnMediaUIOpened() {
  GetForwardingInterface()->OnMediaUIOpened();
}
void DevicePickerObserverInterceptorForTesting::OnMediaUIClosed() {
  GetForwardingInterface()->OnMediaUIClosed();
}
void DevicePickerObserverInterceptorForTesting::OnMediaUIUpdated() {
  GetForwardingInterface()->OnMediaUIUpdated();
}
void DevicePickerObserverInterceptorForTesting::OnPickerDismissed() {
  GetForwardingInterface()->OnPickerDismissed();
}
DevicePickerObserverAsyncWaiter::DevicePickerObserverAsyncWaiter(
    DevicePickerObserver* proxy) : proxy_(proxy) {}

DevicePickerObserverAsyncWaiter::~DevicePickerObserverAsyncWaiter() = default;







}  // global_media_controls::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif