// components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom-params-data.h"
#include "components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom-shared-message-ids.h"

#include "components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom-import-headers.h"
#include "components/fingerprinting_protection_filter/mojom/fingerprinting_protection_filter.mojom-test-utils.h"


namespace fingerprinting_protection_filter::mojom {
// The declaration includes the definition on other builds.

FingerprintingProtectionAgent::IPCStableHashFunction FingerprintingProtectionAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FingerprintingProtectionAgent>(message.name())) {
    case messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad: {
      return &FingerprintingProtectionAgent::ActivateForNextCommittedLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FingerprintingProtectionAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FingerprintingProtectionAgent>(message.name())) {
      case messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad:
            return "Receive fingerprinting_protection_filter::mojom::FingerprintingProtectionAgent::ActivateForNextCommittedLoad";
    }
  } else {
    switch (static_cast<messages::FingerprintingProtectionAgent>(message.name())) {
      case messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad:
            return "Receive reply fingerprinting_protection_filter::mojom::FingerprintingProtectionAgent::ActivateForNextCommittedLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FingerprintingProtectionAgent::ActivateForNextCommittedLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a468950;  // IPCStableHash for fingerprinting_protection_filter::mojom::FingerprintingProtectionAgent::ActivateForNextCommittedLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FingerprintingProtectionAgentProxy::FingerprintingProtectionAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FingerprintingProtectionAgentProxy::ActivateForNextCommittedLoad(
    ::subresource_filter::mojom::ActivationStatePtr in_activation_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send fingerprinting_protection_filter::mojom::FingerprintingProtectionAgent::ActivateForNextCommittedLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_state"), in_activation_state,
                        "<value of type ::subresource_filter::mojom::ActivationStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::fingerprinting_protection_filter::mojom::internal::FingerprintingProtectionAgent_ActivateForNextCommittedLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->activation_state)::BaseType> activation_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::subresource_filter::mojom::ActivationStateDataView>(
    in_activation_state,
    activation_state_fragment);

  params->activation_state.Set(
      activation_state_fragment.is_null() ? nullptr : activation_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->activation_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null activation_state in FingerprintingProtectionAgent.ActivateForNextCommittedLoad request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintingProtectionAgent::Name_);
  message.set_method_name("ActivateForNextCommittedLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FingerprintingProtectionAgentStubDispatch::Accept(
    FingerprintingProtectionAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FingerprintingProtectionAgent>(message->header()->name)) {
    case messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad: {
      DCHECK(message->is_serialized());
      internal::FingerprintingProtectionAgent_ActivateForNextCommittedLoad_Params_Data* params =
          reinterpret_cast<internal::FingerprintingProtectionAgent_ActivateForNextCommittedLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintingProtectionAgent.0
      bool success = true;
      ::subresource_filter::mojom::ActivationStatePtr p_activation_state{};
      FingerprintingProtectionAgent_ActivateForNextCommittedLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActivationState(&p_activation_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintingProtectionAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateForNextCommittedLoad(        
        std::move(p_activation_state));
      return true;
    }
  }
  return false;
}

// static
bool FingerprintingProtectionAgentStubDispatch::AcceptWithResponder(
    FingerprintingProtectionAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FingerprintingProtectionAgent>(message->header()->name)) {
    case messages::FingerprintingProtectionAgent::kActivateForNextCommittedLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFingerprintingProtectionAgentValidationInfo[] = {
    { &internal::FingerprintingProtectionAgent_ActivateForNextCommittedLoad_Params_Data::Validate,
     nullptr /* no response */},
};

bool FingerprintingProtectionAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::fingerprinting_protection_filter::mojom::FingerprintingProtectionAgent::Name_,
    kFingerprintingProtectionAgentValidationInfo);
}

// The declaration includes the definition on other builds.

FingerprintingProtectionHost::IPCStableHashFunction FingerprintingProtectionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FingerprintingProtectionHost>(message.name())) {
    case messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource: {
      return &FingerprintingProtectionHost::DidDisallowFirstSubresource_Sym::IPCStableHash;
    }
    case messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics: {
      return &FingerprintingProtectionHost::SetDocumentLoadStatistics_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FingerprintingProtectionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FingerprintingProtectionHost>(message.name())) {
      case messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource:
            return "Receive fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::DidDisallowFirstSubresource";
      case messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics:
            return "Receive fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::SetDocumentLoadStatistics";
    }
  } else {
    switch (static_cast<messages::FingerprintingProtectionHost>(message.name())) {
      case messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource:
            return "Receive reply fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::DidDisallowFirstSubresource";
      case messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics:
            return "Receive reply fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::SetDocumentLoadStatistics";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FingerprintingProtectionHost::DidDisallowFirstSubresource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48551ffc;  // IPCStableHash for fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::DidDisallowFirstSubresource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FingerprintingProtectionHost::SetDocumentLoadStatistics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf005f1a4;  // IPCStableHash for fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::SetDocumentLoadStatistics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FingerprintingProtectionHostProxy::FingerprintingProtectionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FingerprintingProtectionHostProxy::DidDisallowFirstSubresource(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::DidDisallowFirstSubresource");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::fingerprinting_protection_filter::mojom::internal::FingerprintingProtectionHost_DidDisallowFirstSubresource_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintingProtectionHost::Name_);
  message.set_method_name("DidDisallowFirstSubresource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintingProtectionHostProxy::SetDocumentLoadStatistics(
    ::subresource_filter::mojom::DocumentLoadStatisticsPtr in_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::SetDocumentLoadStatistics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("statistics"), in_statistics,
                        "<value of type ::subresource_filter::mojom::DocumentLoadStatisticsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::fingerprinting_protection_filter::mojom::internal::FingerprintingProtectionHost_SetDocumentLoadStatistics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->statistics)::BaseType> statistics_fragment(
          params.message());
  
  mojo::internal::Serialize<::subresource_filter::mojom::DocumentLoadStatisticsDataView>(
    in_statistics,
    statistics_fragment);

  params->statistics.Set(
      statistics_fragment.is_null() ? nullptr : statistics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->statistics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null statistics in FingerprintingProtectionHost.SetDocumentLoadStatistics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintingProtectionHost::Name_);
  message.set_method_name("SetDocumentLoadStatistics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FingerprintingProtectionHostStubDispatch::Accept(
    FingerprintingProtectionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FingerprintingProtectionHost>(message->header()->name)) {
    case messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource: {
      DCHECK(message->is_serialized());
      internal::FingerprintingProtectionHost_DidDisallowFirstSubresource_Params_Data* params =
          reinterpret_cast<internal::FingerprintingProtectionHost_DidDisallowFirstSubresource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintingProtectionHost.0
      bool success = true;
      FingerprintingProtectionHost_DidDisallowFirstSubresource_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintingProtectionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDisallowFirstSubresource(        );
      return true;
    }
    case messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics: {
      DCHECK(message->is_serialized());
      internal::FingerprintingProtectionHost_SetDocumentLoadStatistics_Params_Data* params =
          reinterpret_cast<internal::FingerprintingProtectionHost_SetDocumentLoadStatistics_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintingProtectionHost.1
      bool success = true;
      ::subresource_filter::mojom::DocumentLoadStatisticsPtr p_statistics{};
      FingerprintingProtectionHost_SetDocumentLoadStatistics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatistics(&p_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintingProtectionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDocumentLoadStatistics(        
        std::move(p_statistics));
      return true;
    }
  }
  return false;
}

// static
bool FingerprintingProtectionHostStubDispatch::AcceptWithResponder(
    FingerprintingProtectionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FingerprintingProtectionHost>(message->header()->name)) {
    case messages::FingerprintingProtectionHost::kDidDisallowFirstSubresource: {
      break;
    }
    case messages::FingerprintingProtectionHost::kSetDocumentLoadStatistics: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFingerprintingProtectionHostValidationInfo[] = {
    { &internal::FingerprintingProtectionHost_DidDisallowFirstSubresource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FingerprintingProtectionHost_SetDocumentLoadStatistics_Params_Data::Validate,
     nullptr /* no response */},
};

bool FingerprintingProtectionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::fingerprinting_protection_filter::mojom::FingerprintingProtectionHost::Name_,
    kFingerprintingProtectionHostValidationInfo);
}

// The declaration includes the definition on other builds.

FingerprintingProtectionRulesetObserver::IPCStableHashFunction FingerprintingProtectionRulesetObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FingerprintingProtectionRulesetObserver>(message.name())) {
    case messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess: {
      return &FingerprintingProtectionRulesetObserver::SetRulesetForProcess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FingerprintingProtectionRulesetObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FingerprintingProtectionRulesetObserver>(message.name())) {
      case messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess:
            return "Receive fingerprinting_protection_filter::mojom::FingerprintingProtectionRulesetObserver::SetRulesetForProcess";
    }
  } else {
    switch (static_cast<messages::FingerprintingProtectionRulesetObserver>(message.name())) {
      case messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess:
            return "Receive reply fingerprinting_protection_filter::mojom::FingerprintingProtectionRulesetObserver::SetRulesetForProcess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FingerprintingProtectionRulesetObserver::SetRulesetForProcess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c1521b4;  // IPCStableHash for fingerprinting_protection_filter::mojom::FingerprintingProtectionRulesetObserver::SetRulesetForProcess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FingerprintingProtectionRulesetObserverProxy::FingerprintingProtectionRulesetObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FingerprintingProtectionRulesetObserverProxy::SetRulesetForProcess(
    ::base::File in_ruleset_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send fingerprinting_protection_filter::mojom::FingerprintingProtectionRulesetObserver::SetRulesetForProcess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ruleset_file"), in_ruleset_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::fingerprinting_protection_filter::mojom::internal::FingerprintingProtectionRulesetObserver_SetRulesetForProcess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ruleset_file)::BaseType> ruleset_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_ruleset_file,
    ruleset_file_fragment);

  params->ruleset_file.Set(
      ruleset_file_fragment.is_null() ? nullptr : ruleset_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ruleset_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ruleset_file in FingerprintingProtectionRulesetObserver.SetRulesetForProcess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintingProtectionRulesetObserver::Name_);
  message.set_method_name("SetRulesetForProcess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FingerprintingProtectionRulesetObserverStubDispatch::Accept(
    FingerprintingProtectionRulesetObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FingerprintingProtectionRulesetObserver>(message->header()->name)) {
    case messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess: {
      DCHECK(message->is_serialized());
      internal::FingerprintingProtectionRulesetObserver_SetRulesetForProcess_Params_Data* params =
          reinterpret_cast<internal::FingerprintingProtectionRulesetObserver_SetRulesetForProcess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintingProtectionRulesetObserver.0
      bool success = true;
      ::base::File p_ruleset_file{};
      FingerprintingProtectionRulesetObserver_SetRulesetForProcess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRulesetFile(&p_ruleset_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintingProtectionRulesetObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRulesetForProcess(        
        std::move(p_ruleset_file));
      return true;
    }
  }
  return false;
}

// static
bool FingerprintingProtectionRulesetObserverStubDispatch::AcceptWithResponder(
    FingerprintingProtectionRulesetObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FingerprintingProtectionRulesetObserver>(message->header()->name)) {
    case messages::FingerprintingProtectionRulesetObserver::kSetRulesetForProcess: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFingerprintingProtectionRulesetObserverValidationInfo[] = {
    { &internal::FingerprintingProtectionRulesetObserver_SetRulesetForProcess_Params_Data::Validate,
     nullptr /* no response */},
};

bool FingerprintingProtectionRulesetObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::fingerprinting_protection_filter::mojom::FingerprintingProtectionRulesetObserver::Name_,
    kFingerprintingProtectionRulesetObserverValidationInfo);
}



}  // fingerprinting_protection_filter::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace fingerprinting_protection_filter::mojom {


void FingerprintingProtectionAgentInterceptorForTesting::ActivateForNextCommittedLoad(::subresource_filter::mojom::ActivationStatePtr activation_state) {
  GetForwardingInterface()->ActivateForNextCommittedLoad(
    std::move(activation_state)
    );
}
FingerprintingProtectionAgentAsyncWaiter::FingerprintingProtectionAgentAsyncWaiter(
    FingerprintingProtectionAgent* proxy) : proxy_(proxy) {}

FingerprintingProtectionAgentAsyncWaiter::~FingerprintingProtectionAgentAsyncWaiter() = default;





void FingerprintingProtectionHostInterceptorForTesting::DidDisallowFirstSubresource() {
  GetForwardingInterface()->DidDisallowFirstSubresource();
}
void FingerprintingProtectionHostInterceptorForTesting::SetDocumentLoadStatistics(::subresource_filter::mojom::DocumentLoadStatisticsPtr statistics) {
  GetForwardingInterface()->SetDocumentLoadStatistics(
    std::move(statistics)
    );
}
FingerprintingProtectionHostAsyncWaiter::FingerprintingProtectionHostAsyncWaiter(
    FingerprintingProtectionHost* proxy) : proxy_(proxy) {}

FingerprintingProtectionHostAsyncWaiter::~FingerprintingProtectionHostAsyncWaiter() = default;





void FingerprintingProtectionRulesetObserverInterceptorForTesting::SetRulesetForProcess(::base::File ruleset_file) {
  GetForwardingInterface()->SetRulesetForProcess(
    std::move(ruleset_file)
    );
}
FingerprintingProtectionRulesetObserverAsyncWaiter::FingerprintingProtectionRulesetObserverAsyncWaiter(
    FingerprintingProtectionRulesetObserver* proxy) : proxy_(proxy) {}

FingerprintingProtectionRulesetObserverAsyncWaiter::~FingerprintingProtectionRulesetObserverAsyncWaiter() = default;







}  // fingerprinting_protection_filter::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif