// components/feed/mojom/rss_link_reader.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_H_
#define COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/feed/mojom/rss_link_reader.mojom-features.h"  // IWYU pragma: export
#include "components/feed/mojom/rss_link_reader.mojom-shared.h"  // IWYU pragma: export
#include "components/feed/mojom/rss_link_reader.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace feed::mojom {

class RssLinkReaderProxy;

template <typename ImplRefTraits>
class RssLinkReaderStub;

class RssLinkReaderRequestValidator;
class RssLinkReaderResponseValidator;


class RssLinkReader
    : public RssLinkReaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "feed.mojom.RssLinkReader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RssLinkReaderInterfaceBase;
  using Proxy_ = RssLinkReaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = RssLinkReaderStub<ImplRefTraits>;

  using RequestValidator_ = RssLinkReaderRequestValidator;
  using ResponseValidator_ = RssLinkReaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetRssLinksMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetRssLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RssLinkReader() = default;

  using GetRssLinksCallback = base::OnceCallback<void(RssLinksPtr)>;
  using GetRssLinksMojoCallback = base::OnceCallback<void(RssLinksPtr)>;

  virtual void GetRssLinks(GetRssLinksCallback callback) = 0;
};



class  RssLinkReaderProxy
    : public RssLinkReader {
 public:
  using InterfaceType = RssLinkReader;

  explicit RssLinkReaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetRssLinks(GetRssLinksCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RssLinkReaderStubDispatch {
 public:
  static bool Accept(RssLinkReader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RssLinkReader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RssLinkReader>>
class RssLinkReaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RssLinkReaderStub() = default;
  ~RssLinkReaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RssLinkReaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RssLinkReaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RssLinkReaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RssLinkReaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  RssLinks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RssLinks, T>::value>;
  using DataView = RssLinksDataView;
  using Data_ = internal::RssLinks_Data;

  template <typename... Args>
  static RssLinksPtr New(Args&&... args) {
    return RssLinksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RssLinksPtr From(const U& u) {
    return mojo::TypeConverter<RssLinksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RssLinks>::Convert(*this);
  }


  RssLinks();

  RssLinks(
      const ::GURL& page_url,
      std::vector<::GURL> links);


  ~RssLinks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RssLinksPtr>
  RssLinksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RssLinks::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RssLinks::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RssLinks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RssLinks_UnserializedMessageContext<
            UserType, RssLinks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RssLinks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RssLinks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RssLinks_UnserializedMessageContext<
            UserType, RssLinks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RssLinks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL page_url;
  
  std::vector<::GURL> links;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RssLinks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RssLinksPtr RssLinks::Clone() const {
  return New(
      mojo::Clone(page_url),
      mojo::Clone(links)
  );
}

template <typename T, RssLinks::EnableIfSame<T>*>
bool RssLinks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_url, other_struct.page_url))
    return false;
  if (!mojo::Equals(this->links, other_struct.links))
    return false;
  return true;
}

template <typename T, RssLinks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.page_url < rhs.page_url)
    return true;
  if (rhs.page_url < lhs.page_url)
    return false;
  if (lhs.links < rhs.links)
    return true;
  if (rhs.links < lhs.links)
    return false;
  return false;
}


}  // feed::mojom

namespace mojo {


template <>
struct  StructTraits<::feed::mojom::RssLinks::DataView,
                                         ::feed::mojom::RssLinksPtr> {
  static bool IsNull(const ::feed::mojom::RssLinksPtr& input) { return !input; }
  static void SetToNull(::feed::mojom::RssLinksPtr* output) { output->reset(); }

  static const decltype(::feed::mojom::RssLinks::page_url)& page_url(
      const ::feed::mojom::RssLinksPtr& input) {
    return input->page_url;
  }

  static const decltype(::feed::mojom::RssLinks::links)& links(
      const ::feed::mojom::RssLinksPtr& input) {
    return input->links;
  }

  static bool Read(::feed::mojom::RssLinks::DataView input, ::feed::mojom::RssLinksPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_H_