// components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-params-data.h"
#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-shared-message-ids.h"

#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-import-headers.h"
#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-test-utils.h"


namespace dom_distiller::mojom {
// The declaration includes the definition on other builds.

DistillerJavaScriptService::IPCStableHashFunction DistillerJavaScriptService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DistillerJavaScriptService>(message.name())) {
    case messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall: {
      return &DistillerJavaScriptService::HandleDistillerOpenSettingsCall_Sym::IPCStableHash;
    }
    case messages::DistillerJavaScriptService::kHandleStoreThemePref: {
      return &DistillerJavaScriptService::HandleStoreThemePref_Sym::IPCStableHash;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref: {
      return &DistillerJavaScriptService::HandleStoreFontFamilyPref_Sym::IPCStableHash;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontScalingPref: {
      return &DistillerJavaScriptService::HandleStoreFontScalingPref_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DistillerJavaScriptService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DistillerJavaScriptService>(message.name())) {
      case messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall:
            return "Receive dom_distiller::mojom::DistillerJavaScriptService::HandleDistillerOpenSettingsCall";
      case messages::DistillerJavaScriptService::kHandleStoreThemePref:
            return "Receive dom_distiller::mojom::DistillerJavaScriptService::HandleStoreThemePref";
      case messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref:
            return "Receive dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontFamilyPref";
      case messages::DistillerJavaScriptService::kHandleStoreFontScalingPref:
            return "Receive dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontScalingPref";
    }
  } else {
    switch (static_cast<messages::DistillerJavaScriptService>(message.name())) {
      case messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall:
            return "Receive reply dom_distiller::mojom::DistillerJavaScriptService::HandleDistillerOpenSettingsCall";
      case messages::DistillerJavaScriptService::kHandleStoreThemePref:
            return "Receive reply dom_distiller::mojom::DistillerJavaScriptService::HandleStoreThemePref";
      case messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref:
            return "Receive reply dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontFamilyPref";
      case messages::DistillerJavaScriptService::kHandleStoreFontScalingPref:
            return "Receive reply dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontScalingPref";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DistillerJavaScriptService::HandleDistillerOpenSettingsCall_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x845834a0;  // IPCStableHash for dom_distiller::mojom::DistillerJavaScriptService::HandleDistillerOpenSettingsCall
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DistillerJavaScriptService::HandleStoreThemePref_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc778b412;  // IPCStableHash for dom_distiller::mojom::DistillerJavaScriptService::HandleStoreThemePref
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DistillerJavaScriptService::HandleStoreFontFamilyPref_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70800146;  // IPCStableHash for dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontFamilyPref
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DistillerJavaScriptService::HandleStoreFontScalingPref_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7181ef8;  // IPCStableHash for dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontScalingPref
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DistillerJavaScriptServiceProxy::DistillerJavaScriptServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DistillerJavaScriptServiceProxy::HandleDistillerOpenSettingsCall(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send dom_distiller::mojom::DistillerJavaScriptService::HandleDistillerOpenSettingsCall");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::dom_distiller::mojom::internal::DistillerJavaScriptService_HandleDistillerOpenSettingsCall_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DistillerJavaScriptService::Name_);
  message.set_method_name("HandleDistillerOpenSettingsCall");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DistillerJavaScriptServiceProxy::HandleStoreThemePref(
    ::dom_distiller::mojom::Theme in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send dom_distiller::mojom::DistillerJavaScriptService::HandleStoreThemePref", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type ::dom_distiller::mojom::Theme>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DistillerJavaScriptService::kHandleStoreThemePref), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::dom_distiller::mojom::internal::DistillerJavaScriptService_HandleStoreThemePref_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::dom_distiller::mojom::Theme>(
    in_theme,
    &params->theme);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DistillerJavaScriptService::Name_);
  message.set_method_name("HandleStoreThemePref");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DistillerJavaScriptServiceProxy::HandleStoreFontFamilyPref(
    ::dom_distiller::mojom::FontFamily in_font_family) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontFamilyPref", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_family"), in_font_family,
                        "<value of type ::dom_distiller::mojom::FontFamily>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::dom_distiller::mojom::internal::DistillerJavaScriptService_HandleStoreFontFamilyPref_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::dom_distiller::mojom::FontFamily>(
    in_font_family,
    &params->font_family);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DistillerJavaScriptService::Name_);
  message.set_method_name("HandleStoreFontFamilyPref");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DistillerJavaScriptServiceProxy::HandleStoreFontScalingPref(
    float in_font_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send dom_distiller::mojom::DistillerJavaScriptService::HandleStoreFontScalingPref", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_scale"), in_font_scale,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DistillerJavaScriptService::kHandleStoreFontScalingPref), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::dom_distiller::mojom::internal::DistillerJavaScriptService_HandleStoreFontScalingPref_Params_Data> params(
          message);
  params.Allocate();

  params->font_scale = in_font_scale;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DistillerJavaScriptService::Name_);
  message.set_method_name("HandleStoreFontScalingPref");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DistillerJavaScriptServiceStubDispatch::Accept(
    DistillerJavaScriptService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DistillerJavaScriptService>(message->header()->name)) {
    case messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall: {
      DCHECK(message->is_serialized());
      internal::DistillerJavaScriptService_HandleDistillerOpenSettingsCall_Params_Data* params =
          reinterpret_cast<internal::DistillerJavaScriptService_HandleDistillerOpenSettingsCall_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DistillerJavaScriptService.0
      bool success = true;
      DistillerJavaScriptService_HandleDistillerOpenSettingsCall_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DistillerJavaScriptService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleDistillerOpenSettingsCall(        );
      return true;
    }
    case messages::DistillerJavaScriptService::kHandleStoreThemePref: {
      DCHECK(message->is_serialized());
      internal::DistillerJavaScriptService_HandleStoreThemePref_Params_Data* params =
          reinterpret_cast<internal::DistillerJavaScriptService_HandleStoreThemePref_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DistillerJavaScriptService.1
      bool success = true;
      ::dom_distiller::mojom::Theme p_theme{};
      DistillerJavaScriptService_HandleStoreThemePref_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DistillerJavaScriptService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleStoreThemePref(        
        std::move(p_theme));
      return true;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref: {
      DCHECK(message->is_serialized());
      internal::DistillerJavaScriptService_HandleStoreFontFamilyPref_Params_Data* params =
          reinterpret_cast<internal::DistillerJavaScriptService_HandleStoreFontFamilyPref_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DistillerJavaScriptService.2
      bool success = true;
      ::dom_distiller::mojom::FontFamily p_font_family{};
      DistillerJavaScriptService_HandleStoreFontFamilyPref_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontFamily(&p_font_family))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DistillerJavaScriptService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleStoreFontFamilyPref(        
        std::move(p_font_family));
      return true;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontScalingPref: {
      DCHECK(message->is_serialized());
      internal::DistillerJavaScriptService_HandleStoreFontScalingPref_Params_Data* params =
          reinterpret_cast<internal::DistillerJavaScriptService_HandleStoreFontScalingPref_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DistillerJavaScriptService.3
      bool success = true;
      float p_font_scale{};
      DistillerJavaScriptService_HandleStoreFontScalingPref_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_font_scale = input_data_view.font_scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DistillerJavaScriptService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleStoreFontScalingPref(        
        std::move(p_font_scale));
      return true;
    }
  }
  return false;
}

// static
bool DistillerJavaScriptServiceStubDispatch::AcceptWithResponder(
    DistillerJavaScriptService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DistillerJavaScriptService>(message->header()->name)) {
    case messages::DistillerJavaScriptService::kHandleDistillerOpenSettingsCall: {
      break;
    }
    case messages::DistillerJavaScriptService::kHandleStoreThemePref: {
      break;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontFamilyPref: {
      break;
    }
    case messages::DistillerJavaScriptService::kHandleStoreFontScalingPref: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDistillerJavaScriptServiceValidationInfo[] = {
    { &internal::DistillerJavaScriptService_HandleDistillerOpenSettingsCall_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DistillerJavaScriptService_HandleStoreThemePref_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DistillerJavaScriptService_HandleStoreFontFamilyPref_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DistillerJavaScriptService_HandleStoreFontScalingPref_Params_Data::Validate,
     nullptr /* no response */},
};

bool DistillerJavaScriptServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::dom_distiller::mojom::DistillerJavaScriptService::Name_,
    kDistillerJavaScriptServiceValidationInfo);
}



}  // dom_distiller::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace dom_distiller::mojom {


void DistillerJavaScriptServiceInterceptorForTesting::HandleDistillerOpenSettingsCall() {
  GetForwardingInterface()->HandleDistillerOpenSettingsCall();
}
void DistillerJavaScriptServiceInterceptorForTesting::HandleStoreThemePref(::dom_distiller::mojom::Theme theme) {
  GetForwardingInterface()->HandleStoreThemePref(
    std::move(theme)
    );
}
void DistillerJavaScriptServiceInterceptorForTesting::HandleStoreFontFamilyPref(::dom_distiller::mojom::FontFamily font_family) {
  GetForwardingInterface()->HandleStoreFontFamilyPref(
    std::move(font_family)
    );
}
void DistillerJavaScriptServiceInterceptorForTesting::HandleStoreFontScalingPref(float font_scale) {
  GetForwardingInterface()->HandleStoreFontScalingPref(
    std::move(font_scale)
    );
}
DistillerJavaScriptServiceAsyncWaiter::DistillerJavaScriptServiceAsyncWaiter(
    DistillerJavaScriptService* proxy) : proxy_(proxy) {}

DistillerJavaScriptServiceAsyncWaiter::~DistillerJavaScriptServiceAsyncWaiter() = default;







}  // dom_distiller::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif