// components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DISCARDABLE_MEMORY_PUBLIC_MOJOM_DISCARDABLE_SHARED_MEMORY_MANAGER_MOJOM_H_
#define COMPONENTS_DISCARDABLE_MEMORY_PUBLIC_MOJOM_DISCARDABLE_SHARED_MEMORY_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-features.h"  // IWYU pragma: export
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"  // IWYU pragma: export
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace discardable_memory::mojom {

class DiscardableSharedMemoryManagerProxy;

template <typename ImplRefTraits>
class DiscardableSharedMemoryManagerStub;

class DiscardableSharedMemoryManagerRequestValidator;
class DiscardableSharedMemoryManagerResponseValidator;


class DiscardableSharedMemoryManager
    : public DiscardableSharedMemoryManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "discardable_memory.mojom.DiscardableSharedMemoryManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DiscardableSharedMemoryManagerInterfaceBase;
  using Proxy_ = DiscardableSharedMemoryManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DiscardableSharedMemoryManagerStub<ImplRefTraits>;

  using RequestValidator_ = DiscardableSharedMemoryManagerRequestValidator;
  using ResponseValidator_ = DiscardableSharedMemoryManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAllocateLockedDiscardableSharedMemoryMinVersion = 0,
    kDeletedDiscardableSharedMemoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AllocateLockedDiscardableSharedMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeletedDiscardableSharedMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DiscardableSharedMemoryManager() = default;

  using AllocateLockedDiscardableSharedMemoryCallback = base::OnceCallback<void(::base::UnsafeSharedMemoryRegion)>;
  using AllocateLockedDiscardableSharedMemoryMojoCallback = base::OnceCallback<void(::base::UnsafeSharedMemoryRegion)>;

  virtual void AllocateLockedDiscardableSharedMemory(uint32_t size, int32_t id, AllocateLockedDiscardableSharedMemoryCallback callback) = 0;

  virtual void DeletedDiscardableSharedMemory(int32_t id) = 0;
};



class  DiscardableSharedMemoryManagerProxy
    : public DiscardableSharedMemoryManager {
 public:
  using InterfaceType = DiscardableSharedMemoryManager;

  explicit DiscardableSharedMemoryManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AllocateLockedDiscardableSharedMemory(uint32_t size, int32_t id, AllocateLockedDiscardableSharedMemoryCallback callback) final;
  
  void DeletedDiscardableSharedMemory(int32_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DiscardableSharedMemoryManagerStubDispatch {
 public:
  static bool Accept(DiscardableSharedMemoryManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DiscardableSharedMemoryManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DiscardableSharedMemoryManager>>
class DiscardableSharedMemoryManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DiscardableSharedMemoryManagerStub() = default;
  ~DiscardableSharedMemoryManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DiscardableSharedMemoryManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DiscardableSharedMemoryManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DiscardableSharedMemoryManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DiscardableSharedMemoryManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // discardable_memory::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_DISCARDABLE_MEMORY_PUBLIC_MOJOM_DISCARDABLE_SHARED_MEMORY_MANAGER_MOJOM_H_