// components/device_signals/core/common/mojom/system_signals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/device_signals/core/common/mojom/system_signals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-params-data.h"
#include "components/device_signals/core/common/mojom/system_signals.mojom-shared-message-ids.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-import-headers.h"
#include "components/device_signals/core/common/mojom/system_signals.mojom-test-utils.h"


namespace device_signals::mojom {
ExecutableMetadata::ExecutableMetadata()
    : is_running(),
      public_keys_hashes(),
      product_name(),
      version(),
      is_os_verified(),
      subject_name() {}

ExecutableMetadata::ExecutableMetadata(
    bool is_running_in,
    std::optional<std::vector<std::string>> public_keys_hashes_in,
    const std::optional<std::string>& product_name_in,
    const std::optional<std::string>& version_in,
    bool is_os_verified_in,
    const std::optional<std::string>& subject_name_in)
    : is_running(std::move(is_running_in)),
      public_keys_hashes(std::move(public_keys_hashes_in)),
      product_name(std::move(product_name_in)),
      version(std::move(version_in)),
      is_os_verified(std::move(is_os_verified_in)),
      subject_name(std::move(subject_name_in)) {}

ExecutableMetadata::~ExecutableMetadata() = default;

void ExecutableMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_running"), this->is_running,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_keys_hashes"), this->public_keys_hashes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_name"), this->product_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_os_verified"), this->is_os_verified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject_name"), this->subject_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExecutableMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemItem::FileSystemItem()
    : file_path(),
      presence(),
      sha256_hash(),
      executable_metadata() {}

FileSystemItem::FileSystemItem(
    const ::base::FilePath& file_path_in,
    ::device_signals::PresenceValue presence_in,
    const std::optional<std::string>& sha256_hash_in,
    const std::optional<::device_signals::ExecutableMetadata>& executable_metadata_in)
    : file_path(std::move(file_path_in)),
      presence(std::move(presence_in)),
      sha256_hash(std::move(sha256_hash_in)),
      executable_metadata(std::move(executable_metadata_in)) {}

FileSystemItem::~FileSystemItem() = default;

void FileSystemItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presence"), this->presence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device_signals::PresenceValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha256_hash"), this->sha256_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "executable_metadata"), this->executable_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device_signals::ExecutableMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemItemRequest::FileSystemItemRequest()
    : file_path(),
      compute_sha256(),
      compute_executable_metadata() {}

FileSystemItemRequest::FileSystemItemRequest(
    const ::base::FilePath& file_path_in,
    bool compute_sha256_in,
    bool compute_executable_metadata_in)
    : file_path(std::move(file_path_in)),
      compute_sha256(std::move(compute_sha256_in)),
      compute_executable_metadata(std::move(compute_executable_metadata_in)) {}

FileSystemItemRequest::~FileSystemItemRequest() = default;

void FileSystemItemRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compute_sha256"), this->compute_sha256,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compute_executable_metadata"), this->compute_executable_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemItemRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SystemSignalsService::IPCStableHashFunction SystemSignalsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemSignalsService>(message.name())) {
    case messages::SystemSignalsService::kGetFileSystemSignals: {
      return &SystemSignalsService::GetFileSystemSignals_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemSignalsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemSignalsService>(message.name())) {
      case messages::SystemSignalsService::kGetFileSystemSignals:
            return "Receive device_signals::mojom::SystemSignalsService::GetFileSystemSignals";
    }
  } else {
    switch (static_cast<messages::SystemSignalsService>(message.name())) {
      case messages::SystemSignalsService::kGetFileSystemSignals:
            return "Receive reply device_signals::mojom::SystemSignalsService::GetFileSystemSignals";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemSignalsService::GetFileSystemSignals_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3f8f946;  // IPCStableHash for device_signals::mojom::SystemSignalsService::GetFileSystemSignals
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SystemSignalsService_GetFileSystemSignals_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemSignalsService_GetFileSystemSignals_ForwardToCallback(
      SystemSignalsService::GetFileSystemSignalsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemSignalsService_GetFileSystemSignals_ForwardToCallback(const SystemSignalsService_GetFileSystemSignals_ForwardToCallback&) = delete;
  SystemSignalsService_GetFileSystemSignals_ForwardToCallback& operator=(const SystemSignalsService_GetFileSystemSignals_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemSignalsService::GetFileSystemSignalsCallback callback_;
};

SystemSignalsServiceProxy::SystemSignalsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemSignalsServiceProxy::GetFileSystemSignals(
    const std::vector<::device_signals::GetFileSystemInfoOptions>& in_requests, GetFileSystemSignalsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_signals::mojom::SystemSignalsService::GetFileSystemSignals", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests,
                        "<value of type const std::vector<::device_signals::GetFileSystemInfoOptions>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemSignalsService::kGetFileSystemSignals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_signals::mojom::internal::SystemSignalsService_GetFileSystemSignals_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device_signals::mojom::FileSystemItemRequestDataView>>(
    in_requests,
    requests_fragment,
    &requests_validate_params);

  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requests.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requests in SystemSignalsService.GetFileSystemSignals request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemSignalsService::Name_);
  message.set_method_name("GetFileSystemSignals");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemSignalsService_GetFileSystemSignals_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SystemSignalsService_GetFileSystemSignals_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemSignalsService::GetFileSystemSignalsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemSignalsService_GetFileSystemSignals_ProxyToResponder> proxy(
        new SystemSignalsService_GetFileSystemSignals_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemSignalsService_GetFileSystemSignals_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemSignalsService_GetFileSystemSignals_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemSignalsService_GetFileSystemSignals_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemSignalsService::GetFileSystemSignalsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::device_signals::FileSystemItem>& in_items);
};

bool SystemSignalsService_GetFileSystemSignals_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemSignalsService_GetFileSystemSignals_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemSignalsService_GetFileSystemSignals_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemSignalsService.0
  bool success = true;
  std::vector<::device_signals::FileSystemItem> p_items{};
  SystemSignalsService_GetFileSystemSignals_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadItems(&p_items))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemSignalsService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_items));
  }
  return true;
}

void SystemSignalsService_GetFileSystemSignals_ProxyToResponder::Run(
    const std::vector<::device_signals::FileSystemItem>& in_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_signals::mojom::SystemSignalsService::GetFileSystemSignals", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type const std::vector<::device_signals::FileSystemItem>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemSignalsService::kGetFileSystemSignals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_signals::mojom::internal::SystemSignalsService_GetFileSystemSignals_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->items)::BaseType>
      items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device_signals::mojom::FileSystemItemDataView>>(
    in_items,
    items_fragment,
    &items_validate_params);

  params->items.Set(
      items_fragment.is_null() ? nullptr : items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null items in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemSignalsService::Name_);
  message.set_method_name("GetFileSystemSignals");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SystemSignalsServiceStubDispatch::Accept(
    SystemSignalsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemSignalsService>(message->header()->name)) {
    case messages::SystemSignalsService::kGetFileSystemSignals: {
      break;
    }
  }
  return false;
}

// static
bool SystemSignalsServiceStubDispatch::AcceptWithResponder(
    SystemSignalsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemSignalsService>(message->header()->name)) {
    case messages::SystemSignalsService::kGetFileSystemSignals: {
      internal::SystemSignalsService_GetFileSystemSignals_Params_Data* params =
          reinterpret_cast<
              internal::SystemSignalsService_GetFileSystemSignals_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemSignalsService.0
      bool success = true;
      std::vector<::device_signals::GetFileSystemInfoOptions> p_requests{};
      SystemSignalsService_GetFileSystemSignals_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequests(&p_requests))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemSignalsService::Name_, 0, false);
        return false;
      }
      auto callback =
          SystemSignalsService_GetFileSystemSignals_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileSystemSignals(        
        std::move(p_requests), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSystemSignalsServiceValidationInfo[] = {
    { &internal::SystemSignalsService_GetFileSystemSignals_Params_Data::Validate,
     &internal::SystemSignalsService_GetFileSystemSignals_ResponseParams_Data::Validate},
};

bool SystemSignalsServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device_signals::mojom::SystemSignalsService::Name_,
    kSystemSignalsServiceValidationInfo);
}

bool SystemSignalsServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device_signals::mojom::SystemSignalsService::Name_,
    kSystemSignalsServiceValidationInfo);
}


}  // device_signals::mojom


namespace mojo {


// static
bool StructTraits<::device_signals::mojom::ExecutableMetadata::DataView, ::device_signals::mojom::ExecutableMetadataPtr>::Read(
    ::device_signals::mojom::ExecutableMetadata::DataView input,
    ::device_signals::mojom::ExecutableMetadataPtr* output) {
  bool success = true;
  ::device_signals::mojom::ExecutableMetadataPtr result(::device_signals::mojom::ExecutableMetadata::New());
  
      if (success)
        result->is_running = input.is_running();
      if (success && !input.ReadPublicKeysHashes(&result->public_keys_hashes))
        success = false;
      if (success && !input.ReadProductName(&result->product_name))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success)
        result->is_os_verified = input.is_os_verified();
      if (success && !input.ReadSubjectName(&result->subject_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_signals::mojom::FileSystemItem::DataView, ::device_signals::mojom::FileSystemItemPtr>::Read(
    ::device_signals::mojom::FileSystemItem::DataView input,
    ::device_signals::mojom::FileSystemItemPtr* output) {
  bool success = true;
  ::device_signals::mojom::FileSystemItemPtr result(::device_signals::mojom::FileSystemItem::New());
  
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
      if (success && !input.ReadPresence(&result->presence))
        success = false;
      if (success && !input.ReadSha256Hash(&result->sha256_hash))
        success = false;
      if (success && !input.ReadExecutableMetadata(&result->executable_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_signals::mojom::FileSystemItemRequest::DataView, ::device_signals::mojom::FileSystemItemRequestPtr>::Read(
    ::device_signals::mojom::FileSystemItemRequest::DataView input,
    ::device_signals::mojom::FileSystemItemRequestPtr* output) {
  bool success = true;
  ::device_signals::mojom::FileSystemItemRequestPtr result(::device_signals::mojom::FileSystemItemRequest::New());
  
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
      if (success)
        result->compute_sha256 = input.compute_sha256();
      if (success)
        result->compute_executable_metadata = input.compute_executable_metadata();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device_signals::mojom {


void SystemSignalsServiceInterceptorForTesting::GetFileSystemSignals(const std::vector<::device_signals::GetFileSystemInfoOptions>& requests, GetFileSystemSignalsCallback callback) {
  GetForwardingInterface()->GetFileSystemSignals(
    std::move(requests)
    , std::move(callback));
}
SystemSignalsServiceAsyncWaiter::SystemSignalsServiceAsyncWaiter(
    SystemSignalsService* proxy) : proxy_(proxy) {}

SystemSignalsServiceAsyncWaiter::~SystemSignalsServiceAsyncWaiter() = default;


void SystemSignalsServiceAsyncWaiter::GetFileSystemSignals(
    const std::vector<::device_signals::GetFileSystemInfoOptions>& requests, std::vector<::device_signals::FileSystemItem>* out_items) {
  base::RunLoop loop;
  proxy_->GetFileSystemSignals(
      std::move(requests),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::device_signals::FileSystemItem>* out_items
,
             const std::vector<::device_signals::FileSystemItem>& items) {*out_items = std::move(items);
            loop->Quit();
          },
          &loop,
          out_items));
  loop.Run();
}

std::vector<::device_signals::FileSystemItem> SystemSignalsServiceAsyncWaiter::GetFileSystemSignals(
    const std::vector<::device_signals::GetFileSystemInfoOptions>& requests) {
  std::vector<::device_signals::FileSystemItem> async_wait_result;
  GetFileSystemSignals(std::move(requests),&async_wait_result);
  return async_wait_result;
}






}  // device_signals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif