// components/content_settings/core/common/content_settings.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  ProviderType as contentSettings_mojom_ProviderType,
  ProviderTypeSpec as contentSettings_mojom_ProviderTypeSpec,
  SessionModel as contentSettings_mojom_SessionModel,
  SessionModelSpec as contentSettings_mojom_SessionModelSpec,
  TpcdMetadataCohort as contentSettings_mojom_TpcdMetadataCohort,
  TpcdMetadataCohortSpec as contentSettings_mojom_TpcdMetadataCohortSpec,
  TpcdMetadataRuleSource as contentSettings_mojom_TpcdMetadataRuleSource,
  TpcdMetadataRuleSourceSpec as contentSettings_mojom_TpcdMetadataRuleSourceSpec
} from './content_settings_enums.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentSettingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentSetting = {
  
  DEFAULT: 0,
  ALLOW: 1,
  BLOCK: 2,
  ASK: 3,
  SESSION_ONLY: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PatternPartsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSettingsPatternSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RuleMetaDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSettingPatternSourceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererContentSettingRulesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PatternPartsSpec.$,
    'PatternParts',
    [
      mojo.internal.StructField(
        'scheme', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSchemeWildcard', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDomainWildcard', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPortWildcard', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPathWildcard', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class PatternParts {
  constructor() {
    /** @type { !string } */
    this.scheme;
    /** @type { !boolean } */
    this.isSchemeWildcard;
    /** @type { !string } */
    this.host;
    /** @type { !boolean } */
    this.hasDomainWildcard;
    /** @type { !string } */
    this.port;
    /** @type { !boolean } */
    this.isPortWildcard;
    /** @type { !string } */
    this.path;
    /** @type { !boolean } */
    this.isPathWildcard;
  }
}



mojo.internal.Struct(
    ContentSettingsPatternSpec.$,
    'ContentSettingsPattern',
    [
      mojo.internal.StructField(
        'parts', 0,
        0,
        PatternPartsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isValid', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentSettingsPattern {
  constructor() {
    /** @type { !PatternParts } */
    this.parts;
    /** @type { !boolean } */
    this.isValid;
  }
}



mojo.internal.Struct(
    RuleMetaDataSpec.$,
    'RuleMetaData',
    [
      mojo.internal.StructField(
        'lastModified', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastUsed', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastVisited', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiration', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionModel', 32,
        0,
        contentSettings_mojom_SessionModelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lifetime', 40,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tpcdMetadataRuleSource', 36,
        0,
        contentSettings_mojom_TpcdMetadataRuleSourceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tpcdMetadataCohort', 48,
        0,
        contentSettings_mojom_TpcdMetadataCohortSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decidedByRelatedWebsiteSets', 52,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ruleOptions', 56,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class RuleMetaData {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.lastModified;
    /** @type { !mojoBase_mojom_Time } */
    this.lastUsed;
    /** @type { !mojoBase_mojom_Time } */
    this.lastVisited;
    /** @type { !mojoBase_mojom_Time } */
    this.expiration;
    /** @type { !contentSettings_mojom_SessionModel } */
    this.sessionModel;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.lifetime;
    /** @type { !contentSettings_mojom_TpcdMetadataRuleSource } */
    this.tpcdMetadataRuleSource;
    /** @type { !contentSettings_mojom_TpcdMetadataCohort } */
    this.tpcdMetadataCohort;
    /** @type { !boolean } */
    this.decidedByRelatedWebsiteSets;
    /** @type { !mojoBase_mojom_Value } */
    this.ruleOptions;
  }
}



mojo.internal.Struct(
    ContentSettingPatternSourceSpec.$,
    'ContentSettingPatternSource',
    [
      mojo.internal.StructField(
        'primaryPattern', 0,
        0,
        ContentSettingsPatternSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secondaryPattern', 8,
        0,
        ContentSettingsPatternSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settingValue', 16,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 32,
        0,
        RuleMetaDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 40,
        0,
        contentSettings_mojom_ProviderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'incognito', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ContentSettingPatternSource {
  constructor() {
    /** @type { !ContentSettingsPattern } */
    this.primaryPattern;
    /** @type { !ContentSettingsPattern } */
    this.secondaryPattern;
    /** @type { !mojoBase_mojom_Value } */
    this.settingValue;
    /** @type { !RuleMetaData } */
    this.metadata;
    /** @type { !contentSettings_mojom_ProviderType } */
    this.source;
    /** @type { !boolean } */
    this.incognito;
  }
}



mojo.internal.Struct(
    RendererContentSettingRulesSpec.$,
    'RendererContentSettingRules',
    [
      mojo.internal.StructField(
        'mixedContentRules', 0,
        0,
        mojo.internal.Array(ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererContentSettingRules {
  constructor() {
    /** @type { !Array<!ContentSettingPatternSource> } */
    this.mixedContentRules;
  }
}

