// components/commerce/core/mojom/shopping_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "components/commerce/core/mojom/shopping_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "components/commerce/core/mojom/shared.mojom-shared.h"

#include "components/commerce/core/mojom/shopping_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::shopping_service::mojom::UserFeedback, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::PricePointDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::PricePointDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::PricePoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::date(input)) in_date = Traits::date(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->date)::BaseType> date_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_date,
        date_fragment);

      fragment->date.Set(
          date_fragment.is_null() ? nullptr : date_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->date.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null date in PricePoint struct");

      fragment->price = Traits::price(input);

      decltype(Traits::formatted_price(input)) in_formatted_price = Traits::formatted_price(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->formatted_price)::BaseType> formatted_price_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_formatted_price,
        formatted_price_fragment);

      fragment->formatted_price.Set(
          formatted_price_fragment.is_null() ? nullptr : formatted_price_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->formatted_price.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null formatted_price in PricePoint struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::UrlInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::UrlInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::UrlInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in UrlInfo struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in UrlInfo struct");

      decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_favicon_url,
        favicon_url_fragment);

      fragment->favicon_url.Set(
          favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->favicon_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null favicon_url in UrlInfo struct");

      decltype(Traits::thumbnail_url(input)) in_thumbnail_url = Traits::thumbnail_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->thumbnail_url)::BaseType> thumbnail_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_thumbnail_url,
        thumbnail_url_fragment);

      fragment->thumbnail_url.Set(
          thumbnail_url_fragment.is_null() ? nullptr : thumbnail_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->thumbnail_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null thumbnail_url in UrlInfo struct");

      decltype(Traits::previewText(input)) in_previewText = Traits::previewText(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->previewText)::BaseType> previewText_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_previewText,
        previewText_fragment);

      fragment->previewText.Set(
          previewText_fragment.is_null() ? nullptr : previewText_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->previewText.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null previewText in UrlInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::PriceInsightsInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::PriceInsightsInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::PriceInsightsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->cluster_id = Traits::cluster_id(input);

      decltype(Traits::typical_low_price(input)) in_typical_low_price = Traits::typical_low_price(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->typical_low_price)::BaseType> typical_low_price_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_typical_low_price,
        typical_low_price_fragment);

      fragment->typical_low_price.Set(
          typical_low_price_fragment.is_null() ? nullptr : typical_low_price_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->typical_low_price.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null typical_low_price in PriceInsightsInfo struct");

      decltype(Traits::typical_high_price(input)) in_typical_high_price = Traits::typical_high_price(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->typical_high_price)::BaseType> typical_high_price_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_typical_high_price,
        typical_high_price_fragment);

      fragment->typical_high_price.Set(
          typical_high_price_fragment.is_null() ? nullptr : typical_high_price_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->typical_high_price.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null typical_high_price in PriceInsightsInfo struct");

      decltype(Traits::catalog_attributes(input)) in_catalog_attributes = Traits::catalog_attributes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->catalog_attributes)::BaseType> catalog_attributes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_catalog_attributes,
        catalog_attributes_fragment);

      fragment->catalog_attributes.Set(
          catalog_attributes_fragment.is_null() ? nullptr : catalog_attributes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->catalog_attributes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null catalog_attributes in PriceInsightsInfo struct");

      decltype(Traits::jackpot(input)) in_jackpot = Traits::jackpot(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->jackpot)::BaseType> jackpot_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_jackpot,
        jackpot_fragment);

      fragment->jackpot.Set(
          jackpot_fragment.is_null() ? nullptr : jackpot_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->jackpot.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null jackpot in PriceInsightsInfo struct");

      
      mojo::internal::Serialize<::shopping_service::mojom::PriceInsightsInfo_PriceBucket>(
        Traits::bucket(input),
        &fragment->bucket);

      fragment->has_multiple_catalogs = Traits::has_multiple_catalogs(input);

      decltype(Traits::history(input)) in_history = Traits::history(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->history)::BaseType>
          history_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& history_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::PricePointDataView>, send_validation>(
        in_history,
        history_fragment,
        &history_validate_params);

      fragment->history.Set(
          history_fragment.is_null() ? nullptr : history_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->history.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null history in PriceInsightsInfo struct");

      decltype(Traits::locale(input)) in_locale = Traits::locale(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->locale)::BaseType> locale_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_locale,
        locale_fragment);

      fragment->locale.Set(
          locale_fragment.is_null() ? nullptr : locale_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->locale.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null locale in PriceInsightsInfo struct");

      decltype(Traits::currency_code(input)) in_currency_code = Traits::currency_code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->currency_code)::BaseType> currency_code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_currency_code,
        currency_code_fragment);

      fragment->currency_code.Set(
          currency_code_fragment.is_null() ? nullptr : currency_code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->currency_code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null currency_code in PriceInsightsInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsDescriptionText_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in ProductSpecificationsDescriptionText struct");

      decltype(Traits::urls(input)) in_urls = Traits::urls(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->urls)::BaseType>
          urls_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>, send_validation>(
        in_urls,
        urls_fragment,
        &urls_validate_params);

      fragment->urls.Set(
          urls_fragment.is_null() ? nullptr : urls_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->urls.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urls in ProductSpecificationsDescriptionText struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsOptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsOptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::descriptions(input)) in_descriptions = Traits::descriptions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->descriptions)::BaseType>
          descriptions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& descriptions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>, send_validation>(
        in_descriptions,
        descriptions_fragment,
        &descriptions_validate_params);

      fragment->descriptions.Set(
          descriptions_fragment.is_null() ? nullptr : descriptions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->descriptions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null descriptions in ProductSpecificationsOption struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsDescriptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDescriptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::options(input)) in_options = Traits::options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->options)::BaseType>
          options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsOptionDataView>, send_validation>(
        in_options,
        options_fragment,
        &options_validate_params);

      fragment->options.Set(
          options_fragment.is_null() ? nullptr : options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in ProductSpecificationsDescription struct");

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in ProductSpecificationsDescription struct");

      decltype(Traits::alt_text(input)) in_alt_text = Traits::alt_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alt_text)::BaseType> alt_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_alt_text,
        alt_text_fragment);

      fragment->alt_text.Set(
          alt_text_fragment.is_null() ? nullptr : alt_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alt_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alt_text in ProductSpecificationsDescription struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::specification_descriptions(input)) in_specification_descriptions = Traits::specification_descriptions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->specification_descriptions)::BaseType>
          specification_descriptions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& specification_descriptions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionDataView>, send_validation>(
        in_specification_descriptions,
        specification_descriptions_fragment,
        &specification_descriptions_validate_params);

      fragment->specification_descriptions.Set(
          specification_descriptions_fragment.is_null() ? nullptr : specification_descriptions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->specification_descriptions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null specification_descriptions in ProductSpecificationsValue struct");

      decltype(Traits::summary(input)) in_summary = Traits::summary(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->summary)::BaseType>
          summary_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>, send_validation>(
        in_summary,
        summary_fragment,
        &summary_validate_params);

      fragment->summary.Set(
          summary_fragment.is_null() ? nullptr : summary_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->summary.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null summary in ProductSpecificationsValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsProductDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsProductDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsProduct_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->product_cluster_id = Traits::product_cluster_id(input);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ProductSpecificationsProduct struct");

      decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_url)::BaseType> image_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_image_url,
        image_url_fragment);

      fragment->image_url.Set(
          image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_url in ProductSpecificationsProduct struct");

      decltype(Traits::product_dimension_values(input)) in_product_dimension_values = Traits::product_dimension_values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->product_dimension_values)::BaseType>
          product_dimension_values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& product_dimension_values_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, ::shopping_service::mojom::ProductSpecificationsValueDataView>, send_validation>(
        in_product_dimension_values,
        product_dimension_values_fragment,
        &product_dimension_values_validate_params);

      fragment->product_dimension_values.Set(
          product_dimension_values_fragment.is_null() ? nullptr : product_dimension_values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->product_dimension_values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null product_dimension_values in ProductSpecificationsProduct struct");

      decltype(Traits::summary(input)) in_summary = Traits::summary(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->summary)::BaseType>
          summary_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& summary_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsDescriptionTextDataView>, send_validation>(
        in_summary,
        summary_fragment,
        &summary_validate_params);

      fragment->summary.Set(
          summary_fragment.is_null() ? nullptr : summary_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->summary.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null summary in ProductSpecificationsProduct struct");

      decltype(Traits::buying_options_url(input)) in_buying_options_url = Traits::buying_options_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buying_options_url)::BaseType> buying_options_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_buying_options_url,
        buying_options_url_fragment);

      fragment->buying_options_url.Set(
          buying_options_url_fragment.is_null() ? nullptr : buying_options_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buying_options_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buying_options_url in ProductSpecificationsProduct struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsFeatureStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecificationsFeatureState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_syncing_tab_compare = Traits::is_syncing_tab_compare(input);

      fragment->can_load_full_page_ui = Traits::can_load_full_page_ui(input);

      fragment->can_manage_sets = Traits::can_manage_sets(input);

      fragment->can_fetch_data = Traits::can_fetch_data(input);

      fragment->is_allowed_for_enterprise = Traits::is_allowed_for_enterprise(input);

      fragment->is_quality_logging_allowed = Traits::is_quality_logging_allowed(input);

      fragment->is_signed_in = Traits::is_signed_in(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shopping_service::mojom::ProductSpecificationsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shopping_service::mojom::ProductSpecificationsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shopping_service::mojom::internal::ProductSpecifications_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::product_dimension_map(input)) in_product_dimension_map = Traits::product_dimension_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->product_dimension_map)::BaseType>
          product_dimension_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& product_dimension_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::StringDataView>, send_validation>(
        in_product_dimension_map,
        product_dimension_map_fragment,
        &product_dimension_map_validate_params);

      fragment->product_dimension_map.Set(
          product_dimension_map_fragment.is_null() ? nullptr : product_dimension_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->product_dimension_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null product_dimension_map in ProductSpecifications struct");

      decltype(Traits::products(input)) in_products = Traits::products(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->products)::BaseType>
          products_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& products_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::ProductSpecificationsProductDataView>, send_validation>(
        in_products,
        products_fragment,
        &products_validate_params);

      fragment->products.Set(
          products_fragment.is_null() ? nullptr : products_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->products.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null products in ProductSpecifications struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHOPPING_SERVICE_MOJOM_SEND_VALIDATION_H_