// components/commerce/core/mojom/shared.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/shared.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/shared.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/shared.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace commerce::shared::mojom {










class  ProductInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductInfo, T>::value>;
  using DataView = ProductInfoDataView;
  using Data_ = internal::ProductInfo_Data;

  template <typename... Args>
  static ProductInfoPtr New(Args&&... args) {
    return ProductInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductInfoPtr From(const U& u) {
    return mojo::TypeConverter<ProductInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductInfo>::Convert(*this);
  }


  ProductInfo();

  ProductInfo(
      const std::string& title,
      const std::string& cluster_title,
      const std::string& domain,
      const ::GURL& image_url,
      const ::GURL& product_url,
      const std::string& current_price,
      const std::string& previous_price,
      uint64_t cluster_id,
      std::vector<std::string> category_labels,
      const std::string& price_summary);


  ~ProductInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductInfoPtr>
  ProductInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductInfo_UnserializedMessageContext<
            UserType, ProductInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductInfo_UnserializedMessageContext<
            UserType, ProductInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  std::string cluster_title;
  
  std::string domain;
  
  ::GURL image_url;
  
  ::GURL product_url;
  
  std::string current_price;
  
  std::string previous_price;
  
  uint64_t cluster_id;
  
  std::vector<std::string> category_labels;
  
  std::string price_summary;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BookmarkProductInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BookmarkProductInfo, T>::value>;
  using DataView = BookmarkProductInfoDataView;
  using Data_ = internal::BookmarkProductInfo_Data;

  template <typename... Args>
  static BookmarkProductInfoPtr New(Args&&... args) {
    return BookmarkProductInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BookmarkProductInfoPtr From(const U& u) {
    return mojo::TypeConverter<BookmarkProductInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BookmarkProductInfo>::Convert(*this);
  }


  BookmarkProductInfo();

  BookmarkProductInfo(
      int64_t bookmark_id,
      ProductInfoPtr info);

BookmarkProductInfo(const BookmarkProductInfo&) = delete;
BookmarkProductInfo& operator=(const BookmarkProductInfo&) = delete;

  ~BookmarkProductInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BookmarkProductInfoPtr>
  BookmarkProductInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarkProductInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarkProductInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BookmarkProductInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BookmarkProductInfo_UnserializedMessageContext<
            UserType, BookmarkProductInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BookmarkProductInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BookmarkProductInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BookmarkProductInfo_UnserializedMessageContext<
            UserType, BookmarkProductInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BookmarkProductInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t bookmark_id;
  
  ProductInfoPtr info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BookmarkProductInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsSet, T>::value>;
  using DataView = ProductSpecificationsSetDataView;
  using Data_ = internal::ProductSpecificationsSet_Data;

  template <typename... Args>
  static ProductSpecificationsSetPtr New(Args&&... args) {
    return ProductSpecificationsSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsSetPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsSet>::Convert(*this);
  }


  ProductSpecificationsSet();

  ProductSpecificationsSet(
      const std::string& name,
      const ::base::Uuid& uuid,
      std::vector<::GURL> urls);


  ~ProductSpecificationsSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsSetPtr>
  ProductSpecificationsSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsSet_UnserializedMessageContext<
            UserType, ProductSpecificationsSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsSet_UnserializedMessageContext<
            UserType, ProductSpecificationsSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::base::Uuid uuid;
  
  std::vector<::GURL> urls;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProductInfoPtr ProductInfo::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(cluster_title),
      mojo::Clone(domain),
      mojo::Clone(image_url),
      mojo::Clone(product_url),
      mojo::Clone(current_price),
      mojo::Clone(previous_price),
      mojo::Clone(cluster_id),
      mojo::Clone(category_labels),
      mojo::Clone(price_summary)
  );
}

template <typename T, ProductInfo::EnableIfSame<T>*>
bool ProductInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->cluster_title, other_struct.cluster_title))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->product_url, other_struct.product_url))
    return false;
  if (!mojo::Equals(this->current_price, other_struct.current_price))
    return false;
  if (!mojo::Equals(this->previous_price, other_struct.previous_price))
    return false;
  if (!mojo::Equals(this->cluster_id, other_struct.cluster_id))
    return false;
  if (!mojo::Equals(this->category_labels, other_struct.category_labels))
    return false;
  if (!mojo::Equals(this->price_summary, other_struct.price_summary))
    return false;
  return true;
}

template <typename T, ProductInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.cluster_title < rhs.cluster_title)
    return true;
  if (rhs.cluster_title < lhs.cluster_title)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.product_url < rhs.product_url)
    return true;
  if (rhs.product_url < lhs.product_url)
    return false;
  if (lhs.current_price < rhs.current_price)
    return true;
  if (rhs.current_price < lhs.current_price)
    return false;
  if (lhs.previous_price < rhs.previous_price)
    return true;
  if (rhs.previous_price < lhs.previous_price)
    return false;
  if (lhs.cluster_id < rhs.cluster_id)
    return true;
  if (rhs.cluster_id < lhs.cluster_id)
    return false;
  if (lhs.category_labels < rhs.category_labels)
    return true;
  if (rhs.category_labels < lhs.category_labels)
    return false;
  if (lhs.price_summary < rhs.price_summary)
    return true;
  if (rhs.price_summary < lhs.price_summary)
    return false;
  return false;
}
template <typename StructPtrType>
BookmarkProductInfoPtr BookmarkProductInfo::Clone() const {
  return New(
      mojo::Clone(bookmark_id),
      mojo::Clone(info)
  );
}

template <typename T, BookmarkProductInfo::EnableIfSame<T>*>
bool BookmarkProductInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bookmark_id, other_struct.bookmark_id))
    return false;
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  return true;
}

template <typename T, BookmarkProductInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bookmark_id < rhs.bookmark_id)
    return true;
  if (rhs.bookmark_id < lhs.bookmark_id)
    return false;
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsSetPtr ProductSpecificationsSet::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(uuid),
      mojo::Clone(urls)
  );
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>*>
bool ProductSpecificationsSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->urls, other_struct.urls))
    return false;
  return true;
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.urls < rhs.urls)
    return true;
  if (rhs.urls < lhs.urls)
    return false;
  return false;
}


}  // commerce::shared::mojom

namespace mojo {


template <>
struct  StructTraits<::commerce::shared::mojom::ProductInfo::DataView,
                                         ::commerce::shared::mojom::ProductInfoPtr> {
  static bool IsNull(const ::commerce::shared::mojom::ProductInfoPtr& input) { return !input; }
  static void SetToNull(::commerce::shared::mojom::ProductInfoPtr* output) { output->reset(); }

  static const decltype(::commerce::shared::mojom::ProductInfo::title)& title(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->title;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::cluster_title)& cluster_title(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->cluster_title;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::domain)& domain(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->domain;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::image_url)& image_url(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->image_url;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::product_url)& product_url(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->product_url;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::current_price)& current_price(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->current_price;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::previous_price)& previous_price(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->previous_price;
  }

  static decltype(::commerce::shared::mojom::ProductInfo::cluster_id) cluster_id(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->cluster_id;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::category_labels)& category_labels(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->category_labels;
  }

  static const decltype(::commerce::shared::mojom::ProductInfo::price_summary)& price_summary(
      const ::commerce::shared::mojom::ProductInfoPtr& input) {
    return input->price_summary;
  }

  static bool Read(::commerce::shared::mojom::ProductInfo::DataView input, ::commerce::shared::mojom::ProductInfoPtr* output);
};


template <>
struct  StructTraits<::commerce::shared::mojom::BookmarkProductInfo::DataView,
                                         ::commerce::shared::mojom::BookmarkProductInfoPtr> {
  static bool IsNull(const ::commerce::shared::mojom::BookmarkProductInfoPtr& input) { return !input; }
  static void SetToNull(::commerce::shared::mojom::BookmarkProductInfoPtr* output) { output->reset(); }

  static decltype(::commerce::shared::mojom::BookmarkProductInfo::bookmark_id) bookmark_id(
      const ::commerce::shared::mojom::BookmarkProductInfoPtr& input) {
    return input->bookmark_id;
  }

  static const decltype(::commerce::shared::mojom::BookmarkProductInfo::info)& info(
      const ::commerce::shared::mojom::BookmarkProductInfoPtr& input) {
    return input->info;
  }

  static bool Read(::commerce::shared::mojom::BookmarkProductInfo::DataView input, ::commerce::shared::mojom::BookmarkProductInfoPtr* output);
};


template <>
struct  StructTraits<::commerce::shared::mojom::ProductSpecificationsSet::DataView,
                                         ::commerce::shared::mojom::ProductSpecificationsSetPtr> {
  static bool IsNull(const ::commerce::shared::mojom::ProductSpecificationsSetPtr& input) { return !input; }
  static void SetToNull(::commerce::shared::mojom::ProductSpecificationsSetPtr* output) { output->reset(); }

  static const decltype(::commerce::shared::mojom::ProductSpecificationsSet::name)& name(
      const ::commerce::shared::mojom::ProductSpecificationsSetPtr& input) {
    return input->name;
  }

  static const decltype(::commerce::shared::mojom::ProductSpecificationsSet::uuid)& uuid(
      const ::commerce::shared::mojom::ProductSpecificationsSetPtr& input) {
    return input->uuid;
  }

  static const decltype(::commerce::shared::mojom::ProductSpecificationsSet::urls)& urls(
      const ::commerce::shared::mojom::ProductSpecificationsSetPtr& input) {
    return input->urls;
  }

  static bool Read(::commerce::shared::mojom::ProductSpecificationsSet::DataView input, ::commerce::shared::mojom::ProductSpecificationsSetPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_SHARED_MOJOM_H_