// components/commerce/core/mojom/product_specifications.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_PRODUCT_SPECIFICATIONS_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_PRODUCT_SPECIFICATIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/product_specifications.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/product_specifications.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/product_specifications.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/commerce/core/mojom/shared.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace commerce::product_specifications::mojom {

class ProductSpecificationsHandlerProxy;

template <typename ImplRefTraits>
class ProductSpecificationsHandlerStub;

class ProductSpecificationsHandlerRequestValidator;
class ProductSpecificationsHandlerResponseValidator;


class ProductSpecificationsHandler
    : public ProductSpecificationsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.product_specifications.mojom.ProductSpecificationsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProductSpecificationsHandlerInterfaceBase;
  using Proxy_ = ProductSpecificationsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProductSpecificationsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ProductSpecificationsHandlerRequestValidator;
  using ResponseValidator_ = ProductSpecificationsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetAcceptedDisclosureVersionMinVersion = 0,
    kMaybeShowDisclosureMinVersion = 0,
    kDeclineDisclosureMinVersion = 0,
    kShowSyncSetupFlowMinVersion = 0,
    kGetPageTitleFromHistoryMinVersion = 0,
    kShowProductSpecificationsSetForUuidMinVersion = 0,
    kShowProductSpecificationsSetsForUuidsMinVersion = 0,
    kShowComparePageMinVersion = 0,
    kGetComparisonTableUrlForUuidMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetAcceptedDisclosureVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeShowDisclosure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeclineDisclosure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSyncSetupFlow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPageTitleFromHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowProductSpecificationsSetForUuid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowProductSpecificationsSetsForUuids_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowComparePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetComparisonTableUrlForUuid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProductSpecificationsHandler() = default;

  virtual void SetAcceptedDisclosureVersion(DisclosureVersion version) = 0;

  using MaybeShowDisclosureCallback = base::OnceCallback<void(bool)>;
  using MaybeShowDisclosureMojoCallback = base::OnceCallback<void(bool)>;

  virtual void MaybeShowDisclosure(const std::vector<::GURL>& urls, const std::string& name, const std::string& set_id, MaybeShowDisclosureCallback callback) = 0;

  virtual void DeclineDisclosure() = 0;

  virtual void ShowSyncSetupFlow() = 0;

  using GetPageTitleFromHistoryCallback = base::OnceCallback<void(const std::string&)>;
  using GetPageTitleFromHistoryMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetPageTitleFromHistory(const ::GURL& url, GetPageTitleFromHistoryCallback callback) = 0;

  virtual void ShowProductSpecificationsSetForUuid(const ::base::Uuid& uuid, bool in_new_tab) = 0;

  virtual void ShowProductSpecificationsSetsForUuids(const std::vector<::base::Uuid>& uuids, ShowSetDisposition disposition) = 0;

  virtual void ShowComparePage(bool in_new_tab) = 0;

  using GetComparisonTableUrlForUuidCallback = base::OnceCallback<void(const ::GURL&)>;
  using GetComparisonTableUrlForUuidMojoCallback = base::OnceCallback<void(const ::GURL&)>;

  virtual void GetComparisonTableUrlForUuid(const ::base::Uuid& uuid, GetComparisonTableUrlForUuidCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.product_specifications.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnProductSpecificationsSetAddedMinVersion = 0,
    kOnProductSpecificationsSetUpdatedMinVersion = 0,
    kOnProductSpecificationsSetRemovedMinVersion = 0,
    kOnSyncStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnProductSpecificationsSetAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnProductSpecificationsSetUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnProductSpecificationsSetRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSyncStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnProductSpecificationsSetAdded(::commerce::shared::mojom::ProductSpecificationsSetPtr set) = 0;

  virtual void OnProductSpecificationsSetUpdated(::commerce::shared::mojom::ProductSpecificationsSetPtr set) = 0;

  virtual void OnProductSpecificationsSetRemoved(const ::base::Uuid& uuid) = 0;

  virtual void OnSyncStateChanged() = 0;
};

class ProductSpecificationsHandlerFactoryProxy;

template <typename ImplRefTraits>
class ProductSpecificationsHandlerFactoryStub;

class ProductSpecificationsHandlerFactoryRequestValidator;


class ProductSpecificationsHandlerFactory
    : public ProductSpecificationsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.product_specifications.mojom.ProductSpecificationsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProductSpecificationsHandlerFactoryInterfaceBase;
  using Proxy_ = ProductSpecificationsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProductSpecificationsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ProductSpecificationsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateProductSpecificationsHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateProductSpecificationsHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProductSpecificationsHandlerFactory() = default;

  virtual void CreateProductSpecificationsHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<ProductSpecificationsHandler> handler) = 0;
};



class  ProductSpecificationsHandlerProxy
    : public ProductSpecificationsHandler {
 public:
  using InterfaceType = ProductSpecificationsHandler;

  explicit ProductSpecificationsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetAcceptedDisclosureVersion(DisclosureVersion version) final;
  
  void MaybeShowDisclosure(const std::vector<::GURL>& urls, const std::string& name, const std::string& set_id, MaybeShowDisclosureCallback callback) final;
  
  void DeclineDisclosure() final;
  
  void ShowSyncSetupFlow() final;
  
  void GetPageTitleFromHistory(const ::GURL& url, GetPageTitleFromHistoryCallback callback) final;
  
  void ShowProductSpecificationsSetForUuid(const ::base::Uuid& uuid, bool in_new_tab) final;
  
  void ShowProductSpecificationsSetsForUuids(const std::vector<::base::Uuid>& uuids, ShowSetDisposition disposition) final;
  
  void ShowComparePage(bool in_new_tab) final;
  
  void GetComparisonTableUrlForUuid(const ::base::Uuid& uuid, GetComparisonTableUrlForUuidCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProductSpecificationsSetAdded(::commerce::shared::mojom::ProductSpecificationsSetPtr set) final;
  
  void OnProductSpecificationsSetUpdated(::commerce::shared::mojom::ProductSpecificationsSetPtr set) final;
  
  void OnProductSpecificationsSetRemoved(const ::base::Uuid& uuid) final;
  
  void OnSyncStateChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProductSpecificationsHandlerFactoryProxy
    : public ProductSpecificationsHandlerFactory {
 public:
  using InterfaceType = ProductSpecificationsHandlerFactory;

  explicit ProductSpecificationsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateProductSpecificationsHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<ProductSpecificationsHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProductSpecificationsHandlerStubDispatch {
 public:
  static bool Accept(ProductSpecificationsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProductSpecificationsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProductSpecificationsHandler>>
class ProductSpecificationsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProductSpecificationsHandlerStub() = default;
  ~ProductSpecificationsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProductSpecificationsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProductSpecificationsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProductSpecificationsHandlerFactoryStubDispatch {
 public:
  static bool Accept(ProductSpecificationsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProductSpecificationsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProductSpecificationsHandlerFactory>>
class ProductSpecificationsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProductSpecificationsHandlerFactoryStub() = default;
  ~ProductSpecificationsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProductSpecificationsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProductSpecificationsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProductSpecificationsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProductSpecificationsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProductSpecificationsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // commerce::product_specifications::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_PRODUCT_SPECIFICATIONS_MOJOM_H_