// components/commerce/core/mojom/price_tracking.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/commerce/core/mojom/price_tracking.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/price_tracking.mojom-params-data.h"
#include "components/commerce/core/mojom/price_tracking.mojom-shared-message-ids.h"

#include "components/commerce/core/mojom/price_tracking.mojom-import-headers.h"
#include "components/commerce/core/mojom/price_tracking.mojom-test-utils.h"


namespace commerce::price_tracking::mojom {
// The declaration includes the definition on other builds.

PriceTrackingHandler::IPCStableHashFunction PriceTrackingHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PriceTrackingHandler>(message.name())) {
    case messages::PriceTrackingHandler::kTrackPriceForBookmark: {
      return &PriceTrackingHandler::TrackPriceForBookmark_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kUntrackPriceForBookmark: {
      return &PriceTrackingHandler::UntrackPriceForBookmark_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl: {
      return &PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo: {
      return &PriceTrackingHandler::GetAllShoppingBookmarkProductInfo_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo: {
      return &PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId: {
      return &PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl: {
      return &PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl_Sym::IPCStableHash;
    }
    case messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl: {
      return &PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PriceTrackingHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PriceTrackingHandler>(message.name())) {
      case messages::PriceTrackingHandler::kTrackPriceForBookmark:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::TrackPriceForBookmark";
      case messages::PriceTrackingHandler::kUntrackPriceForBookmark:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::UntrackPriceForBookmark";
      case messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl";
      case messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::GetAllShoppingBookmarkProductInfo";
      case messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo";
      case messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId";
      case messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl";
      case messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl";
    }
  } else {
    switch (static_cast<messages::PriceTrackingHandler>(message.name())) {
      case messages::PriceTrackingHandler::kTrackPriceForBookmark:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::TrackPriceForBookmark";
      case messages::PriceTrackingHandler::kUntrackPriceForBookmark:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::UntrackPriceForBookmark";
      case messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl";
      case messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::GetAllShoppingBookmarkProductInfo";
      case messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo";
      case messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId";
      case messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl";
      case messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PriceTrackingHandler::TrackPriceForBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d0d79e1;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::TrackPriceForBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::UntrackPriceForBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe45b5f84;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::UntrackPriceForBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb76f8ce;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::GetAllShoppingBookmarkProductInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6354a1f;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::GetAllShoppingBookmarkProductInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1de9724;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f219925;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3f1995e;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41ef4d2f;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback(
      PriceTrackingHandler::GetAllShoppingBookmarkProductInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback(const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback&) = delete;
  PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback& operator=(const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PriceTrackingHandler::GetAllShoppingBookmarkProductInfoCallback callback_;
};

class PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback(
      PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback(const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback&) = delete;
  PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback& operator=(const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfoCallback callback_;
};

class PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback(
      PriceTrackingHandler::GetShoppingCollectionBookmarkFolderIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback(const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback&) = delete;
  PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback& operator=(const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PriceTrackingHandler::GetShoppingCollectionBookmarkFolderIdCallback callback_;
};

class PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback(
      PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback(const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback&) = delete;
  PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback& operator=(const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrlCallback callback_;
};

PriceTrackingHandlerProxy::PriceTrackingHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PriceTrackingHandlerProxy::TrackPriceForBookmark(
    int64_t in_bookmark_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::TrackPriceForBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_id"), in_bookmark_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kTrackPriceForBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_TrackPriceForBookmark_Params_Data> params(
          message);
  params.Allocate();

  params->bookmark_id = in_bookmark_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("TrackPriceForBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PriceTrackingHandlerProxy::UntrackPriceForBookmark(
    int64_t in_bookmark_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::UntrackPriceForBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_id"), in_bookmark_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kUntrackPriceForBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_UntrackPriceForBookmark_Params_Data> params(
          message);
  params.Allocate();

  params->bookmark_id = in_bookmark_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("UntrackPriceForBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PriceTrackingHandlerProxy::SetPriceTrackingStatusForCurrentUrl(
    bool in_track) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::SetPriceTrackingStatusForCurrentUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("track"), in_track,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

  params->track = in_track;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("SetPriceTrackingStatusForCurrentUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PriceTrackingHandlerProxy::GetAllShoppingBookmarkProductInfo(
    GetAllShoppingBookmarkProductInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::GetAllShoppingBookmarkProductInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetAllShoppingBookmarkProductInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PriceTrackingHandlerProxy::GetAllPriceTrackedBookmarkProductInfo(
    GetAllPriceTrackedBookmarkProductInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetAllPriceTrackedBookmarkProductInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PriceTrackingHandlerProxy::GetShoppingCollectionBookmarkFolderId(
    GetShoppingCollectionBookmarkFolderIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetShoppingCollectionBookmarkFolderId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PriceTrackingHandlerProxy::GetParentBookmarkFolderNameForCurrentUrl(
    GetParentBookmarkFolderNameForCurrentUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetParentBookmarkFolderNameForCurrentUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PriceTrackingHandlerProxy::ShowBookmarkEditorForCurrentUrl(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandler::ShowBookmarkEditorForCurrentUrl");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("ShowBookmarkEditorForCurrentUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PriceTrackingHandler::GetAllShoppingBookmarkProductInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder> proxy(
        new PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PriceTrackingHandler::GetAllShoppingBookmarkProductInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> in_productInfos);
};

bool PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PriceTrackingHandler.3
  bool success = true;
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> p_productInfos{};
  PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductInfos(&p_productInfos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PriceTrackingHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_productInfos));
  }
  return true;
}

void PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder::Run(
    std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> in_productInfos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::price_tracking::mojom::PriceTrackingHandler::GetAllShoppingBookmarkProductInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productInfos"), in_productInfos,
                        "<value of type std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->productInfos)::BaseType>
      productInfos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& productInfos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::shared::mojom::BookmarkProductInfoDataView>>(
    in_productInfos,
    productInfos_fragment,
    &productInfos_validate_params);

  params->productInfos.Set(
      productInfos_fragment.is_null() ? nullptr : productInfos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productInfos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productInfos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetAllShoppingBookmarkProductInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder> proxy(
        new PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> in_productInfos);
};

bool PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PriceTrackingHandler.4
  bool success = true;
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> p_productInfos{};
  PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductInfos(&p_productInfos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PriceTrackingHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_productInfos));
  }
  return true;
}

void PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder::Run(
    std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> in_productInfos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::price_tracking::mojom::PriceTrackingHandler::GetAllPriceTrackedBookmarkProductInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("productInfos"), in_productInfos,
                        "<value of type std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->productInfos)::BaseType>
      productInfos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& productInfos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::shared::mojom::BookmarkProductInfoDataView>>(
    in_productInfos,
    productInfos_fragment,
    &productInfos_validate_params);

  params->productInfos.Set(
      productInfos_fragment.is_null() ? nullptr : productInfos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->productInfos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null productInfos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetAllPriceTrackedBookmarkProductInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PriceTrackingHandler::GetShoppingCollectionBookmarkFolderIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder> proxy(
        new PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PriceTrackingHandler::GetShoppingCollectionBookmarkFolderIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_collectionId);
};

bool PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PriceTrackingHandler.5
  bool success = true;
  int64_t p_collectionId{};
  PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_collectionId = input_data_view.collectionId();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PriceTrackingHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_collectionId));
  }
  return true;
}

void PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder::Run(
    int64_t in_collectionId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::price_tracking::mojom::PriceTrackingHandler::GetShoppingCollectionBookmarkFolderId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collectionId"), in_collectionId,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->collectionId = in_collectionId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetShoppingCollectionBookmarkFolderId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder> proxy(
        new PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::std::u16string& in_name);
};

bool PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PriceTrackingHandler.6
  bool success = true;
  ::std::u16string p_name{};
  PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadName(&p_name))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PriceTrackingHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_name));
  }
  return true;
}

void PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder::Run(
    const ::std::u16string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::price_tracking::mojom::PriceTrackingHandler::GetParentBookmarkFolderNameForCurrentUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandler::Name_);
  message.set_method_name("GetParentBookmarkFolderNameForCurrentUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PriceTrackingHandlerStubDispatch::Accept(
    PriceTrackingHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PriceTrackingHandler>(message->header()->name)) {
    case messages::PriceTrackingHandler::kTrackPriceForBookmark: {
      DCHECK(message->is_serialized());
      internal::PriceTrackingHandler_TrackPriceForBookmark_Params_Data* params =
          reinterpret_cast<internal::PriceTrackingHandler_TrackPriceForBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PriceTrackingHandler.0
      bool success = true;
      int64_t p_bookmark_id{};
      PriceTrackingHandler_TrackPriceForBookmark_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bookmark_id = input_data_view.bookmark_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TrackPriceForBookmark(        
        std::move(p_bookmark_id));
      return true;
    }
    case messages::PriceTrackingHandler::kUntrackPriceForBookmark: {
      DCHECK(message->is_serialized());
      internal::PriceTrackingHandler_UntrackPriceForBookmark_Params_Data* params =
          reinterpret_cast<internal::PriceTrackingHandler_UntrackPriceForBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PriceTrackingHandler.1
      bool success = true;
      int64_t p_bookmark_id{};
      PriceTrackingHandler_UntrackPriceForBookmark_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bookmark_id = input_data_view.bookmark_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UntrackPriceForBookmark(        
        std::move(p_bookmark_id));
      return true;
    }
    case messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl: {
      DCHECK(message->is_serialized());
      internal::PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params_Data* params =
          reinterpret_cast<internal::PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PriceTrackingHandler.2
      bool success = true;
      bool p_track{};
      PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_track = input_data_view.track();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriceTrackingStatusForCurrentUrl(        
        std::move(p_track));
      return true;
    }
    case messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo: {
      break;
    }
    case messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo: {
      break;
    }
    case messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId: {
      break;
    }
    case messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl: {
      break;
    }
    case messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl: {
      DCHECK(message->is_serialized());
      internal::PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params_Data* params =
          reinterpret_cast<internal::PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PriceTrackingHandler.7
      bool success = true;
      PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowBookmarkEditorForCurrentUrl(        );
      return true;
    }
  }
  return false;
}

// static
bool PriceTrackingHandlerStubDispatch::AcceptWithResponder(
    PriceTrackingHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PriceTrackingHandler>(message->header()->name)) {
    case messages::PriceTrackingHandler::kTrackPriceForBookmark: {
      break;
    }
    case messages::PriceTrackingHandler::kUntrackPriceForBookmark: {
      break;
    }
    case messages::PriceTrackingHandler::kSetPriceTrackingStatusForCurrentUrl: {
      break;
    }
    case messages::PriceTrackingHandler::kGetAllShoppingBookmarkProductInfo: {
      internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params_Data* params =
          reinterpret_cast<
              internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PriceTrackingHandler.3
      bool success = true;
      PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllShoppingBookmarkProductInfo(std::move(callback));
      return true;
    }
    case messages::PriceTrackingHandler::kGetAllPriceTrackedBookmarkProductInfo: {
      internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params_Data* params =
          reinterpret_cast<
              internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PriceTrackingHandler.4
      bool success = true;
      PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllPriceTrackedBookmarkProductInfo(std::move(callback));
      return true;
    }
    case messages::PriceTrackingHandler::kGetShoppingCollectionBookmarkFolderId: {
      internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params_Data* params =
          reinterpret_cast<
              internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PriceTrackingHandler.5
      bool success = true;
      PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetShoppingCollectionBookmarkFolderId(std::move(callback));
      return true;
    }
    case messages::PriceTrackingHandler::kGetParentBookmarkFolderNameForCurrentUrl: {
      internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params_Data* params =
          reinterpret_cast<
              internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PriceTrackingHandler.6
      bool success = true;
      PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetParentBookmarkFolderNameForCurrentUrl(std::move(callback));
      return true;
    }
    case messages::PriceTrackingHandler::kShowBookmarkEditorForCurrentUrl: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPriceTrackingHandlerValidationInfo[] = {
    { &internal::PriceTrackingHandler_TrackPriceForBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PriceTrackingHandler_UntrackPriceForBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params_Data::Validate,
     &internal::PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams_Data::Validate},
    { &internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params_Data::Validate,
     &internal::PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams_Data::Validate},
    { &internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params_Data::Validate,
     &internal::PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams_Data::Validate},
    { &internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params_Data::Validate,
     &internal::PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams_Data::Validate},
    { &internal::PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params_Data::Validate,
     nullptr /* no response */},
};

bool PriceTrackingHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::price_tracking::mojom::PriceTrackingHandler::Name_,
    kPriceTrackingHandlerValidationInfo);
}

bool PriceTrackingHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::commerce::price_tracking::mojom::PriceTrackingHandler::Name_,
    kPriceTrackingHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kPriceTrackedForBookmark: {
      return &Page::PriceTrackedForBookmark_Sym::IPCStableHash;
    }
    case messages::Page::kPriceUntrackedForBookmark: {
      return &Page::PriceUntrackedForBookmark_Sym::IPCStableHash;
    }
    case messages::Page::kOperationFailedForBookmark: {
      return &Page::OperationFailedForBookmark_Sym::IPCStableHash;
    }
    case messages::Page::kOnProductBookmarkMoved: {
      return &Page::OnProductBookmarkMoved_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kPriceTrackedForBookmark:
            return "Receive commerce::price_tracking::mojom::Page::PriceTrackedForBookmark";
      case messages::Page::kPriceUntrackedForBookmark:
            return "Receive commerce::price_tracking::mojom::Page::PriceUntrackedForBookmark";
      case messages::Page::kOperationFailedForBookmark:
            return "Receive commerce::price_tracking::mojom::Page::OperationFailedForBookmark";
      case messages::Page::kOnProductBookmarkMoved:
            return "Receive commerce::price_tracking::mojom::Page::OnProductBookmarkMoved";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kPriceTrackedForBookmark:
            return "Receive reply commerce::price_tracking::mojom::Page::PriceTrackedForBookmark";
      case messages::Page::kPriceUntrackedForBookmark:
            return "Receive reply commerce::price_tracking::mojom::Page::PriceUntrackedForBookmark";
      case messages::Page::kOperationFailedForBookmark:
            return "Receive reply commerce::price_tracking::mojom::Page::OperationFailedForBookmark";
      case messages::Page::kOnProductBookmarkMoved:
            return "Receive reply commerce::price_tracking::mojom::Page::OnProductBookmarkMoved";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::PriceTrackedForBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb40f9650;  // IPCStableHash for commerce::price_tracking::mojom::Page::PriceTrackedForBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::PriceUntrackedForBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x433ac31d;  // IPCStableHash for commerce::price_tracking::mojom::Page::PriceUntrackedForBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OperationFailedForBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44ea35f3;  // IPCStableHash for commerce::price_tracking::mojom::Page::OperationFailedForBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnProductBookmarkMoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90d90cf2;  // IPCStableHash for commerce::price_tracking::mojom::Page::OnProductBookmarkMoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::PriceTrackedForBookmark(
    ::commerce::shared::mojom::BookmarkProductInfoPtr in_bookmark_product) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::Page::PriceTrackedForBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_product"), in_bookmark_product,
                        "<value of type ::commerce::shared::mojom::BookmarkProductInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kPriceTrackedForBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::Page_PriceTrackedForBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmark_product)::BaseType> bookmark_product_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::BookmarkProductInfoDataView>(
    in_bookmark_product,
    bookmark_product_fragment);

  params->bookmark_product.Set(
      bookmark_product_fragment.is_null() ? nullptr : bookmark_product_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmark_product.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmark_product in Page.PriceTrackedForBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("PriceTrackedForBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::PriceUntrackedForBookmark(
    ::commerce::shared::mojom::BookmarkProductInfoPtr in_bookmark_product) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::Page::PriceUntrackedForBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_product"), in_bookmark_product,
                        "<value of type ::commerce::shared::mojom::BookmarkProductInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kPriceUntrackedForBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::Page_PriceUntrackedForBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmark_product)::BaseType> bookmark_product_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::BookmarkProductInfoDataView>(
    in_bookmark_product,
    bookmark_product_fragment);

  params->bookmark_product.Set(
      bookmark_product_fragment.is_null() ? nullptr : bookmark_product_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmark_product.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmark_product in Page.PriceUntrackedForBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("PriceUntrackedForBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OperationFailedForBookmark(
    ::commerce::shared::mojom::BookmarkProductInfoPtr in_bookmark_product, bool in_attempted_track) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::Page::OperationFailedForBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_product"), in_bookmark_product,
                        "<value of type ::commerce::shared::mojom::BookmarkProductInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attempted_track"), in_attempted_track,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOperationFailedForBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::Page_OperationFailedForBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmark_product)::BaseType> bookmark_product_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::BookmarkProductInfoDataView>(
    in_bookmark_product,
    bookmark_product_fragment);

  params->bookmark_product.Set(
      bookmark_product_fragment.is_null() ? nullptr : bookmark_product_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmark_product.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmark_product in Page.OperationFailedForBookmark request");

  params->attempted_track = in_attempted_track;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OperationFailedForBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnProductBookmarkMoved(
    ::commerce::shared::mojom::BookmarkProductInfoPtr in_bookmark_product) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::Page::OnProductBookmarkMoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bookmark_product"), in_bookmark_product,
                        "<value of type ::commerce::shared::mojom::BookmarkProductInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnProductBookmarkMoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::Page_OnProductBookmarkMoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bookmark_product)::BaseType> bookmark_product_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::BookmarkProductInfoDataView>(
    in_bookmark_product,
    bookmark_product_fragment);

  params->bookmark_product.Set(
      bookmark_product_fragment.is_null() ? nullptr : bookmark_product_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bookmark_product.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bookmark_product in Page.OnProductBookmarkMoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnProductBookmarkMoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kPriceTrackedForBookmark: {
      DCHECK(message->is_serialized());
      internal::Page_PriceTrackedForBookmark_Params_Data* params =
          reinterpret_cast<internal::Page_PriceTrackedForBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::commerce::shared::mojom::BookmarkProductInfoPtr p_bookmark_product{};
      Page_PriceTrackedForBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarkProduct(&p_bookmark_product))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PriceTrackedForBookmark(        
        std::move(p_bookmark_product));
      return true;
    }
    case messages::Page::kPriceUntrackedForBookmark: {
      DCHECK(message->is_serialized());
      internal::Page_PriceUntrackedForBookmark_Params_Data* params =
          reinterpret_cast<internal::Page_PriceUntrackedForBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ::commerce::shared::mojom::BookmarkProductInfoPtr p_bookmark_product{};
      Page_PriceUntrackedForBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarkProduct(&p_bookmark_product))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PriceUntrackedForBookmark(        
        std::move(p_bookmark_product));
      return true;
    }
    case messages::Page::kOperationFailedForBookmark: {
      DCHECK(message->is_serialized());
      internal::Page_OperationFailedForBookmark_Params_Data* params =
          reinterpret_cast<internal::Page_OperationFailedForBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      ::commerce::shared::mojom::BookmarkProductInfoPtr p_bookmark_product{};
      bool p_attempted_track{};
      Page_OperationFailedForBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarkProduct(&p_bookmark_product))
        success = false;
      if (success)
        p_attempted_track = input_data_view.attempted_track();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OperationFailedForBookmark(        
        std::move(p_bookmark_product), 
        std::move(p_attempted_track));
      return true;
    }
    case messages::Page::kOnProductBookmarkMoved: {
      DCHECK(message->is_serialized());
      internal::Page_OnProductBookmarkMoved_Params_Data* params =
          reinterpret_cast<internal::Page_OnProductBookmarkMoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      ::commerce::shared::mojom::BookmarkProductInfoPtr p_bookmark_product{};
      Page_OnProductBookmarkMoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBookmarkProduct(&p_bookmark_product))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProductBookmarkMoved(        
        std::move(p_bookmark_product));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kPriceTrackedForBookmark: {
      break;
    }
    case messages::Page::kPriceUntrackedForBookmark: {
      break;
    }
    case messages::Page::kOperationFailedForBookmark: {
      break;
    }
    case messages::Page::kOnProductBookmarkMoved: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_PriceTrackedForBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_PriceUntrackedForBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OperationFailedForBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnProductBookmarkMoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::price_tracking::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

PriceTrackingHandlerFactory::IPCStableHashFunction PriceTrackingHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PriceTrackingHandlerFactory>(message.name())) {
    case messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler: {
      return &PriceTrackingHandlerFactory::CreatePriceTrackingHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PriceTrackingHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PriceTrackingHandlerFactory>(message.name())) {
      case messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler:
            return "Receive commerce::price_tracking::mojom::PriceTrackingHandlerFactory::CreatePriceTrackingHandler";
    }
  } else {
    switch (static_cast<messages::PriceTrackingHandlerFactory>(message.name())) {
      case messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler:
            return "Receive reply commerce::price_tracking::mojom::PriceTrackingHandlerFactory::CreatePriceTrackingHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PriceTrackingHandlerFactory::CreatePriceTrackingHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd65f8eae;  // IPCStableHash for commerce::price_tracking::mojom::PriceTrackingHandlerFactory::CreatePriceTrackingHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PriceTrackingHandlerFactoryProxy::PriceTrackingHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PriceTrackingHandlerFactoryProxy::CreatePriceTrackingHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PriceTrackingHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::price_tracking::mojom::PriceTrackingHandlerFactory::CreatePriceTrackingHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PriceTrackingHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::price_tracking::mojom::internal::PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::commerce::price_tracking::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PriceTrackingHandlerFactory.CreatePriceTrackingHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::commerce::price_tracking::mojom::PriceTrackingHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PriceTrackingHandlerFactory.CreatePriceTrackingHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PriceTrackingHandlerFactory::Name_);
  message.set_method_name("CreatePriceTrackingHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PriceTrackingHandlerFactoryStubDispatch::Accept(
    PriceTrackingHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PriceTrackingHandlerFactory>(message->header()->name)) {
    case messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler: {
      DCHECK(message->is_serialized());
      internal::PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params_Data* params =
          reinterpret_cast<internal::PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PriceTrackingHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PriceTrackingHandler> p_handler{};
      PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PriceTrackingHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePriceTrackingHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PriceTrackingHandlerFactoryStubDispatch::AcceptWithResponder(
    PriceTrackingHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PriceTrackingHandlerFactory>(message->header()->name)) {
    case messages::PriceTrackingHandlerFactory::kCreatePriceTrackingHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPriceTrackingHandlerFactoryValidationInfo[] = {
    { &internal::PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PriceTrackingHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::price_tracking::mojom::PriceTrackingHandlerFactory::Name_,
    kPriceTrackingHandlerFactoryValidationInfo);
}



}  // commerce::price_tracking::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace commerce::price_tracking::mojom {


void PriceTrackingHandlerInterceptorForTesting::TrackPriceForBookmark(int64_t bookmark_id) {
  GetForwardingInterface()->TrackPriceForBookmark(
    std::move(bookmark_id)
    );
}
void PriceTrackingHandlerInterceptorForTesting::UntrackPriceForBookmark(int64_t bookmark_id) {
  GetForwardingInterface()->UntrackPriceForBookmark(
    std::move(bookmark_id)
    );
}
void PriceTrackingHandlerInterceptorForTesting::SetPriceTrackingStatusForCurrentUrl(bool track) {
  GetForwardingInterface()->SetPriceTrackingStatusForCurrentUrl(
    std::move(track)
    );
}
void PriceTrackingHandlerInterceptorForTesting::GetAllShoppingBookmarkProductInfo(GetAllShoppingBookmarkProductInfoCallback callback) {
  GetForwardingInterface()->GetAllShoppingBookmarkProductInfo(std::move(callback));
}
void PriceTrackingHandlerInterceptorForTesting::GetAllPriceTrackedBookmarkProductInfo(GetAllPriceTrackedBookmarkProductInfoCallback callback) {
  GetForwardingInterface()->GetAllPriceTrackedBookmarkProductInfo(std::move(callback));
}
void PriceTrackingHandlerInterceptorForTesting::GetShoppingCollectionBookmarkFolderId(GetShoppingCollectionBookmarkFolderIdCallback callback) {
  GetForwardingInterface()->GetShoppingCollectionBookmarkFolderId(std::move(callback));
}
void PriceTrackingHandlerInterceptorForTesting::GetParentBookmarkFolderNameForCurrentUrl(GetParentBookmarkFolderNameForCurrentUrlCallback callback) {
  GetForwardingInterface()->GetParentBookmarkFolderNameForCurrentUrl(std::move(callback));
}
void PriceTrackingHandlerInterceptorForTesting::ShowBookmarkEditorForCurrentUrl() {
  GetForwardingInterface()->ShowBookmarkEditorForCurrentUrl();
}
PriceTrackingHandlerAsyncWaiter::PriceTrackingHandlerAsyncWaiter(
    PriceTrackingHandler* proxy) : proxy_(proxy) {}

PriceTrackingHandlerAsyncWaiter::~PriceTrackingHandlerAsyncWaiter() = default;


void PriceTrackingHandlerAsyncWaiter::GetAllShoppingBookmarkProductInfo(
    std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos) {
  base::RunLoop loop;
  proxy_->GetAllShoppingBookmarkProductInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos
,
             std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> productInfos) {*out_productInfos = std::move(productInfos);
            loop->Quit();
          },
          &loop,
          out_productInfos));
  loop.Run();
}

std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> PriceTrackingHandlerAsyncWaiter::GetAllShoppingBookmarkProductInfo(
    ) {
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> async_wait_result;
  GetAllShoppingBookmarkProductInfo(&async_wait_result);
  return async_wait_result;
}

void PriceTrackingHandlerAsyncWaiter::GetAllPriceTrackedBookmarkProductInfo(
    std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos) {
  base::RunLoop loop;
  proxy_->GetAllPriceTrackedBookmarkProductInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos
,
             std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> productInfos) {*out_productInfos = std::move(productInfos);
            loop->Quit();
          },
          &loop,
          out_productInfos));
  loop.Run();
}

std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> PriceTrackingHandlerAsyncWaiter::GetAllPriceTrackedBookmarkProductInfo(
    ) {
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> async_wait_result;
  GetAllPriceTrackedBookmarkProductInfo(&async_wait_result);
  return async_wait_result;
}

void PriceTrackingHandlerAsyncWaiter::GetShoppingCollectionBookmarkFolderId(
    int64_t* out_collectionId) {
  base::RunLoop loop;
  proxy_->GetShoppingCollectionBookmarkFolderId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_collectionId
,
             int64_t collectionId) {*out_collectionId = std::move(collectionId);
            loop->Quit();
          },
          &loop,
          out_collectionId));
  loop.Run();
}

int64_t PriceTrackingHandlerAsyncWaiter::GetShoppingCollectionBookmarkFolderId(
    ) {
  int64_t async_wait_result;
  GetShoppingCollectionBookmarkFolderId(&async_wait_result);
  return async_wait_result;
}

void PriceTrackingHandlerAsyncWaiter::GetParentBookmarkFolderNameForCurrentUrl(
    ::std::u16string* out_name) {
  base::RunLoop loop;
  proxy_->GetParentBookmarkFolderNameForCurrentUrl(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::std::u16string* out_name
,
             const ::std::u16string& name) {*out_name = std::move(name);
            loop->Quit();
          },
          &loop,
          out_name));
  loop.Run();
}

::std::u16string PriceTrackingHandlerAsyncWaiter::GetParentBookmarkFolderNameForCurrentUrl(
    ) {
  ::std::u16string async_wait_result;
  GetParentBookmarkFolderNameForCurrentUrl(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::PriceTrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) {
  GetForwardingInterface()->PriceTrackedForBookmark(
    std::move(bookmark_product)
    );
}
void PageInterceptorForTesting::PriceUntrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) {
  GetForwardingInterface()->PriceUntrackedForBookmark(
    std::move(bookmark_product)
    );
}
void PageInterceptorForTesting::OperationFailedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product, bool attempted_track) {
  GetForwardingInterface()->OperationFailedForBookmark(
    std::move(bookmark_product)
    , 
    std::move(attempted_track)
    );
}
void PageInterceptorForTesting::OnProductBookmarkMoved(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) {
  GetForwardingInterface()->OnProductBookmarkMoved(
    std::move(bookmark_product)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void PriceTrackingHandlerFactoryInterceptorForTesting::CreatePriceTrackingHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PriceTrackingHandler> handler) {
  GetForwardingInterface()->CreatePriceTrackingHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PriceTrackingHandlerFactoryAsyncWaiter::PriceTrackingHandlerFactoryAsyncWaiter(
    PriceTrackingHandlerFactory* proxy) : proxy_(proxy) {}

PriceTrackingHandlerFactoryAsyncWaiter::~PriceTrackingHandlerFactoryAsyncWaiter() = default;







}  // commerce::price_tracking::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif