// components/commerce/core/mojom/price_tracking.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_TEST_UTILS_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_TEST_UTILS_H_

#include "components/commerce/core/mojom/price_tracking.mojom.h"


namespace commerce::price_tracking::mojom {


class  PriceTrackingHandlerInterceptorForTesting : public PriceTrackingHandler {
  virtual PriceTrackingHandler* GetForwardingInterface() = 0;
  void TrackPriceForBookmark(int64_t bookmark_id) override;
  void UntrackPriceForBookmark(int64_t bookmark_id) override;
  void SetPriceTrackingStatusForCurrentUrl(bool track) override;
  void GetAllShoppingBookmarkProductInfo(GetAllShoppingBookmarkProductInfoCallback callback) override;
  void GetAllPriceTrackedBookmarkProductInfo(GetAllPriceTrackedBookmarkProductInfoCallback callback) override;
  void GetShoppingCollectionBookmarkFolderId(GetShoppingCollectionBookmarkFolderIdCallback callback) override;
  void GetParentBookmarkFolderNameForCurrentUrl(GetParentBookmarkFolderNameForCurrentUrlCallback callback) override;
  void ShowBookmarkEditorForCurrentUrl() override;
};
class  PriceTrackingHandlerAsyncWaiter {
 public:
  explicit PriceTrackingHandlerAsyncWaiter(PriceTrackingHandler* proxy);

  PriceTrackingHandlerAsyncWaiter(const PriceTrackingHandlerAsyncWaiter&) = delete;
  PriceTrackingHandlerAsyncWaiter& operator=(const PriceTrackingHandlerAsyncWaiter&) = delete;

  ~PriceTrackingHandlerAsyncWaiter();
  void GetAllShoppingBookmarkProductInfo(
      std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos);
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> GetAllShoppingBookmarkProductInfo();
  void GetAllPriceTrackedBookmarkProductInfo(
      std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>* out_productInfos);
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> GetAllPriceTrackedBookmarkProductInfo();
  void GetShoppingCollectionBookmarkFolderId(
      int64_t* out_collectionId);
  int64_t GetShoppingCollectionBookmarkFolderId();
  void GetParentBookmarkFolderNameForCurrentUrl(
      ::std::u16string* out_name);
  ::std::u16string GetParentBookmarkFolderNameForCurrentUrl();

 private:
  PriceTrackingHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void PriceTrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) override;
  void PriceUntrackedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) override;
  void OperationFailedForBookmark(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product, bool attempted_track) override;
  void OnProductBookmarkMoved(::commerce::shared::mojom::BookmarkProductInfoPtr bookmark_product) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};


class  PriceTrackingHandlerFactoryInterceptorForTesting : public PriceTrackingHandlerFactory {
  virtual PriceTrackingHandlerFactory* GetForwardingInterface() = 0;
  void CreatePriceTrackingHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PriceTrackingHandler> handler) override;
};
class  PriceTrackingHandlerFactoryAsyncWaiter {
 public:
  explicit PriceTrackingHandlerFactoryAsyncWaiter(PriceTrackingHandlerFactory* proxy);

  PriceTrackingHandlerFactoryAsyncWaiter(const PriceTrackingHandlerFactoryAsyncWaiter&) = delete;
  PriceTrackingHandlerFactoryAsyncWaiter& operator=(const PriceTrackingHandlerFactoryAsyncWaiter&) = delete;

  ~PriceTrackingHandlerFactoryAsyncWaiter();

 private:
  PriceTrackingHandlerFactory* const proxy_;
};




}  // commerce::price_tracking::mojom

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_TRACKING_MOJOM_TEST_UTILS_H_