// components/commerce/core/mojom/price_insights.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_INSIGHTS_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_INSIGHTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/mojom/price_insights.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/price_insights.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/price_insights.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace commerce::price_insights::mojom {

class PriceInsightsHandlerProxy;

template <typename ImplRefTraits>
class PriceInsightsHandlerStub;

class PriceInsightsHandlerRequestValidator;


class PriceInsightsHandler
    : public PriceInsightsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.price_insights.mojom.PriceInsightsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PriceInsightsHandlerInterfaceBase;
  using Proxy_ = PriceInsightsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PriceInsightsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PriceInsightsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowSidePanelUIMinVersion = 0,
    kShowFeedbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowSidePanelUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PriceInsightsHandler() = default;

  virtual void ShowSidePanelUI() = 0;

  virtual void ShowFeedback() = 0;
};

class PriceInsightsHandlerFactoryProxy;

template <typename ImplRefTraits>
class PriceInsightsHandlerFactoryStub;

class PriceInsightsHandlerFactoryRequestValidator;


class PriceInsightsHandlerFactory
    : public PriceInsightsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.price_insights.mojom.PriceInsightsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PriceInsightsHandlerFactoryInterfaceBase;
  using Proxy_ = PriceInsightsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PriceInsightsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PriceInsightsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePriceInsightsHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePriceInsightsHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PriceInsightsHandlerFactory() = default;

  virtual void CreatePriceInsightsHandler(::mojo::PendingReceiver<PriceInsightsHandler> handler) = 0;
};



class  PriceInsightsHandlerProxy
    : public PriceInsightsHandler {
 public:
  using InterfaceType = PriceInsightsHandler;

  explicit PriceInsightsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowSidePanelUI() final;
  
  void ShowFeedback() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PriceInsightsHandlerFactoryProxy
    : public PriceInsightsHandlerFactory {
 public:
  using InterfaceType = PriceInsightsHandlerFactory;

  explicit PriceInsightsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePriceInsightsHandler(::mojo::PendingReceiver<PriceInsightsHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PriceInsightsHandlerStubDispatch {
 public:
  static bool Accept(PriceInsightsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PriceInsightsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PriceInsightsHandler>>
class PriceInsightsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PriceInsightsHandlerStub() = default;
  ~PriceInsightsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceInsightsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceInsightsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PriceInsightsHandlerFactoryStubDispatch {
 public:
  static bool Accept(PriceInsightsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PriceInsightsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PriceInsightsHandlerFactory>>
class PriceInsightsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PriceInsightsHandlerFactoryStub() = default;
  ~PriceInsightsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceInsightsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PriceInsightsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PriceInsightsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PriceInsightsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // commerce::price_insights::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_MOJOM_PRICE_INSIGHTS_MOJOM_H_