// components/commerce/core/internals/mojom/commerce_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_H_
#define COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/internals/mojom/commerce_internals.mojom-features.h"  // IWYU pragma: export
#include "components/commerce/core/internals/mojom/commerce_internals.mojom-shared.h"  // IWYU pragma: export
#include "components/commerce/core/internals/mojom/commerce_internals.mojom-forward.h"  // IWYU pragma: export
#include "components/commerce/core/mojom/shopping_service.mojom.h"
#include "components/commerce/core/mojom/shared.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace commerce::mojom {

class CommerceInternalsHandlerFactoryProxy;

template <typename ImplRefTraits>
class CommerceInternalsHandlerFactoryStub;

class CommerceInternalsHandlerFactoryRequestValidator;


class CommerceInternalsHandlerFactory
    : public CommerceInternalsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.mojom.CommerceInternalsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommerceInternalsHandlerFactoryInterfaceBase;
  using Proxy_ = CommerceInternalsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommerceInternalsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CommerceInternalsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateCommerceInternalsHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCommerceInternalsHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommerceInternalsHandlerFactory() = default;

  virtual void CreateCommerceInternalsHandler(::mojo::PendingRemote<CommerceInternalsPage> page, ::mojo::PendingReceiver<CommerceInternalsHandler> handler) = 0;
};

class CommerceInternalsHandlerProxy;

template <typename ImplRefTraits>
class CommerceInternalsHandlerStub;

class CommerceInternalsHandlerRequestValidator;
class CommerceInternalsHandlerResponseValidator;


class CommerceInternalsHandler
    : public CommerceInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.mojom.CommerceInternalsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommerceInternalsHandlerInterfaceBase;
  using Proxy_ = CommerceInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommerceInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CommerceInternalsHandlerRequestValidator;
  using ResponseValidator_ = CommerceInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetIsShoppingListEligibleMinVersion = 0,
    kResetPriceTrackingEmailPrefMinVersion = 0,
    kGetProductInfoForUrlMinVersion = 0,
    kGetSubscriptionDetailsMinVersion = 0,
    kGetProductSpecificationsDetailsMinVersion = 0,
    kResetProductSpecificationsMinVersion = 0,
    kGetShoppingEligibilityDetailsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetIsShoppingListEligible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetPriceTrackingEmailPref_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductInfoForUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSubscriptionDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProductSpecificationsDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetProductSpecifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetShoppingEligibilityDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommerceInternalsHandler() = default;

  using GetIsShoppingListEligibleCallback = base::OnceCallback<void(bool)>;
  using GetIsShoppingListEligibleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetIsShoppingListEligible(GetIsShoppingListEligibleCallback callback) = 0;

  virtual void ResetPriceTrackingEmailPref() = 0;

  using GetProductInfoForUrlCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductInfoPtr)>;
  using GetProductInfoForUrlMojoCallback = base::OnceCallback<void(::commerce::shared::mojom::ProductInfoPtr)>;

  virtual void GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) = 0;

  using GetSubscriptionDetailsCallback = base::OnceCallback<void(std::vector<SubscriptionPtr>)>;
  using GetSubscriptionDetailsMojoCallback = base::OnceCallback<void(std::vector<SubscriptionPtr>)>;

  virtual void GetSubscriptionDetails(GetSubscriptionDetailsCallback callback) = 0;

  using GetProductSpecificationsDetailsCallback = base::OnceCallback<void(std::vector<ProductSpecificationsSetPtr>)>;
  using GetProductSpecificationsDetailsMojoCallback = base::OnceCallback<void(std::vector<ProductSpecificationsSetPtr>)>;

  virtual void GetProductSpecificationsDetails(GetProductSpecificationsDetailsCallback callback) = 0;

  virtual void ResetProductSpecifications() = 0;

  using GetShoppingEligibilityDetailsCallback = base::OnceCallback<void(ShoppingEligibilityDetailsPtr)>;
  using GetShoppingEligibilityDetailsMojoCallback = base::OnceCallback<void(ShoppingEligibilityDetailsPtr)>;

  virtual void GetShoppingEligibilityDetails(GetShoppingEligibilityDetailsCallback callback) = 0;
};

class CommerceInternalsPageProxy;

template <typename ImplRefTraits>
class CommerceInternalsPageStub;

class CommerceInternalsPageRequestValidator;


class CommerceInternalsPage
    : public CommerceInternalsPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "commerce.mojom.CommerceInternalsPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommerceInternalsPageInterfaceBase;
  using Proxy_ = CommerceInternalsPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommerceInternalsPageStub<ImplRefTraits>;

  using RequestValidator_ = CommerceInternalsPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnShoppingListEligibilityChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnShoppingListEligibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommerceInternalsPage() = default;

  virtual void OnShoppingListEligibilityChanged(bool eligible) = 0;
};



class  CommerceInternalsHandlerFactoryProxy
    : public CommerceInternalsHandlerFactory {
 public:
  using InterfaceType = CommerceInternalsHandlerFactory;

  explicit CommerceInternalsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCommerceInternalsHandler(::mojo::PendingRemote<CommerceInternalsPage> page, ::mojo::PendingReceiver<CommerceInternalsHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CommerceInternalsHandlerProxy
    : public CommerceInternalsHandler {
 public:
  using InterfaceType = CommerceInternalsHandler;

  explicit CommerceInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetIsShoppingListEligible(GetIsShoppingListEligibleCallback callback) final;
  
  void ResetPriceTrackingEmailPref() final;
  
  void GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) final;
  
  void GetSubscriptionDetails(GetSubscriptionDetailsCallback callback) final;
  
  void GetProductSpecificationsDetails(GetProductSpecificationsDetailsCallback callback) final;
  
  void ResetProductSpecifications() final;
  
  void GetShoppingEligibilityDetails(GetShoppingEligibilityDetailsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CommerceInternalsPageProxy
    : public CommerceInternalsPage {
 public:
  using InterfaceType = CommerceInternalsPage;

  explicit CommerceInternalsPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnShoppingListEligibilityChanged(bool eligible) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CommerceInternalsHandlerFactoryStubDispatch {
 public:
  static bool Accept(CommerceInternalsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommerceInternalsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommerceInternalsHandlerFactory>>
class CommerceInternalsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommerceInternalsHandlerFactoryStub() = default;
  ~CommerceInternalsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommerceInternalsHandlerStubDispatch {
 public:
  static bool Accept(CommerceInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommerceInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommerceInternalsHandler>>
class CommerceInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommerceInternalsHandlerStub() = default;
  ~CommerceInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommerceInternalsPageStubDispatch {
 public:
  static bool Accept(CommerceInternalsPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommerceInternalsPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommerceInternalsPage>>
class CommerceInternalsPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommerceInternalsPageStub() = default;
  ~CommerceInternalsPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommerceInternalsPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommerceInternalsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommerceInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommerceInternalsPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommerceInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  EligibilityDetail {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EligibilityDetail, T>::value>;
  using DataView = EligibilityDetailDataView;
  using Data_ = internal::EligibilityDetail_Data;

  template <typename... Args>
  static EligibilityDetailPtr New(Args&&... args) {
    return EligibilityDetailPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EligibilityDetailPtr From(const U& u) {
    return mojo::TypeConverter<EligibilityDetailPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EligibilityDetail>::Convert(*this);
  }


  EligibilityDetail();

  EligibilityDetail(
      const std::string& name,
      bool value,
      bool expected_value);


  ~EligibilityDetail();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EligibilityDetailPtr>
  EligibilityDetailPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EligibilityDetail::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EligibilityDetail::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EligibilityDetail::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EligibilityDetail_UnserializedMessageContext<
            UserType, EligibilityDetail::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EligibilityDetail::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EligibilityDetail::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EligibilityDetail_UnserializedMessageContext<
            UserType, EligibilityDetail::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EligibilityDetail::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  bool value;
  
  bool expected_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EligibilityDetail::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  ShoppingEligibilityDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ShoppingEligibilityDetails, T>::value>;
  using DataView = ShoppingEligibilityDetailsDataView;
  using Data_ = internal::ShoppingEligibilityDetails_Data;

  template <typename... Args>
  static ShoppingEligibilityDetailsPtr New(Args&&... args) {
    return ShoppingEligibilityDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ShoppingEligibilityDetailsPtr From(const U& u) {
    return mojo::TypeConverter<ShoppingEligibilityDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ShoppingEligibilityDetails>::Convert(*this);
  }


  ShoppingEligibilityDetails();

  ShoppingEligibilityDetails(
      const std::string& country,
      const std::string& locale,
      std::vector<EligibilityDetailPtr> details);

ShoppingEligibilityDetails(const ShoppingEligibilityDetails&) = delete;
ShoppingEligibilityDetails& operator=(const ShoppingEligibilityDetails&) = delete;

  ~ShoppingEligibilityDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ShoppingEligibilityDetailsPtr>
  ShoppingEligibilityDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShoppingEligibilityDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ShoppingEligibilityDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ShoppingEligibilityDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ShoppingEligibilityDetails_UnserializedMessageContext<
            UserType, ShoppingEligibilityDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ShoppingEligibilityDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ShoppingEligibilityDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ShoppingEligibilityDetails_UnserializedMessageContext<
            UserType, ShoppingEligibilityDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ShoppingEligibilityDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string country;
  
  std::string locale;
  
  std::vector<EligibilityDetailPtr> details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Subscription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Subscription, T>::value>;
  using DataView = SubscriptionDataView;
  using Data_ = internal::Subscription_Data;

  template <typename... Args>
  static SubscriptionPtr New(Args&&... args) {
    return SubscriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubscriptionPtr From(const U& u) {
    return mojo::TypeConverter<SubscriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Subscription>::Convert(*this);
  }


  Subscription();

  Subscription(
      uint64_t cluster_id,
      std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> product_infos);

Subscription(const Subscription&) = delete;
Subscription& operator=(const Subscription&) = delete;

  ~Subscription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubscriptionPtr>
  SubscriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Subscription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Subscription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Subscription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Subscription::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Subscription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Subscription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Subscription_UnserializedMessageContext<
            UserType, Subscription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Subscription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Subscription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Subscription_UnserializedMessageContext<
            UserType, Subscription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Subscription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t cluster_id;
  
  std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> product_infos;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Subscription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Subscription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Subscription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Subscription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProductSpecificationsSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProductSpecificationsSet, T>::value>;
  using DataView = ProductSpecificationsSetDataView;
  using Data_ = internal::ProductSpecificationsSet_Data;

  template <typename... Args>
  static ProductSpecificationsSetPtr New(Args&&... args) {
    return ProductSpecificationsSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProductSpecificationsSetPtr From(const U& u) {
    return mojo::TypeConverter<ProductSpecificationsSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProductSpecificationsSet>::Convert(*this);
  }


  ProductSpecificationsSet();

  ProductSpecificationsSet(
      const std::string& uuid,
      const std::string& name,
      const std::string& creation_time,
      const std::string& update_time,
      std::vector<::shopping_service::mojom::UrlInfoPtr> url_infos);

ProductSpecificationsSet(const ProductSpecificationsSet&) = delete;
ProductSpecificationsSet& operator=(const ProductSpecificationsSet&) = delete;

  ~ProductSpecificationsSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProductSpecificationsSetPtr>
  ProductSpecificationsSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProductSpecificationsSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProductSpecificationsSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProductSpecificationsSet_UnserializedMessageContext<
            UserType, ProductSpecificationsSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProductSpecificationsSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProductSpecificationsSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProductSpecificationsSet_UnserializedMessageContext<
            UserType, ProductSpecificationsSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProductSpecificationsSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string uuid;
  
  std::string name;
  
  std::string creation_time;
  
  std::string update_time;
  
  std::vector<::shopping_service::mojom::UrlInfoPtr> url_infos;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EligibilityDetailPtr EligibilityDetail::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value),
      mojo::Clone(expected_value)
  );
}

template <typename T, EligibilityDetail::EnableIfSame<T>*>
bool EligibilityDetail::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->expected_value, other_struct.expected_value))
    return false;
  return true;
}

template <typename T, EligibilityDetail::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.expected_value < rhs.expected_value)
    return true;
  if (rhs.expected_value < lhs.expected_value)
    return false;
  return false;
}
template <typename StructPtrType>
ShoppingEligibilityDetailsPtr ShoppingEligibilityDetails::Clone() const {
  return New(
      mojo::Clone(country),
      mojo::Clone(locale),
      mojo::Clone(details)
  );
}

template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>*>
bool ShoppingEligibilityDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->country, other_struct.country))
    return false;
  if (!mojo::Equals(this->locale, other_struct.locale))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, ShoppingEligibilityDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.country < rhs.country)
    return true;
  if (rhs.country < lhs.country)
    return false;
  if (lhs.locale < rhs.locale)
    return true;
  if (rhs.locale < lhs.locale)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}
template <typename StructPtrType>
SubscriptionPtr Subscription::Clone() const {
  return New(
      mojo::Clone(cluster_id),
      mojo::Clone(product_infos)
  );
}

template <typename T, Subscription::EnableIfSame<T>*>
bool Subscription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cluster_id, other_struct.cluster_id))
    return false;
  if (!mojo::Equals(this->product_infos, other_struct.product_infos))
    return false;
  return true;
}

template <typename T, Subscription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cluster_id < rhs.cluster_id)
    return true;
  if (rhs.cluster_id < lhs.cluster_id)
    return false;
  if (lhs.product_infos < rhs.product_infos)
    return true;
  if (rhs.product_infos < lhs.product_infos)
    return false;
  return false;
}
template <typename StructPtrType>
ProductSpecificationsSetPtr ProductSpecificationsSet::Clone() const {
  return New(
      mojo::Clone(uuid),
      mojo::Clone(name),
      mojo::Clone(creation_time),
      mojo::Clone(update_time),
      mojo::Clone(url_infos)
  );
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>*>
bool ProductSpecificationsSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->update_time, other_struct.update_time))
    return false;
  if (!mojo::Equals(this->url_infos, other_struct.url_infos))
    return false;
  return true;
}

template <typename T, ProductSpecificationsSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.update_time < rhs.update_time)
    return true;
  if (rhs.update_time < lhs.update_time)
    return false;
  if (lhs.url_infos < rhs.url_infos)
    return true;
  if (rhs.url_infos < lhs.url_infos)
    return false;
  return false;
}


}  // commerce::mojom

namespace mojo {


template <>
struct  StructTraits<::commerce::mojom::EligibilityDetail::DataView,
                                         ::commerce::mojom::EligibilityDetailPtr> {
  static bool IsNull(const ::commerce::mojom::EligibilityDetailPtr& input) { return !input; }
  static void SetToNull(::commerce::mojom::EligibilityDetailPtr* output) { output->reset(); }

  static const decltype(::commerce::mojom::EligibilityDetail::name)& name(
      const ::commerce::mojom::EligibilityDetailPtr& input) {
    return input->name;
  }

  static decltype(::commerce::mojom::EligibilityDetail::value) value(
      const ::commerce::mojom::EligibilityDetailPtr& input) {
    return input->value;
  }

  static decltype(::commerce::mojom::EligibilityDetail::expected_value) expected_value(
      const ::commerce::mojom::EligibilityDetailPtr& input) {
    return input->expected_value;
  }

  static bool Read(::commerce::mojom::EligibilityDetail::DataView input, ::commerce::mojom::EligibilityDetailPtr* output);
};


template <>
struct  StructTraits<::commerce::mojom::ShoppingEligibilityDetails::DataView,
                                         ::commerce::mojom::ShoppingEligibilityDetailsPtr> {
  static bool IsNull(const ::commerce::mojom::ShoppingEligibilityDetailsPtr& input) { return !input; }
  static void SetToNull(::commerce::mojom::ShoppingEligibilityDetailsPtr* output) { output->reset(); }

  static const decltype(::commerce::mojom::ShoppingEligibilityDetails::country)& country(
      const ::commerce::mojom::ShoppingEligibilityDetailsPtr& input) {
    return input->country;
  }

  static const decltype(::commerce::mojom::ShoppingEligibilityDetails::locale)& locale(
      const ::commerce::mojom::ShoppingEligibilityDetailsPtr& input) {
    return input->locale;
  }

  static const decltype(::commerce::mojom::ShoppingEligibilityDetails::details)& details(
      const ::commerce::mojom::ShoppingEligibilityDetailsPtr& input) {
    return input->details;
  }

  static bool Read(::commerce::mojom::ShoppingEligibilityDetails::DataView input, ::commerce::mojom::ShoppingEligibilityDetailsPtr* output);
};


template <>
struct  StructTraits<::commerce::mojom::Subscription::DataView,
                                         ::commerce::mojom::SubscriptionPtr> {
  static bool IsNull(const ::commerce::mojom::SubscriptionPtr& input) { return !input; }
  static void SetToNull(::commerce::mojom::SubscriptionPtr* output) { output->reset(); }

  static decltype(::commerce::mojom::Subscription::cluster_id) cluster_id(
      const ::commerce::mojom::SubscriptionPtr& input) {
    return input->cluster_id;
  }

  static const decltype(::commerce::mojom::Subscription::product_infos)& product_infos(
      const ::commerce::mojom::SubscriptionPtr& input) {
    return input->product_infos;
  }

  static bool Read(::commerce::mojom::Subscription::DataView input, ::commerce::mojom::SubscriptionPtr* output);
};


template <>
struct  StructTraits<::commerce::mojom::ProductSpecificationsSet::DataView,
                                         ::commerce::mojom::ProductSpecificationsSetPtr> {
  static bool IsNull(const ::commerce::mojom::ProductSpecificationsSetPtr& input) { return !input; }
  static void SetToNull(::commerce::mojom::ProductSpecificationsSetPtr* output) { output->reset(); }

  static const decltype(::commerce::mojom::ProductSpecificationsSet::uuid)& uuid(
      const ::commerce::mojom::ProductSpecificationsSetPtr& input) {
    return input->uuid;
  }

  static const decltype(::commerce::mojom::ProductSpecificationsSet::name)& name(
      const ::commerce::mojom::ProductSpecificationsSetPtr& input) {
    return input->name;
  }

  static const decltype(::commerce::mojom::ProductSpecificationsSet::creation_time)& creation_time(
      const ::commerce::mojom::ProductSpecificationsSetPtr& input) {
    return input->creation_time;
  }

  static const decltype(::commerce::mojom::ProductSpecificationsSet::update_time)& update_time(
      const ::commerce::mojom::ProductSpecificationsSetPtr& input) {
    return input->update_time;
  }

  static const decltype(::commerce::mojom::ProductSpecificationsSet::url_infos)& url_infos(
      const ::commerce::mojom::ProductSpecificationsSetPtr& input) {
    return input->url_infos;
  }

  static bool Read(::commerce::mojom::ProductSpecificationsSet::DataView input, ::commerce::mojom::ProductSpecificationsSetPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_H_