// components/commerce/core/internals/mojom/commerce_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/commerce/core/internals/mojom/commerce_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/internals/mojom/commerce_internals.mojom-params-data.h"
#include "components/commerce/core/internals/mojom/commerce_internals.mojom-shared-message-ids.h"

#include "components/commerce/core/internals/mojom/commerce_internals.mojom-import-headers.h"
#include "components/commerce/core/internals/mojom/commerce_internals.mojom-test-utils.h"


namespace commerce::mojom {
EligibilityDetail::EligibilityDetail()
    : name(),
      value(),
      expected_value() {}

EligibilityDetail::EligibilityDetail(
    const std::string& name_in,
    bool value_in,
    bool expected_value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)),
      expected_value(std::move(expected_value_in)) {}

EligibilityDetail::~EligibilityDetail() = default;
size_t EligibilityDetail::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  seed = mojo::internal::Hash(seed, this->expected_value);
  return seed;
}

void EligibilityDetail::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_value"), this->expected_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EligibilityDetail::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ShoppingEligibilityDetails::ShoppingEligibilityDetails()
    : country(),
      locale(),
      details() {}

ShoppingEligibilityDetails::ShoppingEligibilityDetails(
    const std::string& country_in,
    const std::string& locale_in,
    std::vector<EligibilityDetailPtr> details_in)
    : country(std::move(country_in)),
      locale(std::move(locale_in)),
      details(std::move(details_in)) {}

ShoppingEligibilityDetails::~ShoppingEligibilityDetails() = default;

void ShoppingEligibilityDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "country"), this->country,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locale"), this->locale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<EligibilityDetailPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ShoppingEligibilityDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Subscription::Subscription()
    : cluster_id(),
      product_infos() {}

Subscription::Subscription(
    uint64_t cluster_id_in,
    std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr> product_infos_in)
    : cluster_id(std::move(cluster_id_in)),
      product_infos(std::move(product_infos_in)) {}

Subscription::~Subscription() = default;

void Subscription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cluster_id"), this->cluster_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_infos"), this->product_infos,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::commerce::shared::mojom::BookmarkProductInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Subscription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProductSpecificationsSet::ProductSpecificationsSet()
    : uuid(),
      name(),
      creation_time(),
      update_time(),
      url_infos() {}

ProductSpecificationsSet::ProductSpecificationsSet(
    const std::string& uuid_in,
    const std::string& name_in,
    const std::string& creation_time_in,
    const std::string& update_time_in,
    std::vector<::shopping_service::mojom::UrlInfoPtr> url_infos_in)
    : uuid(std::move(uuid_in)),
      name(std::move(name_in)),
      creation_time(std::move(creation_time_in)),
      update_time(std::move(update_time_in)),
      url_infos(std::move(url_infos_in)) {}

ProductSpecificationsSet::~ProductSpecificationsSet() = default;

void ProductSpecificationsSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuid"), this->uuid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_time"), this->creation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_time"), this->update_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_infos"), this->url_infos,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::shopping_service::mojom::UrlInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProductSpecificationsSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CommerceInternalsHandlerFactory::IPCStableHashFunction CommerceInternalsHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommerceInternalsHandlerFactory>(message.name())) {
    case messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler: {
      return &CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommerceInternalsHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommerceInternalsHandlerFactory>(message.name())) {
      case messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler:
            return "Receive commerce::mojom::CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler";
    }
  } else {
    switch (static_cast<messages::CommerceInternalsHandlerFactory>(message.name())) {
      case messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler:
            return "Receive reply commerce::mojom::CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63ebea0d;  // IPCStableHash for commerce::mojom::CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CommerceInternalsHandlerFactoryProxy::CommerceInternalsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommerceInternalsHandlerFactoryProxy::CreateCommerceInternalsHandler(
    ::mojo::PendingRemote<CommerceInternalsPage> in_page, ::mojo::PendingReceiver<CommerceInternalsHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::mojom::CommerceInternalsHandlerFactory::CreateCommerceInternalsHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<CommerceInternalsPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CommerceInternalsHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::commerce::mojom::CommerceInternalsPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in CommerceInternalsHandlerFactory.CreateCommerceInternalsHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::commerce::mojom::CommerceInternalsHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CommerceInternalsHandlerFactory.CreateCommerceInternalsHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandlerFactory::Name_);
  message.set_method_name("CreateCommerceInternalsHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CommerceInternalsHandlerFactoryStubDispatch::Accept(
    CommerceInternalsHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommerceInternalsHandlerFactory>(message->header()->name)) {
    case messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler: {
      DCHECK(message->is_serialized());
      internal::CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params_Data* params =
          reinterpret_cast<internal::CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommerceInternalsHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<CommerceInternalsPage> p_page{};
      ::mojo::PendingReceiver<CommerceInternalsHandler> p_handler{};
      CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCommerceInternalsHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CommerceInternalsHandlerFactoryStubDispatch::AcceptWithResponder(
    CommerceInternalsHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommerceInternalsHandlerFactory>(message->header()->name)) {
    case messages::CommerceInternalsHandlerFactory::kCreateCommerceInternalsHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCommerceInternalsHandlerFactoryValidationInfo[] = {
    { &internal::CommerceInternalsHandlerFactory_CreateCommerceInternalsHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CommerceInternalsHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::mojom::CommerceInternalsHandlerFactory::Name_,
    kCommerceInternalsHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CommerceInternalsHandler::IPCStableHashFunction CommerceInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommerceInternalsHandler>(message.name())) {
    case messages::CommerceInternalsHandler::kGetIsShoppingListEligible: {
      return &CommerceInternalsHandler::GetIsShoppingListEligible_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref: {
      return &CommerceInternalsHandler::ResetPriceTrackingEmailPref_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kGetProductInfoForUrl: {
      return &CommerceInternalsHandler::GetProductInfoForUrl_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kGetSubscriptionDetails: {
      return &CommerceInternalsHandler::GetSubscriptionDetails_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kGetProductSpecificationsDetails: {
      return &CommerceInternalsHandler::GetProductSpecificationsDetails_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kResetProductSpecifications: {
      return &CommerceInternalsHandler::ResetProductSpecifications_Sym::IPCStableHash;
    }
    case messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails: {
      return &CommerceInternalsHandler::GetShoppingEligibilityDetails_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommerceInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommerceInternalsHandler>(message.name())) {
      case messages::CommerceInternalsHandler::kGetIsShoppingListEligible:
            return "Receive commerce::mojom::CommerceInternalsHandler::GetIsShoppingListEligible";
      case messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref:
            return "Receive commerce::mojom::CommerceInternalsHandler::ResetPriceTrackingEmailPref";
      case messages::CommerceInternalsHandler::kGetProductInfoForUrl:
            return "Receive commerce::mojom::CommerceInternalsHandler::GetProductInfoForUrl";
      case messages::CommerceInternalsHandler::kGetSubscriptionDetails:
            return "Receive commerce::mojom::CommerceInternalsHandler::GetSubscriptionDetails";
      case messages::CommerceInternalsHandler::kGetProductSpecificationsDetails:
            return "Receive commerce::mojom::CommerceInternalsHandler::GetProductSpecificationsDetails";
      case messages::CommerceInternalsHandler::kResetProductSpecifications:
            return "Receive commerce::mojom::CommerceInternalsHandler::ResetProductSpecifications";
      case messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails:
            return "Receive commerce::mojom::CommerceInternalsHandler::GetShoppingEligibilityDetails";
    }
  } else {
    switch (static_cast<messages::CommerceInternalsHandler>(message.name())) {
      case messages::CommerceInternalsHandler::kGetIsShoppingListEligible:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::GetIsShoppingListEligible";
      case messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::ResetPriceTrackingEmailPref";
      case messages::CommerceInternalsHandler::kGetProductInfoForUrl:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::GetProductInfoForUrl";
      case messages::CommerceInternalsHandler::kGetSubscriptionDetails:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::GetSubscriptionDetails";
      case messages::CommerceInternalsHandler::kGetProductSpecificationsDetails:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::GetProductSpecificationsDetails";
      case messages::CommerceInternalsHandler::kResetProductSpecifications:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::ResetProductSpecifications";
      case messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails:
            return "Receive reply commerce::mojom::CommerceInternalsHandler::GetShoppingEligibilityDetails";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommerceInternalsHandler::GetIsShoppingListEligible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbdeb528;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::GetIsShoppingListEligible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::ResetPriceTrackingEmailPref_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd544db3;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::ResetPriceTrackingEmailPref
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::GetProductInfoForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x564c4a40;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::GetProductInfoForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::GetSubscriptionDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f5cc048;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::GetSubscriptionDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::GetProductSpecificationsDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54dff45e;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::GetProductSpecificationsDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::ResetProductSpecifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x666ded14;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::ResetProductSpecifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommerceInternalsHandler::GetShoppingEligibilityDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6408a12f;  // IPCStableHash for commerce::mojom::CommerceInternalsHandler::GetShoppingEligibilityDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback(
      CommerceInternalsHandler::GetIsShoppingListEligibleCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback(const CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback&) = delete;
  CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback& operator=(const CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommerceInternalsHandler::GetIsShoppingListEligibleCallback callback_;
};

class CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback(
      CommerceInternalsHandler::GetProductInfoForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback(const CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback&) = delete;
  CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback& operator=(const CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommerceInternalsHandler::GetProductInfoForUrlCallback callback_;
};

class CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback(
      CommerceInternalsHandler::GetSubscriptionDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback(const CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback&) = delete;
  CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback& operator=(const CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommerceInternalsHandler::GetSubscriptionDetailsCallback callback_;
};

class CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback(
      CommerceInternalsHandler::GetProductSpecificationsDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback(const CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback&) = delete;
  CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback& operator=(const CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommerceInternalsHandler::GetProductSpecificationsDetailsCallback callback_;
};

class CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback(
      CommerceInternalsHandler::GetShoppingEligibilityDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback(const CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback&) = delete;
  CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback& operator=(const CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommerceInternalsHandler::GetShoppingEligibilityDetailsCallback callback_;
};

CommerceInternalsHandlerProxy::CommerceInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommerceInternalsHandlerProxy::GetIsShoppingListEligible(
    GetIsShoppingListEligibleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::GetIsShoppingListEligible");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetIsShoppingListEligible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetIsShoppingListEligible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetIsShoppingListEligible");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommerceInternalsHandlerProxy::ResetPriceTrackingEmailPref(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::ResetPriceTrackingEmailPref");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("ResetPriceTrackingEmailPref");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommerceInternalsHandlerProxy::GetProductInfoForUrl(
    const ::GURL& in_url, GetProductInfoForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::mojom::CommerceInternalsHandler::GetProductInfoForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetProductInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetProductInfoForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in CommerceInternalsHandler.GetProductInfoForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetProductInfoForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommerceInternalsHandlerProxy::GetSubscriptionDetails(
    GetSubscriptionDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::GetSubscriptionDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetSubscriptionDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetSubscriptionDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetSubscriptionDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommerceInternalsHandlerProxy::GetProductSpecificationsDetails(
    GetProductSpecificationsDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::GetProductSpecificationsDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetProductSpecificationsDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetProductSpecificationsDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetProductSpecificationsDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommerceInternalsHandlerProxy::ResetProductSpecifications(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::ResetProductSpecifications");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kResetProductSpecifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_ResetProductSpecifications_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("ResetProductSpecifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CommerceInternalsHandlerProxy::GetShoppingEligibilityDetails(
    GetShoppingEligibilityDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send commerce::mojom::CommerceInternalsHandler::GetShoppingEligibilityDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetShoppingEligibilityDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommerceInternalsHandler::GetIsShoppingListEligibleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder> proxy(
        new CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommerceInternalsHandler::GetIsShoppingListEligibleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_eligible);
};

bool CommerceInternalsHandler_GetIsShoppingListEligible_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommerceInternalsHandler.0
  bool success = true;
  bool p_eligible{};
  CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_eligible = input_data_view.eligible();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommerceInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_eligible));
  }
  return true;
}

void CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder::Run(
    bool in_eligible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::mojom::CommerceInternalsHandler::GetIsShoppingListEligible", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetIsShoppingListEligible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->eligible = in_eligible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetIsShoppingListEligible");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommerceInternalsHandler::GetProductInfoForUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder> proxy(
        new CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommerceInternalsHandler::GetProductInfoForUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::commerce::shared::mojom::ProductInfoPtr in_info);
};

bool CommerceInternalsHandler_GetProductInfoForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommerceInternalsHandler.2
  bool success = true;
  ::commerce::shared::mojom::ProductInfoPtr p_info{};
  CommerceInternalsHandler_GetProductInfoForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommerceInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder::Run(
    ::commerce::shared::mojom::ProductInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::mojom::CommerceInternalsHandler::GetProductInfoForUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::commerce::shared::mojom::ProductInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetProductInfoForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::shared::mojom::ProductInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetProductInfoForUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommerceInternalsHandler::GetSubscriptionDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder> proxy(
        new CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommerceInternalsHandler::GetSubscriptionDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SubscriptionPtr> in_subscriptions);
};

bool CommerceInternalsHandler_GetSubscriptionDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommerceInternalsHandler.3
  bool success = true;
  std::vector<SubscriptionPtr> p_subscriptions{};
  CommerceInternalsHandler_GetSubscriptionDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubscriptions(&p_subscriptions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommerceInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_subscriptions));
  }
  return true;
}

void CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder::Run(
    std::vector<SubscriptionPtr> in_subscriptions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::mojom::CommerceInternalsHandler::GetSubscriptionDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscriptions"), in_subscriptions,
                        "<value of type std::vector<SubscriptionPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetSubscriptionDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subscriptions)::BaseType>
      subscriptions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& subscriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::mojom::SubscriptionDataView>>(
    in_subscriptions,
    subscriptions_fragment,
    &subscriptions_validate_params);

  params->subscriptions.Set(
      subscriptions_fragment.is_null() ? nullptr : subscriptions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subscriptions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subscriptions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetSubscriptionDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommerceInternalsHandler::GetProductSpecificationsDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder> proxy(
        new CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommerceInternalsHandler::GetProductSpecificationsDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ProductSpecificationsSetPtr> in_product_specifications_set);
};

bool CommerceInternalsHandler_GetProductSpecificationsDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommerceInternalsHandler.4
  bool success = true;
  std::vector<ProductSpecificationsSetPtr> p_product_specifications_set{};
  CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProductSpecificationsSet(&p_product_specifications_set))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommerceInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_product_specifications_set));
  }
  return true;
}

void CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder::Run(
    std::vector<ProductSpecificationsSetPtr> in_product_specifications_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::mojom::CommerceInternalsHandler::GetProductSpecificationsDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("product_specifications_set"), in_product_specifications_set,
                        "<value of type std::vector<ProductSpecificationsSetPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetProductSpecificationsDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->product_specifications_set)::BaseType>
      product_specifications_set_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& product_specifications_set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::commerce::mojom::ProductSpecificationsSetDataView>>(
    in_product_specifications_set,
    product_specifications_set_fragment,
    &product_specifications_set_validate_params);

  params->product_specifications_set.Set(
      product_specifications_set_fragment.is_null() ? nullptr : product_specifications_set_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->product_specifications_set.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null product_specifications_set in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetProductSpecificationsDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommerceInternalsHandler::GetShoppingEligibilityDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder> proxy(
        new CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommerceInternalsHandler::GetShoppingEligibilityDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ShoppingEligibilityDetailsPtr in_details);
};

bool CommerceInternalsHandler_GetShoppingEligibilityDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommerceInternalsHandler.6
  bool success = true;
  ShoppingEligibilityDetailsPtr p_details{};
  CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDetails(&p_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommerceInternalsHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_details));
  }
  return true;
}

void CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder::Run(
    ShoppingEligibilityDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply commerce::mojom::CommerceInternalsHandler::GetShoppingEligibilityDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ShoppingEligibilityDetailsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::commerce::mojom::ShoppingEligibilityDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsHandler::Name_);
  message.set_method_name("GetShoppingEligibilityDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CommerceInternalsHandlerStubDispatch::Accept(
    CommerceInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommerceInternalsHandler>(message->header()->name)) {
    case messages::CommerceInternalsHandler::kGetIsShoppingListEligible: {
      break;
    }
    case messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref: {
      DCHECK(message->is_serialized());
      internal::CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params_Data* params =
          reinterpret_cast<internal::CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.1
      bool success = true;
      CommerceInternalsHandler_ResetPriceTrackingEmailPref_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetPriceTrackingEmailPref(        );
      return true;
    }
    case messages::CommerceInternalsHandler::kGetProductInfoForUrl: {
      break;
    }
    case messages::CommerceInternalsHandler::kGetSubscriptionDetails: {
      break;
    }
    case messages::CommerceInternalsHandler::kGetProductSpecificationsDetails: {
      break;
    }
    case messages::CommerceInternalsHandler::kResetProductSpecifications: {
      DCHECK(message->is_serialized());
      internal::CommerceInternalsHandler_ResetProductSpecifications_Params_Data* params =
          reinterpret_cast<internal::CommerceInternalsHandler_ResetProductSpecifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.5
      bool success = true;
      CommerceInternalsHandler_ResetProductSpecifications_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetProductSpecifications(        );
      return true;
    }
    case messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails: {
      break;
    }
  }
  return false;
}

// static
bool CommerceInternalsHandlerStubDispatch::AcceptWithResponder(
    CommerceInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommerceInternalsHandler>(message->header()->name)) {
    case messages::CommerceInternalsHandler::kGetIsShoppingListEligible: {
      internal::CommerceInternalsHandler_GetIsShoppingListEligible_Params_Data* params =
          reinterpret_cast<
              internal::CommerceInternalsHandler_GetIsShoppingListEligible_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.0
      bool success = true;
      CommerceInternalsHandler_GetIsShoppingListEligible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          CommerceInternalsHandler_GetIsShoppingListEligible_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsShoppingListEligible(std::move(callback));
      return true;
    }
    case messages::CommerceInternalsHandler::kResetPriceTrackingEmailPref: {
      break;
    }
    case messages::CommerceInternalsHandler::kGetProductInfoForUrl: {
      internal::CommerceInternalsHandler_GetProductInfoForUrl_Params_Data* params =
          reinterpret_cast<
              internal::CommerceInternalsHandler_GetProductInfoForUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.2
      bool success = true;
      ::GURL p_url{};
      CommerceInternalsHandler_GetProductInfoForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          CommerceInternalsHandler_GetProductInfoForUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductInfoForUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::CommerceInternalsHandler::kGetSubscriptionDetails: {
      internal::CommerceInternalsHandler_GetSubscriptionDetails_Params_Data* params =
          reinterpret_cast<
              internal::CommerceInternalsHandler_GetSubscriptionDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.3
      bool success = true;
      CommerceInternalsHandler_GetSubscriptionDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          CommerceInternalsHandler_GetSubscriptionDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubscriptionDetails(std::move(callback));
      return true;
    }
    case messages::CommerceInternalsHandler::kGetProductSpecificationsDetails: {
      internal::CommerceInternalsHandler_GetProductSpecificationsDetails_Params_Data* params =
          reinterpret_cast<
              internal::CommerceInternalsHandler_GetProductSpecificationsDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.4
      bool success = true;
      CommerceInternalsHandler_GetProductSpecificationsDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          CommerceInternalsHandler_GetProductSpecificationsDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProductSpecificationsDetails(std::move(callback));
      return true;
    }
    case messages::CommerceInternalsHandler::kResetProductSpecifications: {
      break;
    }
    case messages::CommerceInternalsHandler::kGetShoppingEligibilityDetails: {
      internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_Params_Data* params =
          reinterpret_cast<
              internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommerceInternalsHandler.6
      bool success = true;
      CommerceInternalsHandler_GetShoppingEligibilityDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          CommerceInternalsHandler_GetShoppingEligibilityDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetShoppingEligibilityDetails(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCommerceInternalsHandlerValidationInfo[] = {
    { &internal::CommerceInternalsHandler_GetIsShoppingListEligible_Params_Data::Validate,
     &internal::CommerceInternalsHandler_GetIsShoppingListEligible_ResponseParams_Data::Validate},
    { &internal::CommerceInternalsHandler_ResetPriceTrackingEmailPref_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CommerceInternalsHandler_GetProductInfoForUrl_Params_Data::Validate,
     &internal::CommerceInternalsHandler_GetProductInfoForUrl_ResponseParams_Data::Validate},
    { &internal::CommerceInternalsHandler_GetSubscriptionDetails_Params_Data::Validate,
     &internal::CommerceInternalsHandler_GetSubscriptionDetails_ResponseParams_Data::Validate},
    { &internal::CommerceInternalsHandler_GetProductSpecificationsDetails_Params_Data::Validate,
     &internal::CommerceInternalsHandler_GetProductSpecificationsDetails_ResponseParams_Data::Validate},
    { &internal::CommerceInternalsHandler_ResetProductSpecifications_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_Params_Data::Validate,
     &internal::CommerceInternalsHandler_GetShoppingEligibilityDetails_ResponseParams_Data::Validate},
};

bool CommerceInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::mojom::CommerceInternalsHandler::Name_,
    kCommerceInternalsHandlerValidationInfo);
}

bool CommerceInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::commerce::mojom::CommerceInternalsHandler::Name_,
    kCommerceInternalsHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

CommerceInternalsPage::IPCStableHashFunction CommerceInternalsPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommerceInternalsPage>(message.name())) {
    case messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged: {
      return &CommerceInternalsPage::OnShoppingListEligibilityChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommerceInternalsPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommerceInternalsPage>(message.name())) {
      case messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged:
            return "Receive commerce::mojom::CommerceInternalsPage::OnShoppingListEligibilityChanged";
    }
  } else {
    switch (static_cast<messages::CommerceInternalsPage>(message.name())) {
      case messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged:
            return "Receive reply commerce::mojom::CommerceInternalsPage::OnShoppingListEligibilityChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommerceInternalsPage::OnShoppingListEligibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f486714;  // IPCStableHash for commerce::mojom::CommerceInternalsPage::OnShoppingListEligibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CommerceInternalsPageProxy::CommerceInternalsPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommerceInternalsPageProxy::OnShoppingListEligibilityChanged(
    bool in_eligible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send commerce::mojom::CommerceInternalsPage::OnShoppingListEligibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::commerce::mojom::internal::CommerceInternalsPage_OnShoppingListEligibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->eligible = in_eligible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommerceInternalsPage::Name_);
  message.set_method_name("OnShoppingListEligibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CommerceInternalsPageStubDispatch::Accept(
    CommerceInternalsPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommerceInternalsPage>(message->header()->name)) {
    case messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged: {
      DCHECK(message->is_serialized());
      internal::CommerceInternalsPage_OnShoppingListEligibilityChanged_Params_Data* params =
          reinterpret_cast<internal::CommerceInternalsPage_OnShoppingListEligibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommerceInternalsPage.0
      bool success = true;
      bool p_eligible{};
      CommerceInternalsPage_OnShoppingListEligibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_eligible = input_data_view.eligible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommerceInternalsPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShoppingListEligibilityChanged(        
        std::move(p_eligible));
      return true;
    }
  }
  return false;
}

// static
bool CommerceInternalsPageStubDispatch::AcceptWithResponder(
    CommerceInternalsPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommerceInternalsPage>(message->header()->name)) {
    case messages::CommerceInternalsPage::kOnShoppingListEligibilityChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCommerceInternalsPageValidationInfo[] = {
    { &internal::CommerceInternalsPage_OnShoppingListEligibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool CommerceInternalsPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::commerce::mojom::CommerceInternalsPage::Name_,
    kCommerceInternalsPageValidationInfo);
}



}  // commerce::mojom


namespace mojo {


// static
bool StructTraits<::commerce::mojom::EligibilityDetail::DataView, ::commerce::mojom::EligibilityDetailPtr>::Read(
    ::commerce::mojom::EligibilityDetail::DataView input,
    ::commerce::mojom::EligibilityDetailPtr* output) {
  bool success = true;
  ::commerce::mojom::EligibilityDetailPtr result(::commerce::mojom::EligibilityDetail::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->value = input.value();
      if (success)
        result->expected_value = input.expected_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::commerce::mojom::ShoppingEligibilityDetails::DataView, ::commerce::mojom::ShoppingEligibilityDetailsPtr>::Read(
    ::commerce::mojom::ShoppingEligibilityDetails::DataView input,
    ::commerce::mojom::ShoppingEligibilityDetailsPtr* output) {
  bool success = true;
  ::commerce::mojom::ShoppingEligibilityDetailsPtr result(::commerce::mojom::ShoppingEligibilityDetails::New());
  
      if (success && !input.ReadCountry(&result->country))
        success = false;
      if (success && !input.ReadLocale(&result->locale))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::commerce::mojom::Subscription::DataView, ::commerce::mojom::SubscriptionPtr>::Read(
    ::commerce::mojom::Subscription::DataView input,
    ::commerce::mojom::SubscriptionPtr* output) {
  bool success = true;
  ::commerce::mojom::SubscriptionPtr result(::commerce::mojom::Subscription::New());
  
      if (success)
        result->cluster_id = input.cluster_id();
      if (success && !input.ReadProductInfos(&result->product_infos))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::commerce::mojom::ProductSpecificationsSet::DataView, ::commerce::mojom::ProductSpecificationsSetPtr>::Read(
    ::commerce::mojom::ProductSpecificationsSet::DataView input,
    ::commerce::mojom::ProductSpecificationsSetPtr* output) {
  bool success = true;
  ::commerce::mojom::ProductSpecificationsSetPtr result(::commerce::mojom::ProductSpecificationsSet::New());
  
      if (success && !input.ReadUuid(&result->uuid))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadCreationTime(&result->creation_time))
        success = false;
      if (success && !input.ReadUpdateTime(&result->update_time))
        success = false;
      if (success && !input.ReadUrlInfos(&result->url_infos))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace commerce::mojom {


void CommerceInternalsHandlerFactoryInterceptorForTesting::CreateCommerceInternalsHandler(::mojo::PendingRemote<CommerceInternalsPage> page, ::mojo::PendingReceiver<CommerceInternalsHandler> handler) {
  GetForwardingInterface()->CreateCommerceInternalsHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
CommerceInternalsHandlerFactoryAsyncWaiter::CommerceInternalsHandlerFactoryAsyncWaiter(
    CommerceInternalsHandlerFactory* proxy) : proxy_(proxy) {}

CommerceInternalsHandlerFactoryAsyncWaiter::~CommerceInternalsHandlerFactoryAsyncWaiter() = default;





void CommerceInternalsHandlerInterceptorForTesting::GetIsShoppingListEligible(GetIsShoppingListEligibleCallback callback) {
  GetForwardingInterface()->GetIsShoppingListEligible(std::move(callback));
}
void CommerceInternalsHandlerInterceptorForTesting::ResetPriceTrackingEmailPref() {
  GetForwardingInterface()->ResetPriceTrackingEmailPref();
}
void CommerceInternalsHandlerInterceptorForTesting::GetProductInfoForUrl(const ::GURL& url, GetProductInfoForUrlCallback callback) {
  GetForwardingInterface()->GetProductInfoForUrl(
    std::move(url)
    , std::move(callback));
}
void CommerceInternalsHandlerInterceptorForTesting::GetSubscriptionDetails(GetSubscriptionDetailsCallback callback) {
  GetForwardingInterface()->GetSubscriptionDetails(std::move(callback));
}
void CommerceInternalsHandlerInterceptorForTesting::GetProductSpecificationsDetails(GetProductSpecificationsDetailsCallback callback) {
  GetForwardingInterface()->GetProductSpecificationsDetails(std::move(callback));
}
void CommerceInternalsHandlerInterceptorForTesting::ResetProductSpecifications() {
  GetForwardingInterface()->ResetProductSpecifications();
}
void CommerceInternalsHandlerInterceptorForTesting::GetShoppingEligibilityDetails(GetShoppingEligibilityDetailsCallback callback) {
  GetForwardingInterface()->GetShoppingEligibilityDetails(std::move(callback));
}
CommerceInternalsHandlerAsyncWaiter::CommerceInternalsHandlerAsyncWaiter(
    CommerceInternalsHandler* proxy) : proxy_(proxy) {}

CommerceInternalsHandlerAsyncWaiter::~CommerceInternalsHandlerAsyncWaiter() = default;


void CommerceInternalsHandlerAsyncWaiter::GetIsShoppingListEligible(
    bool* out_eligible) {
  base::RunLoop loop;
  proxy_->GetIsShoppingListEligible(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_eligible
,
             bool eligible) {*out_eligible = std::move(eligible);
            loop->Quit();
          },
          &loop,
          out_eligible));
  loop.Run();
}

bool CommerceInternalsHandlerAsyncWaiter::GetIsShoppingListEligible(
    ) {
  bool async_wait_result;
  GetIsShoppingListEligible(&async_wait_result);
  return async_wait_result;
}

void CommerceInternalsHandlerAsyncWaiter::GetProductInfoForUrl(
    const ::GURL& url, ::commerce::shared::mojom::ProductInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetProductInfoForUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::commerce::shared::mojom::ProductInfoPtr* out_info
,
             ::commerce::shared::mojom::ProductInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

::commerce::shared::mojom::ProductInfoPtr CommerceInternalsHandlerAsyncWaiter::GetProductInfoForUrl(
    const ::GURL& url) {
  ::commerce::shared::mojom::ProductInfoPtr async_wait_result;
  GetProductInfoForUrl(std::move(url),&async_wait_result);
  return async_wait_result;
}

void CommerceInternalsHandlerAsyncWaiter::GetSubscriptionDetails(
    std::vector<SubscriptionPtr>* out_subscriptions) {
  base::RunLoop loop;
  proxy_->GetSubscriptionDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SubscriptionPtr>* out_subscriptions
,
             std::vector<SubscriptionPtr> subscriptions) {*out_subscriptions = std::move(subscriptions);
            loop->Quit();
          },
          &loop,
          out_subscriptions));
  loop.Run();
}

std::vector<SubscriptionPtr> CommerceInternalsHandlerAsyncWaiter::GetSubscriptionDetails(
    ) {
  std::vector<SubscriptionPtr> async_wait_result;
  GetSubscriptionDetails(&async_wait_result);
  return async_wait_result;
}

void CommerceInternalsHandlerAsyncWaiter::GetProductSpecificationsDetails(
    std::vector<ProductSpecificationsSetPtr>* out_product_specifications_set) {
  base::RunLoop loop;
  proxy_->GetProductSpecificationsDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ProductSpecificationsSetPtr>* out_product_specifications_set
,
             std::vector<ProductSpecificationsSetPtr> product_specifications_set) {*out_product_specifications_set = std::move(product_specifications_set);
            loop->Quit();
          },
          &loop,
          out_product_specifications_set));
  loop.Run();
}

std::vector<ProductSpecificationsSetPtr> CommerceInternalsHandlerAsyncWaiter::GetProductSpecificationsDetails(
    ) {
  std::vector<ProductSpecificationsSetPtr> async_wait_result;
  GetProductSpecificationsDetails(&async_wait_result);
  return async_wait_result;
}

void CommerceInternalsHandlerAsyncWaiter::GetShoppingEligibilityDetails(
    ShoppingEligibilityDetailsPtr* out_details) {
  base::RunLoop loop;
  proxy_->GetShoppingEligibilityDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             ShoppingEligibilityDetailsPtr* out_details
,
             ShoppingEligibilityDetailsPtr details) {*out_details = std::move(details);
            loop->Quit();
          },
          &loop,
          out_details));
  loop.Run();
}

ShoppingEligibilityDetailsPtr CommerceInternalsHandlerAsyncWaiter::GetShoppingEligibilityDetails(
    ) {
  ShoppingEligibilityDetailsPtr async_wait_result;
  GetShoppingEligibilityDetails(&async_wait_result);
  return async_wait_result;
}




void CommerceInternalsPageInterceptorForTesting::OnShoppingListEligibilityChanged(bool eligible) {
  GetForwardingInterface()->OnShoppingListEligibilityChanged(
    std::move(eligible)
    );
}
CommerceInternalsPageAsyncWaiter::CommerceInternalsPageAsyncWaiter(
    CommerceInternalsPage* proxy) : proxy_(proxy) {}

CommerceInternalsPageAsyncWaiter::~CommerceInternalsPageAsyncWaiter() = default;







}  // commerce::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif