// components/commerce/core/internals/mojom/commerce_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_SHARED_H_
#define COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/commerce/core/internals/mojom/commerce_internals.mojom-shared-internal.h"
#include "components/commerce/core/mojom/shopping_service.mojom-shared.h"
#include "components/commerce/core/mojom/shared.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/commerce/core/internals/mojom/commerce_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::commerce::mojom::EligibilityDetailDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::commerce::mojom::EligibilityDetailDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::commerce::mojom::internal::EligibilityDetail_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in EligibilityDetail struct");

    fragment->value = Traits::value(input);

    fragment->expected_value = Traits::expected_value(input);
  }

  static bool Deserialize(::commerce::mojom::internal::EligibilityDetail_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::commerce::mojom::EligibilityDetailDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::commerce::mojom::ShoppingEligibilityDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::commerce::mojom::ShoppingEligibilityDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::commerce::mojom::internal::ShoppingEligibilityDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::country(input)) in_country = Traits::country(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->country)::BaseType> country_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_country,
      country_fragment);

    fragment->country.Set(
        country_fragment.is_null() ? nullptr : country_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->country.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null country in ShoppingEligibilityDetails struct");

    decltype(Traits::locale(input)) in_locale = Traits::locale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->locale)::BaseType> locale_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_locale,
      locale_fragment);

    fragment->locale.Set(
        locale_fragment.is_null() ? nullptr : locale_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->locale.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locale in ShoppingEligibilityDetails struct");

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType>
        details_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::commerce::mojom::EligibilityDetailDataView>>(
      in_details,
      details_fragment,
      &details_validate_params);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in ShoppingEligibilityDetails struct");
  }

  static bool Deserialize(::commerce::mojom::internal::ShoppingEligibilityDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::commerce::mojom::ShoppingEligibilityDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::commerce::mojom::SubscriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::commerce::mojom::SubscriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::commerce::mojom::internal::Subscription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->cluster_id = Traits::cluster_id(input);

    decltype(Traits::product_infos(input)) in_product_infos = Traits::product_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->product_infos)::BaseType>
        product_infos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& product_infos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::commerce::shared::mojom::BookmarkProductInfoDataView>>(
      in_product_infos,
      product_infos_fragment,
      &product_infos_validate_params);

    fragment->product_infos.Set(
        product_infos_fragment.is_null() ? nullptr : product_infos_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->product_infos.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null product_infos in Subscription struct");
  }

  static bool Deserialize(::commerce::mojom::internal::Subscription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::commerce::mojom::SubscriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::commerce::mojom::ProductSpecificationsSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::commerce::mojom::ProductSpecificationsSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::commerce::mojom::internal::ProductSpecificationsSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in ProductSpecificationsSet struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ProductSpecificationsSet struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in ProductSpecificationsSet struct");

    decltype(Traits::update_time(input)) in_update_time = Traits::update_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_time)::BaseType> update_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_update_time,
      update_time_fragment);

    fragment->update_time.Set(
        update_time_fragment.is_null() ? nullptr : update_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->update_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null update_time in ProductSpecificationsSet struct");

    decltype(Traits::url_infos(input)) in_url_infos = Traits::url_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_infos)::BaseType>
        url_infos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& url_infos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>>(
      in_url_infos,
      url_infos_fragment,
      &url_infos_validate_params);

    fragment->url_infos.Set(
        url_infos_fragment.is_null() ? nullptr : url_infos_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_infos.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_infos in ProductSpecificationsSet struct");
  }

  static bool Deserialize(::commerce::mojom::internal::ProductSpecificationsSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::commerce::mojom::ProductSpecificationsSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace commerce::mojom {

inline void EligibilityDetailDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ShoppingEligibilityDetailsDataView::GetCountryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->country.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ShoppingEligibilityDetailsDataView::GetLocaleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->locale.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ShoppingEligibilityDetailsDataView::GetDetailsDataView(
    mojo::ArrayDataView<EligibilityDetailDataView>* output) {
  auto pointer = data_->details.Get();
  *output = mojo::ArrayDataView<EligibilityDetailDataView>(pointer, message_);
}


inline void SubscriptionDataView::GetProductInfosDataView(
    mojo::ArrayDataView<::commerce::shared::mojom::BookmarkProductInfoDataView>* output) {
  auto pointer = data_->product_infos.Get();
  *output = mojo::ArrayDataView<::commerce::shared::mojom::BookmarkProductInfoDataView>(pointer, message_);
}


inline void ProductSpecificationsSetDataView::GetUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsSetDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsSetDataView::GetCreationTimeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsSetDataView::GetUpdateTimeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->update_time.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProductSpecificationsSetDataView::GetUrlInfosDataView(
    mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>* output) {
  auto pointer = data_->url_infos.Get();
  *output = mojo::ArrayDataView<::shopping_service::mojom::UrlInfoDataView>(pointer, message_);
}



}  // commerce::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_COMMERCE_CORE_INTERNALS_MOJOM_COMMERCE_INTERNALS_MOJOM_SHARED_H_