// components/browsing_topics/mojom/browsing_topics_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_H_
#define COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-features.h"  // IWYU pragma: export
#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-shared.h"  // IWYU pragma: export
#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace browsing_topics::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "browsing_topics.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBrowsingTopicsConfigurationMinVersion = 0,
    kGetBrowsingTopicsStateMinVersion = 0,
    kGetModelInfoMinVersion = 0,
    kClassifyHostsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBrowsingTopicsConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBrowsingTopicsState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetModelInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClassifyHosts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetBrowsingTopicsConfigurationCallback = base::OnceCallback<void(WebUIBrowsingTopicsConfigurationPtr)>;
  using GetBrowsingTopicsConfigurationMojoCallback = base::OnceCallback<void(WebUIBrowsingTopicsConfigurationPtr)>;

  virtual void GetBrowsingTopicsConfiguration(GetBrowsingTopicsConfigurationCallback callback) = 0;

  using GetBrowsingTopicsStateCallback = base::OnceCallback<void(WebUIGetBrowsingTopicsStateResultPtr)>;
  using GetBrowsingTopicsStateMojoCallback = base::OnceCallback<void(WebUIGetBrowsingTopicsStateResultPtr)>;

  virtual void GetBrowsingTopicsState(bool calculate_now, GetBrowsingTopicsStateCallback callback) = 0;

  using GetModelInfoCallback = base::OnceCallback<void(WebUIGetModelInfoResultPtr)>;
  using GetModelInfoMojoCallback = base::OnceCallback<void(WebUIGetModelInfoResultPtr)>;

  virtual void GetModelInfo(GetModelInfoCallback callback) = 0;

  using ClassifyHostsCallback = base::OnceCallback<void(std::vector<std::vector<WebUITopicPtr>>)>;
  using ClassifyHostsMojoCallback = base::OnceCallback<void(std::vector<std::vector<WebUITopicPtr>>)>;

  virtual void ClassifyHosts(const std::vector<std::string>& hosts, ClassifyHostsCallback callback) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBrowsingTopicsConfiguration(GetBrowsingTopicsConfigurationCallback callback) final;
  
  void GetBrowsingTopicsState(bool calculate_now, GetBrowsingTopicsStateCallback callback) final;
  
  void GetModelInfo(GetModelInfoCallback callback) final;
  
  void ClassifyHosts(const std::vector<std::string>& hosts, ClassifyHostsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  WebUIModelInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIModelInfo, T>::value>;
  using DataView = WebUIModelInfoDataView;
  using Data_ = internal::WebUIModelInfo_Data;

  template <typename... Args>
  static WebUIModelInfoPtr New(Args&&... args) {
    return WebUIModelInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIModelInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebUIModelInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIModelInfo>::Convert(*this);
  }


  WebUIModelInfo();

  WebUIModelInfo(
      const std::string& model_version,
      const std::string& model_file_path);


  ~WebUIModelInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIModelInfoPtr>
  WebUIModelInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIModelInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIModelInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIModelInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIModelInfo_UnserializedMessageContext<
            UserType, WebUIModelInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIModelInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIModelInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIModelInfo_UnserializedMessageContext<
            UserType, WebUIModelInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIModelInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string model_version;
  
  std::string model_file_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIModelInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIGetBrowsingTopicsStateResult {
 public:
  using DataView = WebUIGetBrowsingTopicsStateResultDataView;
  using Data_ = internal::WebUIGetBrowsingTopicsStateResult_Data;
  using Tag = Data_::WebUIGetBrowsingTopicsStateResult_Tag;

  template <typename... Args>
  static WebUIGetBrowsingTopicsStateResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |override_status_message|.
  static WebUIGetBrowsingTopicsStateResultPtr NewOverrideStatusMessage(
      const std::string& value);
  // Construct an instance holding |browsing_topics_state|.
  static WebUIGetBrowsingTopicsStateResultPtr NewBrowsingTopicsState(
      WebUIBrowsingTopicsStatePtr value);

  template <typename U>
  static WebUIGetBrowsingTopicsStateResultPtr From(const U& u) {
    return mojo::TypeConverter<WebUIGetBrowsingTopicsStateResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIGetBrowsingTopicsStateResult>::Convert(*this);
  }
  ~WebUIGetBrowsingTopicsStateResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebUIGetBrowsingTopicsStateResult(const WebUIGetBrowsingTopicsStateResult& other) = delete;
  WebUIGetBrowsingTopicsStateResult& operator=(const WebUIGetBrowsingTopicsStateResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebUIGetBrowsingTopicsStateResultPtr>
  WebUIGetBrowsingTopicsStateResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIGetBrowsingTopicsStateResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIGetBrowsingTopicsStateResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_override_status_message() const { return tag_ == Tag::kOverrideStatusMessage; }
  const std::string& get_override_status_message() const {
    CHECK(tag_ == Tag::kOverrideStatusMessage);
    return data_.override_status_message;
  }
  std::string& get_override_status_message() {
    CHECK(tag_ == Tag::kOverrideStatusMessage);
    return data_.override_status_message;
  }
  void set_override_status_message(const std::string& override_status_message);

  bool is_browsing_topics_state() const { return tag_ == Tag::kBrowsingTopicsState; }
  const WebUIBrowsingTopicsStatePtr& get_browsing_topics_state() const {
    CHECK(tag_ == Tag::kBrowsingTopicsState);
    return data_.browsing_topics_state;
  }
  WebUIBrowsingTopicsStatePtr& get_browsing_topics_state() {
    CHECK(tag_ == Tag::kBrowsingTopicsState);
    return data_.browsing_topics_state;
  }
  void set_browsing_topics_state(WebUIBrowsingTopicsStatePtr browsing_topics_state);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIGetBrowsingTopicsStateResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebUIGetBrowsingTopicsStateResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
        WebUIBrowsingTopicsStatePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string override_status_message;
    WebUIBrowsingTopicsStatePtr browsing_topics_state;
  };

  WebUIGetBrowsingTopicsStateResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
      const std::string& value);
  WebUIGetBrowsingTopicsStateResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
      WebUIBrowsingTopicsStatePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  WebUIGetModelInfoResult {
 public:
  using DataView = WebUIGetModelInfoResultDataView;
  using Data_ = internal::WebUIGetModelInfoResult_Data;
  using Tag = Data_::WebUIGetModelInfoResult_Tag;

  template <typename... Args>
  static WebUIGetModelInfoResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |override_status_message|.
  static WebUIGetModelInfoResultPtr NewOverrideStatusMessage(
      const std::string& value);
  // Construct an instance holding |model_info|.
  static WebUIGetModelInfoResultPtr NewModelInfo(
      WebUIModelInfoPtr value);

  template <typename U>
  static WebUIGetModelInfoResultPtr From(const U& u) {
    return mojo::TypeConverter<WebUIGetModelInfoResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIGetModelInfoResult>::Convert(*this);
  }
  ~WebUIGetModelInfoResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebUIGetModelInfoResult(const WebUIGetModelInfoResult& other) = delete;
  WebUIGetModelInfoResult& operator=(const WebUIGetModelInfoResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebUIGetModelInfoResultPtr>
  WebUIGetModelInfoResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIGetModelInfoResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebUIGetModelInfoResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_override_status_message() const { return tag_ == Tag::kOverrideStatusMessage; }
  const std::string& get_override_status_message() const {
    CHECK(tag_ == Tag::kOverrideStatusMessage);
    return data_.override_status_message;
  }
  std::string& get_override_status_message() {
    CHECK(tag_ == Tag::kOverrideStatusMessage);
    return data_.override_status_message;
  }
  void set_override_status_message(const std::string& override_status_message);

  bool is_model_info() const { return tag_ == Tag::kModelInfo; }
  const WebUIModelInfoPtr& get_model_info() const {
    CHECK(tag_ == Tag::kModelInfo);
    return data_.model_info;
  }
  WebUIModelInfoPtr& get_model_info() {
    CHECK(tag_ == Tag::kModelInfo);
    return data_.model_info;
  }
  void set_model_info(WebUIModelInfoPtr model_info);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIGetModelInfoResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebUIGetModelInfoResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kModelInfo)>,
        WebUIModelInfoPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string override_status_message;
    WebUIModelInfoPtr model_info;
  };

  WebUIGetModelInfoResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
      const std::string& value);
  WebUIGetModelInfoResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kModelInfo)>,
      WebUIModelInfoPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  WebUIBrowsingTopicsConfiguration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIBrowsingTopicsConfiguration, T>::value>;
  using DataView = WebUIBrowsingTopicsConfigurationDataView;
  using Data_ = internal::WebUIBrowsingTopicsConfiguration_Data;

  template <typename... Args>
  static WebUIBrowsingTopicsConfigurationPtr New(Args&&... args) {
    return WebUIBrowsingTopicsConfigurationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIBrowsingTopicsConfigurationPtr From(const U& u) {
    return mojo::TypeConverter<WebUIBrowsingTopicsConfigurationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIBrowsingTopicsConfiguration>::Convert(*this);
  }


  WebUIBrowsingTopicsConfiguration();

  WebUIBrowsingTopicsConfiguration(
      bool browsing_topics_enabled,
      bool privacy_sandbox_ads_apis_override_enabled,
      bool override_privacy_sandbox_settings_local_testing_enabled,
      bool browsing_topics_bypass_ip_is_publicly_routable_check_enabled,
      bool browsing_topics_document_api_enabled,
      int32_t config_version,
      bool browsing_topics_parameters_enabled,
      int32_t number_of_epochs_to_expose,
      ::base::TimeDelta time_period_per_epoch,
      int32_t number_of_top_topics_per_epoch,
      int32_t use_random_topic_probability_percent,
      ::base::TimeDelta max_epoch_introduction_delay,
      int32_t number_of_epochs_of_observation_data_to_use_for_filtering,
      int32_t max_number_of_api_usage_context_domains_to_keep_per_topic,
      int32_t max_number_of_api_usage_context_entries_to_load_per_epoch,
      int32_t max_number_of_api_usage_context_domains_to_store_per_page_load,
      int32_t taxonomy_version,
      const std::string& disabled_topics_list);


  ~WebUIBrowsingTopicsConfiguration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIBrowsingTopicsConfigurationPtr>
  WebUIBrowsingTopicsConfigurationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIBrowsingTopicsConfiguration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIBrowsingTopicsConfiguration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIBrowsingTopicsConfiguration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIBrowsingTopicsConfiguration_UnserializedMessageContext<
            UserType, WebUIBrowsingTopicsConfiguration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIBrowsingTopicsConfiguration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIBrowsingTopicsConfiguration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIBrowsingTopicsConfiguration_UnserializedMessageContext<
            UserType, WebUIBrowsingTopicsConfiguration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIBrowsingTopicsConfiguration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool browsing_topics_enabled;
  
  bool privacy_sandbox_ads_apis_override_enabled;
  
  bool override_privacy_sandbox_settings_local_testing_enabled;
  
  bool browsing_topics_bypass_ip_is_publicly_routable_check_enabled;
  
  bool browsing_topics_document_api_enabled;
  
  int32_t config_version;
  
  bool browsing_topics_parameters_enabled;
  
  int32_t number_of_epochs_to_expose;
  
  ::base::TimeDelta time_period_per_epoch;
  
  int32_t number_of_top_topics_per_epoch;
  
  int32_t use_random_topic_probability_percent;
  
  ::base::TimeDelta max_epoch_introduction_delay;
  
  int32_t number_of_epochs_of_observation_data_to_use_for_filtering;
  
  int32_t max_number_of_api_usage_context_domains_to_keep_per_topic;
  
  int32_t max_number_of_api_usage_context_entries_to_load_per_epoch;
  
  int32_t max_number_of_api_usage_context_domains_to_store_per_page_load;
  
  int32_t taxonomy_version;
  
  std::string disabled_topics_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUITopic {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUITopic, T>::value>;
  using DataView = WebUITopicDataView;
  using Data_ = internal::WebUITopic_Data;

  template <typename... Args>
  static WebUITopicPtr New(Args&&... args) {
    return WebUITopicPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUITopicPtr From(const U& u) {
    return mojo::TypeConverter<WebUITopicPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUITopic>::Convert(*this);
  }


  WebUITopic();

  WebUITopic(
      int32_t topic_id,
      const ::std::u16string& topic_name,
      bool is_real_topic,
      std::vector<std::string> observed_by_domains);


  ~WebUITopic();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUITopicPtr>
  WebUITopicPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUITopic::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUITopic::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUITopic::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUITopic_UnserializedMessageContext<
            UserType, WebUITopic::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUITopic::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUITopic::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUITopic_UnserializedMessageContext<
            UserType, WebUITopic::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUITopic::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t topic_id;
  
  ::std::u16string topic_name;
  
  bool is_real_topic;
  
  std::vector<std::string> observed_by_domains;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUITopic::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIEpoch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIEpoch, T>::value>;
  using DataView = WebUIEpochDataView;
  using Data_ = internal::WebUIEpoch_Data;

  template <typename... Args>
  static WebUIEpochPtr New(Args&&... args) {
    return WebUIEpochPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIEpochPtr From(const U& u) {
    return mojo::TypeConverter<WebUIEpochPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIEpoch>::Convert(*this);
  }


  WebUIEpoch();

  WebUIEpoch(
      std::vector<WebUITopicPtr> topics,
      ::base::Time calculation_time,
      const std::string& model_version,
      const std::string& taxonomy_version);

WebUIEpoch(const WebUIEpoch&) = delete;
WebUIEpoch& operator=(const WebUIEpoch&) = delete;

  ~WebUIEpoch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIEpochPtr>
  WebUIEpochPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIEpoch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIEpoch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIEpoch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIEpoch_UnserializedMessageContext<
            UserType, WebUIEpoch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIEpoch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIEpoch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIEpoch_UnserializedMessageContext<
            UserType, WebUIEpoch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIEpoch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WebUITopicPtr> topics;
  
  ::base::Time calculation_time;
  
  std::string model_version;
  
  std::string taxonomy_version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIEpoch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIBrowsingTopicsState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIBrowsingTopicsState, T>::value>;
  using DataView = WebUIBrowsingTopicsStateDataView;
  using Data_ = internal::WebUIBrowsingTopicsState_Data;

  template <typename... Args>
  static WebUIBrowsingTopicsStatePtr New(Args&&... args) {
    return WebUIBrowsingTopicsStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIBrowsingTopicsStatePtr From(const U& u) {
    return mojo::TypeConverter<WebUIBrowsingTopicsStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIBrowsingTopicsState>::Convert(*this);
  }


  WebUIBrowsingTopicsState();

  WebUIBrowsingTopicsState(
      std::vector<WebUIEpochPtr> epochs,
      ::base::Time next_scheduled_calculation_time);

WebUIBrowsingTopicsState(const WebUIBrowsingTopicsState&) = delete;
WebUIBrowsingTopicsState& operator=(const WebUIBrowsingTopicsState&) = delete;

  ~WebUIBrowsingTopicsState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIBrowsingTopicsStatePtr>
  WebUIBrowsingTopicsStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIBrowsingTopicsState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIBrowsingTopicsState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIBrowsingTopicsState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIBrowsingTopicsState_UnserializedMessageContext<
            UserType, WebUIBrowsingTopicsState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebUIBrowsingTopicsState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebUIBrowsingTopicsState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIBrowsingTopicsState_UnserializedMessageContext<
            UserType, WebUIBrowsingTopicsState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIBrowsingTopicsState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WebUIEpochPtr> epochs;
  
  ::base::Time next_scheduled_calculation_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
WebUIGetBrowsingTopicsStateResultPtr WebUIGetBrowsingTopicsStateResult::Clone() const {
  switch (tag_) {
    case Tag::kOverrideStatusMessage:
      return NewOverrideStatusMessage(
          mojo::Clone(data_.override_status_message));
    case Tag::kBrowsingTopicsState:
      return NewBrowsingTopicsState(
          mojo::Clone(data_.browsing_topics_state));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebUIGetBrowsingTopicsStateResult>::value>::type*>
bool WebUIGetBrowsingTopicsStateResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kOverrideStatusMessage:
      return mojo::Equals(data_.override_status_message, other.data_.override_status_message);
    case Tag::kBrowsingTopicsState:
      return mojo::Equals(data_.browsing_topics_state, other.data_.browsing_topics_state);
  }

  return false;
}
template <typename UnionPtrType>
WebUIGetModelInfoResultPtr WebUIGetModelInfoResult::Clone() const {
  switch (tag_) {
    case Tag::kOverrideStatusMessage:
      return NewOverrideStatusMessage(
          mojo::Clone(data_.override_status_message));
    case Tag::kModelInfo:
      return NewModelInfo(
          mojo::Clone(data_.model_info));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebUIGetModelInfoResult>::value>::type*>
bool WebUIGetModelInfoResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kOverrideStatusMessage:
      return mojo::Equals(data_.override_status_message, other.data_.override_status_message);
    case Tag::kModelInfo:
      return mojo::Equals(data_.model_info, other.data_.model_info);
  }

  return false;
}
template <typename StructPtrType>
WebUIBrowsingTopicsConfigurationPtr WebUIBrowsingTopicsConfiguration::Clone() const {
  return New(
      mojo::Clone(browsing_topics_enabled),
      mojo::Clone(privacy_sandbox_ads_apis_override_enabled),
      mojo::Clone(override_privacy_sandbox_settings_local_testing_enabled),
      mojo::Clone(browsing_topics_bypass_ip_is_publicly_routable_check_enabled),
      mojo::Clone(browsing_topics_document_api_enabled),
      mojo::Clone(config_version),
      mojo::Clone(browsing_topics_parameters_enabled),
      mojo::Clone(number_of_epochs_to_expose),
      mojo::Clone(time_period_per_epoch),
      mojo::Clone(number_of_top_topics_per_epoch),
      mojo::Clone(use_random_topic_probability_percent),
      mojo::Clone(max_epoch_introduction_delay),
      mojo::Clone(number_of_epochs_of_observation_data_to_use_for_filtering),
      mojo::Clone(max_number_of_api_usage_context_domains_to_keep_per_topic),
      mojo::Clone(max_number_of_api_usage_context_entries_to_load_per_epoch),
      mojo::Clone(max_number_of_api_usage_context_domains_to_store_per_page_load),
      mojo::Clone(taxonomy_version),
      mojo::Clone(disabled_topics_list)
  );
}

template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>*>
bool WebUIBrowsingTopicsConfiguration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->browsing_topics_enabled, other_struct.browsing_topics_enabled))
    return false;
  if (!mojo::Equals(this->privacy_sandbox_ads_apis_override_enabled, other_struct.privacy_sandbox_ads_apis_override_enabled))
    return false;
  if (!mojo::Equals(this->override_privacy_sandbox_settings_local_testing_enabled, other_struct.override_privacy_sandbox_settings_local_testing_enabled))
    return false;
  if (!mojo::Equals(this->browsing_topics_bypass_ip_is_publicly_routable_check_enabled, other_struct.browsing_topics_bypass_ip_is_publicly_routable_check_enabled))
    return false;
  if (!mojo::Equals(this->browsing_topics_document_api_enabled, other_struct.browsing_topics_document_api_enabled))
    return false;
  if (!mojo::Equals(this->config_version, other_struct.config_version))
    return false;
  if (!mojo::Equals(this->browsing_topics_parameters_enabled, other_struct.browsing_topics_parameters_enabled))
    return false;
  if (!mojo::Equals(this->number_of_epochs_to_expose, other_struct.number_of_epochs_to_expose))
    return false;
  if (!mojo::Equals(this->time_period_per_epoch, other_struct.time_period_per_epoch))
    return false;
  if (!mojo::Equals(this->number_of_top_topics_per_epoch, other_struct.number_of_top_topics_per_epoch))
    return false;
  if (!mojo::Equals(this->use_random_topic_probability_percent, other_struct.use_random_topic_probability_percent))
    return false;
  if (!mojo::Equals(this->max_epoch_introduction_delay, other_struct.max_epoch_introduction_delay))
    return false;
  if (!mojo::Equals(this->number_of_epochs_of_observation_data_to_use_for_filtering, other_struct.number_of_epochs_of_observation_data_to_use_for_filtering))
    return false;
  if (!mojo::Equals(this->max_number_of_api_usage_context_domains_to_keep_per_topic, other_struct.max_number_of_api_usage_context_domains_to_keep_per_topic))
    return false;
  if (!mojo::Equals(this->max_number_of_api_usage_context_entries_to_load_per_epoch, other_struct.max_number_of_api_usage_context_entries_to_load_per_epoch))
    return false;
  if (!mojo::Equals(this->max_number_of_api_usage_context_domains_to_store_per_page_load, other_struct.max_number_of_api_usage_context_domains_to_store_per_page_load))
    return false;
  if (!mojo::Equals(this->taxonomy_version, other_struct.taxonomy_version))
    return false;
  if (!mojo::Equals(this->disabled_topics_list, other_struct.disabled_topics_list))
    return false;
  return true;
}

template <typename T, WebUIBrowsingTopicsConfiguration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.browsing_topics_enabled < rhs.browsing_topics_enabled)
    return true;
  if (rhs.browsing_topics_enabled < lhs.browsing_topics_enabled)
    return false;
  if (lhs.privacy_sandbox_ads_apis_override_enabled < rhs.privacy_sandbox_ads_apis_override_enabled)
    return true;
  if (rhs.privacy_sandbox_ads_apis_override_enabled < lhs.privacy_sandbox_ads_apis_override_enabled)
    return false;
  if (lhs.override_privacy_sandbox_settings_local_testing_enabled < rhs.override_privacy_sandbox_settings_local_testing_enabled)
    return true;
  if (rhs.override_privacy_sandbox_settings_local_testing_enabled < lhs.override_privacy_sandbox_settings_local_testing_enabled)
    return false;
  if (lhs.browsing_topics_bypass_ip_is_publicly_routable_check_enabled < rhs.browsing_topics_bypass_ip_is_publicly_routable_check_enabled)
    return true;
  if (rhs.browsing_topics_bypass_ip_is_publicly_routable_check_enabled < lhs.browsing_topics_bypass_ip_is_publicly_routable_check_enabled)
    return false;
  if (lhs.browsing_topics_document_api_enabled < rhs.browsing_topics_document_api_enabled)
    return true;
  if (rhs.browsing_topics_document_api_enabled < lhs.browsing_topics_document_api_enabled)
    return false;
  if (lhs.config_version < rhs.config_version)
    return true;
  if (rhs.config_version < lhs.config_version)
    return false;
  if (lhs.browsing_topics_parameters_enabled < rhs.browsing_topics_parameters_enabled)
    return true;
  if (rhs.browsing_topics_parameters_enabled < lhs.browsing_topics_parameters_enabled)
    return false;
  if (lhs.number_of_epochs_to_expose < rhs.number_of_epochs_to_expose)
    return true;
  if (rhs.number_of_epochs_to_expose < lhs.number_of_epochs_to_expose)
    return false;
  if (lhs.time_period_per_epoch < rhs.time_period_per_epoch)
    return true;
  if (rhs.time_period_per_epoch < lhs.time_period_per_epoch)
    return false;
  if (lhs.number_of_top_topics_per_epoch < rhs.number_of_top_topics_per_epoch)
    return true;
  if (rhs.number_of_top_topics_per_epoch < lhs.number_of_top_topics_per_epoch)
    return false;
  if (lhs.use_random_topic_probability_percent < rhs.use_random_topic_probability_percent)
    return true;
  if (rhs.use_random_topic_probability_percent < lhs.use_random_topic_probability_percent)
    return false;
  if (lhs.max_epoch_introduction_delay < rhs.max_epoch_introduction_delay)
    return true;
  if (rhs.max_epoch_introduction_delay < lhs.max_epoch_introduction_delay)
    return false;
  if (lhs.number_of_epochs_of_observation_data_to_use_for_filtering < rhs.number_of_epochs_of_observation_data_to_use_for_filtering)
    return true;
  if (rhs.number_of_epochs_of_observation_data_to_use_for_filtering < lhs.number_of_epochs_of_observation_data_to_use_for_filtering)
    return false;
  if (lhs.max_number_of_api_usage_context_domains_to_keep_per_topic < rhs.max_number_of_api_usage_context_domains_to_keep_per_topic)
    return true;
  if (rhs.max_number_of_api_usage_context_domains_to_keep_per_topic < lhs.max_number_of_api_usage_context_domains_to_keep_per_topic)
    return false;
  if (lhs.max_number_of_api_usage_context_entries_to_load_per_epoch < rhs.max_number_of_api_usage_context_entries_to_load_per_epoch)
    return true;
  if (rhs.max_number_of_api_usage_context_entries_to_load_per_epoch < lhs.max_number_of_api_usage_context_entries_to_load_per_epoch)
    return false;
  if (lhs.max_number_of_api_usage_context_domains_to_store_per_page_load < rhs.max_number_of_api_usage_context_domains_to_store_per_page_load)
    return true;
  if (rhs.max_number_of_api_usage_context_domains_to_store_per_page_load < lhs.max_number_of_api_usage_context_domains_to_store_per_page_load)
    return false;
  if (lhs.taxonomy_version < rhs.taxonomy_version)
    return true;
  if (rhs.taxonomy_version < lhs.taxonomy_version)
    return false;
  if (lhs.disabled_topics_list < rhs.disabled_topics_list)
    return true;
  if (rhs.disabled_topics_list < lhs.disabled_topics_list)
    return false;
  return false;
}
template <typename StructPtrType>
WebUITopicPtr WebUITopic::Clone() const {
  return New(
      mojo::Clone(topic_id),
      mojo::Clone(topic_name),
      mojo::Clone(is_real_topic),
      mojo::Clone(observed_by_domains)
  );
}

template <typename T, WebUITopic::EnableIfSame<T>*>
bool WebUITopic::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->topic_id, other_struct.topic_id))
    return false;
  if (!mojo::Equals(this->topic_name, other_struct.topic_name))
    return false;
  if (!mojo::Equals(this->is_real_topic, other_struct.is_real_topic))
    return false;
  if (!mojo::Equals(this->observed_by_domains, other_struct.observed_by_domains))
    return false;
  return true;
}

template <typename T, WebUITopic::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.topic_id < rhs.topic_id)
    return true;
  if (rhs.topic_id < lhs.topic_id)
    return false;
  if (lhs.topic_name < rhs.topic_name)
    return true;
  if (rhs.topic_name < lhs.topic_name)
    return false;
  if (lhs.is_real_topic < rhs.is_real_topic)
    return true;
  if (rhs.is_real_topic < lhs.is_real_topic)
    return false;
  if (lhs.observed_by_domains < rhs.observed_by_domains)
    return true;
  if (rhs.observed_by_domains < lhs.observed_by_domains)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIEpochPtr WebUIEpoch::Clone() const {
  return New(
      mojo::Clone(topics),
      mojo::Clone(calculation_time),
      mojo::Clone(model_version),
      mojo::Clone(taxonomy_version)
  );
}

template <typename T, WebUIEpoch::EnableIfSame<T>*>
bool WebUIEpoch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->topics, other_struct.topics))
    return false;
  if (!mojo::Equals(this->calculation_time, other_struct.calculation_time))
    return false;
  if (!mojo::Equals(this->model_version, other_struct.model_version))
    return false;
  if (!mojo::Equals(this->taxonomy_version, other_struct.taxonomy_version))
    return false;
  return true;
}

template <typename T, WebUIEpoch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.topics < rhs.topics)
    return true;
  if (rhs.topics < lhs.topics)
    return false;
  if (lhs.calculation_time < rhs.calculation_time)
    return true;
  if (rhs.calculation_time < lhs.calculation_time)
    return false;
  if (lhs.model_version < rhs.model_version)
    return true;
  if (rhs.model_version < lhs.model_version)
    return false;
  if (lhs.taxonomy_version < rhs.taxonomy_version)
    return true;
  if (rhs.taxonomy_version < lhs.taxonomy_version)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIBrowsingTopicsStatePtr WebUIBrowsingTopicsState::Clone() const {
  return New(
      mojo::Clone(epochs),
      mojo::Clone(next_scheduled_calculation_time)
  );
}

template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>*>
bool WebUIBrowsingTopicsState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->epochs, other_struct.epochs))
    return false;
  if (!mojo::Equals(this->next_scheduled_calculation_time, other_struct.next_scheduled_calculation_time))
    return false;
  return true;
}

template <typename T, WebUIBrowsingTopicsState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.epochs < rhs.epochs)
    return true;
  if (rhs.epochs < lhs.epochs)
    return false;
  if (lhs.next_scheduled_calculation_time < rhs.next_scheduled_calculation_time)
    return true;
  if (rhs.next_scheduled_calculation_time < lhs.next_scheduled_calculation_time)
    return false;
  return false;
}
template <typename StructPtrType>
WebUIModelInfoPtr WebUIModelInfo::Clone() const {
  return New(
      mojo::Clone(model_version),
      mojo::Clone(model_file_path)
  );
}

template <typename T, WebUIModelInfo::EnableIfSame<T>*>
bool WebUIModelInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->model_version, other_struct.model_version))
    return false;
  if (!mojo::Equals(this->model_file_path, other_struct.model_file_path))
    return false;
  return true;
}

template <typename T, WebUIModelInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.model_version < rhs.model_version)
    return true;
  if (rhs.model_version < lhs.model_version)
    return false;
  if (lhs.model_file_path < rhs.model_file_path)
    return true;
  if (rhs.model_file_path < lhs.model_file_path)
    return false;
  return false;
}


}  // browsing_topics::mojom

namespace mojo {


template <>
struct  StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::DataView,
                                         ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr* output) { output->reset(); }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::browsing_topics_enabled) browsing_topics_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->browsing_topics_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::privacy_sandbox_ads_apis_override_enabled) privacy_sandbox_ads_apis_override_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->privacy_sandbox_ads_apis_override_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::override_privacy_sandbox_settings_local_testing_enabled) override_privacy_sandbox_settings_local_testing_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->override_privacy_sandbox_settings_local_testing_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::browsing_topics_bypass_ip_is_publicly_routable_check_enabled) browsing_topics_bypass_ip_is_publicly_routable_check_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->browsing_topics_bypass_ip_is_publicly_routable_check_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::browsing_topics_document_api_enabled) browsing_topics_document_api_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->browsing_topics_document_api_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::config_version) config_version(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->config_version;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::browsing_topics_parameters_enabled) browsing_topics_parameters_enabled(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->browsing_topics_parameters_enabled;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::number_of_epochs_to_expose) number_of_epochs_to_expose(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->number_of_epochs_to_expose;
  }

  static const decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::time_period_per_epoch)& time_period_per_epoch(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->time_period_per_epoch;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::number_of_top_topics_per_epoch) number_of_top_topics_per_epoch(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->number_of_top_topics_per_epoch;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::use_random_topic_probability_percent) use_random_topic_probability_percent(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->use_random_topic_probability_percent;
  }

  static const decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::max_epoch_introduction_delay)& max_epoch_introduction_delay(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->max_epoch_introduction_delay;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::number_of_epochs_of_observation_data_to_use_for_filtering) number_of_epochs_of_observation_data_to_use_for_filtering(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->number_of_epochs_of_observation_data_to_use_for_filtering;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::max_number_of_api_usage_context_domains_to_keep_per_topic) max_number_of_api_usage_context_domains_to_keep_per_topic(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->max_number_of_api_usage_context_domains_to_keep_per_topic;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::max_number_of_api_usage_context_entries_to_load_per_epoch) max_number_of_api_usage_context_entries_to_load_per_epoch(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->max_number_of_api_usage_context_entries_to_load_per_epoch;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::max_number_of_api_usage_context_domains_to_store_per_page_load) max_number_of_api_usage_context_domains_to_store_per_page_load(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->max_number_of_api_usage_context_domains_to_store_per_page_load;
  }

  static decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::taxonomy_version) taxonomy_version(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->taxonomy_version;
  }

  static const decltype(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::disabled_topics_list)& disabled_topics_list(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr& input) {
    return input->disabled_topics_list;
  }

  static bool Read(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::DataView input, ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr* output);
};


template <>
struct  StructTraits<::browsing_topics::mojom::WebUITopic::DataView,
                                         ::browsing_topics::mojom::WebUITopicPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUITopicPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUITopicPtr* output) { output->reset(); }

  static decltype(::browsing_topics::mojom::WebUITopic::topic_id) topic_id(
      const ::browsing_topics::mojom::WebUITopicPtr& input) {
    return input->topic_id;
  }

  static const decltype(::browsing_topics::mojom::WebUITopic::topic_name)& topic_name(
      const ::browsing_topics::mojom::WebUITopicPtr& input) {
    return input->topic_name;
  }

  static decltype(::browsing_topics::mojom::WebUITopic::is_real_topic) is_real_topic(
      const ::browsing_topics::mojom::WebUITopicPtr& input) {
    return input->is_real_topic;
  }

  static const decltype(::browsing_topics::mojom::WebUITopic::observed_by_domains)& observed_by_domains(
      const ::browsing_topics::mojom::WebUITopicPtr& input) {
    return input->observed_by_domains;
  }

  static bool Read(::browsing_topics::mojom::WebUITopic::DataView input, ::browsing_topics::mojom::WebUITopicPtr* output);
};


template <>
struct  StructTraits<::browsing_topics::mojom::WebUIEpoch::DataView,
                                         ::browsing_topics::mojom::WebUIEpochPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIEpochPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIEpochPtr* output) { output->reset(); }

  static const decltype(::browsing_topics::mojom::WebUIEpoch::topics)& topics(
      const ::browsing_topics::mojom::WebUIEpochPtr& input) {
    return input->topics;
  }

  static const decltype(::browsing_topics::mojom::WebUIEpoch::calculation_time)& calculation_time(
      const ::browsing_topics::mojom::WebUIEpochPtr& input) {
    return input->calculation_time;
  }

  static const decltype(::browsing_topics::mojom::WebUIEpoch::model_version)& model_version(
      const ::browsing_topics::mojom::WebUIEpochPtr& input) {
    return input->model_version;
  }

  static const decltype(::browsing_topics::mojom::WebUIEpoch::taxonomy_version)& taxonomy_version(
      const ::browsing_topics::mojom::WebUIEpochPtr& input) {
    return input->taxonomy_version;
  }

  static bool Read(::browsing_topics::mojom::WebUIEpoch::DataView input, ::browsing_topics::mojom::WebUIEpochPtr* output);
};


template <>
struct  StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsState::DataView,
                                         ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr* output) { output->reset(); }

  static const decltype(::browsing_topics::mojom::WebUIBrowsingTopicsState::epochs)& epochs(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr& input) {
    return input->epochs;
  }

  static const decltype(::browsing_topics::mojom::WebUIBrowsingTopicsState::next_scheduled_calculation_time)& next_scheduled_calculation_time(
      const ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr& input) {
    return input->next_scheduled_calculation_time;
  }

  static bool Read(::browsing_topics::mojom::WebUIBrowsingTopicsState::DataView input, ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr* output);
};


template <>
struct  StructTraits<::browsing_topics::mojom::WebUIModelInfo::DataView,
                                         ::browsing_topics::mojom::WebUIModelInfoPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIModelInfoPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIModelInfoPtr* output) { output->reset(); }

  static const decltype(::browsing_topics::mojom::WebUIModelInfo::model_version)& model_version(
      const ::browsing_topics::mojom::WebUIModelInfoPtr& input) {
    return input->model_version;
  }

  static const decltype(::browsing_topics::mojom::WebUIModelInfo::model_file_path)& model_file_path(
      const ::browsing_topics::mojom::WebUIModelInfoPtr& input) {
    return input->model_file_path;
  }

  static bool Read(::browsing_topics::mojom::WebUIModelInfo::DataView input, ::browsing_topics::mojom::WebUIModelInfoPtr* output);
};


template <>
struct  UnionTraits<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult::DataView,
                                        ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr* output) { output->reset(); }

  static ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult::Tag GetTag(const ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr& input) {
    return input->which();
  }

  static const std::string& override_status_message(const ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr& input) {
    return input->get_override_status_message();
  }

  static const ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr& browsing_topics_state(const ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr& input) {
    return input->get_browsing_topics_state();
  }

  static bool Read(::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult::DataView input, ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr* output);
};


template <>
struct  UnionTraits<::browsing_topics::mojom::WebUIGetModelInfoResult::DataView,
                                        ::browsing_topics::mojom::WebUIGetModelInfoResultPtr> {
  static bool IsNull(const ::browsing_topics::mojom::WebUIGetModelInfoResultPtr& input) { return !input; }
  static void SetToNull(::browsing_topics::mojom::WebUIGetModelInfoResultPtr* output) { output->reset(); }

  static ::browsing_topics::mojom::WebUIGetModelInfoResult::Tag GetTag(const ::browsing_topics::mojom::WebUIGetModelInfoResultPtr& input) {
    return input->which();
  }

  static const std::string& override_status_message(const ::browsing_topics::mojom::WebUIGetModelInfoResultPtr& input) {
    return input->get_override_status_message();
  }

  static const ::browsing_topics::mojom::WebUIModelInfoPtr& model_info(const ::browsing_topics::mojom::WebUIGetModelInfoResultPtr& input) {
    return input->get_model_info();
  }

  static bool Read(::browsing_topics::mojom::WebUIGetModelInfoResult::DataView input, ::browsing_topics::mojom::WebUIGetModelInfoResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_H_