// components/browsing_topics/mojom/browsing_topics_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-params-data.h"
#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-shared-message-ids.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-import-headers.h"
#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-test-utils.h"


namespace browsing_topics::mojom {
WebUIBrowsingTopicsConfiguration::WebUIBrowsingTopicsConfiguration()
    : browsing_topics_enabled(),
      privacy_sandbox_ads_apis_override_enabled(),
      override_privacy_sandbox_settings_local_testing_enabled(),
      browsing_topics_bypass_ip_is_publicly_routable_check_enabled(),
      browsing_topics_document_api_enabled(),
      config_version(),
      browsing_topics_parameters_enabled(),
      number_of_epochs_to_expose(),
      time_period_per_epoch(),
      number_of_top_topics_per_epoch(),
      use_random_topic_probability_percent(),
      max_epoch_introduction_delay(),
      number_of_epochs_of_observation_data_to_use_for_filtering(),
      max_number_of_api_usage_context_domains_to_keep_per_topic(),
      max_number_of_api_usage_context_entries_to_load_per_epoch(),
      max_number_of_api_usage_context_domains_to_store_per_page_load(),
      taxonomy_version(),
      disabled_topics_list() {}

WebUIBrowsingTopicsConfiguration::WebUIBrowsingTopicsConfiguration(
    bool browsing_topics_enabled_in,
    bool privacy_sandbox_ads_apis_override_enabled_in,
    bool override_privacy_sandbox_settings_local_testing_enabled_in,
    bool browsing_topics_bypass_ip_is_publicly_routable_check_enabled_in,
    bool browsing_topics_document_api_enabled_in,
    int32_t config_version_in,
    bool browsing_topics_parameters_enabled_in,
    int32_t number_of_epochs_to_expose_in,
    ::base::TimeDelta time_period_per_epoch_in,
    int32_t number_of_top_topics_per_epoch_in,
    int32_t use_random_topic_probability_percent_in,
    ::base::TimeDelta max_epoch_introduction_delay_in,
    int32_t number_of_epochs_of_observation_data_to_use_for_filtering_in,
    int32_t max_number_of_api_usage_context_domains_to_keep_per_topic_in,
    int32_t max_number_of_api_usage_context_entries_to_load_per_epoch_in,
    int32_t max_number_of_api_usage_context_domains_to_store_per_page_load_in,
    int32_t taxonomy_version_in,
    const std::string& disabled_topics_list_in)
    : browsing_topics_enabled(std::move(browsing_topics_enabled_in)),
      privacy_sandbox_ads_apis_override_enabled(std::move(privacy_sandbox_ads_apis_override_enabled_in)),
      override_privacy_sandbox_settings_local_testing_enabled(std::move(override_privacy_sandbox_settings_local_testing_enabled_in)),
      browsing_topics_bypass_ip_is_publicly_routable_check_enabled(std::move(browsing_topics_bypass_ip_is_publicly_routable_check_enabled_in)),
      browsing_topics_document_api_enabled(std::move(browsing_topics_document_api_enabled_in)),
      config_version(std::move(config_version_in)),
      browsing_topics_parameters_enabled(std::move(browsing_topics_parameters_enabled_in)),
      number_of_epochs_to_expose(std::move(number_of_epochs_to_expose_in)),
      time_period_per_epoch(std::move(time_period_per_epoch_in)),
      number_of_top_topics_per_epoch(std::move(number_of_top_topics_per_epoch_in)),
      use_random_topic_probability_percent(std::move(use_random_topic_probability_percent_in)),
      max_epoch_introduction_delay(std::move(max_epoch_introduction_delay_in)),
      number_of_epochs_of_observation_data_to_use_for_filtering(std::move(number_of_epochs_of_observation_data_to_use_for_filtering_in)),
      max_number_of_api_usage_context_domains_to_keep_per_topic(std::move(max_number_of_api_usage_context_domains_to_keep_per_topic_in)),
      max_number_of_api_usage_context_entries_to_load_per_epoch(std::move(max_number_of_api_usage_context_entries_to_load_per_epoch_in)),
      max_number_of_api_usage_context_domains_to_store_per_page_load(std::move(max_number_of_api_usage_context_domains_to_store_per_page_load_in)),
      taxonomy_version(std::move(taxonomy_version_in)),
      disabled_topics_list(std::move(disabled_topics_list_in)) {}

WebUIBrowsingTopicsConfiguration::~WebUIBrowsingTopicsConfiguration() = default;

void WebUIBrowsingTopicsConfiguration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics_enabled"), this->browsing_topics_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "privacy_sandbox_ads_apis_override_enabled"), this->privacy_sandbox_ads_apis_override_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "override_privacy_sandbox_settings_local_testing_enabled"), this->override_privacy_sandbox_settings_local_testing_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics_bypass_ip_is_publicly_routable_check_enabled"), this->browsing_topics_bypass_ip_is_publicly_routable_check_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics_document_api_enabled"), this->browsing_topics_document_api_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config_version"), this->config_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_topics_parameters_enabled"), this->browsing_topics_parameters_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_epochs_to_expose"), this->number_of_epochs_to_expose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_period_per_epoch"), this->time_period_per_epoch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_top_topics_per_epoch"), this->number_of_top_topics_per_epoch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_random_topic_probability_percent"), this->use_random_topic_probability_percent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_epoch_introduction_delay"), this->max_epoch_introduction_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_epochs_of_observation_data_to_use_for_filtering"), this->number_of_epochs_of_observation_data_to_use_for_filtering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_number_of_api_usage_context_domains_to_keep_per_topic"), this->max_number_of_api_usage_context_domains_to_keep_per_topic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_number_of_api_usage_context_entries_to_load_per_epoch"), this->max_number_of_api_usage_context_entries_to_load_per_epoch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_number_of_api_usage_context_domains_to_store_per_page_load"), this->max_number_of_api_usage_context_domains_to_store_per_page_load,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "taxonomy_version"), this->taxonomy_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_topics_list"), this->disabled_topics_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIBrowsingTopicsConfiguration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUITopic::WebUITopic()
    : topic_id(),
      topic_name(),
      is_real_topic(),
      observed_by_domains() {}

WebUITopic::WebUITopic(
    int32_t topic_id_in,
    const ::std::u16string& topic_name_in,
    bool is_real_topic_in,
    std::vector<std::string> observed_by_domains_in)
    : topic_id(std::move(topic_id_in)),
      topic_name(std::move(topic_name_in)),
      is_real_topic(std::move(is_real_topic_in)),
      observed_by_domains(std::move(observed_by_domains_in)) {}

WebUITopic::~WebUITopic() = default;

void WebUITopic::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "topic_id"), this->topic_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "topic_name"), this->topic_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_real_topic"), this->is_real_topic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observed_by_domains"), this->observed_by_domains,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUITopic::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIEpoch::WebUIEpoch()
    : topics(),
      calculation_time(),
      model_version(),
      taxonomy_version() {}

WebUIEpoch::WebUIEpoch(
    std::vector<WebUITopicPtr> topics_in,
    ::base::Time calculation_time_in,
    const std::string& model_version_in,
    const std::string& taxonomy_version_in)
    : topics(std::move(topics_in)),
      calculation_time(std::move(calculation_time_in)),
      model_version(std::move(model_version_in)),
      taxonomy_version(std::move(taxonomy_version_in)) {}

WebUIEpoch::~WebUIEpoch() = default;

void WebUIEpoch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "topics"), this->topics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WebUITopicPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "calculation_time"), this->calculation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_version"), this->model_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "taxonomy_version"), this->taxonomy_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIEpoch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIBrowsingTopicsState::WebUIBrowsingTopicsState()
    : epochs(),
      next_scheduled_calculation_time() {}

WebUIBrowsingTopicsState::WebUIBrowsingTopicsState(
    std::vector<WebUIEpochPtr> epochs_in,
    ::base::Time next_scheduled_calculation_time_in)
    : epochs(std::move(epochs_in)),
      next_scheduled_calculation_time(std::move(next_scheduled_calculation_time_in)) {}

WebUIBrowsingTopicsState::~WebUIBrowsingTopicsState() = default;

void WebUIBrowsingTopicsState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "epochs"), this->epochs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WebUIEpochPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "next_scheduled_calculation_time"), this->next_scheduled_calculation_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIBrowsingTopicsState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIModelInfo::WebUIModelInfo()
    : model_version(),
      model_file_path() {}

WebUIModelInfo::WebUIModelInfo(
    const std::string& model_version_in,
    const std::string& model_file_path_in)
    : model_version(std::move(model_version_in)),
      model_file_path(std::move(model_file_path_in)) {}

WebUIModelInfo::~WebUIModelInfo() = default;
size_t WebUIModelInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->model_version);
  seed = mojo::internal::Hash(seed, this->model_file_path);
  return seed;
}

void WebUIModelInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_version"), this->model_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_file_path"), this->model_file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebUIModelInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebUIGetBrowsingTopicsStateResultPtr
WebUIGetBrowsingTopicsStateResult::NewOverrideStatusMessage(
    const std::string& value) {
  return WebUIGetBrowsingTopicsStateResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
      std::move(value));
}

WebUIGetBrowsingTopicsStateResultPtr
WebUIGetBrowsingTopicsStateResult::NewBrowsingTopicsState(
    WebUIBrowsingTopicsStatePtr value) {
  return WebUIGetBrowsingTopicsStateResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
      std::move(value));
}

WebUIGetBrowsingTopicsStateResult::WebUIGetBrowsingTopicsStateResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
    const std::string& value)
    : tag_(Tag::kOverrideStatusMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
            std::move(value)) {}

WebUIGetBrowsingTopicsStateResult::WebUIGetBrowsingTopicsStateResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
    WebUIBrowsingTopicsStatePtr value)
    : tag_(Tag::kBrowsingTopicsState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
            std::move(value)) {}
WebUIGetBrowsingTopicsStateResult::~WebUIGetBrowsingTopicsStateResult() {
  DestroyActive();
}

void WebUIGetBrowsingTopicsStateResult::set_override_status_message(const std::string& override_status_message) {
  if (tag_ == Tag::kOverrideStatusMessage) {
    data_.override_status_message = std::move(override_status_message);
  } else {
    DestroyActive();
    tag_ = Tag::kOverrideStatusMessage;
    new (&data_.override_status_message) std::string(
        std::move(override_status_message));
  }
}

void WebUIGetBrowsingTopicsStateResult::set_browsing_topics_state(WebUIBrowsingTopicsStatePtr browsing_topics_state) {
  if (tag_ == Tag::kBrowsingTopicsState) {
    data_.browsing_topics_state = std::move(browsing_topics_state);
  } else {
    DestroyActive();
    tag_ = Tag::kBrowsingTopicsState;
    new (&data_.browsing_topics_state) WebUIBrowsingTopicsStatePtr(
        std::move(browsing_topics_state));
  }
}


WebUIGetBrowsingTopicsStateResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
    const std::string& value)
    : override_status_message(std::move(value)) {}

WebUIGetBrowsingTopicsStateResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBrowsingTopicsState)>,
    WebUIBrowsingTopicsStatePtr value)
    : browsing_topics_state(std::move(value)) {}

void WebUIGetBrowsingTopicsStateResult::DestroyActive() {
  switch (tag_) {

    case Tag::kOverrideStatusMessage:
      std::destroy_at(&data_.override_status_message);
      break;
    case Tag::kBrowsingTopicsState:
      std::destroy_at(&data_.browsing_topics_state);
      break;
  }
}

bool WebUIGetBrowsingTopicsStateResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebUIGetModelInfoResultPtr
WebUIGetModelInfoResult::NewOverrideStatusMessage(
    const std::string& value) {
  return WebUIGetModelInfoResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
      std::move(value));
}

WebUIGetModelInfoResultPtr
WebUIGetModelInfoResult::NewModelInfo(
    WebUIModelInfoPtr value) {
  return WebUIGetModelInfoResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kModelInfo)>,
      std::move(value));
}

WebUIGetModelInfoResult::WebUIGetModelInfoResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
    const std::string& value)
    : tag_(Tag::kOverrideStatusMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
            std::move(value)) {}

WebUIGetModelInfoResult::WebUIGetModelInfoResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kModelInfo)>,
    WebUIModelInfoPtr value)
    : tag_(Tag::kModelInfo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kModelInfo)>,
            std::move(value)) {}
WebUIGetModelInfoResult::~WebUIGetModelInfoResult() {
  DestroyActive();
}

void WebUIGetModelInfoResult::set_override_status_message(const std::string& override_status_message) {
  if (tag_ == Tag::kOverrideStatusMessage) {
    data_.override_status_message = std::move(override_status_message);
  } else {
    DestroyActive();
    tag_ = Tag::kOverrideStatusMessage;
    new (&data_.override_status_message) std::string(
        std::move(override_status_message));
  }
}

void WebUIGetModelInfoResult::set_model_info(WebUIModelInfoPtr model_info) {
  if (tag_ == Tag::kModelInfo) {
    data_.model_info = std::move(model_info);
  } else {
    DestroyActive();
    tag_ = Tag::kModelInfo;
    new (&data_.model_info) WebUIModelInfoPtr(
        std::move(model_info));
  }
}


WebUIGetModelInfoResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOverrideStatusMessage)>,
    const std::string& value)
    : override_status_message(std::move(value)) {}

WebUIGetModelInfoResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kModelInfo)>,
    WebUIModelInfoPtr value)
    : model_info(std::move(value)) {}

void WebUIGetModelInfoResult::DestroyActive() {
  switch (tag_) {

    case Tag::kOverrideStatusMessage:
      std::destroy_at(&data_.override_status_message);
      break;
    case Tag::kModelInfo:
      std::destroy_at(&data_.model_info);
      break;
  }
}
size_t WebUIGetModelInfoResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kOverrideStatusMessage:
      return mojo::internal::Hash(seed, data_.override_status_message);
    case Tag::kModelInfo:
      return mojo::internal::Hash(seed, data_.model_info);
    default:
      NOTREACHED();
  }
}

bool WebUIGetModelInfoResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetBrowsingTopicsConfiguration: {
      return &PageHandler::GetBrowsingTopicsConfiguration_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetBrowsingTopicsState: {
      return &PageHandler::GetBrowsingTopicsState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetModelInfo: {
      return &PageHandler::GetModelInfo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClassifyHosts: {
      return &PageHandler::ClassifyHosts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetBrowsingTopicsConfiguration:
            return "Receive browsing_topics::mojom::PageHandler::GetBrowsingTopicsConfiguration";
      case messages::PageHandler::kGetBrowsingTopicsState:
            return "Receive browsing_topics::mojom::PageHandler::GetBrowsingTopicsState";
      case messages::PageHandler::kGetModelInfo:
            return "Receive browsing_topics::mojom::PageHandler::GetModelInfo";
      case messages::PageHandler::kClassifyHosts:
            return "Receive browsing_topics::mojom::PageHandler::ClassifyHosts";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetBrowsingTopicsConfiguration:
            return "Receive reply browsing_topics::mojom::PageHandler::GetBrowsingTopicsConfiguration";
      case messages::PageHandler::kGetBrowsingTopicsState:
            return "Receive reply browsing_topics::mojom::PageHandler::GetBrowsingTopicsState";
      case messages::PageHandler::kGetModelInfo:
            return "Receive reply browsing_topics::mojom::PageHandler::GetModelInfo";
      case messages::PageHandler::kClassifyHosts:
            return "Receive reply browsing_topics::mojom::PageHandler::ClassifyHosts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetBrowsingTopicsConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0739cf51;  // IPCStableHash for browsing_topics::mojom::PageHandler::GetBrowsingTopicsConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetBrowsingTopicsState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb6a6854;  // IPCStableHash for browsing_topics::mojom::PageHandler::GetBrowsingTopicsState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetModelInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9790c0e7;  // IPCStableHash for browsing_topics::mojom::PageHandler::GetModelInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ClassifyHosts_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09ae047f;  // IPCStableHash for browsing_topics::mojom::PageHandler::ClassifyHosts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback(
      PageHandler::GetBrowsingTopicsConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback(const PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback&) = delete;
  PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback& operator=(const PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetBrowsingTopicsConfigurationCallback callback_;
};

class PageHandler_GetBrowsingTopicsState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetBrowsingTopicsState_ForwardToCallback(
      PageHandler::GetBrowsingTopicsStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetBrowsingTopicsState_ForwardToCallback(const PageHandler_GetBrowsingTopicsState_ForwardToCallback&) = delete;
  PageHandler_GetBrowsingTopicsState_ForwardToCallback& operator=(const PageHandler_GetBrowsingTopicsState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetBrowsingTopicsStateCallback callback_;
};

class PageHandler_GetModelInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetModelInfo_ForwardToCallback(
      PageHandler::GetModelInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetModelInfo_ForwardToCallback(const PageHandler_GetModelInfo_ForwardToCallback&) = delete;
  PageHandler_GetModelInfo_ForwardToCallback& operator=(const PageHandler_GetModelInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetModelInfoCallback callback_;
};

class PageHandler_ClassifyHosts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ClassifyHosts_ForwardToCallback(
      PageHandler::ClassifyHostsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ClassifyHosts_ForwardToCallback(const PageHandler_ClassifyHosts_ForwardToCallback&) = delete;
  PageHandler_ClassifyHosts_ForwardToCallback& operator=(const PageHandler_ClassifyHosts_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ClassifyHostsCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetBrowsingTopicsConfiguration(
    GetBrowsingTopicsConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send browsing_topics::mojom::PageHandler::GetBrowsingTopicsConfiguration");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBrowsingTopicsConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetBrowsingTopicsConfiguration_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBrowsingTopicsConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetBrowsingTopicsState(
    bool in_calculate_now, GetBrowsingTopicsStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send browsing_topics::mojom::PageHandler::GetBrowsingTopicsState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("calculate_now"), in_calculate_now,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBrowsingTopicsState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetBrowsingTopicsState_Params_Data> params(
          message);
  params.Allocate();

  params->calculate_now = in_calculate_now;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBrowsingTopicsState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetBrowsingTopicsState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetModelInfo(
    GetModelInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send browsing_topics::mojom::PageHandler::GetModelInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModelInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetModelInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModelInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetModelInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ClassifyHosts(
    const std::vector<std::string>& in_hosts, ClassifyHostsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send browsing_topics::mojom::PageHandler::ClassifyHosts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hosts"), in_hosts,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClassifyHosts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_ClassifyHosts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hosts)::BaseType>
      hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_hosts,
    hosts_fragment,
    &hosts_validate_params);

  params->hosts.Set(
      hosts_fragment.is_null() ? nullptr : hosts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hosts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hosts in PageHandler.ClassifyHosts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClassifyHosts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ClassifyHosts_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetBrowsingTopicsConfigurationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder> proxy(
        new PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetBrowsingTopicsConfigurationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebUIBrowsingTopicsConfigurationPtr in_config);
};

bool PageHandler_GetBrowsingTopicsConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  WebUIBrowsingTopicsConfigurationPtr p_config{};
  PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_config));
  }
  return true;
}

void PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder::Run(
    WebUIBrowsingTopicsConfigurationPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browsing_topics::mojom::PageHandler::GetBrowsingTopicsConfiguration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type WebUIBrowsingTopicsConfigurationPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBrowsingTopicsConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBrowsingTopicsConfiguration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetBrowsingTopicsState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetBrowsingTopicsStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetBrowsingTopicsState_ProxyToResponder> proxy(
        new PageHandler_GetBrowsingTopicsState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetBrowsingTopicsState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetBrowsingTopicsState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetBrowsingTopicsState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetBrowsingTopicsStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebUIGetBrowsingTopicsStateResultPtr in_result);
};

bool PageHandler_GetBrowsingTopicsState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetBrowsingTopicsState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetBrowsingTopicsState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  WebUIGetBrowsingTopicsStateResultPtr p_result{};
  PageHandler_GetBrowsingTopicsState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageHandler_GetBrowsingTopicsState_ProxyToResponder::Run(
    WebUIGetBrowsingTopicsStateResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browsing_topics::mojom::PageHandler::GetBrowsingTopicsState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebUIGetBrowsingTopicsStateResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetBrowsingTopicsState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetBrowsingTopicsState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetBrowsingTopicsState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetModelInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetModelInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetModelInfo_ProxyToResponder> proxy(
        new PageHandler_GetModelInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetModelInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetModelInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetModelInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetModelInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebUIGetModelInfoResultPtr in_result);
};

bool PageHandler_GetModelInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetModelInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetModelInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  WebUIGetModelInfoResultPtr p_result{};
  PageHandler_GetModelInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageHandler_GetModelInfo_ProxyToResponder::Run(
    WebUIGetModelInfoResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browsing_topics::mojom::PageHandler::GetModelInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebUIGetModelInfoResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModelInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_GetModelInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::browsing_topics::mojom::WebUIGetModelInfoResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModelInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ClassifyHosts_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ClassifyHostsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ClassifyHosts_ProxyToResponder> proxy(
        new PageHandler_ClassifyHosts_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ClassifyHosts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ClassifyHosts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ClassifyHosts_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ClassifyHostsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<std::vector<WebUITopicPtr>> in_topics_for_hosts);
};

bool PageHandler_ClassifyHosts_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ClassifyHosts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ClassifyHosts_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::vector<std::vector<WebUITopicPtr>> p_topics_for_hosts{};
  PageHandler_ClassifyHosts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTopicsForHosts(&p_topics_for_hosts))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_topics_for_hosts));
  }
  return true;
}

void PageHandler_ClassifyHosts_ProxyToResponder::Run(
    std::vector<std::vector<WebUITopicPtr>> in_topics_for_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browsing_topics::mojom::PageHandler::ClassifyHosts", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("topics_for_hosts"), in_topics_for_hosts,
                        "<value of type std::vector<std::vector<WebUITopicPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClassifyHosts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browsing_topics::mojom::internal::PageHandler_ClassifyHosts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->topics_for_hosts)::BaseType>
      topics_for_hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& topics_for_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::browsing_topics::mojom::WebUITopicDataView>>>(
    in_topics_for_hosts,
    topics_for_hosts_fragment,
    &topics_for_hosts_validate_params);

  params->topics_for_hosts.Set(
      topics_for_hosts_fragment.is_null() ? nullptr : topics_for_hosts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->topics_for_hosts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null topics_for_hosts in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ClassifyHosts");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetBrowsingTopicsConfiguration: {
      break;
    }
    case messages::PageHandler::kGetBrowsingTopicsState: {
      break;
    }
    case messages::PageHandler::kGetModelInfo: {
      break;
    }
    case messages::PageHandler::kClassifyHosts: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetBrowsingTopicsConfiguration: {
      internal::PageHandler_GetBrowsingTopicsConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetBrowsingTopicsConfiguration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetBrowsingTopicsConfiguration_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetBrowsingTopicsConfiguration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBrowsingTopicsConfiguration(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetBrowsingTopicsState: {
      internal::PageHandler_GetBrowsingTopicsState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetBrowsingTopicsState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      bool p_calculate_now{};
      PageHandler_GetBrowsingTopicsState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_calculate_now = input_data_view.calculate_now();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetBrowsingTopicsState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBrowsingTopicsState(        
        std::move(p_calculate_now), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetModelInfo: {
      internal::PageHandler_GetModelInfo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetModelInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetModelInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetModelInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetModelInfo(std::move(callback));
      return true;
    }
    case messages::PageHandler::kClassifyHosts: {
      internal::PageHandler_ClassifyHosts_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ClassifyHosts_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::vector<std::string> p_hosts{};
      PageHandler_ClassifyHosts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHosts(&p_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_ClassifyHosts_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClassifyHosts(        
        std::move(p_hosts), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetBrowsingTopicsConfiguration_Params_Data::Validate,
     &internal::PageHandler_GetBrowsingTopicsConfiguration_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetBrowsingTopicsState_Params_Data::Validate,
     &internal::PageHandler_GetBrowsingTopicsState_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetModelInfo_Params_Data::Validate,
     &internal::PageHandler_GetModelInfo_ResponseParams_Data::Validate},
    { &internal::PageHandler_ClassifyHosts_Params_Data::Validate,
     &internal::PageHandler_ClassifyHosts_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::browsing_topics::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::browsing_topics::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}


}  // browsing_topics::mojom


namespace mojo {


// static
bool StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::DataView, ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr>::Read(
    ::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::DataView input,
    ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr* output) {
  bool success = true;
  ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationPtr result(::browsing_topics::mojom::WebUIBrowsingTopicsConfiguration::New());
  
      if (success)
        result->browsing_topics_enabled = input.browsing_topics_enabled();
      if (success)
        result->privacy_sandbox_ads_apis_override_enabled = input.privacy_sandbox_ads_apis_override_enabled();
      if (success)
        result->override_privacy_sandbox_settings_local_testing_enabled = input.override_privacy_sandbox_settings_local_testing_enabled();
      if (success)
        result->browsing_topics_bypass_ip_is_publicly_routable_check_enabled = input.browsing_topics_bypass_ip_is_publicly_routable_check_enabled();
      if (success)
        result->browsing_topics_document_api_enabled = input.browsing_topics_document_api_enabled();
      if (success)
        result->config_version = input.config_version();
      if (success)
        result->browsing_topics_parameters_enabled = input.browsing_topics_parameters_enabled();
      if (success)
        result->number_of_epochs_to_expose = input.number_of_epochs_to_expose();
      if (success && !input.ReadTimePeriodPerEpoch(&result->time_period_per_epoch))
        success = false;
      if (success)
        result->number_of_top_topics_per_epoch = input.number_of_top_topics_per_epoch();
      if (success)
        result->use_random_topic_probability_percent = input.use_random_topic_probability_percent();
      if (success && !input.ReadMaxEpochIntroductionDelay(&result->max_epoch_introduction_delay))
        success = false;
      if (success)
        result->number_of_epochs_of_observation_data_to_use_for_filtering = input.number_of_epochs_of_observation_data_to_use_for_filtering();
      if (success)
        result->max_number_of_api_usage_context_domains_to_keep_per_topic = input.max_number_of_api_usage_context_domains_to_keep_per_topic();
      if (success)
        result->max_number_of_api_usage_context_entries_to_load_per_epoch = input.max_number_of_api_usage_context_entries_to_load_per_epoch();
      if (success)
        result->max_number_of_api_usage_context_domains_to_store_per_page_load = input.max_number_of_api_usage_context_domains_to_store_per_page_load();
      if (success)
        result->taxonomy_version = input.taxonomy_version();
      if (success && !input.ReadDisabledTopicsList(&result->disabled_topics_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::browsing_topics::mojom::WebUITopic::DataView, ::browsing_topics::mojom::WebUITopicPtr>::Read(
    ::browsing_topics::mojom::WebUITopic::DataView input,
    ::browsing_topics::mojom::WebUITopicPtr* output) {
  bool success = true;
  ::browsing_topics::mojom::WebUITopicPtr result(::browsing_topics::mojom::WebUITopic::New());
  
      if (success)
        result->topic_id = input.topic_id();
      if (success && !input.ReadTopicName(&result->topic_name))
        success = false;
      if (success)
        result->is_real_topic = input.is_real_topic();
      if (success && !input.ReadObservedByDomains(&result->observed_by_domains))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::browsing_topics::mojom::WebUIEpoch::DataView, ::browsing_topics::mojom::WebUIEpochPtr>::Read(
    ::browsing_topics::mojom::WebUIEpoch::DataView input,
    ::browsing_topics::mojom::WebUIEpochPtr* output) {
  bool success = true;
  ::browsing_topics::mojom::WebUIEpochPtr result(::browsing_topics::mojom::WebUIEpoch::New());
  
      if (success && !input.ReadTopics(&result->topics))
        success = false;
      if (success && !input.ReadCalculationTime(&result->calculation_time))
        success = false;
      if (success && !input.ReadModelVersion(&result->model_version))
        success = false;
      if (success && !input.ReadTaxonomyVersion(&result->taxonomy_version))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsState::DataView, ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr>::Read(
    ::browsing_topics::mojom::WebUIBrowsingTopicsState::DataView input,
    ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr* output) {
  bool success = true;
  ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr result(::browsing_topics::mojom::WebUIBrowsingTopicsState::New());
  
      if (success && !input.ReadEpochs(&result->epochs))
        success = false;
      if (success && !input.ReadNextScheduledCalculationTime(&result->next_scheduled_calculation_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::browsing_topics::mojom::WebUIModelInfo::DataView, ::browsing_topics::mojom::WebUIModelInfoPtr>::Read(
    ::browsing_topics::mojom::WebUIModelInfo::DataView input,
    ::browsing_topics::mojom::WebUIModelInfoPtr* output) {
  bool success = true;
  ::browsing_topics::mojom::WebUIModelInfoPtr result(::browsing_topics::mojom::WebUIModelInfo::New());
  
      if (success && !input.ReadModelVersion(&result->model_version))
        success = false;
      if (success && !input.ReadModelFilePath(&result->model_file_path))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult::DataView, ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr>::Read(
    ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult::DataView input,
    ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultPtr* output) {
  using UnionType = ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kOverrideStatusMessage: {
      std::string result_override_status_message{};
      if (!input.ReadOverrideStatusMessage(&result_override_status_message))
        return false;

      *output = UnionType::NewOverrideStatusMessage(
          std::move(result_override_status_message));
      break;
    }
    case Tag::kBrowsingTopicsState: {
      ::browsing_topics::mojom::WebUIBrowsingTopicsStatePtr result_browsing_topics_state{};
      if (!input.ReadBrowsingTopicsState(&result_browsing_topics_state))
        return false;

      *output = UnionType::NewBrowsingTopicsState(
          std::move(result_browsing_topics_state));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::browsing_topics::mojom::WebUIGetModelInfoResult::DataView, ::browsing_topics::mojom::WebUIGetModelInfoResultPtr>::Read(
    ::browsing_topics::mojom::WebUIGetModelInfoResult::DataView input,
    ::browsing_topics::mojom::WebUIGetModelInfoResultPtr* output) {
  using UnionType = ::browsing_topics::mojom::WebUIGetModelInfoResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kOverrideStatusMessage: {
      std::string result_override_status_message{};
      if (!input.ReadOverrideStatusMessage(&result_override_status_message))
        return false;

      *output = UnionType::NewOverrideStatusMessage(
          std::move(result_override_status_message));
      break;
    }
    case Tag::kModelInfo: {
      ::browsing_topics::mojom::WebUIModelInfoPtr result_model_info{};
      if (!input.ReadModelInfo(&result_model_info))
        return false;

      *output = UnionType::NewModelInfo(
          std::move(result_model_info));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace browsing_topics::mojom {


void PageHandlerInterceptorForTesting::GetBrowsingTopicsConfiguration(GetBrowsingTopicsConfigurationCallback callback) {
  GetForwardingInterface()->GetBrowsingTopicsConfiguration(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetBrowsingTopicsState(bool calculate_now, GetBrowsingTopicsStateCallback callback) {
  GetForwardingInterface()->GetBrowsingTopicsState(
    std::move(calculate_now)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetModelInfo(GetModelInfoCallback callback) {
  GetForwardingInterface()->GetModelInfo(std::move(callback));
}
void PageHandlerInterceptorForTesting::ClassifyHosts(const std::vector<std::string>& hosts, ClassifyHostsCallback callback) {
  GetForwardingInterface()->ClassifyHosts(
    std::move(hosts)
    , std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetBrowsingTopicsConfiguration(
    WebUIBrowsingTopicsConfigurationPtr* out_config) {
  base::RunLoop loop;
  proxy_->GetBrowsingTopicsConfiguration(
      base::BindOnce(
          [](base::RunLoop* loop,
             WebUIBrowsingTopicsConfigurationPtr* out_config
,
             WebUIBrowsingTopicsConfigurationPtr config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

WebUIBrowsingTopicsConfigurationPtr PageHandlerAsyncWaiter::GetBrowsingTopicsConfiguration(
    ) {
  WebUIBrowsingTopicsConfigurationPtr async_wait_result;
  GetBrowsingTopicsConfiguration(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetBrowsingTopicsState(
    bool calculate_now, WebUIGetBrowsingTopicsStateResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetBrowsingTopicsState(
      std::move(calculate_now),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebUIGetBrowsingTopicsStateResultPtr* out_result
,
             WebUIGetBrowsingTopicsStateResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebUIGetBrowsingTopicsStateResultPtr PageHandlerAsyncWaiter::GetBrowsingTopicsState(
    bool calculate_now) {
  WebUIGetBrowsingTopicsStateResultPtr async_wait_result;
  GetBrowsingTopicsState(std::move(calculate_now),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetModelInfo(
    WebUIGetModelInfoResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetModelInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             WebUIGetModelInfoResultPtr* out_result
,
             WebUIGetModelInfoResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebUIGetModelInfoResultPtr PageHandlerAsyncWaiter::GetModelInfo(
    ) {
  WebUIGetModelInfoResultPtr async_wait_result;
  GetModelInfo(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ClassifyHosts(
    const std::vector<std::string>& hosts, std::vector<std::vector<WebUITopicPtr>>* out_topics_for_hosts) {
  base::RunLoop loop;
  proxy_->ClassifyHosts(
      std::move(hosts),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::vector<WebUITopicPtr>>* out_topics_for_hosts
,
             std::vector<std::vector<WebUITopicPtr>> topics_for_hosts) {*out_topics_for_hosts = std::move(topics_for_hosts);
            loop->Quit();
          },
          &loop,
          out_topics_for_hosts));
  loop.Run();
}

std::vector<std::vector<WebUITopicPtr>> PageHandlerAsyncWaiter::ClassifyHosts(
    const std::vector<std::string>& hosts) {
  std::vector<std::vector<WebUITopicPtr>> async_wait_result;
  ClassifyHosts(std::move(hosts),&async_wait_result);
  return async_wait_result;
}






}  // browsing_topics::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif