// components/browsing_topics/mojom/browsing_topics_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_SHARED_H_
#define COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/browsing_topics/mojom/browsing_topics_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::browsing_topics::mojom::internal::WebUIBrowsingTopicsConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->browsing_topics_enabled = Traits::browsing_topics_enabled(input);

    fragment->privacy_sandbox_ads_apis_override_enabled = Traits::privacy_sandbox_ads_apis_override_enabled(input);

    fragment->override_privacy_sandbox_settings_local_testing_enabled = Traits::override_privacy_sandbox_settings_local_testing_enabled(input);

    fragment->browsing_topics_bypass_ip_is_publicly_routable_check_enabled = Traits::browsing_topics_bypass_ip_is_publicly_routable_check_enabled(input);

    fragment->browsing_topics_document_api_enabled = Traits::browsing_topics_document_api_enabled(input);

    fragment->config_version = Traits::config_version(input);

    fragment->browsing_topics_parameters_enabled = Traits::browsing_topics_parameters_enabled(input);

    fragment->number_of_epochs_to_expose = Traits::number_of_epochs_to_expose(input);

    decltype(Traits::time_period_per_epoch(input)) in_time_period_per_epoch = Traits::time_period_per_epoch(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_period_per_epoch)::BaseType> time_period_per_epoch_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_period_per_epoch,
      time_period_per_epoch_fragment);

    fragment->time_period_per_epoch.Set(
        time_period_per_epoch_fragment.is_null() ? nullptr : time_period_per_epoch_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time_period_per_epoch.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_period_per_epoch in WebUIBrowsingTopicsConfiguration struct");

    fragment->number_of_top_topics_per_epoch = Traits::number_of_top_topics_per_epoch(input);

    fragment->use_random_topic_probability_percent = Traits::use_random_topic_probability_percent(input);

    decltype(Traits::max_epoch_introduction_delay(input)) in_max_epoch_introduction_delay = Traits::max_epoch_introduction_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_epoch_introduction_delay)::BaseType> max_epoch_introduction_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_max_epoch_introduction_delay,
      max_epoch_introduction_delay_fragment);

    fragment->max_epoch_introduction_delay.Set(
        max_epoch_introduction_delay_fragment.is_null() ? nullptr : max_epoch_introduction_delay_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_epoch_introduction_delay.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_epoch_introduction_delay in WebUIBrowsingTopicsConfiguration struct");

    fragment->number_of_epochs_of_observation_data_to_use_for_filtering = Traits::number_of_epochs_of_observation_data_to_use_for_filtering(input);

    fragment->max_number_of_api_usage_context_domains_to_keep_per_topic = Traits::max_number_of_api_usage_context_domains_to_keep_per_topic(input);

    fragment->max_number_of_api_usage_context_entries_to_load_per_epoch = Traits::max_number_of_api_usage_context_entries_to_load_per_epoch(input);

    fragment->max_number_of_api_usage_context_domains_to_store_per_page_load = Traits::max_number_of_api_usage_context_domains_to_store_per_page_load(input);

    fragment->taxonomy_version = Traits::taxonomy_version(input);

    decltype(Traits::disabled_topics_list(input)) in_disabled_topics_list = Traits::disabled_topics_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disabled_topics_list)::BaseType> disabled_topics_list_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_disabled_topics_list,
      disabled_topics_list_fragment);

    fragment->disabled_topics_list.Set(
        disabled_topics_list_fragment.is_null() ? nullptr : disabled_topics_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->disabled_topics_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disabled_topics_list in WebUIBrowsingTopicsConfiguration struct");
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIBrowsingTopicsConfiguration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIBrowsingTopicsConfigurationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUITopicDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::browsing_topics::mojom::WebUITopicDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::browsing_topics::mojom::internal::WebUITopic_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->topic_id = Traits::topic_id(input);

    decltype(Traits::topic_name(input)) in_topic_name = Traits::topic_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->topic_name)::BaseType> topic_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_topic_name,
      topic_name_fragment);

    fragment->topic_name.Set(
        topic_name_fragment.is_null() ? nullptr : topic_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->topic_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null topic_name in WebUITopic struct");

    fragment->is_real_topic = Traits::is_real_topic(input);

    decltype(Traits::observed_by_domains(input)) in_observed_by_domains = Traits::observed_by_domains(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->observed_by_domains)::BaseType>
        observed_by_domains_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& observed_by_domains_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_observed_by_domains,
      observed_by_domains_fragment,
      &observed_by_domains_validate_params);

    fragment->observed_by_domains.Set(
        observed_by_domains_fragment.is_null() ? nullptr : observed_by_domains_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->observed_by_domains.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null observed_by_domains in WebUITopic struct");
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUITopic_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUITopicDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIEpochDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::browsing_topics::mojom::WebUIEpochDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::browsing_topics::mojom::internal::WebUIEpoch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::topics(input)) in_topics = Traits::topics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->topics)::BaseType>
        topics_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& topics_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::browsing_topics::mojom::WebUITopicDataView>>(
      in_topics,
      topics_fragment,
      &topics_validate_params);

    fragment->topics.Set(
        topics_fragment.is_null() ? nullptr : topics_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->topics.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null topics in WebUIEpoch struct");

    decltype(Traits::calculation_time(input)) in_calculation_time = Traits::calculation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->calculation_time)::BaseType> calculation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_calculation_time,
      calculation_time_fragment);

    fragment->calculation_time.Set(
        calculation_time_fragment.is_null() ? nullptr : calculation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->calculation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null calculation_time in WebUIEpoch struct");

    decltype(Traits::model_version(input)) in_model_version = Traits::model_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_version)::BaseType> model_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_version,
      model_version_fragment);

    fragment->model_version.Set(
        model_version_fragment.is_null() ? nullptr : model_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_version in WebUIEpoch struct");

    decltype(Traits::taxonomy_version(input)) in_taxonomy_version = Traits::taxonomy_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->taxonomy_version)::BaseType> taxonomy_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_taxonomy_version,
      taxonomy_version_fragment);

    fragment->taxonomy_version.Set(
        taxonomy_version_fragment.is_null() ? nullptr : taxonomy_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->taxonomy_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null taxonomy_version in WebUIEpoch struct");
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIEpoch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIEpochDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::browsing_topics::mojom::internal::WebUIBrowsingTopicsState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::epochs(input)) in_epochs = Traits::epochs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->epochs)::BaseType>
        epochs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& epochs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::browsing_topics::mojom::WebUIEpochDataView>>(
      in_epochs,
      epochs_fragment,
      &epochs_validate_params);

    fragment->epochs.Set(
        epochs_fragment.is_null() ? nullptr : epochs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->epochs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null epochs in WebUIBrowsingTopicsState struct");

    decltype(Traits::next_scheduled_calculation_time(input)) in_next_scheduled_calculation_time = Traits::next_scheduled_calculation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->next_scheduled_calculation_time)::BaseType> next_scheduled_calculation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_next_scheduled_calculation_time,
      next_scheduled_calculation_time_fragment);

    fragment->next_scheduled_calculation_time.Set(
        next_scheduled_calculation_time_fragment.is_null() ? nullptr : next_scheduled_calculation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->next_scheduled_calculation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null next_scheduled_calculation_time in WebUIBrowsingTopicsState struct");
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIBrowsingTopicsState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIModelInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::browsing_topics::mojom::WebUIModelInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::browsing_topics::mojom::internal::WebUIModelInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::model_version(input)) in_model_version = Traits::model_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_version)::BaseType> model_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_version,
      model_version_fragment);

    fragment->model_version.Set(
        model_version_fragment.is_null() ? nullptr : model_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_version in WebUIModelInfo struct");

    decltype(Traits::model_file_path(input)) in_model_file_path = Traits::model_file_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_file_path)::BaseType> model_file_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_file_path,
      model_file_path_fragment);

    fragment->model_file_path.Set(
        model_file_path_fragment.is_null() ? nullptr : model_file_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_file_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_file_path in WebUIModelInfo struct");
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIModelInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIModelInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::browsing_topics::mojom::internal::WebUIGetBrowsingTopicsStateResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView::Tag::kOverrideStatusMessage: {
    decltype(Traits::override_status_message(input))
    in_override_status_message = Traits::override_status_message(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_override_status_message)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_override_status_message,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null override_status_message in WebUIGetBrowsingTopicsStateResult union");
    fragment->data.f_override_status_message.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView::Tag::kBrowsingTopicsState: {
    decltype(Traits::browsing_topics_state(input))
    in_browsing_topics_state = Traits::browsing_topics_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_browsing_topics_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::browsing_topics::mojom::WebUIBrowsingTopicsStateDataView>(
  in_browsing_topics_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null browsing_topics_state in WebUIGetBrowsingTopicsStateResult union");
    fragment->data.f_browsing_topics_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIGetBrowsingTopicsStateResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIGetBrowsingTopicsStateResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::browsing_topics::mojom::WebUIGetModelInfoResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::browsing_topics::mojom::WebUIGetModelInfoResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::browsing_topics::mojom::internal::WebUIGetModelInfoResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::browsing_topics::mojom::WebUIGetModelInfoResultDataView::Tag::kOverrideStatusMessage: {
    decltype(Traits::override_status_message(input))
    in_override_status_message = Traits::override_status_message(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_override_status_message)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_override_status_message,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null override_status_message in WebUIGetModelInfoResult union");
    fragment->data.f_override_status_message.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::browsing_topics::mojom::WebUIGetModelInfoResultDataView::Tag::kModelInfo: {
    decltype(Traits::model_info(input))
    in_model_info = Traits::model_info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_model_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::browsing_topics::mojom::WebUIModelInfoDataView>(
  in_model_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null model_info in WebUIGetModelInfoResult union");
    fragment->data.f_model_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::browsing_topics::mojom::internal::WebUIGetModelInfoResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::browsing_topics::mojom::WebUIGetModelInfoResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace browsing_topics::mojom {

inline void WebUIBrowsingTopicsConfigurationDataView::GetTimePeriodPerEpochDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_period_per_epoch.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WebUIBrowsingTopicsConfigurationDataView::GetMaxEpochIntroductionDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->max_epoch_introduction_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WebUIBrowsingTopicsConfigurationDataView::GetDisabledTopicsListDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->disabled_topics_list.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebUITopicDataView::GetTopicNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->topic_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void WebUITopicDataView::GetObservedByDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->observed_by_domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void WebUIEpochDataView::GetTopicsDataView(
    mojo::ArrayDataView<WebUITopicDataView>* output) {
  auto pointer = data_->topics.Get();
  *output = mojo::ArrayDataView<WebUITopicDataView>(pointer, message_);
}
inline void WebUIEpochDataView::GetCalculationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->calculation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void WebUIEpochDataView::GetModelVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIEpochDataView::GetTaxonomyVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->taxonomy_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebUIBrowsingTopicsStateDataView::GetEpochsDataView(
    mojo::ArrayDataView<WebUIEpochDataView>* output) {
  auto pointer = data_->epochs.Get();
  *output = mojo::ArrayDataView<WebUIEpochDataView>(pointer, message_);
}
inline void WebUIBrowsingTopicsStateDataView::GetNextScheduledCalculationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->next_scheduled_calculation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void WebUIModelInfoDataView::GetModelVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIModelInfoDataView::GetModelFilePathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_file_path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebUIGetBrowsingTopicsStateResultDataView::GetOverrideStatusMessageDataView(
    mojo::StringDataView* output) const {
  CHECK(is_override_status_message());
  *output = mojo::StringDataView(data_->data.f_override_status_message.Get(), message_);
}
inline void WebUIGetBrowsingTopicsStateResultDataView::GetBrowsingTopicsStateDataView(
    WebUIBrowsingTopicsStateDataView* output) const {
  CHECK(is_browsing_topics_state());
  *output = WebUIBrowsingTopicsStateDataView(data_->data.f_browsing_topics_state.Get(), message_);
}

inline void WebUIGetModelInfoResultDataView::GetOverrideStatusMessageDataView(
    mojo::StringDataView* output) const {
  CHECK(is_override_status_message());
  *output = mojo::StringDataView(data_->data.f_override_status_message.Get(), message_);
}
inline void WebUIGetModelInfoResultDataView::GetModelInfoDataView(
    WebUIModelInfoDataView* output) const {
  CHECK(is_model_info());
  *output = WebUIModelInfoDataView(data_->data.f_model_info.Get(), message_);
}


}  // browsing_topics::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_BROWSING_TOPICS_MOJOM_BROWSING_TOPICS_INTERNALS_MOJOM_SHARED_H_