// components/browser_apis/tab_strip/tab_strip_api.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SEND_VALIDATION_H_

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-shared-internal.h"
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"
#include "mojo/public/mojom/base/empty.mojom-shared.h"
#include "mojo/public/mojom/base/error.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabsSnapshotDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabsSnapshotDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabsSnapshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tab_strip(input)) in_tab_strip = Traits::tab_strip(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tab_strip)::BaseType> tab_strip_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tabs_api::mojom::ContainerDataView, send_validation>(
        in_tab_strip,
        tab_strip_fragment);

      fragment->tab_strip.Set(
          tab_strip_fragment.is_null() ? nullptr : tab_strip_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tab_strip.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab_strip in TabsSnapshot struct");

      decltype(Traits::stream(input)) in_stream = Traits::stream(input);

      
      mojo::internal::Serialize<::tabs_api::mojom::TabsObserverAssociatedRequestDataView>(
        in_stream,
        &fragment->stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid stream in TabsSnapshot struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabsEventDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabsEventDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabsEvent_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabsEventDataView::Tag::kTabsCreatedEvent: {
    decltype(Traits::tabs_created_event(input))
    in_tabs_created_event = Traits::tabs_created_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tabs_created_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnTabsCreatedEventDataView, send_validation>(
  in_tabs_created_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tabs_created_event in TabsEvent union");
    fragment->data.f_tabs_created_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kTabsClosedEvent: {
    decltype(Traits::tabs_closed_event(input))
    in_tabs_closed_event = Traits::tabs_closed_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tabs_closed_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnTabsClosedEventDataView, send_validation>(
  in_tabs_closed_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tabs_closed_event in TabsEvent union");
    fragment->data.f_tabs_closed_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kNodeMovedEvent: {
    decltype(Traits::node_moved_event(input))
    in_node_moved_event = Traits::node_moved_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_node_moved_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnNodeMovedEventDataView, send_validation>(
  in_node_moved_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null node_moved_event in TabsEvent union");
    fragment->data.f_node_moved_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kDataChangedEvent: {
    decltype(Traits::data_changed_event(input))
    in_data_changed_event = Traits::data_changed_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data_changed_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnDataChangedEventDataView, send_validation>(
  in_data_changed_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data_changed_event in TabsEvent union");
    fragment->data.f_data_changed_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kCollectionCreatedEvent: {
    decltype(Traits::collection_created_event(input))
    in_collection_created_event = Traits::collection_created_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_collection_created_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnCollectionCreatedEventDataView, send_validation>(
  in_collection_created_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null collection_created_event in TabsEvent union");
    fragment->data.f_collection_created_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_GetTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabsSnapshotDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_GetTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_GetTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_GetTab_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_GetTab_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_GetTab_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_CreateTabAt_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_CreateTabAt_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_CreateTabAt_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_CloseTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_CloseTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_CloseTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_ActivateTab_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_ActivateTab_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_ActivateTab_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_SetSelectedTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_SetSelectedTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_MoveNode_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_MoveNode_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_MoveNode_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SEND_VALIDATION_H_