// components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ColorSpec as tabGroups_mojom_ColorSpec,
  Color as tabGroups_mojom_Color
} from './tab_group_types.mojom-webui.js';
import {
  NodeIdSpec as tabsApi_mojom_NodeIdSpec,
  PositionSpec as tabsApi_mojom_PositionSpec,
  Position as tabsApi_mojom_Position
} from './tab_strip_api_types.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const AlertStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AlertState {

  MIN_VALUE = 0,
  MAX_VALUE = 16,
  kAudioMuting = 0,
  kAudioRecording = 1,
  kAudioPlaying = 2,
  kBluetoothConnected = 3,
  kBluetoothScanActive = 4,
  kDesktopCapturing = 5,
  kActorAccessing = 6,
  kGlicAccessing = 7,
  kGlicSharing = 8,
  kHidConnected = 9,
  kMediaRecording = 10,
  kPipPlaying = 11,
  kSerialConnected = 12,
  kTabCapturing = 13,
  kUsbConnected = 14,
  kVideoRecording = 15,
  kVrPresentingInHeadset = 16,
}

export const NetworkStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum NetworkState {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kNone = 0,
  kWaiting = 1,
  kLoading = 2,
  kError = 3,
}


export const ImageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PinnedTabsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UnpinnedTabsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabGroupVisualDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SplitTabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SplitTabVisualDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ContainerSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabCreatedContainerSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ImageMojoType {
  dataUrl: url_mojom_Url;
}


export type Image = ImageMojoType;
mojo.internal.Struct<ImageMojoType>(
    ImageSpec.$,
    'Image',
    [
      mojo.internal.StructField<ImageMojoType, url_mojom_Url>(
        'dataUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabMojoType {
  id: string;
  title: string;
  url: url_mojom_Url;
  favicon: Image;
  alertStates: AlertState[];
  networkState: NetworkState;
  isActive: boolean;
  isSelected: boolean;
  isBlocked: boolean;
}


export type Tab = TabMojoType;
mojo.internal.Struct<TabMojoType>(
    TabSpec.$,
    'Tab',
    [
      mojo.internal.StructField<TabMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, Image>(
        'favicon', 24,
        0,
        ImageSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, AlertState[]>(
        'alertStates', 32,
        0,
        mojo.internal.Array(AlertStateSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, NetworkState>(
        'networkState', 40,
        0,
        NetworkStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'isActive', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'isSelected', 44,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'isBlocked', 44,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface TabStripMojoType {
  id: string;
}


export type TabStrip = TabStripMojoType;
mojo.internal.Struct<TabStripMojoType>(
    TabStripSpec.$,
    'TabStrip',
    [
      mojo.internal.StructField<TabStripMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PinnedTabsMojoType {
  id: string;
}


export type PinnedTabs = PinnedTabsMojoType;
mojo.internal.Struct<PinnedTabsMojoType>(
    PinnedTabsSpec.$,
    'PinnedTabs',
    [
      mojo.internal.StructField<PinnedTabsMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UnpinnedTabsMojoType {
  id: string;
}


export type UnpinnedTabs = UnpinnedTabsMojoType;
mojo.internal.Struct<UnpinnedTabsMojoType>(
    UnpinnedTabsSpec.$,
    'UnpinnedTabs',
    [
      mojo.internal.StructField<UnpinnedTabsMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabGroupMojoType {
  id: string;
  data: TabGroupVisualData;
}


export type TabGroup = TabGroupMojoType;
mojo.internal.Struct<TabGroupMojoType>(
    TabGroupSpec.$,
    'TabGroup',
    [
      mojo.internal.StructField<TabGroupMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, TabGroupVisualData>(
        'data', 8,
        0,
        TabGroupVisualDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabGroupVisualDataMojoType {
  title: string;
  color: tabGroups_mojom_Color;
  isCollapsed: boolean;
}


export type TabGroupVisualData = TabGroupVisualDataMojoType;
mojo.internal.Struct<TabGroupVisualDataMojoType>(
    TabGroupVisualDataSpec.$,
    'TabGroupVisualData',
    [
      mojo.internal.StructField<TabGroupVisualDataMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupVisualDataMojoType, tabGroups_mojom_Color>(
        'color', 8,
        0,
        tabGroups_mojom_ColorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupVisualDataMojoType, boolean>(
        'isCollapsed', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SplitTabMojoType {
  id: string;
  data: SplitTabVisualData;
}


export type SplitTab = SplitTabMojoType;
mojo.internal.Struct<SplitTabMojoType>(
    SplitTabSpec.$,
    'SplitTab',
    [
      mojo.internal.StructField<SplitTabMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SplitTabMojoType, SplitTabVisualData>(
        'data', 8,
        0,
        SplitTabVisualDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);




export const SplitTabVisualData_LayoutSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SplitTabVisualData_Layout {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kVertical = 0,
  kHorizontal = 1,
}


export interface SplitTabVisualDataMojoType {
  layout: SplitTabVisualData_Layout;
  splitRatio: number;
}


export type SplitTabVisualData = SplitTabVisualDataMojoType;
mojo.internal.Struct<SplitTabVisualDataMojoType>(
    SplitTabVisualDataSpec.$,
    'SplitTabVisualData',
    [
      mojo.internal.StructField<SplitTabVisualDataMojoType, SplitTabVisualData_Layout>(
        'layout', 0,
        0,
        SplitTabVisualData_LayoutSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SplitTabVisualDataMojoType, number>(
        'splitRatio', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ContainerMojoType {
  data: Data;
  children: Container[];
}


export type Container = ContainerMojoType;
mojo.internal.Struct<ContainerMojoType>(
    ContainerSpec.$,
    'Container',
    [
      mojo.internal.StructField<ContainerMojoType, Data>(
        'data', 0,
        0,
        DataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ContainerMojoType, Container[]>(
        'children', 16,
        0,
        mojo.internal.Array(ContainerSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabCreatedContainerMojoType {
  tab: Tab;
  position: tabsApi_mojom_Position;
}


export type TabCreatedContainer = TabCreatedContainerMojoType;
mojo.internal.Struct<TabCreatedContainerMojoType>(
    TabCreatedContainerSpec.$,
    'TabCreatedContainer',
    [
      mojo.internal.StructField<TabCreatedContainerMojoType, Tab>(
        'tab', 0,
        0,
        TabSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabCreatedContainerMojoType, tabsApi_mojom_Position>(
        'position', 8,
        0,
        tabsApi_mojom_PositionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



mojo.internal.Union(
    DataSpec.$, 'Data',
    {
      'tab': {
        'ordinal': 0,
        'type': TabSpec.$,
      },
      'tabStrip': {
        'ordinal': 1,
        'type': TabStripSpec.$,
      },
      'pinnedTabs': {
        'ordinal': 2,
        'type': PinnedTabsSpec.$,
      },
      'unpinnedTabs': {
        'ordinal': 3,
        'type': UnpinnedTabsSpec.$,
      },
      'tabGroup': {
        'ordinal': 4,
        'type': TabGroupSpec.$,
      },
      'splitTab': {
        'ordinal': 5,
        'type': SplitTabSpec.$,
      },
    });

export interface Data {
  tab?: Tab,
  tabStrip?: TabStrip,
  pinnedTabs?: PinnedTabs,
  unpinnedTabs?: UnpinnedTabs,
  tabGroup?: TabGroup,
  splitTab?: SplitTab,
}

export enum DataFieldTags {
  TAB,
  TAB_STRIP,
  PINNED_TABS,
  UNPINNED_TABS,
  TAB_GROUP,
  SPLIT_TAB,
}

export function whichData(u: Data): DataFieldTags {
  if (u.tab !== null && u.tab !== undefined) {
    return DataFieldTags.TAB;
  }
  if (u.tabStrip !== null && u.tabStrip !== undefined) {
    return DataFieldTags.TAB_STRIP;
  }
  if (u.pinnedTabs !== null && u.pinnedTabs !== undefined) {
    return DataFieldTags.PINNED_TABS;
  }
  if (u.unpinnedTabs !== null && u.unpinnedTabs !== undefined) {
    return DataFieldTags.UNPINNED_TABS;
  }
  if (u.tabGroup !== null && u.tabGroup !== undefined) {
    return DataFieldTags.TAB_GROUP;
  }
  if (u.splitTab !== null && u.splitTab !== undefined) {
    return DataFieldTags.SPLIT_TAB;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
