// components/attribution_reporting/registration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/attribution_reporting/registration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/registration.mojom-params-data.h"
#include "components/attribution_reporting/registration.mojom-shared-message-ids.h"

#include "components/attribution_reporting/registration.mojom-import-headers.h"
#include "components/attribution_reporting/registration.mojom-test-utils.h"


namespace attribution_reporting::mojom {
SuitableOrigin::SuitableOrigin()
    : origin() {}

SuitableOrigin::SuitableOrigin(
    const ::url::Origin& origin_in)
    : origin(std::move(origin_in)) {}

SuitableOrigin::~SuitableOrigin() = default;

void SuitableOrigin::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SuitableOrigin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilterData::FilterData()
    : filter_values() {}

FilterData::FilterData(
    const base::flat_map<std::string, std::vector<std::string>>& filter_values_in)
    : filter_values(std::move(filter_values_in)) {}

FilterData::~FilterData() = default;

void FilterData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_values"), this->filter_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FilterData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilterConfig::FilterConfig()
    : lookback_window(),
      filter_values() {}

FilterConfig::FilterConfig(
    std::optional<::base::TimeDelta> lookback_window_in,
    const base::flat_map<std::string, std::vector<std::string>>& filter_values_in)
    : lookback_window(std::move(lookback_window_in)),
      filter_values(std::move(filter_values_in)) {}

FilterConfig::~FilterConfig() = default;

void FilterConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lookback_window"), this->lookback_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_values"), this->filter_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FilterConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FilterPair::FilterPair()
    : positive(),
      negative() {}

FilterPair::FilterPair(
    std::vector<FilterConfigPtr> positive_in,
    std::vector<FilterConfigPtr> negative_in)
    : positive(std::move(positive_in)),
      negative(std::move(negative_in)) {}

FilterPair::~FilterPair() = default;

void FilterPair::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive"), this->positive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FilterConfigPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative"), this->negative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FilterConfigPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FilterPair::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregationKeys::AggregationKeys()
    : keys() {}

AggregationKeys::AggregationKeys(
    const base::flat_map<std::string, ::absl::uint128>& keys_in)
    : keys(std::move(keys_in)) {}

AggregationKeys::~AggregationKeys() = default;

void AggregationKeys::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keys"), this->keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, ::absl::uint128>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregationKeys::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableTriggerData::AggregatableTriggerData()
    : key_piece(),
      source_keys(),
      filters() {}

AggregatableTriggerData::AggregatableTriggerData(
    const ::absl::uint128& key_piece_in,
    std::vector<std::string> source_keys_in,
    const ::attribution_reporting::FilterPair& filters_in)
    : key_piece(std::move(key_piece_in)),
      source_keys(std::move(source_keys_in)),
      filters(std::move(filters_in)) {}

AggregatableTriggerData::~AggregatableTriggerData() = default;

void AggregatableTriggerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_piece"), this->key_piece,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_keys"), this->source_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableTriggerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DestinationSet::DestinationSet()
    : destinations() {}

DestinationSet::DestinationSet(
    std::vector<::net::SchemefulSite> destinations_in)
    : destinations(std::move(destinations_in)) {}

DestinationSet::~DestinationSet() = default;

void DestinationSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destinations"), this->destinations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::SchemefulSite>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DestinationSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventReportWindows::EventReportWindows()
    : start_time(),
      end_times() {}

EventReportWindows::EventReportWindows(
    ::base::TimeDelta start_time_in,
    std::vector<::base::TimeDelta> end_times_in)
    : start_time(std::move(start_time_in)),
      end_times(std::move(end_times_in)) {}

EventReportWindows::~EventReportWindows() = default;

void EventReportWindows::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_times"), this->end_times,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::TimeDelta>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventReportWindows::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TriggerDataSet::TriggerDataSet()
    : trigger_data() {}

TriggerDataSet::TriggerDataSet(
    std::vector<uint32_t> trigger_data_in)
    : trigger_data(std::move(trigger_data_in)) {}

TriggerDataSet::~TriggerDataSet() = default;

void TriggerDataSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_data"), this->trigger_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TriggerDataSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableDebugReportingContribution::AggregatableDebugReportingContribution()
    : key_piece(),
      value() {}

AggregatableDebugReportingContribution::AggregatableDebugReportingContribution(
    const ::absl::uint128& key_piece_in,
    uint32_t value_in)
    : key_piece(std::move(key_piece_in)),
      value(std::move(value_in)) {}

AggregatableDebugReportingContribution::~AggregatableDebugReportingContribution() = default;

void AggregatableDebugReportingContribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_piece"), this->key_piece,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableDebugReportingContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableDebugReportingConfig::AggregatableDebugReportingConfig()
    : key_piece(),
      debug_data(),
      aggregation_coordinator_origin() {}

AggregatableDebugReportingConfig::AggregatableDebugReportingConfig(
    const ::absl::uint128& key_piece_in,
    const base::flat_map<::attribution_reporting::mojom::DebugDataType, ::attribution_reporting::AggregatableDebugReportingContribution>& debug_data_in,
    std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin_in)
    : key_piece(std::move(key_piece_in)),
      debug_data(std::move(debug_data_in)),
      aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)) {}

AggregatableDebugReportingConfig::~AggregatableDebugReportingConfig() = default;

void AggregatableDebugReportingConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_piece"), this->key_piece,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_data"), this->debug_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::attribution_reporting::mojom::DebugDataType, ::attribution_reporting::AggregatableDebugReportingContribution>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::attribution_reporting::SuitableOrigin>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableDebugReportingConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SourceAggregatableDebugReportingConfig::SourceAggregatableDebugReportingConfig()
    : budget(),
      config() {}

SourceAggregatableDebugReportingConfig::SourceAggregatableDebugReportingConfig(
    int32_t budget_in,
    const ::attribution_reporting::AggregatableDebugReportingConfig& config_in)
    : budget(std::move(budget_in)),
      config(std::move(config_in)) {}

SourceAggregatableDebugReportingConfig::~SourceAggregatableDebugReportingConfig() = default;

void SourceAggregatableDebugReportingConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "budget"), this->budget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config"), this->config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AggregatableDebugReportingConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SourceAggregatableDebugReportingConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AttributionScopesSet::AttributionScopesSet()
    : scopes() {}

AttributionScopesSet::AttributionScopesSet(
    std::vector<std::string> scopes_in)
    : scopes(std::move(scopes_in)) {}

AttributionScopesSet::~AttributionScopesSet() = default;

void AttributionScopesSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scopes"), this->scopes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AttributionScopesSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AttributionScopesData::AttributionScopesData()
    : attribution_scopes_set(),
      attribution_scope_limit(),
      max_event_states() {}

AttributionScopesData::AttributionScopesData(
    const ::attribution_reporting::AttributionScopesSet& attribution_scopes_set_in,
    uint32_t attribution_scope_limit_in,
    uint32_t max_event_states_in)
    : attribution_scopes_set(std::move(attribution_scopes_set_in)),
      attribution_scope_limit(std::move(attribution_scope_limit_in)),
      max_event_states(std::move(max_event_states_in)) {}

AttributionScopesData::~AttributionScopesData() = default;

void AttributionScopesData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_scopes_set"), this->attribution_scopes_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AttributionScopesSet&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_scope_limit"), this->attribution_scope_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_event_states"), this->max_event_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AttributionScopesData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableNamedBudgetDefs::AggregatableNamedBudgetDefs()
    : budgets() {}

AggregatableNamedBudgetDefs::AggregatableNamedBudgetDefs(
    const base::flat_map<std::string, int32_t>& budgets_in)
    : budgets(std::move(budgets_in)) {}

AggregatableNamedBudgetDefs::~AggregatableNamedBudgetDefs() = default;

void AggregatableNamedBudgetDefs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "budgets"), this->budgets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableNamedBudgetDefs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SourceRegistration::SourceRegistration()
    : destinations(mojo::internal::DefaultConstructTag()),
      source_event_id(0ULL),
      expiry(),
      trigger_data(),
      event_report_windows(),
      max_event_level_reports(),
      aggregatable_report_window(),
      priority(0),
      debug_key(),
      filter_data(),
      aggregation_keys(),
      debug_reporting(false),
      trigger_data_matching(),
      event_level_epsilon(),
      aggregatable_debug_reporting_config(),
      destination_limit_priority(),
      attribution_scopes_data(),
      aggregatable_named_budget_defs() {}

SourceRegistration::SourceRegistration(
    const ::attribution_reporting::DestinationSet& destinations_in,
    uint64_t source_event_id_in,
    ::base::TimeDelta expiry_in,
    const ::attribution_reporting::TriggerDataSet& trigger_data_in,
    const ::attribution_reporting::EventReportWindows& event_report_windows_in,
    int32_t max_event_level_reports_in,
    ::base::TimeDelta aggregatable_report_window_in,
    int64_t priority_in,
    std::optional<uint64_t> debug_key_in,
    const ::attribution_reporting::FilterData& filter_data_in,
    const ::attribution_reporting::AggregationKeys& aggregation_keys_in,
    bool debug_reporting_in,
    ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching_in,
    double event_level_epsilon_in,
    const ::attribution_reporting::SourceAggregatableDebugReportingConfig& aggregatable_debug_reporting_config_in,
    int64_t destination_limit_priority_in,
    const std::optional<::attribution_reporting::AttributionScopesData>& attribution_scopes_data_in,
    const ::attribution_reporting::AggregatableNamedBudgetDefs& aggregatable_named_budget_defs_in)
    : destinations(std::move(destinations_in)),
      source_event_id(std::move(source_event_id_in)),
      expiry(std::move(expiry_in)),
      trigger_data(std::move(trigger_data_in)),
      event_report_windows(std::move(event_report_windows_in)),
      max_event_level_reports(std::move(max_event_level_reports_in)),
      aggregatable_report_window(std::move(aggregatable_report_window_in)),
      priority(std::move(priority_in)),
      debug_key(std::move(debug_key_in)),
      filter_data(std::move(filter_data_in)),
      aggregation_keys(std::move(aggregation_keys_in)),
      debug_reporting(std::move(debug_reporting_in)),
      trigger_data_matching(std::move(trigger_data_matching_in)),
      event_level_epsilon(std::move(event_level_epsilon_in)),
      aggregatable_debug_reporting_config(std::move(aggregatable_debug_reporting_config_in)),
      destination_limit_priority(std::move(destination_limit_priority_in)),
      attribution_scopes_data(std::move(attribution_scopes_data_in)),
      aggregatable_named_budget_defs(std::move(aggregatable_named_budget_defs_in)) {}

SourceRegistration::~SourceRegistration() = default;

void SourceRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destinations"), this->destinations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::DestinationSet&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_event_id"), this->source_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_data"), this->trigger_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::TriggerDataSet&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_report_windows"), this->event_report_windows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::EventReportWindows&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_event_level_reports"), this->max_event_level_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_report_window"), this->aggregatable_report_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_key"), this->debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_data"), this->filter_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_keys"), this->aggregation_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AggregationKeys&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_reporting"), this->debug_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_data_matching"), this->trigger_data_matching,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::TriggerDataMatching>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_level_epsilon"), this->event_level_epsilon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_debug_reporting_config"), this->aggregatable_debug_reporting_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::SourceAggregatableDebugReportingConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination_limit_priority"), this->destination_limit_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_scopes_data"), this->attribution_scopes_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::attribution_reporting::AttributionScopesData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_named_budget_defs"), this->aggregatable_named_budget_defs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AggregatableNamedBudgetDefs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SourceRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventTriggerData::EventTriggerData()
    : data(0ULL),
      priority(0),
      dedup_key(),
      filters() {}

EventTriggerData::EventTriggerData(
    uint64_t data_in,
    int64_t priority_in,
    std::optional<uint64_t> dedup_key_in,
    const ::attribution_reporting::FilterPair& filters_in)
    : data(std::move(data_in)),
      priority(std::move(priority_in)),
      dedup_key(std::move(dedup_key_in)),
      filters(std::move(filters_in)) {}

EventTriggerData::~EventTriggerData() = default;

void EventTriggerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dedup_key"), this->dedup_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventTriggerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableDedupKey::AggregatableDedupKey()
    : dedup_key(),
      filters() {}

AggregatableDedupKey::AggregatableDedupKey(
    std::optional<uint64_t> dedup_key_in,
    const ::attribution_reporting::FilterPair& filters_in)
    : dedup_key(std::move(dedup_key_in)),
      filters(std::move(filters_in)) {}

AggregatableDedupKey::~AggregatableDedupKey() = default;

void AggregatableDedupKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dedup_key"), this->dedup_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableDedupKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableValuesValue::AggregatableValuesValue()
    : value(),
      filtering_id() {}

AggregatableValuesValue::AggregatableValuesValue(
    uint32_t value_in,
    uint64_t filtering_id_in)
    : value(std::move(value_in)),
      filtering_id(std::move(filtering_id_in)) {}

AggregatableValuesValue::~AggregatableValuesValue() = default;

void AggregatableValuesValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id"), this->filtering_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableValuesValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableValues::AggregatableValues()
    : values(),
      filters() {}

AggregatableValues::AggregatableValues(
    const base::flat_map<std::string, ::attribution_reporting::AggregatableValuesValue>& values_in,
    const ::attribution_reporting::FilterPair& filters_in)
    : values(std::move(values_in)),
      filters(std::move(filters_in)) {}

AggregatableValues::~AggregatableValues() = default;

void AggregatableValues::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "values"), this->values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, ::attribution_reporting::AggregatableValuesValue>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableValues::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableNamedBudgetCandidate::AggregatableNamedBudgetCandidate()
    : name(),
      filters() {}

AggregatableNamedBudgetCandidate::AggregatableNamedBudgetCandidate(
    const std::optional<std::string>& name_in,
    const ::attribution_reporting::FilterPair& filters_in)
    : name(std::move(name_in)),
      filters(std::move(filters_in)) {}

AggregatableNamedBudgetCandidate::~AggregatableNamedBudgetCandidate() = default;

void AggregatableNamedBudgetCandidate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableNamedBudgetCandidate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TriggerRegistration::TriggerRegistration()
    : event_triggers(),
      filters(),
      aggregatable_trigger_data(),
      aggregatable_values(),
      debug_key(),
      aggregatable_dedup_keys(),
      debug_reporting(false),
      aggregation_coordinator_origin(),
      source_registration_time_config(),
      trigger_context_id(),
      aggregatable_filtering_id_max_bytes(),
      aggregatable_debug_reporting_config(),
      attribution_scopes(),
      aggregatable_named_budget_candidates() {}

TriggerRegistration::TriggerRegistration(
    std::vector<::attribution_reporting::EventTriggerData> event_triggers_in,
    const ::attribution_reporting::FilterPair& filters_in,
    std::vector<::attribution_reporting::AggregatableTriggerData> aggregatable_trigger_data_in,
    std::vector<::attribution_reporting::AggregatableValues> aggregatable_values_in,
    std::optional<uint64_t> debug_key_in,
    std::vector<::attribution_reporting::AggregatableDedupKey> aggregatable_dedup_keys_in,
    bool debug_reporting_in,
    std::optional<::attribution_reporting::SuitableOrigin> aggregation_coordinator_origin_in,
    ::attribution_reporting::mojom::SourceRegistrationTimeConfig source_registration_time_config_in,
    const std::optional<std::string>& trigger_context_id_in,
    uint8_t aggregatable_filtering_id_max_bytes_in,
    const ::attribution_reporting::AggregatableDebugReportingConfig& aggregatable_debug_reporting_config_in,
    const ::attribution_reporting::AttributionScopesSet& attribution_scopes_in,
    std::vector<::attribution_reporting::AggregatableNamedBudgetCandidate> aggregatable_named_budget_candidates_in)
    : event_triggers(std::move(event_triggers_in)),
      filters(std::move(filters_in)),
      aggregatable_trigger_data(std::move(aggregatable_trigger_data_in)),
      aggregatable_values(std::move(aggregatable_values_in)),
      debug_key(std::move(debug_key_in)),
      aggregatable_dedup_keys(std::move(aggregatable_dedup_keys_in)),
      debug_reporting(std::move(debug_reporting_in)),
      aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)),
      source_registration_time_config(std::move(source_registration_time_config_in)),
      trigger_context_id(std::move(trigger_context_id_in)),
      aggregatable_filtering_id_max_bytes(std::move(aggregatable_filtering_id_max_bytes_in)),
      aggregatable_debug_reporting_config(std::move(aggregatable_debug_reporting_config_in)),
      attribution_scopes(std::move(attribution_scopes_in)),
      aggregatable_named_budget_candidates(std::move(aggregatable_named_budget_candidates_in)) {}

TriggerRegistration::~TriggerRegistration() = default;

void TriggerRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_triggers"), this->event_triggers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::EventTriggerData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters"), this->filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::FilterPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_trigger_data"), this->aggregatable_trigger_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::AggregatableTriggerData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_values"), this->aggregatable_values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::AggregatableValues>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_key"), this->debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_dedup_keys"), this->aggregatable_dedup_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::AggregatableDedupKey>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_reporting"), this->debug_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::attribution_reporting::SuitableOrigin>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_registration_time_config"), this->source_registration_time_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::attribution_reporting::mojom::SourceRegistrationTimeConfig>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_context_id"), this->trigger_context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_filtering_id_max_bytes"), this->aggregatable_filtering_id_max_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_debug_reporting_config"), this->aggregatable_debug_reporting_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AggregatableDebugReportingConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_scopes"), this->attribution_scopes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::AttributionScopesSet&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregatable_named_budget_candidates"), this->aggregatable_named_budget_candidates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::AggregatableNamedBudgetCandidate>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TriggerRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OsRegistrationItem::OsRegistrationItem()
    : url(),
      debug_reporting() {}

OsRegistrationItem::OsRegistrationItem(
    const ::GURL& url_in,
    bool debug_reporting_in)
    : url(std::move(url_in)),
      debug_reporting(std::move(debug_reporting_in)) {}

OsRegistrationItem::~OsRegistrationItem() = default;

void OsRegistrationItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_reporting"), this->debug_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OsRegistrationItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OsRegistration::OsRegistration()
    : items() {}

OsRegistration::OsRegistration(
    std::vector<::attribution_reporting::OsRegistrationItem> items_in)
    : items(std::move(items_in)) {}

OsRegistration::~OsRegistration() = default;

void OsRegistration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::attribution_reporting::OsRegistrationItem>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OsRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // attribution_reporting::mojom


namespace mojo {


// static
bool StructTraits<::attribution_reporting::mojom::SuitableOrigin::DataView, ::attribution_reporting::mojom::SuitableOriginPtr>::Read(
    ::attribution_reporting::mojom::SuitableOrigin::DataView input,
    ::attribution_reporting::mojom::SuitableOriginPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::SuitableOriginPtr result(::attribution_reporting::mojom::SuitableOrigin::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::FilterData::DataView, ::attribution_reporting::mojom::FilterDataPtr>::Read(
    ::attribution_reporting::mojom::FilterData::DataView input,
    ::attribution_reporting::mojom::FilterDataPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::FilterDataPtr result(::attribution_reporting::mojom::FilterData::New());
  
      if (success && !input.ReadFilterValues(&result->filter_values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::FilterConfig::DataView, ::attribution_reporting::mojom::FilterConfigPtr>::Read(
    ::attribution_reporting::mojom::FilterConfig::DataView input,
    ::attribution_reporting::mojom::FilterConfigPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::FilterConfigPtr result(::attribution_reporting::mojom::FilterConfig::New());
  
      if (success && !input.ReadLookbackWindow(&result->lookback_window))
        success = false;
      if (success && !input.ReadFilterValues(&result->filter_values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::FilterPair::DataView, ::attribution_reporting::mojom::FilterPairPtr>::Read(
    ::attribution_reporting::mojom::FilterPair::DataView input,
    ::attribution_reporting::mojom::FilterPairPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::FilterPairPtr result(::attribution_reporting::mojom::FilterPair::New());
  
      if (success && !input.ReadPositive(&result->positive))
        success = false;
      if (success && !input.ReadNegative(&result->negative))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregationKeys::DataView, ::attribution_reporting::mojom::AggregationKeysPtr>::Read(
    ::attribution_reporting::mojom::AggregationKeys::DataView input,
    ::attribution_reporting::mojom::AggregationKeysPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregationKeysPtr result(::attribution_reporting::mojom::AggregationKeys::New());
  
      if (success && !input.ReadKeys(&result->keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableTriggerData::DataView, ::attribution_reporting::mojom::AggregatableTriggerDataPtr>::Read(
    ::attribution_reporting::mojom::AggregatableTriggerData::DataView input,
    ::attribution_reporting::mojom::AggregatableTriggerDataPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableTriggerDataPtr result(::attribution_reporting::mojom::AggregatableTriggerData::New());
  
      if (success && !input.ReadKeyPiece(&result->key_piece))
        success = false;
      if (success && !input.ReadSourceKeys(&result->source_keys))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::DestinationSet::DataView, ::attribution_reporting::mojom::DestinationSetPtr>::Read(
    ::attribution_reporting::mojom::DestinationSet::DataView input,
    ::attribution_reporting::mojom::DestinationSetPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::DestinationSetPtr result(::attribution_reporting::mojom::DestinationSet::New());
  
      if (success && !input.ReadDestinations(&result->destinations))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::EventReportWindows::DataView, ::attribution_reporting::mojom::EventReportWindowsPtr>::Read(
    ::attribution_reporting::mojom::EventReportWindows::DataView input,
    ::attribution_reporting::mojom::EventReportWindowsPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::EventReportWindowsPtr result(::attribution_reporting::mojom::EventReportWindows::New());
  
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success && !input.ReadEndTimes(&result->end_times))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::TriggerDataSet::DataView, ::attribution_reporting::mojom::TriggerDataSetPtr>::Read(
    ::attribution_reporting::mojom::TriggerDataSet::DataView input,
    ::attribution_reporting::mojom::TriggerDataSetPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::TriggerDataSetPtr result(::attribution_reporting::mojom::TriggerDataSet::New());
  
      if (success && !input.ReadTriggerData(&result->trigger_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableDebugReportingContribution::DataView, ::attribution_reporting::mojom::AggregatableDebugReportingContributionPtr>::Read(
    ::attribution_reporting::mojom::AggregatableDebugReportingContribution::DataView input,
    ::attribution_reporting::mojom::AggregatableDebugReportingContributionPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableDebugReportingContributionPtr result(::attribution_reporting::mojom::AggregatableDebugReportingContribution::New());
  
      if (success && !input.ReadKeyPiece(&result->key_piece))
        success = false;
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableDebugReportingConfig::DataView, ::attribution_reporting::mojom::AggregatableDebugReportingConfigPtr>::Read(
    ::attribution_reporting::mojom::AggregatableDebugReportingConfig::DataView input,
    ::attribution_reporting::mojom::AggregatableDebugReportingConfigPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableDebugReportingConfigPtr result(::attribution_reporting::mojom::AggregatableDebugReportingConfig::New());
  
      if (success && !input.ReadKeyPiece(&result->key_piece))
        success = false;
      if (success && !input.ReadDebugData(&result->debug_data))
        success = false;
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfig::DataView, ::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigPtr>::Read(
    ::attribution_reporting::mojom::SourceAggregatableDebugReportingConfig::DataView input,
    ::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigPtr result(::attribution_reporting::mojom::SourceAggregatableDebugReportingConfig::New());
  
      if (success)
        result->budget = input.budget();
      if (success && !input.ReadConfig(&result->config))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AttributionScopesSet::DataView, ::attribution_reporting::mojom::AttributionScopesSetPtr>::Read(
    ::attribution_reporting::mojom::AttributionScopesSet::DataView input,
    ::attribution_reporting::mojom::AttributionScopesSetPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AttributionScopesSetPtr result(::attribution_reporting::mojom::AttributionScopesSet::New());
  
      if (success && !input.ReadScopes(&result->scopes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AttributionScopesData::DataView, ::attribution_reporting::mojom::AttributionScopesDataPtr>::Read(
    ::attribution_reporting::mojom::AttributionScopesData::DataView input,
    ::attribution_reporting::mojom::AttributionScopesDataPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AttributionScopesDataPtr result(::attribution_reporting::mojom::AttributionScopesData::New());
  
      if (success && !input.ReadAttributionScopesSet(&result->attribution_scopes_set))
        success = false;
      if (success)
        result->attribution_scope_limit = input.attribution_scope_limit();
      if (success)
        result->max_event_states = input.max_event_states();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableNamedBudgetDefs::DataView, ::attribution_reporting::mojom::AggregatableNamedBudgetDefsPtr>::Read(
    ::attribution_reporting::mojom::AggregatableNamedBudgetDefs::DataView input,
    ::attribution_reporting::mojom::AggregatableNamedBudgetDefsPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableNamedBudgetDefsPtr result(::attribution_reporting::mojom::AggregatableNamedBudgetDefs::New());
  
      if (success && !input.ReadBudgets(&result->budgets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::SourceRegistration::DataView, ::attribution_reporting::mojom::SourceRegistrationPtr>::Read(
    ::attribution_reporting::mojom::SourceRegistration::DataView input,
    ::attribution_reporting::mojom::SourceRegistrationPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::SourceRegistrationPtr result(::attribution_reporting::mojom::SourceRegistration::New());
  
      if (success && !input.ReadDestinations(&result->destinations))
        success = false;
      if (success)
        result->source_event_id = input.source_event_id();
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadTriggerData(&result->trigger_data))
        success = false;
      if (success && !input.ReadEventReportWindows(&result->event_report_windows))
        success = false;
      if (success)
        result->max_event_level_reports = input.max_event_level_reports();
      if (success && !input.ReadAggregatableReportWindow(&result->aggregatable_report_window))
        success = false;
      if (success)
        result->priority = input.priority();
      if (success) {
        result->debug_key = input.debug_key();
      }
      if (success && !input.ReadFilterData(&result->filter_data))
        success = false;
      if (success && !input.ReadAggregationKeys(&result->aggregation_keys))
        success = false;
      if (success)
        result->debug_reporting = input.debug_reporting();
      if (success && !input.ReadTriggerDataMatching(&result->trigger_data_matching))
        success = false;
      if (success)
        result->event_level_epsilon = input.event_level_epsilon();
      if (success && !input.ReadAggregatableDebugReportingConfig(&result->aggregatable_debug_reporting_config))
        success = false;
      if (success)
        result->destination_limit_priority = input.destination_limit_priority();
      if (success && !input.ReadAttributionScopesData(&result->attribution_scopes_data))
        success = false;
      if (success && !input.ReadAggregatableNamedBudgetDefs(&result->aggregatable_named_budget_defs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::EventTriggerData::DataView, ::attribution_reporting::mojom::EventTriggerDataPtr>::Read(
    ::attribution_reporting::mojom::EventTriggerData::DataView input,
    ::attribution_reporting::mojom::EventTriggerDataPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::EventTriggerDataPtr result(::attribution_reporting::mojom::EventTriggerData::New());
  
      if (success)
        result->data = input.data();
      if (success)
        result->priority = input.priority();
      if (success) {
        result->dedup_key = input.dedup_key();
      }
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableDedupKey::DataView, ::attribution_reporting::mojom::AggregatableDedupKeyPtr>::Read(
    ::attribution_reporting::mojom::AggregatableDedupKey::DataView input,
    ::attribution_reporting::mojom::AggregatableDedupKeyPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableDedupKeyPtr result(::attribution_reporting::mojom::AggregatableDedupKey::New());
  
      if (success) {
        result->dedup_key = input.dedup_key();
      }
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableValuesValue::DataView, ::attribution_reporting::mojom::AggregatableValuesValuePtr>::Read(
    ::attribution_reporting::mojom::AggregatableValuesValue::DataView input,
    ::attribution_reporting::mojom::AggregatableValuesValuePtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableValuesValuePtr result(::attribution_reporting::mojom::AggregatableValuesValue::New());
  
      if (success)
        result->value = input.value();
      if (success)
        result->filtering_id = input.filtering_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableValues::DataView, ::attribution_reporting::mojom::AggregatableValuesPtr>::Read(
    ::attribution_reporting::mojom::AggregatableValues::DataView input,
    ::attribution_reporting::mojom::AggregatableValuesPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableValuesPtr result(::attribution_reporting::mojom::AggregatableValues::New());
  
      if (success && !input.ReadValues(&result->values))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::AggregatableNamedBudgetCandidate::DataView, ::attribution_reporting::mojom::AggregatableNamedBudgetCandidatePtr>::Read(
    ::attribution_reporting::mojom::AggregatableNamedBudgetCandidate::DataView input,
    ::attribution_reporting::mojom::AggregatableNamedBudgetCandidatePtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::AggregatableNamedBudgetCandidatePtr result(::attribution_reporting::mojom::AggregatableNamedBudgetCandidate::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::TriggerRegistration::DataView, ::attribution_reporting::mojom::TriggerRegistrationPtr>::Read(
    ::attribution_reporting::mojom::TriggerRegistration::DataView input,
    ::attribution_reporting::mojom::TriggerRegistrationPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::TriggerRegistrationPtr result(::attribution_reporting::mojom::TriggerRegistration::New());
  
      if (success && !input.ReadEventTriggers(&result->event_triggers))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success && !input.ReadAggregatableTriggerData(&result->aggregatable_trigger_data))
        success = false;
      if (success && !input.ReadAggregatableValues(&result->aggregatable_values))
        success = false;
      if (success) {
        result->debug_key = input.debug_key();
      }
      if (success && !input.ReadAggregatableDedupKeys(&result->aggregatable_dedup_keys))
        success = false;
      if (success)
        result->debug_reporting = input.debug_reporting();
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
      if (success && !input.ReadSourceRegistrationTimeConfig(&result->source_registration_time_config))
        success = false;
      if (success && !input.ReadTriggerContextId(&result->trigger_context_id))
        success = false;
      if (success)
        result->aggregatable_filtering_id_max_bytes = input.aggregatable_filtering_id_max_bytes();
      if (success && !input.ReadAggregatableDebugReportingConfig(&result->aggregatable_debug_reporting_config))
        success = false;
      if (success && !input.ReadAttributionScopes(&result->attribution_scopes))
        success = false;
      if (success && !input.ReadAggregatableNamedBudgetCandidates(&result->aggregatable_named_budget_candidates))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::OsRegistrationItem::DataView, ::attribution_reporting::mojom::OsRegistrationItemPtr>::Read(
    ::attribution_reporting::mojom::OsRegistrationItem::DataView input,
    ::attribution_reporting::mojom::OsRegistrationItemPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::OsRegistrationItemPtr result(::attribution_reporting::mojom::OsRegistrationItem::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->debug_reporting = input.debug_reporting();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::attribution_reporting::mojom::OsRegistration::DataView, ::attribution_reporting::mojom::OsRegistrationPtr>::Read(
    ::attribution_reporting::mojom::OsRegistration::DataView input,
    ::attribution_reporting::mojom::OsRegistrationPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::OsRegistrationPtr result(::attribution_reporting::mojom::OsRegistration::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace attribution_reporting::mojom {




}  // attribution_reporting::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif