// components/attribution_reporting/registration.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_SEND_VALIDATION_H_

#include "components/attribution_reporting/registration.mojom-shared-internal.h"
#include "components/attribution_reporting/source_registration_time_config.mojom-shared.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-shared.h"
#include "components/attribution_reporting/debug_types.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/attribution_reporting/registration.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::SuitableOriginDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::SuitableOriginDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::SuitableOrigin_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in SuitableOrigin struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::FilterDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::FilterDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::FilterData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::filter_values(input)) in_filter_values = Traits::filter_values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filter_values)::BaseType>
          filter_values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& filter_values_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, send_validation>(
        in_filter_values,
        filter_values_fragment,
        &filter_values_validate_params);

      fragment->filter_values.Set(
          filter_values_fragment.is_null() ? nullptr : filter_values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filter_values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filter_values in FilterData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::FilterConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::FilterConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::FilterConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lookback_window(input)) in_lookback_window = Traits::lookback_window(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lookback_window)::BaseType> lookback_window_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_lookback_window,
        lookback_window_fragment);

      fragment->lookback_window.Set(
          lookback_window_fragment.is_null() ? nullptr : lookback_window_fragment.data());

      decltype(Traits::filter_values(input)) in_filter_values = Traits::filter_values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filter_values)::BaseType>
          filter_values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& filter_values_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, send_validation>(
        in_filter_values,
        filter_values_fragment,
        &filter_values_validate_params);

      fragment->filter_values.Set(
          filter_values_fragment.is_null() ? nullptr : filter_values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filter_values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filter_values in FilterConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::FilterPairDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::FilterPairDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::FilterPair_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::positive(input)) in_positive = Traits::positive(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->positive)::BaseType>
          positive_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& positive_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::FilterConfigDataView>, send_validation>(
        in_positive,
        positive_fragment,
        &positive_validate_params);

      fragment->positive.Set(
          positive_fragment.is_null() ? nullptr : positive_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->positive.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive in FilterPair struct");

      decltype(Traits::negative(input)) in_negative = Traits::negative(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->negative)::BaseType>
          negative_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& negative_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::FilterConfigDataView>, send_validation>(
        in_negative,
        negative_fragment,
        &negative_validate_params);

      fragment->negative.Set(
          negative_fragment.is_null() ? nullptr : negative_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->negative.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative in FilterPair struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregationKeysDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregationKeysDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregationKeys_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::keys(input)) in_keys = Traits::keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keys)::BaseType>
          keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::Uint128DataView>, send_validation>(
        in_keys,
        keys_fragment,
        &keys_validate_params);

      fragment->keys.Set(
          keys_fragment.is_null() ? nullptr : keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keys in AggregationKeys struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableTriggerDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableTriggerDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableTriggerData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key_piece(input)) in_key_piece = Traits::key_piece(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_piece)::BaseType> key_piece_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView, send_validation>(
        in_key_piece,
        key_piece_fragment);

      fragment->key_piece.Set(
          key_piece_fragment.is_null() ? nullptr : key_piece_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_piece.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_piece in AggregatableTriggerData struct");

      decltype(Traits::source_keys(input)) in_source_keys = Traits::source_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_keys)::BaseType>
          source_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& source_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_source_keys,
        source_keys_fragment,
        &source_keys_validate_params);

      fragment->source_keys.Set(
          source_keys_fragment.is_null() ? nullptr : source_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_keys in AggregatableTriggerData struct");

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in AggregatableTriggerData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::DestinationSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::DestinationSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::DestinationSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::destinations(input)) in_destinations = Traits::destinations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destinations)::BaseType>
          destinations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& destinations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SchemefulSiteDataView>, send_validation>(
        in_destinations,
        destinations_fragment,
        &destinations_validate_params);

      fragment->destinations.Set(
          destinations_fragment.is_null() ? nullptr : destinations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destinations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destinations in DestinationSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::EventReportWindowsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::EventReportWindowsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::EventReportWindows_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_time)::BaseType> start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_start_time,
        start_time_fragment);

      fragment->start_time.Set(
          start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in EventReportWindows struct");

      decltype(Traits::end_times(input)) in_end_times = Traits::end_times(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->end_times)::BaseType>
          end_times_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& end_times_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>, send_validation>(
        in_end_times,
        end_times_fragment,
        &end_times_validate_params);

      fragment->end_times.Set(
          end_times_fragment.is_null() ? nullptr : end_times_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->end_times.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end_times in EventReportWindows struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::TriggerDataSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::TriggerDataSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::TriggerDataSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::trigger_data(input)) in_trigger_data = Traits::trigger_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trigger_data)::BaseType>
          trigger_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trigger_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_trigger_data,
        trigger_data_fragment,
        &trigger_data_validate_params);

      fragment->trigger_data.Set(
          trigger_data_fragment.is_null() ? nullptr : trigger_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trigger_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trigger_data in TriggerDataSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableDebugReportingContributionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableDebugReportingContributionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableDebugReportingContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key_piece(input)) in_key_piece = Traits::key_piece(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_piece)::BaseType> key_piece_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView, send_validation>(
        in_key_piece,
        key_piece_fragment);

      fragment->key_piece.Set(
          key_piece_fragment.is_null() ? nullptr : key_piece_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_piece.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_piece in AggregatableDebugReportingContribution struct");

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableDebugReportingConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key_piece(input)) in_key_piece = Traits::key_piece(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_piece)::BaseType> key_piece_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView, send_validation>(
        in_key_piece,
        key_piece_fragment);

      fragment->key_piece.Set(
          key_piece_fragment.is_null() ? nullptr : key_piece_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_piece.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_piece in AggregatableDebugReportingConfig struct");

      decltype(Traits::debug_data(input)) in_debug_data = Traits::debug_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->debug_data)::BaseType>
          debug_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& debug_data_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::attribution_reporting::mojom::internal::DebugDataType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::attribution_reporting::mojom::DebugDataType, ::attribution_reporting::mojom::AggregatableDebugReportingContributionDataView>, send_validation>(
        in_debug_data,
        debug_data_fragment,
        &debug_data_validate_params);

      fragment->debug_data.Set(
          debug_data_fragment.is_null() ? nullptr : debug_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->debug_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_data in AggregatableDebugReportingConfig struct");

      decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::SuitableOriginDataView, send_validation>(
        in_aggregation_coordinator_origin,
        aggregation_coordinator_origin_fragment);

      fragment->aggregation_coordinator_origin.Set(
          aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::SourceAggregatableDebugReportingConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->budget = Traits::budget(input);

      decltype(Traits::config(input)) in_config = Traits::config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config)::BaseType> config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView, send_validation>(
        in_config,
        config_fragment);

      fragment->config.Set(
          config_fragment.is_null() ? nullptr : config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in SourceAggregatableDebugReportingConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AttributionScopesSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AttributionScopesSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AttributionScopesSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scopes(input)) in_scopes = Traits::scopes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scopes)::BaseType>
          scopes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scopes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_scopes,
        scopes_fragment,
        &scopes_validate_params);

      fragment->scopes.Set(
          scopes_fragment.is_null() ? nullptr : scopes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scopes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scopes in AttributionScopesSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AttributionScopesDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AttributionScopesDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AttributionScopesData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::attribution_scopes_set(input)) in_attribution_scopes_set = Traits::attribution_scopes_set(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attribution_scopes_set)::BaseType> attribution_scopes_set_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AttributionScopesSetDataView, send_validation>(
        in_attribution_scopes_set,
        attribution_scopes_set_fragment);

      fragment->attribution_scopes_set.Set(
          attribution_scopes_set_fragment.is_null() ? nullptr : attribution_scopes_set_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attribution_scopes_set.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribution_scopes_set in AttributionScopesData struct");

      fragment->attribution_scope_limit = Traits::attribution_scope_limit(input);

      fragment->max_event_states = Traits::max_event_states(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableNamedBudgetDefsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableNamedBudgetDefsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableNamedBudgetDefs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::budgets(input)) in_budgets = Traits::budgets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->budgets)::BaseType>
          budgets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& budgets_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, int32_t>, send_validation>(
        in_budgets,
        budgets_fragment,
        &budgets_validate_params);

      fragment->budgets.Set(
          budgets_fragment.is_null() ? nullptr : budgets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->budgets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null budgets in AggregatableNamedBudgetDefs struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::SourceRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::SourceRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::SourceRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::destinations(input)) in_destinations = Traits::destinations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destinations)::BaseType> destinations_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::DestinationSetDataView, send_validation>(
        in_destinations,
        destinations_fragment);

      fragment->destinations.Set(
          destinations_fragment.is_null() ? nullptr : destinations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destinations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destinations in SourceRegistration struct");

      fragment->source_event_id = Traits::source_event_id(input);

      decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiry)::BaseType> expiry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_expiry,
        expiry_fragment);

      fragment->expiry.Set(
          expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiry.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in SourceRegistration struct");

      decltype(Traits::trigger_data(input)) in_trigger_data = Traits::trigger_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trigger_data)::BaseType> trigger_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::TriggerDataSetDataView, send_validation>(
        in_trigger_data,
        trigger_data_fragment);

      fragment->trigger_data.Set(
          trigger_data_fragment.is_null() ? nullptr : trigger_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trigger_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trigger_data in SourceRegistration struct");

      decltype(Traits::event_report_windows(input)) in_event_report_windows = Traits::event_report_windows(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_report_windows)::BaseType> event_report_windows_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::EventReportWindowsDataView, send_validation>(
        in_event_report_windows,
        event_report_windows_fragment);

      fragment->event_report_windows.Set(
          event_report_windows_fragment.is_null() ? nullptr : event_report_windows_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_report_windows.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_report_windows in SourceRegistration struct");

      fragment->max_event_level_reports = Traits::max_event_level_reports(input);

      decltype(Traits::aggregatable_report_window(input)) in_aggregatable_report_window = Traits::aggregatable_report_window(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_report_window)::BaseType> aggregatable_report_window_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_aggregatable_report_window,
        aggregatable_report_window_fragment);

      fragment->aggregatable_report_window.Set(
          aggregatable_report_window_fragment.is_null() ? nullptr : aggregatable_report_window_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_report_window.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_report_window in SourceRegistration struct");

      fragment->priority = Traits::priority(input);
      fragment->debug_key_$flag = Traits::debug_key(input).has_value();
      if (Traits::debug_key(input).has_value()) {
        fragment->debug_key_$value = Traits::debug_key(input).value();
      }

      decltype(Traits::filter_data(input)) in_filter_data = Traits::filter_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filter_data)::BaseType> filter_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterDataDataView, send_validation>(
        in_filter_data,
        filter_data_fragment);

      fragment->filter_data.Set(
          filter_data_fragment.is_null() ? nullptr : filter_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filter_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filter_data in SourceRegistration struct");

      decltype(Traits::aggregation_keys(input)) in_aggregation_keys = Traits::aggregation_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_keys)::BaseType> aggregation_keys_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AggregationKeysDataView, send_validation>(
        in_aggregation_keys,
        aggregation_keys_fragment);

      fragment->aggregation_keys.Set(
          aggregation_keys_fragment.is_null() ? nullptr : aggregation_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregation_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregation_keys in SourceRegistration struct");

      fragment->debug_reporting = Traits::debug_reporting(input);

      
      mojo::internal::Serialize<::attribution_reporting::mojom::TriggerDataMatching>(
        Traits::trigger_data_matching(input),
        &fragment->trigger_data_matching);

      fragment->event_level_epsilon = Traits::event_level_epsilon(input);

      decltype(Traits::aggregatable_debug_reporting_config(input)) in_aggregatable_debug_reporting_config = Traits::aggregatable_debug_reporting_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_debug_reporting_config)::BaseType> aggregatable_debug_reporting_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigDataView, send_validation>(
        in_aggregatable_debug_reporting_config,
        aggregatable_debug_reporting_config_fragment);

      fragment->aggregatable_debug_reporting_config.Set(
          aggregatable_debug_reporting_config_fragment.is_null() ? nullptr : aggregatable_debug_reporting_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_debug_reporting_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_debug_reporting_config in SourceRegistration struct");

      fragment->destination_limit_priority = Traits::destination_limit_priority(input);

      decltype(Traits::attribution_scopes_data(input)) in_attribution_scopes_data = Traits::attribution_scopes_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attribution_scopes_data)::BaseType> attribution_scopes_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AttributionScopesDataDataView, send_validation>(
        in_attribution_scopes_data,
        attribution_scopes_data_fragment);

      fragment->attribution_scopes_data.Set(
          attribution_scopes_data_fragment.is_null() ? nullptr : attribution_scopes_data_fragment.data());

      decltype(Traits::aggregatable_named_budget_defs(input)) in_aggregatable_named_budget_defs = Traits::aggregatable_named_budget_defs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_named_budget_defs)::BaseType> aggregatable_named_budget_defs_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AggregatableNamedBudgetDefsDataView, send_validation>(
        in_aggregatable_named_budget_defs,
        aggregatable_named_budget_defs_fragment);

      fragment->aggregatable_named_budget_defs.Set(
          aggregatable_named_budget_defs_fragment.is_null() ? nullptr : aggregatable_named_budget_defs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_named_budget_defs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_named_budget_defs in SourceRegistration struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::EventTriggerDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::EventTriggerDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::EventTriggerData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->data = Traits::data(input);

      fragment->priority = Traits::priority(input);
      fragment->dedup_key_$flag = Traits::dedup_key(input).has_value();
      if (Traits::dedup_key(input).has_value()) {
        fragment->dedup_key_$value = Traits::dedup_key(input).value();
      }

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in EventTriggerData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableDedupKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableDedupKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableDedupKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
      fragment->dedup_key_$flag = Traits::dedup_key(input).has_value();
      if (Traits::dedup_key(input).has_value()) {
        fragment->dedup_key_$value = Traits::dedup_key(input).value();
      }

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in AggregatableDedupKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableValuesValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableValuesValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableValuesValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->value = Traits::value(input);

      fragment->filtering_id = Traits::filtering_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableValuesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableValuesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableValues_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::values(input)) in_values = Traits::values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->values)::BaseType>
          values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::attribution_reporting::mojom::AggregatableValuesValueDataView>, send_validation>(
        in_values,
        values_fragment,
        &values_validate_params);

      fragment->values.Set(
          values_fragment.is_null() ? nullptr : values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null values in AggregatableValues struct");

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in AggregatableValues struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::AggregatableNamedBudgetCandidateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::AggregatableNamedBudgetCandidateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::AggregatableNamedBudgetCandidate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in AggregatableNamedBudgetCandidate struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::TriggerRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::TriggerRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::TriggerRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::event_triggers(input)) in_event_triggers = Traits::event_triggers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_triggers)::BaseType>
          event_triggers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& event_triggers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::EventTriggerDataDataView>, send_validation>(
        in_event_triggers,
        event_triggers_fragment,
        &event_triggers_validate_params);

      fragment->event_triggers.Set(
          event_triggers_fragment.is_null() ? nullptr : event_triggers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_triggers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_triggers in TriggerRegistration struct");

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::FilterPairDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in TriggerRegistration struct");

      decltype(Traits::aggregatable_trigger_data(input)) in_aggregatable_trigger_data = Traits::aggregatable_trigger_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_trigger_data)::BaseType>
          aggregatable_trigger_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregatable_trigger_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableTriggerDataDataView>, send_validation>(
        in_aggregatable_trigger_data,
        aggregatable_trigger_data_fragment,
        &aggregatable_trigger_data_validate_params);

      fragment->aggregatable_trigger_data.Set(
          aggregatable_trigger_data_fragment.is_null() ? nullptr : aggregatable_trigger_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_trigger_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_trigger_data in TriggerRegistration struct");

      decltype(Traits::aggregatable_values(input)) in_aggregatable_values = Traits::aggregatable_values(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_values)::BaseType>
          aggregatable_values_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregatable_values_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableValuesDataView>, send_validation>(
        in_aggregatable_values,
        aggregatable_values_fragment,
        &aggregatable_values_validate_params);

      fragment->aggregatable_values.Set(
          aggregatable_values_fragment.is_null() ? nullptr : aggregatable_values_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_values.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_values in TriggerRegistration struct");
      fragment->debug_key_$flag = Traits::debug_key(input).has_value();
      if (Traits::debug_key(input).has_value()) {
        fragment->debug_key_$value = Traits::debug_key(input).value();
      }

      decltype(Traits::aggregatable_dedup_keys(input)) in_aggregatable_dedup_keys = Traits::aggregatable_dedup_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_dedup_keys)::BaseType>
          aggregatable_dedup_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregatable_dedup_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableDedupKeyDataView>, send_validation>(
        in_aggregatable_dedup_keys,
        aggregatable_dedup_keys_fragment,
        &aggregatable_dedup_keys_validate_params);

      fragment->aggregatable_dedup_keys.Set(
          aggregatable_dedup_keys_fragment.is_null() ? nullptr : aggregatable_dedup_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_dedup_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_dedup_keys in TriggerRegistration struct");

      fragment->debug_reporting = Traits::debug_reporting(input);

      decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::SuitableOriginDataView, send_validation>(
        in_aggregation_coordinator_origin,
        aggregation_coordinator_origin_fragment);

      fragment->aggregation_coordinator_origin.Set(
          aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());

      
      mojo::internal::Serialize<::attribution_reporting::mojom::SourceRegistrationTimeConfig>(
        Traits::source_registration_time_config(input),
        &fragment->source_registration_time_config);

      decltype(Traits::trigger_context_id(input)) in_trigger_context_id = Traits::trigger_context_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trigger_context_id)::BaseType> trigger_context_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_trigger_context_id,
        trigger_context_id_fragment);

      fragment->trigger_context_id.Set(
          trigger_context_id_fragment.is_null() ? nullptr : trigger_context_id_fragment.data());

      fragment->aggregatable_filtering_id_max_bytes = Traits::aggregatable_filtering_id_max_bytes(input);

      decltype(Traits::aggregatable_debug_reporting_config(input)) in_aggregatable_debug_reporting_config = Traits::aggregatable_debug_reporting_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_debug_reporting_config)::BaseType> aggregatable_debug_reporting_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView, send_validation>(
        in_aggregatable_debug_reporting_config,
        aggregatable_debug_reporting_config_fragment);

      fragment->aggregatable_debug_reporting_config.Set(
          aggregatable_debug_reporting_config_fragment.is_null() ? nullptr : aggregatable_debug_reporting_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_debug_reporting_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_debug_reporting_config in TriggerRegistration struct");

      decltype(Traits::attribution_scopes(input)) in_attribution_scopes = Traits::attribution_scopes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attribution_scopes)::BaseType> attribution_scopes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::attribution_reporting::mojom::AttributionScopesSetDataView, send_validation>(
        in_attribution_scopes,
        attribution_scopes_fragment);

      fragment->attribution_scopes.Set(
          attribution_scopes_fragment.is_null() ? nullptr : attribution_scopes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attribution_scopes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribution_scopes in TriggerRegistration struct");

      decltype(Traits::aggregatable_named_budget_candidates(input)) in_aggregatable_named_budget_candidates = Traits::aggregatable_named_budget_candidates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aggregatable_named_budget_candidates)::BaseType>
          aggregatable_named_budget_candidates_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& aggregatable_named_budget_candidates_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableNamedBudgetCandidateDataView>, send_validation>(
        in_aggregatable_named_budget_candidates,
        aggregatable_named_budget_candidates_fragment,
        &aggregatable_named_budget_candidates_validate_params);

      fragment->aggregatable_named_budget_candidates.Set(
          aggregatable_named_budget_candidates_fragment.is_null() ? nullptr : aggregatable_named_budget_candidates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aggregatable_named_budget_candidates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aggregatable_named_budget_candidates in TriggerRegistration struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::OsRegistrationItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::OsRegistrationItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::OsRegistrationItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in OsRegistrationItem struct");

      fragment->debug_reporting = Traits::debug_reporting(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::OsRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::OsRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::OsRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::attribution_reporting::mojom::OsRegistrationItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in OsRegistration struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_SEND_VALIDATION_H_