// chrome/updater/mojom/updater_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_H_
#define CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/updater/mojom/updater_service.mojom-features.h"  // IWYU pragma: export
#include "chrome/updater/mojom/updater_service.mojom-shared.h"  // IWYU pragma: export
#include "chrome/updater/mojom/updater_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "chrome/enterprise_companion/mojom/policy_fetch_reason.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace updater::mojom {

class UpdateServiceProxy;

template <typename ImplRefTraits>
class UpdateServiceStub;

class UpdateServiceRequestValidator;
class UpdateServiceResponseValidator;


class UpdateService
    : public UpdateServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "updater.mojom.UpdateService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 4;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UpdateServiceInterfaceBase;
  using Proxy_ = UpdateServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = UpdateServiceStub<ImplRefTraits>;

  using RequestValidator_ = UpdateServiceRequestValidator;
  using ResponseValidator_ = UpdateServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetVersionMinVersion = 0,
    kFetchPoliciesMinVersion = 0,
    kRegisterAppMinVersion = 0,
    kGetAppStatesMinVersion = 0,
    kRunPeriodicTasksMinVersion = 0,
    kUpdateAllMinVersion = 0,
    kUpdateMinVersion = 0,
    kInstallMinVersion = 0,
    kCancelInstallsMinVersion = 0,
    kRunInstallerMinVersion = 0,
    kCheckForUpdateMinVersion = 2,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchPolicies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAppStates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunPeriodicTasks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Update_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Install_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelInstalls_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunInstaller_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckForUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using PolicySameVersionUpdate = UpdateService_PolicySameVersionUpdate;
  
  using Result = UpdateService_Result;
  
  using ErrorCategory = UpdateService_ErrorCategory;
  
  using Priority = UpdateService_Priority;
  virtual ~UpdateService() = default;

  using GetVersionCallback = base::OnceCallback<void(const std::string&)>;
  using GetVersionMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetVersion(GetVersionCallback callback) = 0;

  using FetchPoliciesCallback = base::OnceCallback<void(int32_t)>;
  using FetchPoliciesMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void FetchPolicies(::policy::PolicyFetchReason reason, FetchPoliciesCallback callback) = 0;

  using RegisterAppCallback = base::OnceCallback<void(int32_t)>;
  using RegisterAppMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void RegisterApp(RegistrationRequestPtr request, RegisterAppCallback callback) = 0;

  using GetAppStatesCallback = base::OnceCallback<void(std::vector<AppStatePtr>)>;
  using GetAppStatesMojoCallback = base::OnceCallback<void(std::vector<AppStatePtr>)>;

  virtual void GetAppStates(GetAppStatesCallback callback) = 0;

  using RunPeriodicTasksCallback = base::OnceCallback<void()>;
  using RunPeriodicTasksMojoCallback = base::OnceCallback<void()>;

  virtual void RunPeriodicTasks(RunPeriodicTasksCallback callback) = 0;

  using UpdateAllCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;
  using UpdateAllMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;

  virtual void UpdateAll(UpdateAllCallback callback) = 0;

  using UpdateCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;
  using UpdateMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;

  virtual void Update(const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, UpdateCallback callback) = 0;

  using InstallCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;
  using InstallMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;

  virtual void Install(RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, InstallCallback callback) = 0;

  virtual void CancelInstalls(const std::string& app_id) = 0;

  using RunInstallerCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;
  using RunInstallerMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;

  virtual void RunInstaller(const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, RunInstallerCallback callback) = 0;

  using CheckForUpdateCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;
  using CheckForUpdateMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<StateChangeObserver>)>;

  virtual void CheckForUpdate(const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, CheckForUpdateCallback callback) = 0;
};

class StateChangeObserverProxy;

template <typename ImplRefTraits>
class StateChangeObserverStub;

class StateChangeObserverRequestValidator;


class StateChangeObserver
    : public StateChangeObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "updater.mojom.StateChangeObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StateChangeObserverInterfaceBase;
  using Proxy_ = StateChangeObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = StateChangeObserverStub<ImplRefTraits>;

  using RequestValidator_ = StateChangeObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnStateChangeMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StateChangeObserver() = default;

  virtual void OnStateChange(UpdateStatePtr state) = 0;

  virtual void OnComplete(UpdateService::Result result) = 0;
};



class  UpdateServiceProxy
    : public UpdateService {
 public:
  using InterfaceType = UpdateService;

  explicit UpdateServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetVersion(GetVersionCallback callback) final;
  
  void FetchPolicies(::policy::PolicyFetchReason reason, FetchPoliciesCallback callback) final;
  
  void RegisterApp(RegistrationRequestPtr request, RegisterAppCallback callback) final;
  
  void GetAppStates(GetAppStatesCallback callback) final;
  
  void RunPeriodicTasks(RunPeriodicTasksCallback callback) final;
  
  void UpdateAll(UpdateAllCallback callback) final;
  
  void Update(const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, UpdateCallback callback) final;
  
  void Install(RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, InstallCallback callback) final;
  
  void CancelInstalls(const std::string& app_id) final;
  
  void RunInstaller(const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, RunInstallerCallback callback) final;
  
  void CheckForUpdate(const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, CheckForUpdateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StateChangeObserverProxy
    : public StateChangeObserver {
 public:
  using InterfaceType = StateChangeObserver;

  explicit StateChangeObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStateChange(UpdateStatePtr state) final;
  
  void OnComplete(UpdateService::Result result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UpdateServiceStubDispatch {
 public:
  static bool Accept(UpdateService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UpdateService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UpdateService>>
class UpdateServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UpdateServiceStub() = default;
  ~UpdateServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UpdateServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UpdateServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StateChangeObserverStubDispatch {
 public:
  static bool Accept(StateChangeObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StateChangeObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StateChangeObserver>>
class StateChangeObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StateChangeObserverStub() = default;
  ~StateChangeObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StateChangeObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StateChangeObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UpdateServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StateChangeObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UpdateServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  RegistrationRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RegistrationRequest, T>::value>;
  using DataView = RegistrationRequestDataView;
  using Data_ = internal::RegistrationRequest_Data;

  template <typename... Args>
  static RegistrationRequestPtr New(Args&&... args) {
    return RegistrationRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RegistrationRequestPtr From(const U& u) {
    return mojo::TypeConverter<RegistrationRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RegistrationRequest>::Convert(*this);
  }


  RegistrationRequest();

  RegistrationRequest(
      const std::string& app_id,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const std::string& ap,
      const std::string& version,
      const ::base::FilePath& existence_checker_path);

  RegistrationRequest(
      const std::string& app_id,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const std::string& ap,
      const std::string& version,
      const ::base::FilePath& existence_checker_path,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key);

  RegistrationRequest(
      const std::string& app_id,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const std::string& ap,
      const std::string& version,
      const ::base::FilePath& existence_checker_path,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key,
      const std::optional<std::string>& install_id);

  RegistrationRequest(
      const std::string& app_id,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const std::string& ap,
      const std::string& version,
      const ::base::FilePath& existence_checker_path,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key,
      const std::optional<std::string>& install_id,
      const std::optional<std::string>& lang);

  RegistrationRequest(
      const std::string& app_id,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const std::string& ap,
      const std::string& version,
      const ::base::FilePath& existence_checker_path,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key,
      const std::optional<std::string>& install_id,
      const std::optional<std::string>& lang,
      std::optional<int32_t> dla,
      std::optional<int32_t> dlrc,
      std::optional<int32_t> install_date,
      const std::optional<std::string>& cohort,
      const std::optional<std::string>& cohort_name,
      const std::optional<std::string>& cohort_hint);


  ~RegistrationRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RegistrationRequestPtr>
  RegistrationRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RegistrationRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RegistrationRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RegistrationRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RegistrationRequest_UnserializedMessageContext<
            UserType, RegistrationRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RegistrationRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RegistrationRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RegistrationRequest_UnserializedMessageContext<
            UserType, RegistrationRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RegistrationRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string app_id;
  
  std::string brand_code;
  
  ::base::FilePath brand_path;
  
  std::string ap;
  
  std::string version;
  
  ::base::FilePath existence_checker_path;
  
  std::optional<::base::FilePath> ap_path;
  
  std::optional<std::string> ap_key;
  
  std::optional<::base::FilePath> version_path;
  
  std::optional<std::string> version_key;
  
  std::optional<std::string> install_id;
  
  std::optional<std::string> lang;
  
  std::optional<int32_t> dla;
  
  std::optional<int32_t> dlrc;
  
  std::optional<int32_t> install_date;
  
  std::optional<std::string> cohort;
  
  std::optional<std::string> cohort_name;
  
  std::optional<std::string> cohort_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RegistrationRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UpdateState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateState, T>::value>;
  using DataView = UpdateStateDataView;
  using Data_ = internal::UpdateState_Data;
  using State = UpdateState_State;

  template <typename... Args>
  static UpdateStatePtr New(Args&&... args) {
    return UpdateStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateStatePtr From(const U& u) {
    return mojo::TypeConverter<UpdateStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateState>::Convert(*this);
  }


  UpdateState();

  UpdateState(
      const std::string& app_id,
      UpdateState::State state,
      const std::string& next_version,
      int64_t downloaded_bytes,
      int64_t total_bytes,
      int8_t install_progress,
      UpdateService::ErrorCategory error_category,
      int32_t error_code,
      int32_t extra_code1,
      const std::string& installer_text,
      const std::string& installer_cmd_line);


  ~UpdateState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateStatePtr>
  UpdateStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateState_UnserializedMessageContext<
            UserType, UpdateState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UpdateState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UpdateState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateState_UnserializedMessageContext<
            UserType, UpdateState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string app_id;
  
  UpdateState::State state;
  
  std::string next_version;
  
  int64_t downloaded_bytes;
  
  int64_t total_bytes;
  
  int8_t install_progress;
  
  UpdateService::ErrorCategory error_category;
  
  int32_t error_code;
  
  int32_t extra_code1;
  
  std::string installer_text;
  
  std::string installer_cmd_line;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AppState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AppState, T>::value>;
  using DataView = AppStateDataView;
  using Data_ = internal::AppState_Data;

  template <typename... Args>
  static AppStatePtr New(Args&&... args) {
    return AppStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppStatePtr From(const U& u) {
    return mojo::TypeConverter<AppStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AppState>::Convert(*this);
  }


  AppState();

  AppState(
      const std::string& app_id,
      const std::string& version,
      const std::string& ap,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const ::base::FilePath& ecp);

  AppState(
      const std::string& app_id,
      const std::string& version,
      const std::string& ap,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const ::base::FilePath& ecp,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key);

  AppState(
      const std::string& app_id,
      const std::string& version,
      const std::string& ap,
      const std::string& brand_code,
      const ::base::FilePath& brand_path,
      const ::base::FilePath& ecp,
      const std::optional<::base::FilePath>& ap_path,
      const std::optional<std::string>& ap_key,
      const std::optional<::base::FilePath>& version_path,
      const std::optional<std::string>& version_key,
      const std::optional<std::string>& cohort);


  ~AppState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppStatePtr>
  AppStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AppState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AppState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AppState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AppState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AppState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AppState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AppState_UnserializedMessageContext<
            UserType, AppState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AppState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AppState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AppState_UnserializedMessageContext<
            UserType, AppState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AppState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string app_id;
  
  std::string version;
  
  std::string ap;
  
  std::string brand_code;
  
  ::base::FilePath brand_path;
  
  ::base::FilePath ecp;
  
  std::optional<::base::FilePath> ap_path;
  
  std::optional<std::string> ap_key;
  
  std::optional<::base::FilePath> version_path;
  
  std::optional<std::string> version_key;
  
  std::optional<std::string> cohort;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AppState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AppState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AppState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AppState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RegistrationRequestPtr RegistrationRequest::Clone() const {
  return New(
      mojo::Clone(app_id),
      mojo::Clone(brand_code),
      mojo::Clone(brand_path),
      mojo::Clone(ap),
      mojo::Clone(version),
      mojo::Clone(existence_checker_path),
      mojo::Clone(ap_path),
      mojo::Clone(ap_key),
      mojo::Clone(version_path),
      mojo::Clone(version_key),
      mojo::Clone(install_id),
      mojo::Clone(lang),
      mojo::Clone(dla),
      mojo::Clone(dlrc),
      mojo::Clone(install_date),
      mojo::Clone(cohort),
      mojo::Clone(cohort_name),
      mojo::Clone(cohort_hint)
  );
}

template <typename T, RegistrationRequest::EnableIfSame<T>*>
bool RegistrationRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->brand_code, other_struct.brand_code))
    return false;
  if (!mojo::Equals(this->brand_path, other_struct.brand_path))
    return false;
  if (!mojo::Equals(this->ap, other_struct.ap))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->existence_checker_path, other_struct.existence_checker_path))
    return false;
  if (!mojo::Equals(this->ap_path, other_struct.ap_path))
    return false;
  if (!mojo::Equals(this->ap_key, other_struct.ap_key))
    return false;
  if (!mojo::Equals(this->version_path, other_struct.version_path))
    return false;
  if (!mojo::Equals(this->version_key, other_struct.version_key))
    return false;
  if (!mojo::Equals(this->install_id, other_struct.install_id))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->dla, other_struct.dla))
    return false;
  if (!mojo::Equals(this->dlrc, other_struct.dlrc))
    return false;
  if (!mojo::Equals(this->install_date, other_struct.install_date))
    return false;
  if (!mojo::Equals(this->cohort, other_struct.cohort))
    return false;
  if (!mojo::Equals(this->cohort_name, other_struct.cohort_name))
    return false;
  if (!mojo::Equals(this->cohort_hint, other_struct.cohort_hint))
    return false;
  return true;
}

template <typename T, RegistrationRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.brand_code < rhs.brand_code)
    return true;
  if (rhs.brand_code < lhs.brand_code)
    return false;
  if (lhs.brand_path < rhs.brand_path)
    return true;
  if (rhs.brand_path < lhs.brand_path)
    return false;
  if (lhs.ap < rhs.ap)
    return true;
  if (rhs.ap < lhs.ap)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.existence_checker_path < rhs.existence_checker_path)
    return true;
  if (rhs.existence_checker_path < lhs.existence_checker_path)
    return false;
  if (lhs.ap_path < rhs.ap_path)
    return true;
  if (rhs.ap_path < lhs.ap_path)
    return false;
  if (lhs.ap_key < rhs.ap_key)
    return true;
  if (rhs.ap_key < lhs.ap_key)
    return false;
  if (lhs.version_path < rhs.version_path)
    return true;
  if (rhs.version_path < lhs.version_path)
    return false;
  if (lhs.version_key < rhs.version_key)
    return true;
  if (rhs.version_key < lhs.version_key)
    return false;
  if (lhs.install_id < rhs.install_id)
    return true;
  if (rhs.install_id < lhs.install_id)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  if (lhs.dla < rhs.dla)
    return true;
  if (rhs.dla < lhs.dla)
    return false;
  if (lhs.dlrc < rhs.dlrc)
    return true;
  if (rhs.dlrc < lhs.dlrc)
    return false;
  if (lhs.install_date < rhs.install_date)
    return true;
  if (rhs.install_date < lhs.install_date)
    return false;
  if (lhs.cohort < rhs.cohort)
    return true;
  if (rhs.cohort < lhs.cohort)
    return false;
  if (lhs.cohort_name < rhs.cohort_name)
    return true;
  if (rhs.cohort_name < lhs.cohort_name)
    return false;
  if (lhs.cohort_hint < rhs.cohort_hint)
    return true;
  if (rhs.cohort_hint < lhs.cohort_hint)
    return false;
  return false;
}
template <typename StructPtrType>
UpdateStatePtr UpdateState::Clone() const {
  return New(
      mojo::Clone(app_id),
      mojo::Clone(state),
      mojo::Clone(next_version),
      mojo::Clone(downloaded_bytes),
      mojo::Clone(total_bytes),
      mojo::Clone(install_progress),
      mojo::Clone(error_category),
      mojo::Clone(error_code),
      mojo::Clone(extra_code1),
      mojo::Clone(installer_text),
      mojo::Clone(installer_cmd_line)
  );
}

template <typename T, UpdateState::EnableIfSame<T>*>
bool UpdateState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->next_version, other_struct.next_version))
    return false;
  if (!mojo::Equals(this->downloaded_bytes, other_struct.downloaded_bytes))
    return false;
  if (!mojo::Equals(this->total_bytes, other_struct.total_bytes))
    return false;
  if (!mojo::Equals(this->install_progress, other_struct.install_progress))
    return false;
  if (!mojo::Equals(this->error_category, other_struct.error_category))
    return false;
  if (!mojo::Equals(this->error_code, other_struct.error_code))
    return false;
  if (!mojo::Equals(this->extra_code1, other_struct.extra_code1))
    return false;
  if (!mojo::Equals(this->installer_text, other_struct.installer_text))
    return false;
  if (!mojo::Equals(this->installer_cmd_line, other_struct.installer_cmd_line))
    return false;
  return true;
}

template <typename T, UpdateState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.next_version < rhs.next_version)
    return true;
  if (rhs.next_version < lhs.next_version)
    return false;
  if (lhs.downloaded_bytes < rhs.downloaded_bytes)
    return true;
  if (rhs.downloaded_bytes < lhs.downloaded_bytes)
    return false;
  if (lhs.total_bytes < rhs.total_bytes)
    return true;
  if (rhs.total_bytes < lhs.total_bytes)
    return false;
  if (lhs.install_progress < rhs.install_progress)
    return true;
  if (rhs.install_progress < lhs.install_progress)
    return false;
  if (lhs.error_category < rhs.error_category)
    return true;
  if (rhs.error_category < lhs.error_category)
    return false;
  if (lhs.error_code < rhs.error_code)
    return true;
  if (rhs.error_code < lhs.error_code)
    return false;
  if (lhs.extra_code1 < rhs.extra_code1)
    return true;
  if (rhs.extra_code1 < lhs.extra_code1)
    return false;
  if (lhs.installer_text < rhs.installer_text)
    return true;
  if (rhs.installer_text < lhs.installer_text)
    return false;
  if (lhs.installer_cmd_line < rhs.installer_cmd_line)
    return true;
  if (rhs.installer_cmd_line < lhs.installer_cmd_line)
    return false;
  return false;
}
template <typename StructPtrType>
AppStatePtr AppState::Clone() const {
  return New(
      mojo::Clone(app_id),
      mojo::Clone(version),
      mojo::Clone(ap),
      mojo::Clone(brand_code),
      mojo::Clone(brand_path),
      mojo::Clone(ecp),
      mojo::Clone(ap_path),
      mojo::Clone(ap_key),
      mojo::Clone(version_path),
      mojo::Clone(version_key),
      mojo::Clone(cohort)
  );
}

template <typename T, AppState::EnableIfSame<T>*>
bool AppState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->app_id, other_struct.app_id))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->ap, other_struct.ap))
    return false;
  if (!mojo::Equals(this->brand_code, other_struct.brand_code))
    return false;
  if (!mojo::Equals(this->brand_path, other_struct.brand_path))
    return false;
  if (!mojo::Equals(this->ecp, other_struct.ecp))
    return false;
  if (!mojo::Equals(this->ap_path, other_struct.ap_path))
    return false;
  if (!mojo::Equals(this->ap_key, other_struct.ap_key))
    return false;
  if (!mojo::Equals(this->version_path, other_struct.version_path))
    return false;
  if (!mojo::Equals(this->version_key, other_struct.version_key))
    return false;
  if (!mojo::Equals(this->cohort, other_struct.cohort))
    return false;
  return true;
}

template <typename T, AppState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.app_id < rhs.app_id)
    return true;
  if (rhs.app_id < lhs.app_id)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.ap < rhs.ap)
    return true;
  if (rhs.ap < lhs.ap)
    return false;
  if (lhs.brand_code < rhs.brand_code)
    return true;
  if (rhs.brand_code < lhs.brand_code)
    return false;
  if (lhs.brand_path < rhs.brand_path)
    return true;
  if (rhs.brand_path < lhs.brand_path)
    return false;
  if (lhs.ecp < rhs.ecp)
    return true;
  if (rhs.ecp < lhs.ecp)
    return false;
  if (lhs.ap_path < rhs.ap_path)
    return true;
  if (rhs.ap_path < lhs.ap_path)
    return false;
  if (lhs.ap_key < rhs.ap_key)
    return true;
  if (rhs.ap_key < lhs.ap_key)
    return false;
  if (lhs.version_path < rhs.version_path)
    return true;
  if (rhs.version_path < lhs.version_path)
    return false;
  if (lhs.version_key < rhs.version_key)
    return true;
  if (rhs.version_key < lhs.version_key)
    return false;
  if (lhs.cohort < rhs.cohort)
    return true;
  if (rhs.cohort < lhs.cohort)
    return false;
  return false;
}


}  // updater::mojom

namespace mojo {


template <>
struct  StructTraits<::updater::mojom::RegistrationRequest::DataView,
                                         ::updater::mojom::RegistrationRequestPtr> {
  static bool IsNull(const ::updater::mojom::RegistrationRequestPtr& input) { return !input; }
  static void SetToNull(::updater::mojom::RegistrationRequestPtr* output) { output->reset(); }

  static const decltype(::updater::mojom::RegistrationRequest::app_id)& app_id(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->app_id;
  }

  static const decltype(::updater::mojom::RegistrationRequest::brand_code)& brand_code(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->brand_code;
  }

  static const decltype(::updater::mojom::RegistrationRequest::brand_path)& brand_path(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->brand_path;
  }

  static const decltype(::updater::mojom::RegistrationRequest::ap)& ap(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->ap;
  }

  static const decltype(::updater::mojom::RegistrationRequest::version)& version(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->version;
  }

  static const decltype(::updater::mojom::RegistrationRequest::existence_checker_path)& existence_checker_path(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->existence_checker_path;
  }

  static const decltype(::updater::mojom::RegistrationRequest::ap_path)& ap_path(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->ap_path;
  }

  static const decltype(::updater::mojom::RegistrationRequest::ap_key)& ap_key(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->ap_key;
  }

  static const decltype(::updater::mojom::RegistrationRequest::version_path)& version_path(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->version_path;
  }

  static const decltype(::updater::mojom::RegistrationRequest::version_key)& version_key(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->version_key;
  }

  static const decltype(::updater::mojom::RegistrationRequest::install_id)& install_id(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->install_id;
  }

  static const decltype(::updater::mojom::RegistrationRequest::lang)& lang(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->lang;
  }

  static decltype(::updater::mojom::RegistrationRequest::dla) dla(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->dla;
  }

  static decltype(::updater::mojom::RegistrationRequest::dlrc) dlrc(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->dlrc;
  }

  static decltype(::updater::mojom::RegistrationRequest::install_date) install_date(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->install_date;
  }

  static const decltype(::updater::mojom::RegistrationRequest::cohort)& cohort(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->cohort;
  }

  static const decltype(::updater::mojom::RegistrationRequest::cohort_name)& cohort_name(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->cohort_name;
  }

  static const decltype(::updater::mojom::RegistrationRequest::cohort_hint)& cohort_hint(
      const ::updater::mojom::RegistrationRequestPtr& input) {
    return input->cohort_hint;
  }

  static bool Read(::updater::mojom::RegistrationRequest::DataView input, ::updater::mojom::RegistrationRequestPtr* output);
};


template <>
struct  StructTraits<::updater::mojom::UpdateState::DataView,
                                         ::updater::mojom::UpdateStatePtr> {
  static bool IsNull(const ::updater::mojom::UpdateStatePtr& input) { return !input; }
  static void SetToNull(::updater::mojom::UpdateStatePtr* output) { output->reset(); }

  static const decltype(::updater::mojom::UpdateState::app_id)& app_id(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->app_id;
  }

  static decltype(::updater::mojom::UpdateState::state) state(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->state;
  }

  static const decltype(::updater::mojom::UpdateState::next_version)& next_version(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->next_version;
  }

  static decltype(::updater::mojom::UpdateState::downloaded_bytes) downloaded_bytes(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->downloaded_bytes;
  }

  static decltype(::updater::mojom::UpdateState::total_bytes) total_bytes(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->total_bytes;
  }

  static decltype(::updater::mojom::UpdateState::install_progress) install_progress(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->install_progress;
  }

  static decltype(::updater::mojom::UpdateState::error_category) error_category(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->error_category;
  }

  static decltype(::updater::mojom::UpdateState::error_code) error_code(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->error_code;
  }

  static decltype(::updater::mojom::UpdateState::extra_code1) extra_code1(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->extra_code1;
  }

  static const decltype(::updater::mojom::UpdateState::installer_text)& installer_text(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->installer_text;
  }

  static const decltype(::updater::mojom::UpdateState::installer_cmd_line)& installer_cmd_line(
      const ::updater::mojom::UpdateStatePtr& input) {
    return input->installer_cmd_line;
  }

  static bool Read(::updater::mojom::UpdateState::DataView input, ::updater::mojom::UpdateStatePtr* output);
};


template <>
struct  StructTraits<::updater::mojom::AppState::DataView,
                                         ::updater::mojom::AppStatePtr> {
  static bool IsNull(const ::updater::mojom::AppStatePtr& input) { return !input; }
  static void SetToNull(::updater::mojom::AppStatePtr* output) { output->reset(); }

  static const decltype(::updater::mojom::AppState::app_id)& app_id(
      const ::updater::mojom::AppStatePtr& input) {
    return input->app_id;
  }

  static const decltype(::updater::mojom::AppState::version)& version(
      const ::updater::mojom::AppStatePtr& input) {
    return input->version;
  }

  static const decltype(::updater::mojom::AppState::ap)& ap(
      const ::updater::mojom::AppStatePtr& input) {
    return input->ap;
  }

  static const decltype(::updater::mojom::AppState::brand_code)& brand_code(
      const ::updater::mojom::AppStatePtr& input) {
    return input->brand_code;
  }

  static const decltype(::updater::mojom::AppState::brand_path)& brand_path(
      const ::updater::mojom::AppStatePtr& input) {
    return input->brand_path;
  }

  static const decltype(::updater::mojom::AppState::ecp)& ecp(
      const ::updater::mojom::AppStatePtr& input) {
    return input->ecp;
  }

  static const decltype(::updater::mojom::AppState::ap_path)& ap_path(
      const ::updater::mojom::AppStatePtr& input) {
    return input->ap_path;
  }

  static const decltype(::updater::mojom::AppState::ap_key)& ap_key(
      const ::updater::mojom::AppStatePtr& input) {
    return input->ap_key;
  }

  static const decltype(::updater::mojom::AppState::version_path)& version_path(
      const ::updater::mojom::AppStatePtr& input) {
    return input->version_path;
  }

  static const decltype(::updater::mojom::AppState::version_key)& version_key(
      const ::updater::mojom::AppStatePtr& input) {
    return input->version_key;
  }

  static const decltype(::updater::mojom::AppState::cohort)& cohort(
      const ::updater::mojom::AppStatePtr& input) {
    return input->cohort;
  }

  static bool Read(::updater::mojom::AppState::DataView input, ::updater::mojom::AppStatePtr* output);
};

}  // namespace mojo

#endif  // CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_H_