// chrome/updater/mojom/updater_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_DATA_VIEW_H_
#define CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/updater/mojom/updater_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "chrome/enterprise_companion/mojom/policy_fetch_reason.mojom-shared.h"


namespace updater::mojom {
class RegistrationRequestDataView;

class UpdateStateDataView;

class AppStateDataView;



}  // updater::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::updater::mojom::RegistrationRequestDataView> {
  using Data = ::updater::mojom::internal::RegistrationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::updater::mojom::UpdateStateDataView> {
  using Data = ::updater::mojom::internal::UpdateState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::updater::mojom::AppStateDataView> {
  using Data = ::updater::mojom::internal::AppState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace updater::mojom {


enum class UpdateState_State : int32_t {
  
  kUnknown = 0,
  
  kNotStarted = 1,
  
  kCheckingForUpdates = 2,
  
  kUpdateAvailable = 3,
  
  kDownloading = 4,
  
  kInstalling = 5,
  
  kUpdated = 6,
  
  kNoUpdate = 7,
  
  kUpdateError = 8,
  
  kDecompressing = 9,
  
  kPatching = 10,
  kMinValue = 0,
  kMaxValue = 10,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UpdateState_State value);
inline bool IsKnownEnumValue(UpdateState_State value) {
  return internal::UpdateState_State_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UpdateState_State ToKnownEnumValue(UpdateState_State value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UpdateState_State::kDefaultValue;
}


enum class UpdateService_PolicySameVersionUpdate : int32_t {
  
  kNotAllowed = 0,
  
  kAllowed = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UpdateService_PolicySameVersionUpdate value);
inline bool IsKnownEnumValue(UpdateService_PolicySameVersionUpdate value) {
  return internal::UpdateService_PolicySameVersionUpdate_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UpdateService_PolicySameVersionUpdate ToKnownEnumValue(UpdateService_PolicySameVersionUpdate value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UpdateService_PolicySameVersionUpdate::kDefaultValue;
}


enum class UpdateService_Result : int32_t {
  
  kSuccess = 0,
  
  kUpdateInProgress = 1,
  
  kUpdateCanceled = 2,
  
  kRetryLater = 3,
  
  kServiceFailed = 4,
  
  kUpdateCheckFailed = 5,
  
  kAppNotFound = 6,
  
  kInvalidArgument = 7,
  
  kInactive = 8,
  
  kIPCConnectionFailed = 9,
  
  kInstallFailed = 10,
  
  kPermissionDenied = 11,
  
  kUnknown = 12,
  
  kServiceStopped = 13,
  
  kEulaRequiredOrOemMode = 14,
  
  kFetchPoliciesFailed = 15,
  kMinValue = 0,
  kMaxValue = 15,
  kDefaultValue = 12
};

 std::ostream& operator<<(std::ostream& os, UpdateService_Result value);
inline bool IsKnownEnumValue(UpdateService_Result value) {
  return internal::UpdateService_Result_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UpdateService_Result ToKnownEnumValue(UpdateService_Result value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UpdateService_Result::kDefaultValue;
}


enum class UpdateService_ErrorCategory : int32_t {
  
  kNone = 0,
  
  kDownload = 1,
  
  kUnpack = 2,
  
  kInstall = 3,
  
  kService = 4,
  
  kUpdateCheck = 5,
  
  kUnknown = 6,
  
  kInstaller = 7,
  kMinValue = 0,
  kMaxValue = 7,
  kDefaultValue = 6
};

 std::ostream& operator<<(std::ostream& os, UpdateService_ErrorCategory value);
inline bool IsKnownEnumValue(UpdateService_ErrorCategory value) {
  return internal::UpdateService_ErrorCategory_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UpdateService_ErrorCategory ToKnownEnumValue(UpdateService_ErrorCategory value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UpdateService_ErrorCategory::kDefaultValue;
}


enum class UpdateService_Priority : int32_t {
  
  kUnknown = 0,
  
  kBackground = 1,
  
  kForeground = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, UpdateService_Priority value);
inline bool IsKnownEnumValue(UpdateService_Priority value) {
  return internal::UpdateService_Priority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline UpdateService_Priority ToKnownEnumValue(UpdateService_Priority value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return UpdateService_Priority::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class UpdateServiceInterfaceBase {};

using UpdateServicePtrDataView =
    mojo::InterfacePtrDataView<UpdateServiceInterfaceBase>;
using UpdateServiceRequestDataView =
    mojo::InterfaceRequestDataView<UpdateServiceInterfaceBase>;
using UpdateServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UpdateServiceInterfaceBase>;
using UpdateServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UpdateServiceInterfaceBase>;
class StateChangeObserverInterfaceBase {};

using StateChangeObserverPtrDataView =
    mojo::InterfacePtrDataView<StateChangeObserverInterfaceBase>;
using StateChangeObserverRequestDataView =
    mojo::InterfaceRequestDataView<StateChangeObserverInterfaceBase>;
using StateChangeObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<StateChangeObserverInterfaceBase>;
using StateChangeObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<StateChangeObserverInterfaceBase>;


class RegistrationRequestDataView {
 public:
  RegistrationRequestDataView() = default;

  RegistrationRequestDataView(
      internal::RegistrationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrandCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrandCode(UserType* output) {
    
    auto* pointer = data_->brand_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrandPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrandPath(UserType* output) {
    
    auto* pointer = data_->brand_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetApDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAp(UserType* output) {
    
    auto* pointer = data_->ap.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExistenceCheckerPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExistenceCheckerPath(UserType* output) {
    
    auto* pointer = data_->existence_checker_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetApPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `ap_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadApPath` instead "
    "of `ReadApPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->ap_path.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetApKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `ap_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadApKey` instead "
    "of `ReadApKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->ap_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `version_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionPath` instead "
    "of `ReadVersionPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->version_path.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetVersionKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `version_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionKey` instead "
    "of `ReadVersionKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->version_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInstallIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstallId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `install_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstallId` instead "
    "of `ReadInstallId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->install_id.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `lang` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLang` instead "
    "of `ReadLang if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->lang.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> dla() const {
    if (data_->header_.version < 4) {
      return std::nullopt;
    }

    return data_->dla_$flag
        ? std::make_optional(data_->dla_$value)
        : std::nullopt;
  }
  std::optional<int32_t> dlrc() const {
    if (data_->header_.version < 4) {
      return std::nullopt;
    }

    return data_->dlrc_$flag
        ? std::make_optional(data_->dlrc_$value)
        : std::nullopt;
  }
  std::optional<int32_t> install_date() const {
    if (data_->header_.version < 4) {
      return std::nullopt;
    }

    return data_->install_date_$flag
        ? std::make_optional(data_->install_date_$value)
        : std::nullopt;
  }
  inline void GetCohortDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCohort(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cohort` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCohort` instead "
    "of `ReadCohort if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->cohort.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCohortNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCohortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cohort_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCohortName` instead "
    "of `ReadCohortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->cohort_name.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCohortHintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCohortHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cohort_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCohortHint` instead "
    "of `ReadCohortHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->cohort_hint.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RegistrationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UpdateStateDataView {
 public:
  UpdateStateDataView() = default;

  UpdateStateDataView(
      internal::UpdateState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::updater::mojom::UpdateState_State>(
        data_value, output);
  }
  UpdateState_State state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::updater::mojom::UpdateState_State>(data_->state));
  }
  inline void GetNextVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNextVersion(UserType* output) {
    
    auto* pointer = data_->next_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t downloaded_bytes() const {
    return data_->downloaded_bytes;
  }
  int64_t total_bytes() const {
    return data_->total_bytes;
  }
  int8_t install_progress() const {
    return data_->install_progress;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCategory(UserType* output) const {
    auto data_value = data_->error_category;
    return mojo::internal::Deserialize<::updater::mojom::UpdateService_ErrorCategory>(
        data_value, output);
  }
  UpdateService_ErrorCategory error_category() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::updater::mojom::UpdateService_ErrorCategory>(data_->error_category));
  }
  int32_t error_code() const {
    return data_->error_code;
  }
  int32_t extra_code1() const {
    return data_->extra_code1;
  }
  inline void GetInstallerTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstallerText(UserType* output) {
    
    auto* pointer = data_->installer_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInstallerCmdLineDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstallerCmdLine(UserType* output) {
    
    auto* pointer = data_->installer_cmd_line.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::UpdateState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppStateDataView {
 public:
  AppStateDataView() = default;

  AppStateDataView(
      internal::AppState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetApDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAp(UserType* output) {
    
    auto* pointer = data_->ap.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrandCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrandCode(UserType* output) {
    
    auto* pointer = data_->brand_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrandPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrandPath(UserType* output) {
    
    auto* pointer = data_->brand_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetEcpDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEcp(UserType* output) {
    
    auto* pointer = data_->ecp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetApPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `ap_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadApPath` instead "
    "of `ReadApPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->ap_path.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetApKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `ap_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadApKey` instead "
    "of `ReadApKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->ap_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `version_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionPath` instead "
    "of `ReadVersionPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->version_path.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetVersionKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `version_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionKey` instead "
    "of `ReadVersionKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->version_key.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCohortDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCohort(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cohort` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCohort` instead "
    "of `ReadCohort if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->cohort.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // updater::mojom

#endif  // CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_DATA_VIEW_H_