// chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_REMOVABLE_STORAGE_WRITER_PUBLIC_MOJOM_REMOVABLE_STORAGE_WRITER_MOJOM_H_
#define CHROME_SERVICES_REMOVABLE_STORAGE_WRITER_PUBLIC_MOJOM_REMOVABLE_STORAGE_WRITER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/removable_storage_writer/public/mojom/removable_storage_writer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kRemovableStorageWriterSandbox = ::sandbox::mojom::Sandbox::kNoSandbox;


namespace chrome::mojom {

class RemovableStorageWriterProxy;

template <typename ImplRefTraits>
class RemovableStorageWriterStub;

class RemovableStorageWriterRequestValidator;


class RemovableStorageWriter
    : public RemovableStorageWriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.RemovableStorageWriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemovableStorageWriterInterfaceBase;
  using Proxy_ = RemovableStorageWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemovableStorageWriterStub<ImplRefTraits>;

  using RequestValidator_ = RemovableStorageWriterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kWriteMinVersion = 0,
    kVerifyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Write_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Verify_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr char kTestDevice[] = "chrome://test-removable-storage-writer";
  virtual ~RemovableStorageWriter() = default;

  virtual void Write(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) = 0;

  virtual void Verify(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) = 0;
};

class RemovableStorageWriterClientProxy;

template <typename ImplRefTraits>
class RemovableStorageWriterClientStub;

class RemovableStorageWriterClientRequestValidator;


class RemovableStorageWriterClient
    : public RemovableStorageWriterClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.RemovableStorageWriterClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RemovableStorageWriterClientInterfaceBase;
  using Proxy_ = RemovableStorageWriterClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemovableStorageWriterClientStub<ImplRefTraits>;

  using RequestValidator_ = RemovableStorageWriterClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kProgressMinVersion = 0,
    kCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Progress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Complete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RemovableStorageWriterClient() = default;

  virtual void Progress(int64_t progress) = 0;

  virtual void Complete(const std::optional<std::string>& error) = 0;
};



class  RemovableStorageWriterProxy
    : public RemovableStorageWriter {
 public:
  using InterfaceType = RemovableStorageWriter;

  explicit RemovableStorageWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Write(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) final;
  
  void Verify(const ::base::FilePath& source, const ::base::FilePath& target, ::mojo::PendingRemote<RemovableStorageWriterClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  RemovableStorageWriterClientProxy
    : public RemovableStorageWriterClient {
 public:
  using InterfaceType = RemovableStorageWriterClient;

  explicit RemovableStorageWriterClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Progress(int64_t progress) final;
  
  void Complete(const std::optional<std::string>& error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RemovableStorageWriterStubDispatch {
 public:
  static bool Accept(RemovableStorageWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemovableStorageWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemovableStorageWriter>>
class RemovableStorageWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemovableStorageWriterStub() = default;
  ~RemovableStorageWriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemovableStorageWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemovableStorageWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RemovableStorageWriterClientStubDispatch {
 public:
  static bool Accept(RemovableStorageWriterClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemovableStorageWriterClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemovableStorageWriterClient>>
class RemovableStorageWriterClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemovableStorageWriterClientStub() = default;
  ~RemovableStorageWriterClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemovableStorageWriterClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemovableStorageWriterClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RemovableStorageWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RemovableStorageWriterClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_REMOVABLE_STORAGE_WRITER_PUBLIC_MOJOM_REMOVABLE_STORAGE_WRITER_MOJOM_H_